/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.mem.mnode.info;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.commons.schema.node.IMNode;
import org.apache.iotdb.commons.schema.node.info.IDeviceInfo;
import org.apache.iotdb.commons.schema.node.role.IDeviceMNode;
import org.apache.iotdb.commons.schema.node.role.IMeasurementMNode;

public class DeviceInfo<N extends IMNode<N>>
implements IDeviceInfo<N> {
    protected int schemaTemplateId = -1;
    private volatile boolean useTemplate = false;
    private volatile transient Map<String, IMeasurementMNode<N>> aliasChildren = null;
    private volatile Boolean isAligned = false;

    public void moveDataToNewMNode(IDeviceMNode<N> newMNode) {
        newMNode.setSchemaTemplateId(this.schemaTemplateId);
        newMNode.setUseTemplate(this.useTemplate);
        newMNode.setAliasChildren(this.aliasChildren);
        newMNode.setAligned(this.isAligned);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAlias(String alias, IMeasurementMNode<N> child) {
        if (this.aliasChildren == null) {
            DeviceInfo deviceInfo = this;
            synchronized (deviceInfo) {
                if (this.aliasChildren == null) {
                    this.aliasChildren = new ConcurrentHashMap<String, IMeasurementMNode<N>>();
                }
            }
        }
        return this.aliasChildren.computeIfAbsent(alias, aliasName -> child) == child;
    }

    public void deleteAliasChild(String alias) {
        if (this.aliasChildren != null) {
            this.aliasChildren.remove(alias);
        }
    }

    public Map<String, IMeasurementMNode<N>> getAliasChildren() {
        if (this.aliasChildren == null) {
            return Collections.emptyMap();
        }
        return this.aliasChildren;
    }

    public void setAliasChildren(Map<String, IMeasurementMNode<N>> aliasChildren) {
        this.aliasChildren = aliasChildren;
    }

    public boolean hasAliasChild(String name) {
        return this.aliasChildren != null && this.aliasChildren.containsKey(name);
    }

    public N getAliasChild(String name) {
        if (this.aliasChildren != null) {
            IMeasurementMNode<N> child = this.aliasChildren.get(name);
            return (N)(child == null ? null : child.getAsMNode());
        }
        return null;
    }

    public int getSchemaTemplateId() {
        return this.schemaTemplateId >= -1 ? this.schemaTemplateId : -this.schemaTemplateId - 2;
    }

    public int getSchemaTemplateIdWithState() {
        return this.schemaTemplateId;
    }

    public boolean isPreDeactivateTemplate() {
        return this.schemaTemplateId < -1;
    }

    public void preDeactivateTemplate() {
        if (this.schemaTemplateId > -1) {
            this.schemaTemplateId = -this.schemaTemplateId - 2;
        }
    }

    public void rollbackPreDeactivateTemplate() {
        if (this.schemaTemplateId < -1) {
            this.schemaTemplateId = -this.schemaTemplateId - 2;
        }
    }

    public void deactivateTemplate() {
        this.schemaTemplateId = -1;
        this.setUseTemplate(false);
    }

    public boolean isUseTemplate() {
        return this.useTemplate;
    }

    public void setUseTemplate(boolean useTemplate) {
        this.useTemplate = useTemplate;
    }

    public void setSchemaTemplateId(int schemaTemplateId) {
        this.schemaTemplateId = schemaTemplateId;
    }

    public Boolean isAligned() {
        return this.isAligned;
    }

    public void setAligned(Boolean isAligned) {
        this.isAligned = isAligned;
    }

    public int estimateSize() {
        return 22;
    }
}

