/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.receiver.visitor;

import java.util.Arrays;
import java.util.Optional;
import java.util.stream.IntStream;
import org.apache.iotdb.commons.pipe.datastructure.pattern.IoTDBPipePatternOperations;
import org.apache.iotdb.commons.pipe.datastructure.pattern.PipePattern;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.StatementNode;
import org.apache.iotdb.db.queryengine.plan.statement.StatementVisitor;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.AlterTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CreateAlignedTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CreateTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.ActivateTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.view.CreateLogicalViewStatement;

public class PipeStatementPatternParseVisitor
extends StatementVisitor<Optional<Statement>, IoTDBPipePatternOperations> {
    @Override
    public Optional<Statement> visitNode(StatementNode statement, IoTDBPipePatternOperations pattern) {
        return Optional.of((Statement)statement);
    }

    @Override
    public Optional<Statement> visitCreateTimeseries(CreateTimeSeriesStatement statement, IoTDBPipePatternOperations pattern) {
        return pattern.matchesMeasurement(statement.getPath().getDevice(), statement.getPath().getMeasurement()) ? Optional.of(statement) : Optional.empty();
    }

    @Override
    public Optional<Statement> visitCreateAlignedTimeseries(CreateAlignedTimeSeriesStatement statement, IoTDBPipePatternOperations pattern) {
        int[] filteredIndexes = IntStream.range(0, statement.getMeasurements().size()).filter(index -> pattern.matchesMeasurement(statement.getDevicePath().getFullPath(), statement.getMeasurements().get(index))).toArray();
        if (filteredIndexes.length == 0) {
            return Optional.empty();
        }
        CreateAlignedTimeSeriesStatement targetCreateAlignedTimeSeriesStatement = new CreateAlignedTimeSeriesStatement();
        targetCreateAlignedTimeSeriesStatement.setDevicePath(statement.getDevicePath());
        Arrays.stream(filteredIndexes).forEach(index -> {
            targetCreateAlignedTimeSeriesStatement.addMeasurement(statement.getMeasurements().get(index));
            targetCreateAlignedTimeSeriesStatement.addDataType(statement.getDataTypes().get(index));
            targetCreateAlignedTimeSeriesStatement.addEncoding(statement.getEncodings().get(index));
            targetCreateAlignedTimeSeriesStatement.addCompressor(statement.getCompressors().get(index));
            targetCreateAlignedTimeSeriesStatement.addTagsList(statement.getTagsList().get(index));
            targetCreateAlignedTimeSeriesStatement.addAttributesList(statement.getAttributesList().get(index));
            targetCreateAlignedTimeSeriesStatement.addAliasList(statement.getAliasList().get(index));
        });
        return Optional.of(targetCreateAlignedTimeSeriesStatement);
    }

    @Override
    public Optional<Statement> visitAlterTimeSeries(AlterTimeSeriesStatement alterTimeSeriesStatement, IoTDBPipePatternOperations pattern) {
        return pattern.matchesMeasurement(alterTimeSeriesStatement.getPath().getDevice(), alterTimeSeriesStatement.getPath().getMeasurement()) ? Optional.of(alterTimeSeriesStatement) : Optional.empty();
    }

    @Override
    public Optional<Statement> visitActivateTemplate(ActivateTemplateStatement activateTemplateStatement, IoTDBPipePatternOperations pattern) {
        return pattern.matchDevice(activateTemplateStatement.getPath().getFullPath()) ? Optional.of(activateTemplateStatement) : Optional.empty();
    }

    @Override
    public Optional<Statement> visitCreateLogicalView(CreateLogicalViewStatement createLogicalViewStatement, IoTDBPipePatternOperations pattern) {
        int[] filteredIndexes = IntStream.range(0, createLogicalViewStatement.getTargetPathList().size()).filter(index -> pattern.matchesMeasurement(createLogicalViewStatement.getTargetPathList().get(index).getDevice(), createLogicalViewStatement.getTargetPathList().get(index).getMeasurement())).toArray();
        if (filteredIndexes.length == 0) {
            return Optional.empty();
        }
        createLogicalViewStatement.setTargetFullPaths(PipePattern.applyIndexesOnList((int[])filteredIndexes, createLogicalViewStatement.getTargetPathList()));
        createLogicalViewStatement.setViewExpressions(PipePattern.applyIndexesOnList((int[])filteredIndexes, createLogicalViewStatement.getViewExpressions()));
        return Optional.of(createLogicalViewStatement);
    }
}

