/*
 * Decompiled with CFR 0.152.
 */
package org.jtransforms.fft;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;
import org.jtransforms.fft.DoubleFFT_1D;
import org.jtransforms.utils.CommonUtils;
import pl.edu.icm.jlargearrays.ConcurrencyUtils;
import pl.edu.icm.jlargearrays.DoubleLargeArray;
import pl.edu.icm.jlargearrays.LargeArray;
import pl.edu.icm.jlargearrays.LargeArrayUtils;

public class DoubleFFT_3D {
    private int slices;
    private long slicesl;
    private int rows;
    private long rowsl;
    private int columns;
    private long columnsl;
    private int sliceStride;
    private long sliceStridel;
    private int rowStride;
    private long rowStridel;
    private DoubleFFT_1D fftSlices;
    private DoubleFFT_1D fftRows;
    private DoubleFFT_1D fftColumns;
    private boolean isPowerOfTwo = false;
    private boolean useThreads = false;

    public DoubleFFT_3D(long slices, long rows, long columns) {
        if (slices <= 1L || rows <= 1L || columns <= 1L) {
            throw new IllegalArgumentException("slices, rows and columns must be greater than 1");
        }
        this.slices = (int)slices;
        this.rows = (int)rows;
        this.columns = (int)columns;
        this.slicesl = slices;
        this.rowsl = rows;
        this.columnsl = columns;
        this.sliceStride = (int)(rows * columns);
        this.rowStride = (int)columns;
        this.sliceStridel = rows * columns;
        this.rowStridel = columns;
        if (slices * rows * columns >= CommonUtils.getThreadsBeginN_3D()) {
            this.useThreads = true;
        }
        if (CommonUtils.isPowerOf2(slices) && CommonUtils.isPowerOf2(rows) && CommonUtils.isPowerOf2(columns)) {
            this.isPowerOfTwo = true;
        }
        CommonUtils.setUseLargeArrays(2L * slices * rows * columns > (long)LargeArray.getMaxSizeOf32bitArray());
        this.fftSlices = new DoubleFFT_1D(slices);
        this.fftRows = slices == rows ? this.fftSlices : new DoubleFFT_1D(rows);
        this.fftColumns = slices == columns ? this.fftSlices : (rows == columns ? this.fftRows : new DoubleFFT_1D(columns));
    }

    public void complexForward(final double[] a) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            int oldn3 = this.columns;
            this.columns = 2 * this.columns;
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
            if (nthreads > 1 && this.useThreads) {
                this.xdft3da_subth2(0, -1, a, true);
                this.cdft3db_subth(-1, a, true);
            } else {
                this.xdft3da_sub2(0, -1, a, true);
                this.cdft3db_sub(-1, a, true);
            }
            this.columns = oldn3;
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
        } else {
            this.sliceStride = 2 * this.rows * this.columns;
            this.rowStride = 2 * this.columns;
            if (nthreads > 1 && this.useThreads && this.slices >= nthreads && this.rows >= nthreads && this.columns >= nthreads) {
                int lastSlice;
                int firstSlice;
                Future[] futures = new Future[nthreads];
                int p = this.slices / nthreads;
                for (int l = 0; l < nthreads; ++l) {
                    firstSlice = l * p;
                    lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                                int idx1 = s2 * DoubleFFT_3D.this.sliceStride;
                                for (int r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    DoubleFFT_3D.this.fftColumns.complexForward(a, idx1 + r * DoubleFFT_3D.this.rowStride);
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                for (int l = 0; l < nthreads; ++l) {
                    firstSlice = l * p;
                    lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            double[] temp = new double[2 * DoubleFFT_3D.this.rows];
                            for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                                int idx1 = s2 * DoubleFFT_3D.this.sliceStride;
                                for (int c = 0; c < DoubleFFT_3D.this.columns; ++c) {
                                    int idx4;
                                    int idx3;
                                    int r;
                                    int idx2 = 2 * c;
                                    for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                        idx3 = idx1 + idx2 + r * DoubleFFT_3D.this.rowStride;
                                        idx4 = 2 * r;
                                        temp[idx4] = a[idx3];
                                        temp[idx4 + 1] = a[idx3 + 1];
                                    }
                                    DoubleFFT_3D.this.fftRows.complexForward(temp);
                                    for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                        idx3 = idx1 + idx2 + r * DoubleFFT_3D.this.rowStride;
                                        idx4 = 2 * r;
                                        a[idx3] = temp[idx4];
                                        a[idx3 + 1] = temp[idx4 + 1];
                                    }
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                p = this.rows / nthreads;
                for (int l = 0; l < nthreads; ++l) {
                    final int firstRow = l * p;
                    final int lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            double[] temp = new double[2 * DoubleFFT_3D.this.slices];
                            for (int r = firstRow; r < lastRow; ++r) {
                                int idx1 = r * DoubleFFT_3D.this.rowStride;
                                for (int c = 0; c < DoubleFFT_3D.this.columns; ++c) {
                                    int idx4;
                                    int idx3;
                                    int s2;
                                    int idx2 = 2 * c;
                                    for (s2 = 0; s2 < DoubleFFT_3D.this.slices; ++s2) {
                                        idx3 = s2 * DoubleFFT_3D.this.sliceStride + idx1 + idx2;
                                        idx4 = 2 * s2;
                                        temp[idx4] = a[idx3];
                                        temp[idx4 + 1] = a[idx3 + 1];
                                    }
                                    DoubleFFT_3D.this.fftSlices.complexForward(temp);
                                    for (s2 = 0; s2 < DoubleFFT_3D.this.slices; ++s2) {
                                        idx3 = s2 * DoubleFFT_3D.this.sliceStride + idx1 + idx2;
                                        idx4 = 2 * s2;
                                        a[idx3] = temp[idx4];
                                        a[idx3 + 1] = temp[idx4 + 1];
                                    }
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                int idx4;
                int idx3;
                int idx2;
                int c;
                int idx1;
                for (int s2 = 0; s2 < this.slices; ++s2) {
                    int idx12 = s2 * this.sliceStride;
                    for (int r = 0; r < this.rows; ++r) {
                        this.fftColumns.complexForward(a, idx12 + r * this.rowStride);
                    }
                }
                double[] temp = new double[2 * this.rows];
                for (int s3 = 0; s3 < this.slices; ++s3) {
                    idx1 = s3 * this.sliceStride;
                    for (c = 0; c < this.columns; ++c) {
                        int r;
                        idx2 = 2 * c;
                        for (r = 0; r < this.rows; ++r) {
                            idx3 = idx1 + idx2 + r * this.rowStride;
                            idx4 = 2 * r;
                            temp[idx4] = a[idx3];
                            temp[idx4 + 1] = a[idx3 + 1];
                        }
                        this.fftRows.complexForward(temp);
                        for (r = 0; r < this.rows; ++r) {
                            idx3 = idx1 + idx2 + r * this.rowStride;
                            idx4 = 2 * r;
                            a[idx3] = temp[idx4];
                            a[idx3 + 1] = temp[idx4 + 1];
                        }
                    }
                }
                temp = new double[2 * this.slices];
                for (int r = 0; r < this.rows; ++r) {
                    idx1 = r * this.rowStride;
                    for (c = 0; c < this.columns; ++c) {
                        int s4;
                        idx2 = 2 * c;
                        for (s4 = 0; s4 < this.slices; ++s4) {
                            idx3 = s4 * this.sliceStride + idx1 + idx2;
                            idx4 = 2 * s4;
                            temp[idx4] = a[idx3];
                            temp[idx4 + 1] = a[idx3 + 1];
                        }
                        this.fftSlices.complexForward(temp);
                        for (s4 = 0; s4 < this.slices; ++s4) {
                            idx3 = s4 * this.sliceStride + idx1 + idx2;
                            idx4 = 2 * s4;
                            a[idx3] = temp[idx4];
                            a[idx3 + 1] = temp[idx4 + 1];
                        }
                    }
                }
            }
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
        }
    }

    public void complexForward(final DoubleLargeArray a) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            long oldn3 = this.columnsl;
            this.columnsl = 2L * this.columnsl;
            this.sliceStridel = this.rowsl * this.columnsl;
            this.rowStridel = this.columnsl;
            if (nthreads > 1 && this.useThreads) {
                this.xdft3da_subth2(0L, -1, a, true);
                this.cdft3db_subth(-1, a, true);
            } else {
                this.xdft3da_sub2(0L, -1, a, true);
                this.cdft3db_sub(-1, a, true);
            }
            this.columnsl = oldn3;
            this.sliceStridel = this.rowsl * this.columnsl;
            this.rowStridel = this.columnsl;
        } else {
            this.sliceStridel = 2L * this.rowsl * this.columnsl;
            this.rowStridel = 2L * this.columnsl;
            if (nthreads > 1 && this.useThreads && this.slicesl >= (long)nthreads && this.rowsl >= (long)nthreads && this.columnsl >= (long)nthreads) {
                long lastSlice;
                long firstSlice;
                Future[] futures = new Future[nthreads];
                long p = this.slicesl / (long)nthreads;
                for (int l = 0; l < nthreads; ++l) {
                    firstSlice = (long)l * p;
                    lastSlice = l == nthreads - 1 ? this.slicesl : firstSlice + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long s2 = firstSlice; s2 < lastSlice; ++s2) {
                                long idx1 = s2 * DoubleFFT_3D.this.sliceStridel;
                                for (long r = 0L; r < DoubleFFT_3D.this.rowsl; ++r) {
                                    DoubleFFT_3D.this.fftColumns.complexForward(a, idx1 + r * DoubleFFT_3D.this.rowStridel);
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                for (int l = 0; l < nthreads; ++l) {
                    firstSlice = (long)l * p;
                    lastSlice = l == nthreads - 1 ? this.slicesl : firstSlice + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            DoubleLargeArray temp = new DoubleLargeArray(2L * DoubleFFT_3D.this.rowsl, false);
                            for (long s2 = firstSlice; s2 < lastSlice; ++s2) {
                                long idx1 = s2 * DoubleFFT_3D.this.sliceStridel;
                                for (long c = 0L; c < DoubleFFT_3D.this.columnsl; ++c) {
                                    long idx4;
                                    long idx3;
                                    long r;
                                    long idx2 = 2L * c;
                                    for (r = 0L; r < DoubleFFT_3D.this.rowsl; ++r) {
                                        idx3 = idx1 + idx2 + r * DoubleFFT_3D.this.rowStridel;
                                        idx4 = 2L * r;
                                        temp.setDouble(idx4, a.getDouble(idx3));
                                        temp.setDouble(idx4 + 1L, a.getDouble(idx3 + 1L));
                                    }
                                    DoubleFFT_3D.this.fftRows.complexForward(temp);
                                    for (r = 0L; r < DoubleFFT_3D.this.rowsl; ++r) {
                                        idx3 = idx1 + idx2 + r * DoubleFFT_3D.this.rowStridel;
                                        idx4 = 2L * r;
                                        a.setDouble(idx3, temp.getDouble(idx4));
                                        a.setDouble(idx3 + 1L, temp.getDouble(idx4 + 1L));
                                    }
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                p = this.rowsl / (long)nthreads;
                for (int l = 0; l < nthreads; ++l) {
                    final long firstRow = (long)l * p;
                    final long lastRow = l == nthreads - 1 ? this.rowsl : firstRow + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            DoubleLargeArray temp = new DoubleLargeArray(2L * DoubleFFT_3D.this.slicesl, false);
                            for (long r = firstRow; r < lastRow; ++r) {
                                long idx1 = r * DoubleFFT_3D.this.rowStridel;
                                for (long c = 0L; c < DoubleFFT_3D.this.columnsl; ++c) {
                                    long idx4;
                                    long idx3;
                                    long s2;
                                    long idx2 = 2L * c;
                                    for (s2 = 0L; s2 < DoubleFFT_3D.this.slicesl; ++s2) {
                                        idx3 = s2 * DoubleFFT_3D.this.sliceStridel + idx1 + idx2;
                                        idx4 = 2L * s2;
                                        temp.setDouble(idx4, a.getDouble(idx3));
                                        temp.setDouble(idx4 + 1L, a.getDouble(idx3 + 1L));
                                    }
                                    DoubleFFT_3D.this.fftSlices.complexForward(temp);
                                    for (s2 = 0L; s2 < DoubleFFT_3D.this.slicesl; ++s2) {
                                        idx3 = s2 * DoubleFFT_3D.this.sliceStridel + idx1 + idx2;
                                        idx4 = 2L * s2;
                                        a.setDouble(idx3, temp.getDouble(idx4));
                                        a.setDouble(idx3 + 1L, temp.getDouble(idx4 + 1L));
                                    }
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                long idx4;
                long idx3;
                long idx2;
                long c;
                long idx1;
                for (long s2 = 0L; s2 < this.slicesl; ++s2) {
                    long idx12 = s2 * this.sliceStridel;
                    for (long r = 0L; r < this.rowsl; ++r) {
                        this.fftColumns.complexForward(a, idx12 + r * this.rowStridel);
                    }
                }
                DoubleLargeArray temp = new DoubleLargeArray(2L * this.rowsl, false);
                for (long s3 = 0L; s3 < this.slicesl; ++s3) {
                    idx1 = s3 * this.sliceStridel;
                    for (c = 0L; c < this.columnsl; ++c) {
                        long r;
                        idx2 = 2L * c;
                        for (r = 0L; r < this.rowsl; ++r) {
                            idx3 = idx1 + idx2 + r * this.rowStridel;
                            idx4 = 2L * r;
                            temp.setDouble(idx4, a.getDouble(idx3));
                            temp.setDouble(idx4 + 1L, a.getDouble(idx3 + 1L));
                        }
                        this.fftRows.complexForward(temp);
                        for (r = 0L; r < this.rowsl; ++r) {
                            idx3 = idx1 + idx2 + r * this.rowStridel;
                            idx4 = 2L * r;
                            a.setDouble(idx3, temp.getDouble(idx4));
                            a.setDouble(idx3 + 1L, temp.getDouble(idx4 + 1L));
                        }
                    }
                }
                temp = new DoubleLargeArray(2L * this.slicesl, false);
                for (long r = 0L; r < this.rowsl; ++r) {
                    idx1 = r * this.rowStridel;
                    for (c = 0L; c < this.columnsl; ++c) {
                        long s4;
                        idx2 = 2L * c;
                        for (s4 = 0L; s4 < this.slicesl; ++s4) {
                            idx3 = s4 * this.sliceStridel + idx1 + idx2;
                            idx4 = 2L * s4;
                            temp.setDouble(idx4, a.getDouble(idx3));
                            temp.setDouble(idx4 + 1L, a.getDouble(idx3 + 1L));
                        }
                        this.fftSlices.complexForward(temp);
                        for (s4 = 0L; s4 < this.slicesl; ++s4) {
                            idx3 = s4 * this.sliceStridel + idx1 + idx2;
                            idx4 = 2L * s4;
                            a.setDouble(idx3, temp.getDouble(idx4));
                            a.setDouble(idx3 + 1L, temp.getDouble(idx4 + 1L));
                        }
                    }
                }
            }
            this.sliceStridel = this.rowsl * this.columnsl;
            this.rowStridel = this.columnsl;
        }
    }

    public void complexForward(final double[][][] a) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            int oldn3 = this.columns;
            this.columns = 2 * this.columns;
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
            if (nthreads > 1 && this.useThreads) {
                this.xdft3da_subth2(0, -1, a, true);
                this.cdft3db_subth(-1, a, true);
            } else {
                this.xdft3da_sub2(0, -1, a, true);
                this.cdft3db_sub(-1, a, true);
            }
            this.columns = oldn3;
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
        } else if (nthreads > 1 && this.useThreads && this.slices >= nthreads && this.rows >= nthreads && this.columns >= nthreads) {
            int lastSlice;
            int firstSlice;
            Future[] futures = new Future[nthreads];
            int p = this.slices / nthreads;
            for (int l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                            for (int r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                DoubleFFT_3D.this.fftColumns.complexForward(a[s2][r]);
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            for (int l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] temp = new double[2 * DoubleFFT_3D.this.rows];
                        for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                            for (int c = 0; c < DoubleFFT_3D.this.columns; ++c) {
                                int idx4;
                                int r;
                                int idx2 = 2 * c;
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    idx4 = 2 * r;
                                    temp[idx4] = a[s2][r][idx2];
                                    temp[idx4 + 1] = a[s2][r][idx2 + 1];
                                }
                                DoubleFFT_3D.this.fftRows.complexForward(temp);
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    idx4 = 2 * r;
                                    a[s2][r][idx2] = temp[idx4];
                                    a[s2][r][idx2 + 1] = temp[idx4 + 1];
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            p = this.rows / nthreads;
            for (int l = 0; l < nthreads; ++l) {
                final int firstRow = l * p;
                final int lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] temp = new double[2 * DoubleFFT_3D.this.slices];
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < DoubleFFT_3D.this.columns; ++c) {
                                int idx4;
                                int s2;
                                int idx2 = 2 * c;
                                for (s2 = 0; s2 < DoubleFFT_3D.this.slices; ++s2) {
                                    idx4 = 2 * s2;
                                    temp[idx4] = a[s2][r][idx2];
                                    temp[idx4 + 1] = a[s2][r][idx2 + 1];
                                }
                                DoubleFFT_3D.this.fftSlices.complexForward(temp);
                                for (s2 = 0; s2 < DoubleFFT_3D.this.slices; ++s2) {
                                    idx4 = 2 * s2;
                                    a[s2][r][idx2] = temp[idx4];
                                    a[s2][r][idx2 + 1] = temp[idx4 + 1];
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            int idx4;
            int idx2;
            int c;
            int r;
            for (int s2 = 0; s2 < this.slices; ++s2) {
                for (r = 0; r < this.rows; ++r) {
                    this.fftColumns.complexForward(a[s2][r]);
                }
            }
            double[] temp = new double[2 * this.rows];
            for (int s3 = 0; s3 < this.slices; ++s3) {
                for (c = 0; c < this.columns; ++c) {
                    int r2;
                    idx2 = 2 * c;
                    for (r2 = 0; r2 < this.rows; ++r2) {
                        idx4 = 2 * r2;
                        temp[idx4] = a[s3][r2][idx2];
                        temp[idx4 + 1] = a[s3][r2][idx2 + 1];
                    }
                    this.fftRows.complexForward(temp);
                    for (r2 = 0; r2 < this.rows; ++r2) {
                        idx4 = 2 * r2;
                        a[s3][r2][idx2] = temp[idx4];
                        a[s3][r2][idx2 + 1] = temp[idx4 + 1];
                    }
                }
            }
            temp = new double[2 * this.slices];
            for (r = 0; r < this.rows; ++r) {
                for (c = 0; c < this.columns; ++c) {
                    int s4;
                    idx2 = 2 * c;
                    for (s4 = 0; s4 < this.slices; ++s4) {
                        idx4 = 2 * s4;
                        temp[idx4] = a[s4][r][idx2];
                        temp[idx4 + 1] = a[s4][r][idx2 + 1];
                    }
                    this.fftSlices.complexForward(temp);
                    for (s4 = 0; s4 < this.slices; ++s4) {
                        idx4 = 2 * s4;
                        a[s4][r][idx2] = temp[idx4];
                        a[s4][r][idx2 + 1] = temp[idx4 + 1];
                    }
                }
            }
        }
    }

    public void complexInverse(final double[] a, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            int oldn3 = this.columns;
            this.columns = 2 * this.columns;
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
            if (nthreads > 1 && this.useThreads) {
                this.xdft3da_subth2(0, 1, a, scale);
                this.cdft3db_subth(1, a, scale);
            } else {
                this.xdft3da_sub2(0, 1, a, scale);
                this.cdft3db_sub(1, a, scale);
            }
            this.columns = oldn3;
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
        } else {
            this.sliceStride = 2 * this.rows * this.columns;
            this.rowStride = 2 * this.columns;
            if (nthreads > 1 && this.useThreads && this.slices >= nthreads && this.rows >= nthreads && this.columns >= nthreads) {
                int lastSlice;
                int firstSlice;
                Future[] futures = new Future[nthreads];
                int p = this.slices / nthreads;
                for (int l = 0; l < nthreads; ++l) {
                    firstSlice = l * p;
                    lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                                int idx1 = s2 * DoubleFFT_3D.this.sliceStride;
                                for (int r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    DoubleFFT_3D.this.fftColumns.complexInverse(a, idx1 + r * DoubleFFT_3D.this.rowStride, scale);
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                for (int l = 0; l < nthreads; ++l) {
                    firstSlice = l * p;
                    lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            double[] temp = new double[2 * DoubleFFT_3D.this.rows];
                            for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                                int idx1 = s2 * DoubleFFT_3D.this.sliceStride;
                                for (int c = 0; c < DoubleFFT_3D.this.columns; ++c) {
                                    int idx4;
                                    int idx3;
                                    int r;
                                    int idx2 = 2 * c;
                                    for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                        idx3 = idx1 + idx2 + r * DoubleFFT_3D.this.rowStride;
                                        idx4 = 2 * r;
                                        temp[idx4] = a[idx3];
                                        temp[idx4 + 1] = a[idx3 + 1];
                                    }
                                    DoubleFFT_3D.this.fftRows.complexInverse(temp, scale);
                                    for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                        idx3 = idx1 + idx2 + r * DoubleFFT_3D.this.rowStride;
                                        idx4 = 2 * r;
                                        a[idx3] = temp[idx4];
                                        a[idx3 + 1] = temp[idx4 + 1];
                                    }
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                p = this.rows / nthreads;
                for (int l = 0; l < nthreads; ++l) {
                    final int firstRow = l * p;
                    final int lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            double[] temp = new double[2 * DoubleFFT_3D.this.slices];
                            for (int r = firstRow; r < lastRow; ++r) {
                                int idx1 = r * DoubleFFT_3D.this.rowStride;
                                for (int c = 0; c < DoubleFFT_3D.this.columns; ++c) {
                                    int idx4;
                                    int idx3;
                                    int s2;
                                    int idx2 = 2 * c;
                                    for (s2 = 0; s2 < DoubleFFT_3D.this.slices; ++s2) {
                                        idx3 = s2 * DoubleFFT_3D.this.sliceStride + idx1 + idx2;
                                        idx4 = 2 * s2;
                                        temp[idx4] = a[idx3];
                                        temp[idx4 + 1] = a[idx3 + 1];
                                    }
                                    DoubleFFT_3D.this.fftSlices.complexInverse(temp, scale);
                                    for (s2 = 0; s2 < DoubleFFT_3D.this.slices; ++s2) {
                                        idx3 = s2 * DoubleFFT_3D.this.sliceStride + idx1 + idx2;
                                        idx4 = 2 * s2;
                                        a[idx3] = temp[idx4];
                                        a[idx3 + 1] = temp[idx4 + 1];
                                    }
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                int idx4;
                int idx3;
                int idx2;
                int c;
                int idx1;
                for (int s2 = 0; s2 < this.slices; ++s2) {
                    int idx12 = s2 * this.sliceStride;
                    for (int r = 0; r < this.rows; ++r) {
                        this.fftColumns.complexInverse(a, idx12 + r * this.rowStride, scale);
                    }
                }
                double[] temp = new double[2 * this.rows];
                for (int s3 = 0; s3 < this.slices; ++s3) {
                    idx1 = s3 * this.sliceStride;
                    for (c = 0; c < this.columns; ++c) {
                        int r;
                        idx2 = 2 * c;
                        for (r = 0; r < this.rows; ++r) {
                            idx3 = idx1 + idx2 + r * this.rowStride;
                            idx4 = 2 * r;
                            temp[idx4] = a[idx3];
                            temp[idx4 + 1] = a[idx3 + 1];
                        }
                        this.fftRows.complexInverse(temp, scale);
                        for (r = 0; r < this.rows; ++r) {
                            idx3 = idx1 + idx2 + r * this.rowStride;
                            idx4 = 2 * r;
                            a[idx3] = temp[idx4];
                            a[idx3 + 1] = temp[idx4 + 1];
                        }
                    }
                }
                temp = new double[2 * this.slices];
                for (int r = 0; r < this.rows; ++r) {
                    idx1 = r * this.rowStride;
                    for (c = 0; c < this.columns; ++c) {
                        int s4;
                        idx2 = 2 * c;
                        for (s4 = 0; s4 < this.slices; ++s4) {
                            idx3 = s4 * this.sliceStride + idx1 + idx2;
                            idx4 = 2 * s4;
                            temp[idx4] = a[idx3];
                            temp[idx4 + 1] = a[idx3 + 1];
                        }
                        this.fftSlices.complexInverse(temp, scale);
                        for (s4 = 0; s4 < this.slices; ++s4) {
                            idx3 = s4 * this.sliceStride + idx1 + idx2;
                            idx4 = 2 * s4;
                            a[idx3] = temp[idx4];
                            a[idx3 + 1] = temp[idx4 + 1];
                        }
                    }
                }
            }
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
        }
    }

    public void complexInverse(final DoubleLargeArray a, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            long oldn3 = this.columnsl;
            this.columnsl = 2L * this.columnsl;
            this.sliceStridel = this.rowsl * this.columnsl;
            this.rowStridel = this.columnsl;
            if (nthreads > 1 && this.useThreads) {
                this.xdft3da_subth2(0L, 1, a, scale);
                this.cdft3db_subth(1, a, scale);
            } else {
                this.xdft3da_sub2(0L, 1, a, scale);
                this.cdft3db_sub(1, a, scale);
            }
            this.columnsl = oldn3;
            this.sliceStridel = this.rowsl * this.columnsl;
            this.rowStridel = this.columnsl;
        } else {
            this.sliceStridel = 2L * this.rowsl * this.columnsl;
            this.rowStridel = 2L * this.columnsl;
            if (nthreads > 1 && this.useThreads && this.slicesl >= (long)nthreads && this.rowsl >= (long)nthreads && this.columnsl >= (long)nthreads) {
                long lastSlice;
                long firstSlice;
                Future[] futures = new Future[nthreads];
                long p = this.slicesl / (long)nthreads;
                for (int l = 0; l < nthreads; ++l) {
                    firstSlice = (long)l * p;
                    lastSlice = l == nthreads - 1 ? this.slicesl : firstSlice + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long s2 = firstSlice; s2 < lastSlice; ++s2) {
                                long idx1 = s2 * DoubleFFT_3D.this.sliceStridel;
                                for (long r = 0L; r < DoubleFFT_3D.this.rowsl; ++r) {
                                    DoubleFFT_3D.this.fftColumns.complexInverse(a, idx1 + r * DoubleFFT_3D.this.rowStridel, scale);
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                for (int l = 0; l < nthreads; ++l) {
                    firstSlice = (long)l * p;
                    lastSlice = l == nthreads - 1 ? this.slicesl : firstSlice + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            DoubleLargeArray temp = new DoubleLargeArray(2L * DoubleFFT_3D.this.rowsl, false);
                            for (long s2 = firstSlice; s2 < lastSlice; ++s2) {
                                long idx1 = s2 * DoubleFFT_3D.this.sliceStridel;
                                for (long c = 0L; c < DoubleFFT_3D.this.columnsl; ++c) {
                                    long idx4;
                                    long idx3;
                                    long r;
                                    long idx2 = 2L * c;
                                    for (r = 0L; r < DoubleFFT_3D.this.rowsl; ++r) {
                                        idx3 = idx1 + idx2 + r * DoubleFFT_3D.this.rowStridel;
                                        idx4 = 2L * r;
                                        temp.setDouble(idx4, a.getDouble(idx3));
                                        temp.setDouble(idx4 + 1L, a.getDouble(idx3 + 1L));
                                    }
                                    DoubleFFT_3D.this.fftRows.complexInverse(temp, scale);
                                    for (r = 0L; r < DoubleFFT_3D.this.rowsl; ++r) {
                                        idx3 = idx1 + idx2 + r * DoubleFFT_3D.this.rowStridel;
                                        idx4 = 2L * r;
                                        a.setDouble(idx3, temp.getDouble(idx4));
                                        a.setDouble(idx3 + 1L, temp.getDouble(idx4 + 1L));
                                    }
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                p = this.rowsl / (long)nthreads;
                for (int l = 0; l < nthreads; ++l) {
                    final long firstRow = (long)l * p;
                    final long lastRow = l == nthreads - 1 ? this.rowsl : firstRow + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            DoubleLargeArray temp = new DoubleLargeArray(2L * DoubleFFT_3D.this.slicesl, false);
                            for (long r = firstRow; r < lastRow; ++r) {
                                long idx1 = r * DoubleFFT_3D.this.rowStridel;
                                for (long c = 0L; c < DoubleFFT_3D.this.columnsl; ++c) {
                                    long idx4;
                                    long idx3;
                                    long s2;
                                    long idx2 = 2L * c;
                                    for (s2 = 0L; s2 < DoubleFFT_3D.this.slicesl; ++s2) {
                                        idx3 = s2 * DoubleFFT_3D.this.sliceStridel + idx1 + idx2;
                                        idx4 = 2L * s2;
                                        temp.setDouble(idx4, a.getDouble(idx3));
                                        temp.setDouble(idx4 + 1L, a.getDouble(idx3 + 1L));
                                    }
                                    DoubleFFT_3D.this.fftSlices.complexInverse(temp, scale);
                                    for (s2 = 0L; s2 < DoubleFFT_3D.this.slicesl; ++s2) {
                                        idx3 = s2 * DoubleFFT_3D.this.sliceStridel + idx1 + idx2;
                                        idx4 = 2L * s2;
                                        a.setDouble(idx3, temp.getDouble(idx4));
                                        a.setDouble(idx3 + 1L, temp.getDouble(idx4 + 1L));
                                    }
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                long idx4;
                long idx3;
                long idx2;
                long c;
                long idx1;
                for (long s2 = 0L; s2 < this.slicesl; ++s2) {
                    long idx12 = s2 * this.sliceStridel;
                    for (long r = 0L; r < this.rowsl; ++r) {
                        this.fftColumns.complexInverse(a, idx12 + r * this.rowStridel, scale);
                    }
                }
                DoubleLargeArray temp = new DoubleLargeArray(2L * this.rowsl, false);
                for (long s3 = 0L; s3 < this.slicesl; ++s3) {
                    idx1 = s3 * this.sliceStridel;
                    for (c = 0L; c < this.columnsl; ++c) {
                        long r;
                        idx2 = 2L * c;
                        for (r = 0L; r < this.rowsl; ++r) {
                            idx3 = idx1 + idx2 + r * this.rowStridel;
                            idx4 = 2L * r;
                            temp.setDouble(idx4, a.getDouble(idx3));
                            temp.setDouble(idx4 + 1L, a.getDouble(idx3 + 1L));
                        }
                        this.fftRows.complexInverse(temp, scale);
                        for (r = 0L; r < this.rowsl; ++r) {
                            idx3 = idx1 + idx2 + r * this.rowStridel;
                            idx4 = 2L * r;
                            a.setDouble(idx3, temp.getDouble(idx4));
                            a.setDouble(idx3 + 1L, temp.getDouble(idx4 + 1L));
                        }
                    }
                }
                temp = new DoubleLargeArray(2L * this.slicesl, false);
                for (long r = 0L; r < this.rowsl; ++r) {
                    idx1 = r * this.rowStridel;
                    for (c = 0L; c < this.columnsl; ++c) {
                        long s4;
                        idx2 = 2L * c;
                        for (s4 = 0L; s4 < this.slicesl; ++s4) {
                            idx3 = s4 * this.sliceStridel + idx1 + idx2;
                            idx4 = 2L * s4;
                            temp.setDouble(idx4, a.getDouble(idx3));
                            temp.setDouble(idx4 + 1L, a.getDouble(idx3 + 1L));
                        }
                        this.fftSlices.complexInverse(temp, scale);
                        for (s4 = 0L; s4 < this.slicesl; ++s4) {
                            idx3 = s4 * this.sliceStridel + idx1 + idx2;
                            idx4 = 2L * s4;
                            a.setDouble(idx3, temp.getDouble(idx4));
                            a.setDouble(idx3 + 1L, temp.getDouble(idx4 + 1L));
                        }
                    }
                }
            }
            this.sliceStridel = this.rowsl * this.columnsl;
            this.rowStridel = this.columnsl;
        }
    }

    public void complexInverse(final double[][][] a, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            int oldn3 = this.columns;
            this.columns = 2 * this.columns;
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
            if (nthreads > 1 && this.useThreads) {
                this.xdft3da_subth2(0, 1, a, scale);
                this.cdft3db_subth(1, a, scale);
            } else {
                this.xdft3da_sub2(0, 1, a, scale);
                this.cdft3db_sub(1, a, scale);
            }
            this.columns = oldn3;
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
        } else if (nthreads > 1 && this.useThreads && this.slices >= nthreads && this.rows >= nthreads && this.columns >= nthreads) {
            int lastSlice;
            int firstSlice;
            Future[] futures = new Future[nthreads];
            int p = this.slices / nthreads;
            for (int l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                            for (int r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                DoubleFFT_3D.this.fftColumns.complexInverse(a[s2][r], scale);
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            for (int l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] temp = new double[2 * DoubleFFT_3D.this.rows];
                        for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                            for (int c = 0; c < DoubleFFT_3D.this.columns; ++c) {
                                int idx4;
                                int r;
                                int idx2 = 2 * c;
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    idx4 = 2 * r;
                                    temp[idx4] = a[s2][r][idx2];
                                    temp[idx4 + 1] = a[s2][r][idx2 + 1];
                                }
                                DoubleFFT_3D.this.fftRows.complexInverse(temp, scale);
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    idx4 = 2 * r;
                                    a[s2][r][idx2] = temp[idx4];
                                    a[s2][r][idx2 + 1] = temp[idx4 + 1];
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            p = this.rows / nthreads;
            for (int l = 0; l < nthreads; ++l) {
                final int firstRow = l * p;
                final int lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] temp = new double[2 * DoubleFFT_3D.this.slices];
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < DoubleFFT_3D.this.columns; ++c) {
                                int idx4;
                                int s2;
                                int idx2 = 2 * c;
                                for (s2 = 0; s2 < DoubleFFT_3D.this.slices; ++s2) {
                                    idx4 = 2 * s2;
                                    temp[idx4] = a[s2][r][idx2];
                                    temp[idx4 + 1] = a[s2][r][idx2 + 1];
                                }
                                DoubleFFT_3D.this.fftSlices.complexInverse(temp, scale);
                                for (s2 = 0; s2 < DoubleFFT_3D.this.slices; ++s2) {
                                    idx4 = 2 * s2;
                                    a[s2][r][idx2] = temp[idx4];
                                    a[s2][r][idx2 + 1] = temp[idx4 + 1];
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            int idx4;
            int idx2;
            int c;
            int r;
            for (int s2 = 0; s2 < this.slices; ++s2) {
                for (r = 0; r < this.rows; ++r) {
                    this.fftColumns.complexInverse(a[s2][r], scale);
                }
            }
            double[] temp = new double[2 * this.rows];
            for (int s3 = 0; s3 < this.slices; ++s3) {
                for (c = 0; c < this.columns; ++c) {
                    int r2;
                    idx2 = 2 * c;
                    for (r2 = 0; r2 < this.rows; ++r2) {
                        idx4 = 2 * r2;
                        temp[idx4] = a[s3][r2][idx2];
                        temp[idx4 + 1] = a[s3][r2][idx2 + 1];
                    }
                    this.fftRows.complexInverse(temp, scale);
                    for (r2 = 0; r2 < this.rows; ++r2) {
                        idx4 = 2 * r2;
                        a[s3][r2][idx2] = temp[idx4];
                        a[s3][r2][idx2 + 1] = temp[idx4 + 1];
                    }
                }
            }
            temp = new double[2 * this.slices];
            for (r = 0; r < this.rows; ++r) {
                for (c = 0; c < this.columns; ++c) {
                    int s4;
                    idx2 = 2 * c;
                    for (s4 = 0; s4 < this.slices; ++s4) {
                        idx4 = 2 * s4;
                        temp[idx4] = a[s4][r][idx2];
                        temp[idx4 + 1] = a[s4][r][idx2 + 1];
                    }
                    this.fftSlices.complexInverse(temp, scale);
                    for (s4 = 0; s4 < this.slices; ++s4) {
                        idx4 = 2 * s4;
                        a[s4][r][idx2] = temp[idx4];
                        a[s4][r][idx2 + 1] = temp[idx4 + 1];
                    }
                }
            }
        }
    }

    public void realForward(double[] a) {
        if (!this.isPowerOfTwo) {
            throw new IllegalArgumentException("slices, rows and columns must be power of two numbers");
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.useThreads) {
            this.xdft3da_subth1(1, -1, a, true);
            this.cdft3db_subth(-1, a, true);
            this.rdft3d_sub(1, a);
        } else {
            this.xdft3da_sub1(1, -1, a, true);
            this.cdft3db_sub(-1, a, true);
            this.rdft3d_sub(1, a);
        }
    }

    public void realForward(DoubleLargeArray a) {
        if (!this.isPowerOfTwo) {
            throw new IllegalArgumentException("slices, rows and columns must be power of two numbers");
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.useThreads) {
            this.xdft3da_subth1(1L, -1, a, true);
            this.cdft3db_subth(-1, a, true);
            this.rdft3d_sub(1, a);
        } else {
            this.xdft3da_sub1(1L, -1, a, true);
            this.cdft3db_sub(-1, a, true);
            this.rdft3d_sub(1, a);
        }
    }

    public void realForward(double[][][] a) {
        if (!this.isPowerOfTwo) {
            throw new IllegalArgumentException("slices, rows and columns must be power of two numbers");
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.useThreads) {
            this.xdft3da_subth1(1, -1, a, true);
            this.cdft3db_subth(-1, a, true);
            this.rdft3d_sub(1, a);
        } else {
            this.xdft3da_sub1(1, -1, a, true);
            this.cdft3db_sub(-1, a, true);
            this.rdft3d_sub(1, a);
        }
    }

    public void realForwardFull(double[] a) {
        if (this.isPowerOfTwo) {
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (nthreads > 1 && this.useThreads) {
                this.xdft3da_subth2(1, -1, a, true);
                this.cdft3db_subth(-1, a, true);
                this.rdft3d_sub(1, a);
            } else {
                this.xdft3da_sub2(1, -1, a, true);
                this.cdft3db_sub(-1, a, true);
                this.rdft3d_sub(1, a);
            }
            this.fillSymmetric(a);
        } else {
            this.mixedRadixRealForwardFull(a);
        }
    }

    public void realForwardFull(DoubleLargeArray a) {
        if (this.isPowerOfTwo) {
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (nthreads > 1 && this.useThreads) {
                this.xdft3da_subth2(1L, -1, a, true);
                this.cdft3db_subth(-1, a, true);
                this.rdft3d_sub(1, a);
            } else {
                this.xdft3da_sub2(1L, -1, a, true);
                this.cdft3db_sub(-1, a, true);
                this.rdft3d_sub(1, a);
            }
            this.fillSymmetric(a);
        } else {
            this.mixedRadixRealForwardFull(a);
        }
    }

    public void realForwardFull(double[][][] a) {
        if (this.isPowerOfTwo) {
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (nthreads > 1 && this.useThreads) {
                this.xdft3da_subth2(1, -1, a, true);
                this.cdft3db_subth(-1, a, true);
                this.rdft3d_sub(1, a);
            } else {
                this.xdft3da_sub2(1, -1, a, true);
                this.cdft3db_sub(-1, a, true);
                this.rdft3d_sub(1, a);
            }
            this.fillSymmetric(a);
        } else {
            this.mixedRadixRealForwardFull(a);
        }
    }

    public void realInverse(double[] a, boolean scale) {
        if (!this.isPowerOfTwo) {
            throw new IllegalArgumentException("slices, rows and columns must be power of two numbers");
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.useThreads) {
            this.rdft3d_sub(-1, a);
            this.cdft3db_subth(1, a, scale);
            this.xdft3da_subth1(1, 1, a, scale);
        } else {
            this.rdft3d_sub(-1, a);
            this.cdft3db_sub(1, a, scale);
            this.xdft3da_sub1(1, 1, a, scale);
        }
    }

    public void realInverse(DoubleLargeArray a, boolean scale) {
        if (!this.isPowerOfTwo) {
            throw new IllegalArgumentException("slices, rows and columns must be power of two numbers");
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.useThreads) {
            this.rdft3d_sub(-1, a);
            this.cdft3db_subth(1, a, scale);
            this.xdft3da_subth1(1L, 1, a, scale);
        } else {
            this.rdft3d_sub(-1, a);
            this.cdft3db_sub(1, a, scale);
            this.xdft3da_sub1(1L, 1, a, scale);
        }
    }

    public void realInverse(double[][][] a, boolean scale) {
        if (!this.isPowerOfTwo) {
            throw new IllegalArgumentException("slices, rows and columns must be power of two numbers");
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.useThreads) {
            this.rdft3d_sub(-1, a);
            this.cdft3db_subth(1, a, scale);
            this.xdft3da_subth1(1, 1, a, scale);
        } else {
            this.rdft3d_sub(-1, a);
            this.cdft3db_sub(1, a, scale);
            this.xdft3da_sub1(1, 1, a, scale);
        }
    }

    public void realInverseFull(double[] a, boolean scale) {
        if (this.isPowerOfTwo) {
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (nthreads > 1 && this.useThreads) {
                this.xdft3da_subth2(1, 1, a, scale);
                this.cdft3db_subth(1, a, scale);
                this.rdft3d_sub(1, a);
            } else {
                this.xdft3da_sub2(1, 1, a, scale);
                this.cdft3db_sub(1, a, scale);
                this.rdft3d_sub(1, a);
            }
            this.fillSymmetric(a);
        } else {
            this.mixedRadixRealInverseFull(a, scale);
        }
    }

    public void realInverseFull(DoubleLargeArray a, boolean scale) {
        if (this.isPowerOfTwo) {
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (nthreads > 1 && this.useThreads) {
                this.xdft3da_subth2(1L, 1, a, scale);
                this.cdft3db_subth(1, a, scale);
                this.rdft3d_sub(1, a);
            } else {
                this.xdft3da_sub2(1L, 1, a, scale);
                this.cdft3db_sub(1, a, scale);
                this.rdft3d_sub(1, a);
            }
            this.fillSymmetric(a);
        } else {
            this.mixedRadixRealInverseFull(a, scale);
        }
    }

    public void realInverseFull(double[][][] a, boolean scale) {
        if (this.isPowerOfTwo) {
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (nthreads > 1 && this.useThreads) {
                this.xdft3da_subth2(1, 1, a, scale);
                this.cdft3db_subth(1, a, scale);
                this.rdft3d_sub(1, a);
            } else {
                this.xdft3da_sub2(1, 1, a, scale);
                this.cdft3db_sub(1, a, scale);
                this.rdft3d_sub(1, a);
            }
            this.fillSymmetric(a);
        } else {
            this.mixedRadixRealInverseFull(a, scale);
        }
    }

    private void mixedRadixRealForwardFull(final double[][][] a) {
        double[] temp = new double[2 * this.rows];
        int ldimn2 = this.rows / 2 + 1;
        final int newn3 = 2 * this.columns;
        final int n2d2 = this.rows % 2 == 0 ? this.rows / 2 : (this.rows + 1) / 2;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.useThreads && this.slices >= nthreads && this.columns >= nthreads && ldimn2 >= nthreads) {
            int lastSlice;
            int firstSlice;
            Future[] futures = new Future[nthreads];
            int p = this.slices / nthreads;
            for (int l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                            for (int r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                DoubleFFT_3D.this.fftColumns.realForwardFull(a[s2][r]);
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            for (int l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] temp = new double[2 * DoubleFFT_3D.this.rows];
                        for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                            for (int c = 0; c < DoubleFFT_3D.this.columns; ++c) {
                                int idx4;
                                int r;
                                int idx2 = 2 * c;
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    idx4 = 2 * r;
                                    temp[idx4] = a[s2][r][idx2];
                                    temp[idx4 + 1] = a[s2][r][idx2 + 1];
                                }
                                DoubleFFT_3D.this.fftRows.complexForward(temp);
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    idx4 = 2 * r;
                                    a[s2][r][idx2] = temp[idx4];
                                    a[s2][r][idx2 + 1] = temp[idx4 + 1];
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            p = ldimn2 / nthreads;
            for (int l = 0; l < nthreads; ++l) {
                final int firstRow = l * p;
                final int lastRow = l == nthreads - 1 ? ldimn2 : firstRow + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] temp = new double[2 * DoubleFFT_3D.this.slices];
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < DoubleFFT_3D.this.columns; ++c) {
                                int idx2;
                                int s2;
                                int idx1 = 2 * c;
                                for (s2 = 0; s2 < DoubleFFT_3D.this.slices; ++s2) {
                                    idx2 = 2 * s2;
                                    temp[idx2] = a[s2][r][idx1];
                                    temp[idx2 + 1] = a[s2][r][idx1 + 1];
                                }
                                DoubleFFT_3D.this.fftSlices.complexForward(temp);
                                for (s2 = 0; s2 < DoubleFFT_3D.this.slices; ++s2) {
                                    idx2 = 2 * s2;
                                    a[s2][r][idx1] = temp[idx2];
                                    a[s2][r][idx1 + 1] = temp[idx2 + 1];
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            p = this.slices / nthreads;
            for (int l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                            int idx2 = (DoubleFFT_3D.this.slices - s2) % DoubleFFT_3D.this.slices;
                            for (int r = 1; r < n2d2; ++r) {
                                int idx4 = DoubleFFT_3D.this.rows - r;
                                for (int c = 0; c < DoubleFFT_3D.this.columns; ++c) {
                                    int idx1 = 2 * c;
                                    int idx3 = newn3 - idx1;
                                    a[idx2][idx4][idx3 % newn3] = a[s2][r][idx1];
                                    a[idx2][idx4][(idx3 + 1) % newn3] = -a[s2][r][idx1 + 1];
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            int c;
            int s2;
            for (s2 = 0; s2 < this.slices; ++s2) {
                for (int r = 0; r < this.rows; ++r) {
                    this.fftColumns.realForwardFull(a[s2][r]);
                }
            }
            for (s2 = 0; s2 < this.slices; ++s2) {
                for (c = 0; c < this.columns; ++c) {
                    int idx4;
                    int r;
                    int idx2 = 2 * c;
                    for (r = 0; r < this.rows; ++r) {
                        idx4 = 2 * r;
                        temp[idx4] = a[s2][r][idx2];
                        temp[idx4 + 1] = a[s2][r][idx2 + 1];
                    }
                    this.fftRows.complexForward(temp);
                    for (r = 0; r < this.rows; ++r) {
                        idx4 = 2 * r;
                        a[s2][r][idx2] = temp[idx4];
                        a[s2][r][idx2 + 1] = temp[idx4 + 1];
                    }
                }
            }
            temp = new double[2 * this.slices];
            for (int r = 0; r < ldimn2; ++r) {
                for (c = 0; c < this.columns; ++c) {
                    int idx2;
                    int s3;
                    int idx1 = 2 * c;
                    for (s3 = 0; s3 < this.slices; ++s3) {
                        idx2 = 2 * s3;
                        temp[idx2] = a[s3][r][idx1];
                        temp[idx2 + 1] = a[s3][r][idx1 + 1];
                    }
                    this.fftSlices.complexForward(temp);
                    for (s3 = 0; s3 < this.slices; ++s3) {
                        idx2 = 2 * s3;
                        a[s3][r][idx1] = temp[idx2];
                        a[s3][r][idx1 + 1] = temp[idx2 + 1];
                    }
                }
            }
            for (s2 = 0; s2 < this.slices; ++s2) {
                int idx2 = (this.slices - s2) % this.slices;
                for (int r = 1; r < n2d2; ++r) {
                    int idx4 = this.rows - r;
                    for (int c2 = 0; c2 < this.columns; ++c2) {
                        int idx1 = 2 * c2;
                        int idx3 = newn3 - idx1;
                        a[idx2][idx4][idx3 % newn3] = a[s2][r][idx1];
                        a[idx2][idx4][(idx3 + 1) % newn3] = -a[s2][r][idx1 + 1];
                    }
                }
            }
        }
    }

    private void mixedRadixRealInverseFull(final double[][][] a, final boolean scale) {
        double[] temp = new double[2 * this.rows];
        int ldimn2 = this.rows / 2 + 1;
        final int newn3 = 2 * this.columns;
        final int n2d2 = this.rows % 2 == 0 ? this.rows / 2 : (this.rows + 1) / 2;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.useThreads && this.slices >= nthreads && this.columns >= nthreads && ldimn2 >= nthreads) {
            int lastSlice;
            int firstSlice;
            Future[] futures = new Future[nthreads];
            int p = this.slices / nthreads;
            for (int l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                            for (int r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                DoubleFFT_3D.this.fftColumns.realInverseFull(a[s2][r], scale);
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            for (int l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] temp = new double[2 * DoubleFFT_3D.this.rows];
                        for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                            for (int c = 0; c < DoubleFFT_3D.this.columns; ++c) {
                                int idx4;
                                int r;
                                int idx2 = 2 * c;
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    idx4 = 2 * r;
                                    temp[idx4] = a[s2][r][idx2];
                                    temp[idx4 + 1] = a[s2][r][idx2 + 1];
                                }
                                DoubleFFT_3D.this.fftRows.complexInverse(temp, scale);
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    idx4 = 2 * r;
                                    a[s2][r][idx2] = temp[idx4];
                                    a[s2][r][idx2 + 1] = temp[idx4 + 1];
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            p = ldimn2 / nthreads;
            for (int l = 0; l < nthreads; ++l) {
                final int firstRow = l * p;
                final int lastRow = l == nthreads - 1 ? ldimn2 : firstRow + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] temp = new double[2 * DoubleFFT_3D.this.slices];
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < DoubleFFT_3D.this.columns; ++c) {
                                int idx2;
                                int s2;
                                int idx1 = 2 * c;
                                for (s2 = 0; s2 < DoubleFFT_3D.this.slices; ++s2) {
                                    idx2 = 2 * s2;
                                    temp[idx2] = a[s2][r][idx1];
                                    temp[idx2 + 1] = a[s2][r][idx1 + 1];
                                }
                                DoubleFFT_3D.this.fftSlices.complexInverse(temp, scale);
                                for (s2 = 0; s2 < DoubleFFT_3D.this.slices; ++s2) {
                                    idx2 = 2 * s2;
                                    a[s2][r][idx1] = temp[idx2];
                                    a[s2][r][idx1 + 1] = temp[idx2 + 1];
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            p = this.slices / nthreads;
            for (int l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                            int idx2 = (DoubleFFT_3D.this.slices - s2) % DoubleFFT_3D.this.slices;
                            for (int r = 1; r < n2d2; ++r) {
                                int idx4 = DoubleFFT_3D.this.rows - r;
                                for (int c = 0; c < DoubleFFT_3D.this.columns; ++c) {
                                    int idx1 = 2 * c;
                                    int idx3 = newn3 - idx1;
                                    a[idx2][idx4][idx3 % newn3] = a[s2][r][idx1];
                                    a[idx2][idx4][(idx3 + 1) % newn3] = -a[s2][r][idx1 + 1];
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            int c;
            int s2;
            for (s2 = 0; s2 < this.slices; ++s2) {
                for (int r = 0; r < this.rows; ++r) {
                    this.fftColumns.realInverseFull(a[s2][r], scale);
                }
            }
            for (s2 = 0; s2 < this.slices; ++s2) {
                for (c = 0; c < this.columns; ++c) {
                    int idx4;
                    int r;
                    int idx2 = 2 * c;
                    for (r = 0; r < this.rows; ++r) {
                        idx4 = 2 * r;
                        temp[idx4] = a[s2][r][idx2];
                        temp[idx4 + 1] = a[s2][r][idx2 + 1];
                    }
                    this.fftRows.complexInverse(temp, scale);
                    for (r = 0; r < this.rows; ++r) {
                        idx4 = 2 * r;
                        a[s2][r][idx2] = temp[idx4];
                        a[s2][r][idx2 + 1] = temp[idx4 + 1];
                    }
                }
            }
            temp = new double[2 * this.slices];
            for (int r = 0; r < ldimn2; ++r) {
                for (c = 0; c < this.columns; ++c) {
                    int idx2;
                    int s3;
                    int idx1 = 2 * c;
                    for (s3 = 0; s3 < this.slices; ++s3) {
                        idx2 = 2 * s3;
                        temp[idx2] = a[s3][r][idx1];
                        temp[idx2 + 1] = a[s3][r][idx1 + 1];
                    }
                    this.fftSlices.complexInverse(temp, scale);
                    for (s3 = 0; s3 < this.slices; ++s3) {
                        idx2 = 2 * s3;
                        a[s3][r][idx1] = temp[idx2];
                        a[s3][r][idx1 + 1] = temp[idx2 + 1];
                    }
                }
            }
            for (s2 = 0; s2 < this.slices; ++s2) {
                int idx2 = (this.slices - s2) % this.slices;
                for (int r = 1; r < n2d2; ++r) {
                    int idx4 = this.rows - r;
                    for (int c2 = 0; c2 < this.columns; ++c2) {
                        int idx1 = 2 * c2;
                        int idx3 = newn3 - idx1;
                        a[idx2][idx4][idx3 % newn3] = a[s2][r][idx1];
                        a[idx2][idx4][(idx3 + 1) % newn3] = -a[s2][r][idx1 + 1];
                    }
                }
            }
        }
    }

    private void mixedRadixRealForwardFull(final double[] a) {
        final int twon3 = 2 * this.columns;
        double[] temp = new double[twon3];
        int ldimn2 = this.rows / 2 + 1;
        final int n2d2 = this.rows % 2 == 0 ? this.rows / 2 : (this.rows + 1) / 2;
        final int twoSliceStride = 2 * this.sliceStride;
        final int twoRowStride = 2 * this.rowStride;
        int n1d2 = this.slices / 2;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.useThreads && n1d2 >= nthreads && this.columns >= nthreads && ldimn2 >= nthreads) {
            int lastSlice;
            int firstSlice;
            Future[] futures = new Future[nthreads];
            int p = n1d2 / nthreads;
            for (int l = 0; l < nthreads; ++l) {
                final int firstSlice2 = this.slices - 1 - l * p;
                final int lastSlice2 = l == nthreads - 1 ? n1d2 + 1 : firstSlice2 - p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] temp = new double[twon3];
                        for (int s2 = firstSlice2; s2 >= lastSlice2; --s2) {
                            int idx1 = s2 * DoubleFFT_3D.this.sliceStride;
                            int idx2 = s2 * twoSliceStride;
                            for (int r = DoubleFFT_3D.this.rows - 1; r >= 0; --r) {
                                System.arraycopy(a, idx1 + r * DoubleFFT_3D.this.rowStride, temp, 0, DoubleFFT_3D.this.columns);
                                DoubleFFT_3D.this.fftColumns.realForwardFull(temp);
                                System.arraycopy(temp, 0, a, idx2 + r * twoRowStride, twon3);
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            final double[][][] temp2 = new double[n1d2 + 1][this.rows][twon3];
            for (int l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? n1d2 + 1 : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                            int idx1 = s2 * DoubleFFT_3D.this.sliceStride;
                            for (int r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                System.arraycopy(a, idx1 + r * DoubleFFT_3D.this.rowStride, temp2[s2][r], 0, DoubleFFT_3D.this.columns);
                                DoubleFFT_3D.this.fftColumns.realForwardFull(temp2[s2][r]);
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            for (int l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? n1d2 + 1 : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                            int idx1 = s2 * twoSliceStride;
                            for (int r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                System.arraycopy(temp2[s2][r], 0, a, idx1 + r * twoRowStride, twon3);
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            p = this.slices / nthreads;
            for (int l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] temp = new double[2 * DoubleFFT_3D.this.rows];
                        for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                            int idx1 = s2 * twoSliceStride;
                            for (int c = 0; c < DoubleFFT_3D.this.columns; ++c) {
                                int idx4;
                                int idx3;
                                int r;
                                int idx2 = 2 * c;
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    idx3 = idx1 + r * twoRowStride + idx2;
                                    idx4 = 2 * r;
                                    temp[idx4] = a[idx3];
                                    temp[idx4 + 1] = a[idx3 + 1];
                                }
                                DoubleFFT_3D.this.fftRows.complexForward(temp);
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    idx3 = idx1 + r * twoRowStride + idx2;
                                    idx4 = 2 * r;
                                    a[idx3] = temp[idx4];
                                    a[idx3 + 1] = temp[idx4 + 1];
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            p = ldimn2 / nthreads;
            for (int l = 0; l < nthreads; ++l) {
                final int firstRow = l * p;
                final int lastRow = l == nthreads - 1 ? ldimn2 : firstRow + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] temp = new double[2 * DoubleFFT_3D.this.slices];
                        for (int r = firstRow; r < lastRow; ++r) {
                            int idx3 = r * twoRowStride;
                            for (int c = 0; c < DoubleFFT_3D.this.columns; ++c) {
                                int idx4;
                                int idx2;
                                int s2;
                                int idx1 = 2 * c;
                                for (s2 = 0; s2 < DoubleFFT_3D.this.slices; ++s2) {
                                    idx2 = 2 * s2;
                                    idx4 = s2 * twoSliceStride + idx3 + idx1;
                                    temp[idx2] = a[idx4];
                                    temp[idx2 + 1] = a[idx4 + 1];
                                }
                                DoubleFFT_3D.this.fftSlices.complexForward(temp);
                                for (s2 = 0; s2 < DoubleFFT_3D.this.slices; ++s2) {
                                    idx2 = 2 * s2;
                                    idx4 = s2 * twoSliceStride + idx3 + idx1;
                                    a[idx4] = temp[idx2];
                                    a[idx4 + 1] = temp[idx2 + 1];
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            p = this.slices / nthreads;
            for (int l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                            int idx2 = (DoubleFFT_3D.this.slices - s2) % DoubleFFT_3D.this.slices;
                            int idx5 = idx2 * twoSliceStride;
                            int idx6 = s2 * twoSliceStride;
                            for (int r = 1; r < n2d2; ++r) {
                                int idx4 = DoubleFFT_3D.this.rows - r;
                                int idx7 = idx4 * twoRowStride;
                                int idx8 = r * twoRowStride;
                                int idx9 = idx5 + idx7;
                                for (int c = 0; c < DoubleFFT_3D.this.columns; ++c) {
                                    int idx1 = 2 * c;
                                    int idx3 = twon3 - idx1;
                                    int idx10 = idx6 + idx8 + idx1;
                                    a[idx9 + idx3 % twon3] = a[idx10];
                                    a[idx9 + (idx3 + 1) % twon3] = -a[idx10 + 1];
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            int idx4;
            int r;
            int c;
            int idx1;
            int s2;
            for (s2 = this.slices - 1; s2 >= 0; --s2) {
                idx1 = s2 * this.sliceStride;
                int idx2 = s2 * twoSliceStride;
                for (int r2 = this.rows - 1; r2 >= 0; --r2) {
                    System.arraycopy(a, idx1 + r2 * this.rowStride, temp, 0, this.columns);
                    this.fftColumns.realForwardFull(temp);
                    System.arraycopy(temp, 0, a, idx2 + r2 * twoRowStride, twon3);
                }
            }
            temp = new double[2 * this.rows];
            for (s2 = 0; s2 < this.slices; ++s2) {
                idx1 = s2 * twoSliceStride;
                for (c = 0; c < this.columns; ++c) {
                    int idx3;
                    int idx2 = 2 * c;
                    for (r = 0; r < this.rows; ++r) {
                        idx4 = 2 * r;
                        idx3 = idx1 + r * twoRowStride + idx2;
                        temp[idx4] = a[idx3];
                        temp[idx4 + 1] = a[idx3 + 1];
                    }
                    this.fftRows.complexForward(temp);
                    for (r = 0; r < this.rows; ++r) {
                        idx4 = 2 * r;
                        idx3 = idx1 + r * twoRowStride + idx2;
                        a[idx3] = temp[idx4];
                        a[idx3 + 1] = temp[idx4 + 1];
                    }
                }
            }
            temp = new double[2 * this.slices];
            for (int r3 = 0; r3 < ldimn2; ++r3) {
                int idx3 = r3 * twoRowStride;
                for (c = 0; c < this.columns; ++c) {
                    int idx42;
                    int idx2;
                    int s3;
                    int idx12 = 2 * c;
                    for (s3 = 0; s3 < this.slices; ++s3) {
                        idx2 = 2 * s3;
                        idx42 = s3 * twoSliceStride + idx3 + idx12;
                        temp[idx2] = a[idx42];
                        temp[idx2 + 1] = a[idx42 + 1];
                    }
                    this.fftSlices.complexForward(temp);
                    for (s3 = 0; s3 < this.slices; ++s3) {
                        idx2 = 2 * s3;
                        idx42 = s3 * twoSliceStride + idx3 + idx12;
                        a[idx42] = temp[idx2];
                        a[idx42 + 1] = temp[idx2 + 1];
                    }
                }
            }
            for (s2 = 0; s2 < this.slices; ++s2) {
                int idx2 = (this.slices - s2) % this.slices;
                int idx5 = idx2 * twoSliceStride;
                int idx6 = s2 * twoSliceStride;
                for (r = 1; r < n2d2; ++r) {
                    idx4 = this.rows - r;
                    int idx7 = idx4 * twoRowStride;
                    int idx8 = r * twoRowStride;
                    int idx9 = idx5 + idx7;
                    for (int c2 = 0; c2 < this.columns; ++c2) {
                        int idx13 = 2 * c2;
                        int idx3 = twon3 - idx13;
                        int idx10 = idx6 + idx8 + idx13;
                        a[idx9 + idx3 % twon3] = a[idx10];
                        a[idx9 + (idx3 + 1) % twon3] = -a[idx10 + 1];
                    }
                }
            }
        }
    }

    private void mixedRadixRealForwardFull(final DoubleLargeArray a) {
        final long twon3 = 2L * this.columnsl;
        DoubleLargeArray temp = new DoubleLargeArray(twon3);
        long ldimn2 = this.rowsl / 2L + 1L;
        final long n2d2 = this.rowsl % 2L == 0L ? this.rowsl / 2L : (this.rowsl + 1L) / 2L;
        final long twoSliceStride = 2L * this.sliceStridel;
        final long twoRowStride = 2L * this.rowStridel;
        long n1d2 = this.slicesl / 2L;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.useThreads && n1d2 >= (long)nthreads && this.columnsl >= (long)nthreads && ldimn2 >= (long)nthreads) {
            long lastSlice;
            long firstSlice;
            Future[] futures = new Future[nthreads];
            long p = n1d2 / (long)nthreads;
            for (int l = 0; l < nthreads; ++l) {
                final long firstSlice2 = this.slicesl - 1L - (long)l * p;
                final long lastSlice2 = l == nthreads - 1 ? n1d2 + 1L : firstSlice2 - p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        DoubleLargeArray temp = new DoubleLargeArray(twon3);
                        for (long s2 = firstSlice2; s2 >= lastSlice2; --s2) {
                            long idx1 = s2 * DoubleFFT_3D.this.sliceStridel;
                            long idx2 = s2 * twoSliceStride;
                            for (long r = DoubleFFT_3D.this.rowsl - 1L; r >= 0L; --r) {
                                LargeArrayUtils.arraycopy(a, idx1 + r * DoubleFFT_3D.this.rowStridel, temp, 0L, DoubleFFT_3D.this.columnsl);
                                DoubleFFT_3D.this.fftColumns.realForwardFull(temp);
                                LargeArrayUtils.arraycopy(temp, 0L, a, idx2 + r * twoRowStride, twon3);
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            final DoubleLargeArray temp2 = new DoubleLargeArray((n1d2 + 1L) * this.rowsl * twon3);
            for (int l = 0; l < nthreads; ++l) {
                firstSlice = (long)l * p;
                lastSlice = l == nthreads - 1 ? n1d2 + 1L : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long s2 = firstSlice; s2 < lastSlice; ++s2) {
                            long idx1 = s2 * DoubleFFT_3D.this.sliceStridel;
                            for (long r = 0L; r < DoubleFFT_3D.this.rowsl; ++r) {
                                LargeArrayUtils.arraycopy(a, idx1 + r * DoubleFFT_3D.this.rowStridel, temp2, s2 * DoubleFFT_3D.this.rowsl * twon3 + r * twon3, DoubleFFT_3D.this.columnsl);
                                DoubleFFT_3D.this.fftColumns.realForwardFull(temp2, s2 * DoubleFFT_3D.this.rowsl * twon3 + r * twon3);
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            for (int l = 0; l < nthreads; ++l) {
                firstSlice = (long)l * p;
                lastSlice = l == nthreads - 1 ? n1d2 + 1L : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long s2 = firstSlice; s2 < lastSlice; ++s2) {
                            long idx1 = s2 * twoSliceStride;
                            for (long r = 0L; r < DoubleFFT_3D.this.rowsl; ++r) {
                                LargeArrayUtils.arraycopy(temp2, s2 * DoubleFFT_3D.this.rowsl * twon3 + r * twon3, a, idx1 + r * twoRowStride, twon3);
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            p = this.slicesl / (long)nthreads;
            for (int l = 0; l < nthreads; ++l) {
                firstSlice = (long)l * p;
                lastSlice = l == nthreads - 1 ? this.slicesl : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        DoubleLargeArray temp = new DoubleLargeArray(2L * DoubleFFT_3D.this.rowsl, false);
                        for (long s2 = firstSlice; s2 < lastSlice; ++s2) {
                            long idx1 = s2 * twoSliceStride;
                            for (long c = 0L; c < DoubleFFT_3D.this.columnsl; ++c) {
                                long idx4;
                                long idx3;
                                long r;
                                long idx2 = 2L * c;
                                for (r = 0L; r < DoubleFFT_3D.this.rowsl; ++r) {
                                    idx3 = idx1 + r * twoRowStride + idx2;
                                    idx4 = 2L * r;
                                    temp.setDouble(idx4, a.getDouble(idx3));
                                    temp.setDouble(idx4 + 1L, a.getDouble(idx3 + 1L));
                                }
                                DoubleFFT_3D.this.fftRows.complexForward(temp);
                                for (r = 0L; r < DoubleFFT_3D.this.rowsl; ++r) {
                                    idx3 = idx1 + r * twoRowStride + idx2;
                                    idx4 = 2L * r;
                                    a.setDouble(idx3, temp.getDouble(idx4));
                                    a.setDouble(idx3 + 1L, temp.getDouble(idx4 + 1L));
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            p = ldimn2 / (long)nthreads;
            for (int l = 0; l < nthreads; ++l) {
                final long firstRow = (long)l * p;
                final long lastRow = l == nthreads - 1 ? ldimn2 : firstRow + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        DoubleLargeArray temp = new DoubleLargeArray(2L * DoubleFFT_3D.this.slicesl, false);
                        for (long r = firstRow; r < lastRow; ++r) {
                            long idx3 = r * twoRowStride;
                            for (long c = 0L; c < DoubleFFT_3D.this.columnsl; ++c) {
                                long idx4;
                                long idx2;
                                long s2;
                                long idx1 = 2L * c;
                                for (s2 = 0L; s2 < DoubleFFT_3D.this.slicesl; ++s2) {
                                    idx2 = 2L * s2;
                                    idx4 = s2 * twoSliceStride + idx3 + idx1;
                                    temp.setDouble(idx2, a.getDouble(idx4));
                                    temp.setDouble(idx2 + 1L, a.getDouble(idx4 + 1L));
                                }
                                DoubleFFT_3D.this.fftSlices.complexForward(temp);
                                for (s2 = 0L; s2 < DoubleFFT_3D.this.slicesl; ++s2) {
                                    idx2 = 2L * s2;
                                    idx4 = s2 * twoSliceStride + idx3 + idx1;
                                    a.setDouble(idx4, temp.getDouble(idx2));
                                    a.setDouble(idx4 + 1L, temp.getDouble(idx2 + 1L));
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            p = this.slicesl / (long)nthreads;
            for (int l = 0; l < nthreads; ++l) {
                firstSlice = (long)l * p;
                lastSlice = l == nthreads - 1 ? this.slicesl : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long s2 = firstSlice; s2 < lastSlice; ++s2) {
                            long idx2 = (DoubleFFT_3D.this.slicesl - s2) % DoubleFFT_3D.this.slicesl;
                            long idx5 = idx2 * twoSliceStride;
                            long idx6 = s2 * twoSliceStride;
                            for (long r = 1L; r < n2d2; ++r) {
                                long idx4 = DoubleFFT_3D.this.rowsl - r;
                                long idx7 = idx4 * twoRowStride;
                                long idx8 = r * twoRowStride;
                                long idx9 = idx5 + idx7;
                                for (long c = 0L; c < DoubleFFT_3D.this.columnsl; ++c) {
                                    long idx1 = 2L * c;
                                    long idx3 = twon3 - idx1;
                                    long idx10 = idx6 + idx8 + idx1;
                                    a.setDouble(idx9 + idx3 % twon3, a.getDouble(idx10));
                                    a.setDouble(idx9 + (idx3 + 1L) % twon3, -a.getDouble(idx10 + 1L));
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            long idx4;
            long r;
            long c;
            long idx1;
            long s2;
            for (s2 = this.slicesl - 1L; s2 >= 0L; --s2) {
                idx1 = s2 * this.sliceStridel;
                long idx2 = s2 * twoSliceStride;
                for (long r2 = this.rowsl - 1L; r2 >= 0L; --r2) {
                    LargeArrayUtils.arraycopy(a, idx1 + r2 * this.rowStridel, temp, 0L, this.columnsl);
                    this.fftColumns.realForwardFull(temp);
                    LargeArrayUtils.arraycopy(temp, 0L, a, idx2 + r2 * twoRowStride, twon3);
                }
            }
            temp = new DoubleLargeArray(2L * this.rowsl, false);
            for (s2 = 0L; s2 < this.slicesl; ++s2) {
                idx1 = s2 * twoSliceStride;
                for (c = 0L; c < this.columnsl; ++c) {
                    long idx3;
                    long idx2 = 2L * c;
                    for (r = 0L; r < this.rowsl; ++r) {
                        idx4 = 2L * r;
                        idx3 = idx1 + r * twoRowStride + idx2;
                        temp.setDouble(idx4, a.getDouble(idx3));
                        temp.setDouble(idx4 + 1L, a.getDouble(idx3 + 1L));
                    }
                    this.fftRows.complexForward(temp);
                    for (r = 0L; r < this.rowsl; ++r) {
                        idx4 = 2L * r;
                        idx3 = idx1 + r * twoRowStride + idx2;
                        a.setDouble(idx3, temp.getDouble(idx4));
                        a.setDouble(idx3 + 1L, temp.getDouble(idx4 + 1L));
                    }
                }
            }
            temp = new DoubleLargeArray(2L * this.slicesl, false);
            for (long r3 = 0L; r3 < ldimn2; ++r3) {
                long idx3 = r3 * twoRowStride;
                for (c = 0L; c < this.columnsl; ++c) {
                    long idx42;
                    long idx2;
                    long s3;
                    long idx12 = 2L * c;
                    for (s3 = 0L; s3 < this.slicesl; ++s3) {
                        idx2 = 2L * s3;
                        idx42 = s3 * twoSliceStride + idx3 + idx12;
                        temp.setDouble(idx2, a.getDouble(idx42));
                        temp.setDouble(idx2 + 1L, a.getDouble(idx42 + 1L));
                    }
                    this.fftSlices.complexForward(temp);
                    for (s3 = 0L; s3 < this.slicesl; ++s3) {
                        idx2 = 2L * s3;
                        idx42 = s3 * twoSliceStride + idx3 + idx12;
                        a.setDouble(idx42, temp.getDouble(idx2));
                        a.setDouble(idx42 + 1L, temp.getDouble(idx2 + 1L));
                    }
                }
            }
            for (s2 = 0L; s2 < this.slicesl; ++s2) {
                long idx2 = (this.slicesl - s2) % this.slicesl;
                long idx5 = idx2 * twoSliceStride;
                long idx6 = s2 * twoSliceStride;
                for (r = 1L; r < n2d2; ++r) {
                    idx4 = this.rowsl - r;
                    long idx7 = idx4 * twoRowStride;
                    long idx8 = r * twoRowStride;
                    long idx9 = idx5 + idx7;
                    for (long c2 = 0L; c2 < this.columnsl; ++c2) {
                        long idx13 = 2L * c2;
                        long idx3 = twon3 - idx13;
                        long idx10 = idx6 + idx8 + idx13;
                        a.setDouble(idx9 + idx3 % twon3, a.getDouble(idx10));
                        a.setDouble(idx9 + (idx3 + 1L) % twon3, -a.getDouble(idx10 + 1L));
                    }
                }
            }
        }
    }

    private void mixedRadixRealInverseFull(final double[] a, final boolean scale) {
        final int twon3 = 2 * this.columns;
        double[] temp = new double[twon3];
        int ldimn2 = this.rows / 2 + 1;
        final int n2d2 = this.rows % 2 == 0 ? this.rows / 2 : (this.rows + 1) / 2;
        final int twoSliceStride = 2 * this.sliceStride;
        final int twoRowStride = 2 * this.rowStride;
        int n1d2 = this.slices / 2;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.useThreads && n1d2 >= nthreads && this.columns >= nthreads && ldimn2 >= nthreads) {
            int lastSlice;
            int firstSlice;
            Future[] futures = new Future[nthreads];
            int p = n1d2 / nthreads;
            for (int l = 0; l < nthreads; ++l) {
                final int firstSlice2 = this.slices - 1 - l * p;
                final int lastSlice2 = l == nthreads - 1 ? n1d2 + 1 : firstSlice2 - p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] temp = new double[twon3];
                        for (int s2 = firstSlice2; s2 >= lastSlice2; --s2) {
                            int idx1 = s2 * DoubleFFT_3D.this.sliceStride;
                            int idx2 = s2 * twoSliceStride;
                            for (int r = DoubleFFT_3D.this.rows - 1; r >= 0; --r) {
                                System.arraycopy(a, idx1 + r * DoubleFFT_3D.this.rowStride, temp, 0, DoubleFFT_3D.this.columns);
                                DoubleFFT_3D.this.fftColumns.realInverseFull(temp, scale);
                                System.arraycopy(temp, 0, a, idx2 + r * twoRowStride, twon3);
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            final double[][][] temp2 = new double[n1d2 + 1][this.rows][twon3];
            for (int l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? n1d2 + 1 : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                            int idx1 = s2 * DoubleFFT_3D.this.sliceStride;
                            for (int r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                System.arraycopy(a, idx1 + r * DoubleFFT_3D.this.rowStride, temp2[s2][r], 0, DoubleFFT_3D.this.columns);
                                DoubleFFT_3D.this.fftColumns.realInverseFull(temp2[s2][r], scale);
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            for (int l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? n1d2 + 1 : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                            int idx1 = s2 * twoSliceStride;
                            for (int r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                System.arraycopy(temp2[s2][r], 0, a, idx1 + r * twoRowStride, twon3);
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            p = this.slices / nthreads;
            for (int l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] temp = new double[2 * DoubleFFT_3D.this.rows];
                        for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                            int idx1 = s2 * twoSliceStride;
                            for (int c = 0; c < DoubleFFT_3D.this.columns; ++c) {
                                int idx4;
                                int idx3;
                                int r;
                                int idx2 = 2 * c;
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    idx3 = idx1 + r * twoRowStride + idx2;
                                    idx4 = 2 * r;
                                    temp[idx4] = a[idx3];
                                    temp[idx4 + 1] = a[idx3 + 1];
                                }
                                DoubleFFT_3D.this.fftRows.complexInverse(temp, scale);
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    idx3 = idx1 + r * twoRowStride + idx2;
                                    idx4 = 2 * r;
                                    a[idx3] = temp[idx4];
                                    a[idx3 + 1] = temp[idx4 + 1];
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            p = ldimn2 / nthreads;
            for (int l = 0; l < nthreads; ++l) {
                final int firstRow = l * p;
                final int lastRow = l == nthreads - 1 ? ldimn2 : firstRow + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] temp = new double[2 * DoubleFFT_3D.this.slices];
                        for (int r = firstRow; r < lastRow; ++r) {
                            int idx3 = r * twoRowStride;
                            for (int c = 0; c < DoubleFFT_3D.this.columns; ++c) {
                                int idx4;
                                int idx2;
                                int s2;
                                int idx1 = 2 * c;
                                for (s2 = 0; s2 < DoubleFFT_3D.this.slices; ++s2) {
                                    idx2 = 2 * s2;
                                    idx4 = s2 * twoSliceStride + idx3 + idx1;
                                    temp[idx2] = a[idx4];
                                    temp[idx2 + 1] = a[idx4 + 1];
                                }
                                DoubleFFT_3D.this.fftSlices.complexInverse(temp, scale);
                                for (s2 = 0; s2 < DoubleFFT_3D.this.slices; ++s2) {
                                    idx2 = 2 * s2;
                                    idx4 = s2 * twoSliceStride + idx3 + idx1;
                                    a[idx4] = temp[idx2];
                                    a[idx4 + 1] = temp[idx2 + 1];
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            p = this.slices / nthreads;
            for (int l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                            int idx2 = (DoubleFFT_3D.this.slices - s2) % DoubleFFT_3D.this.slices;
                            int idx5 = idx2 * twoSliceStride;
                            int idx6 = s2 * twoSliceStride;
                            for (int r = 1; r < n2d2; ++r) {
                                int idx4 = DoubleFFT_3D.this.rows - r;
                                int idx7 = idx4 * twoRowStride;
                                int idx8 = r * twoRowStride;
                                int idx9 = idx5 + idx7;
                                for (int c = 0; c < DoubleFFT_3D.this.columns; ++c) {
                                    int idx1 = 2 * c;
                                    int idx3 = twon3 - idx1;
                                    int idx10 = idx6 + idx8 + idx1;
                                    a[idx9 + idx3 % twon3] = a[idx10];
                                    a[idx9 + (idx3 + 1) % twon3] = -a[idx10 + 1];
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            int idx4;
            int r;
            int c;
            int idx1;
            int s2;
            for (s2 = this.slices - 1; s2 >= 0; --s2) {
                idx1 = s2 * this.sliceStride;
                int idx2 = s2 * twoSliceStride;
                for (int r2 = this.rows - 1; r2 >= 0; --r2) {
                    System.arraycopy(a, idx1 + r2 * this.rowStride, temp, 0, this.columns);
                    this.fftColumns.realInverseFull(temp, scale);
                    System.arraycopy(temp, 0, a, idx2 + r2 * twoRowStride, twon3);
                }
            }
            temp = new double[2 * this.rows];
            for (s2 = 0; s2 < this.slices; ++s2) {
                idx1 = s2 * twoSliceStride;
                for (c = 0; c < this.columns; ++c) {
                    int idx3;
                    int idx2 = 2 * c;
                    for (r = 0; r < this.rows; ++r) {
                        idx4 = 2 * r;
                        idx3 = idx1 + r * twoRowStride + idx2;
                        temp[idx4] = a[idx3];
                        temp[idx4 + 1] = a[idx3 + 1];
                    }
                    this.fftRows.complexInverse(temp, scale);
                    for (r = 0; r < this.rows; ++r) {
                        idx4 = 2 * r;
                        idx3 = idx1 + r * twoRowStride + idx2;
                        a[idx3] = temp[idx4];
                        a[idx3 + 1] = temp[idx4 + 1];
                    }
                }
            }
            temp = new double[2 * this.slices];
            for (int r3 = 0; r3 < ldimn2; ++r3) {
                int idx3 = r3 * twoRowStride;
                for (c = 0; c < this.columns; ++c) {
                    int idx42;
                    int idx2;
                    int s3;
                    int idx12 = 2 * c;
                    for (s3 = 0; s3 < this.slices; ++s3) {
                        idx2 = 2 * s3;
                        idx42 = s3 * twoSliceStride + idx3 + idx12;
                        temp[idx2] = a[idx42];
                        temp[idx2 + 1] = a[idx42 + 1];
                    }
                    this.fftSlices.complexInverse(temp, scale);
                    for (s3 = 0; s3 < this.slices; ++s3) {
                        idx2 = 2 * s3;
                        idx42 = s3 * twoSliceStride + idx3 + idx12;
                        a[idx42] = temp[idx2];
                        a[idx42 + 1] = temp[idx2 + 1];
                    }
                }
            }
            for (s2 = 0; s2 < this.slices; ++s2) {
                int idx2 = (this.slices - s2) % this.slices;
                int idx5 = idx2 * twoSliceStride;
                int idx6 = s2 * twoSliceStride;
                for (r = 1; r < n2d2; ++r) {
                    idx4 = this.rows - r;
                    int idx7 = idx4 * twoRowStride;
                    int idx8 = r * twoRowStride;
                    int idx9 = idx5 + idx7;
                    for (int c2 = 0; c2 < this.columns; ++c2) {
                        int idx13 = 2 * c2;
                        int idx3 = twon3 - idx13;
                        int idx10 = idx6 + idx8 + idx13;
                        a[idx9 + idx3 % twon3] = a[idx10];
                        a[idx9 + (idx3 + 1) % twon3] = -a[idx10 + 1];
                    }
                }
            }
        }
    }

    private void mixedRadixRealInverseFull(final DoubleLargeArray a, final boolean scale) {
        final long twon3 = 2L * this.columnsl;
        DoubleLargeArray temp = new DoubleLargeArray(twon3);
        long ldimn2 = this.rowsl / 2L + 1L;
        final long n2d2 = this.rowsl % 2L == 0L ? this.rowsl / 2L : (this.rowsl + 1L) / 2L;
        final long twoSliceStride = 2L * this.sliceStridel;
        final long twoRowStride = 2L * this.rowStridel;
        long n1d2 = this.slicesl / 2L;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.useThreads && n1d2 >= (long)nthreads && this.columnsl >= (long)nthreads && ldimn2 >= (long)nthreads) {
            long lastSlice;
            long firstSlice;
            Future[] futures = new Future[nthreads];
            long p = n1d2 / (long)nthreads;
            for (int l = 0; l < nthreads; ++l) {
                final long firstSlice2 = this.slicesl - 1L - (long)l * p;
                final long lastSlice2 = l == nthreads - 1 ? n1d2 + 1L : firstSlice2 - p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        DoubleLargeArray temp = new DoubleLargeArray(twon3);
                        for (long s2 = firstSlice2; s2 >= lastSlice2; --s2) {
                            long idx1 = s2 * DoubleFFT_3D.this.sliceStridel;
                            long idx2 = s2 * twoSliceStride;
                            for (long r = DoubleFFT_3D.this.rowsl - 1L; r >= 0L; --r) {
                                LargeArrayUtils.arraycopy(a, idx1 + r * DoubleFFT_3D.this.rowStridel, temp, 0L, DoubleFFT_3D.this.columnsl);
                                DoubleFFT_3D.this.fftColumns.realInverseFull(temp, scale);
                                LargeArrayUtils.arraycopy(temp, 0L, a, idx2 + r * twoRowStride, twon3);
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            final DoubleLargeArray temp2 = new DoubleLargeArray((n1d2 + 1L) * this.rowsl * twon3);
            for (int l = 0; l < nthreads; ++l) {
                firstSlice = (long)l * p;
                lastSlice = l == nthreads - 1 ? n1d2 + 1L : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long s2 = firstSlice; s2 < lastSlice; ++s2) {
                            long idx1 = s2 * DoubleFFT_3D.this.sliceStridel;
                            for (long r = 0L; r < DoubleFFT_3D.this.rowsl; ++r) {
                                LargeArrayUtils.arraycopy(a, idx1 + r * DoubleFFT_3D.this.rowStridel, temp2, s2 * DoubleFFT_3D.this.rowsl * twon3 + r * twon3, DoubleFFT_3D.this.columnsl);
                                DoubleFFT_3D.this.fftColumns.realInverseFull(temp2, s2 * DoubleFFT_3D.this.rowsl * twon3 + r * twon3, scale);
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            for (int l = 0; l < nthreads; ++l) {
                firstSlice = (long)l * p;
                lastSlice = l == nthreads - 1 ? n1d2 + 1L : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long s2 = firstSlice; s2 < lastSlice; ++s2) {
                            long idx1 = s2 * twoSliceStride;
                            for (long r = 0L; r < DoubleFFT_3D.this.rowsl; ++r) {
                                LargeArrayUtils.arraycopy(temp2, s2 * DoubleFFT_3D.this.rowsl * twon3 + r * twon3, a, idx1 + r * twoRowStride, twon3);
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            p = this.slicesl / (long)nthreads;
            for (int l = 0; l < nthreads; ++l) {
                firstSlice = (long)l * p;
                lastSlice = l == nthreads - 1 ? this.slicesl : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        DoubleLargeArray temp = new DoubleLargeArray(2L * DoubleFFT_3D.this.rowsl, false);
                        for (long s2 = firstSlice; s2 < lastSlice; ++s2) {
                            long idx1 = s2 * twoSliceStride;
                            for (long c = 0L; c < DoubleFFT_3D.this.columnsl; ++c) {
                                long idx4;
                                long idx3;
                                long r;
                                long idx2 = 2L * c;
                                for (r = 0L; r < DoubleFFT_3D.this.rowsl; ++r) {
                                    idx3 = idx1 + r * twoRowStride + idx2;
                                    idx4 = 2L * r;
                                    temp.setDouble(idx4, a.getDouble(idx3));
                                    temp.setDouble(idx4 + 1L, a.getDouble(idx3 + 1L));
                                }
                                DoubleFFT_3D.this.fftRows.complexInverse(temp, scale);
                                for (r = 0L; r < DoubleFFT_3D.this.rowsl; ++r) {
                                    idx3 = idx1 + r * twoRowStride + idx2;
                                    idx4 = 2L * r;
                                    a.setDouble(idx3, temp.getDouble(idx4));
                                    a.setDouble(idx3 + 1L, temp.getDouble(idx4 + 1L));
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            p = ldimn2 / (long)nthreads;
            for (int l = 0; l < nthreads; ++l) {
                final long firstRow = (long)l * p;
                final long lastRow = l == nthreads - 1 ? ldimn2 : firstRow + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        DoubleLargeArray temp = new DoubleLargeArray(2L * DoubleFFT_3D.this.slicesl, false);
                        for (long r = firstRow; r < lastRow; ++r) {
                            long idx3 = r * twoRowStride;
                            for (long c = 0L; c < DoubleFFT_3D.this.columnsl; ++c) {
                                long idx4;
                                long idx2;
                                long s2;
                                long idx1 = 2L * c;
                                for (s2 = 0L; s2 < DoubleFFT_3D.this.slicesl; ++s2) {
                                    idx2 = 2L * s2;
                                    idx4 = s2 * twoSliceStride + idx3 + idx1;
                                    temp.setDouble(idx2, a.getDouble(idx4));
                                    temp.setDouble(idx2 + 1L, a.getDouble(idx4 + 1L));
                                }
                                DoubleFFT_3D.this.fftSlices.complexInverse(temp, scale);
                                for (s2 = 0L; s2 < DoubleFFT_3D.this.slicesl; ++s2) {
                                    idx2 = 2L * s2;
                                    idx4 = s2 * twoSliceStride + idx3 + idx1;
                                    a.setDouble(idx4, temp.getDouble(idx2));
                                    a.setDouble(idx4 + 1L, temp.getDouble(idx2 + 1L));
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            p = this.slicesl / (long)nthreads;
            for (int l = 0; l < nthreads; ++l) {
                firstSlice = (long)l * p;
                lastSlice = l == nthreads - 1 ? this.slicesl : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long s2 = firstSlice; s2 < lastSlice; ++s2) {
                            long idx2 = (DoubleFFT_3D.this.slicesl - s2) % DoubleFFT_3D.this.slicesl;
                            long idx5 = idx2 * twoSliceStride;
                            long idx6 = s2 * twoSliceStride;
                            for (long r = 1L; r < n2d2; ++r) {
                                long idx4 = DoubleFFT_3D.this.rowsl - r;
                                long idx7 = idx4 * twoRowStride;
                                long idx8 = r * twoRowStride;
                                long idx9 = idx5 + idx7;
                                for (long c = 0L; c < DoubleFFT_3D.this.columnsl; ++c) {
                                    long idx1 = 2L * c;
                                    long idx3 = twon3 - idx1;
                                    long idx10 = idx6 + idx8 + idx1;
                                    a.setDouble(idx9 + idx3 % twon3, a.getDouble(idx10));
                                    a.setDouble(idx9 + (idx3 + 1L) % twon3, -a.getDouble(idx10 + 1L));
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            long idx4;
            long r;
            long c;
            long idx1;
            long s2;
            for (s2 = this.slicesl - 1L; s2 >= 0L; --s2) {
                idx1 = s2 * this.sliceStridel;
                long idx2 = s2 * twoSliceStride;
                for (long r2 = this.rowsl - 1L; r2 >= 0L; --r2) {
                    LargeArrayUtils.arraycopy(a, idx1 + r2 * this.rowStridel, temp, 0L, this.columnsl);
                    this.fftColumns.realInverseFull(temp, scale);
                    LargeArrayUtils.arraycopy(temp, 0L, a, idx2 + r2 * twoRowStride, twon3);
                }
            }
            temp = new DoubleLargeArray(2L * this.rowsl, false);
            for (s2 = 0L; s2 < this.slicesl; ++s2) {
                idx1 = s2 * twoSliceStride;
                for (c = 0L; c < this.columnsl; ++c) {
                    long idx3;
                    long idx2 = 2L * c;
                    for (r = 0L; r < this.rowsl; ++r) {
                        idx4 = 2L * r;
                        idx3 = idx1 + r * twoRowStride + idx2;
                        temp.setDouble(idx4, a.getDouble(idx3));
                        temp.setDouble(idx4 + 1L, a.getDouble(idx3 + 1L));
                    }
                    this.fftRows.complexInverse(temp, scale);
                    for (r = 0L; r < this.rowsl; ++r) {
                        idx4 = 2L * r;
                        idx3 = idx1 + r * twoRowStride + idx2;
                        a.setDouble(idx3, temp.getDouble(idx4));
                        a.setDouble(idx3 + 1L, temp.getDouble(idx4 + 1L));
                    }
                }
            }
            temp = new DoubleLargeArray(2L * this.slicesl, false);
            for (long r3 = 0L; r3 < ldimn2; ++r3) {
                long idx3 = r3 * twoRowStride;
                for (c = 0L; c < this.columnsl; ++c) {
                    long idx42;
                    long idx2;
                    long s3;
                    long idx12 = 2L * c;
                    for (s3 = 0L; s3 < this.slicesl; ++s3) {
                        idx2 = 2L * s3;
                        idx42 = s3 * twoSliceStride + idx3 + idx12;
                        temp.setDouble(idx2, a.getDouble(idx42));
                        temp.setDouble(idx2 + 1L, a.getDouble(idx42 + 1L));
                    }
                    this.fftSlices.complexInverse(temp, scale);
                    for (s3 = 0L; s3 < this.slicesl; ++s3) {
                        idx2 = 2L * s3;
                        idx42 = s3 * twoSliceStride + idx3 + idx12;
                        a.setDouble(idx42, temp.getDouble(idx2));
                        a.setDouble(idx42 + 1L, temp.getDouble(idx2 + 1L));
                    }
                }
            }
            for (s2 = 0L; s2 < this.slicesl; ++s2) {
                long idx2 = (this.slicesl - s2) % this.slicesl;
                long idx5 = idx2 * twoSliceStride;
                long idx6 = s2 * twoSliceStride;
                for (r = 1L; r < n2d2; ++r) {
                    idx4 = this.rowsl - r;
                    long idx7 = idx4 * twoRowStride;
                    long idx8 = r * twoRowStride;
                    long idx9 = idx5 + idx7;
                    for (long c2 = 0L; c2 < this.columnsl; ++c2) {
                        long idx13 = 2L * c2;
                        long idx3 = twon3 - idx13;
                        long idx10 = idx6 + idx8 + idx13;
                        a.setDouble(idx9 + idx3 % twon3, a.getDouble(idx10));
                        a.setDouble(idx9 + (idx3 + 1L) % twon3, -a.getDouble(idx10 + 1L));
                    }
                }
            }
        }
    }

    private void xdft3da_sub1(int icr, int isgn, double[] a, boolean scale) {
        int nt = this.slices;
        if (nt < this.rows) {
            nt = this.rows;
        }
        nt *= 8;
        if (this.columns == 4) {
            nt >>= 1;
        } else if (this.columns < 4) {
            nt >>= 2;
        }
        double[] t2 = new double[nt];
        if (isgn == -1) {
            for (int s2 = 0; s2 < this.slices; ++s2) {
                int idx3;
                int idx2;
                int idx1;
                int r;
                int idx0 = s2 * this.sliceStride;
                if (icr == 0) {
                    for (r = 0; r < this.rows; ++r) {
                        this.fftColumns.complexForward(a, idx0 + r * this.rowStride);
                    }
                } else {
                    for (r = 0; r < this.rows; ++r) {
                        this.fftColumns.realForward(a, idx0 + r * this.rowStride);
                    }
                }
                if (this.columns > 4) {
                    for (int c = 0; c < this.columns; c += 8) {
                        int idx5;
                        int idx4;
                        int r2;
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            idx1 = idx0 + r2 * this.rowStride + c;
                            idx2 = 2 * r2;
                            idx3 = 2 * this.rows + 2 * r2;
                            idx4 = idx3 + 2 * this.rows;
                            idx5 = idx4 + 2 * this.rows;
                            t2[idx2] = a[idx1];
                            t2[idx2 + 1] = a[idx1 + 1];
                            t2[idx3] = a[idx1 + 2];
                            t2[idx3 + 1] = a[idx1 + 3];
                            t2[idx4] = a[idx1 + 4];
                            t2[idx4 + 1] = a[idx1 + 5];
                            t2[idx5] = a[idx1 + 6];
                            t2[idx5 + 1] = a[idx1 + 7];
                        }
                        this.fftRows.complexForward(t2, 0);
                        this.fftRows.complexForward(t2, 2 * this.rows);
                        this.fftRows.complexForward(t2, 4 * this.rows);
                        this.fftRows.complexForward(t2, 6 * this.rows);
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            idx1 = idx0 + r2 * this.rowStride + c;
                            idx2 = 2 * r2;
                            idx3 = 2 * this.rows + 2 * r2;
                            idx4 = idx3 + 2 * this.rows;
                            idx5 = idx4 + 2 * this.rows;
                            a[idx1] = t2[idx2];
                            a[idx1 + 1] = t2[idx2 + 1];
                            a[idx1 + 2] = t2[idx3];
                            a[idx1 + 3] = t2[idx3 + 1];
                            a[idx1 + 4] = t2[idx4];
                            a[idx1 + 5] = t2[idx4 + 1];
                            a[idx1 + 6] = t2[idx5];
                            a[idx1 + 7] = t2[idx5 + 1];
                        }
                    }
                    continue;
                }
                if (this.columns == 4) {
                    for (r = 0; r < this.rows; ++r) {
                        idx1 = idx0 + r * this.rowStride;
                        idx2 = 2 * r;
                        idx3 = 2 * this.rows + 2 * r;
                        t2[idx2] = a[idx1];
                        t2[idx2 + 1] = a[idx1 + 1];
                        t2[idx3] = a[idx1 + 2];
                        t2[idx3 + 1] = a[idx1 + 3];
                    }
                    this.fftRows.complexForward(t2, 0);
                    this.fftRows.complexForward(t2, 2 * this.rows);
                    for (r = 0; r < this.rows; ++r) {
                        idx1 = idx0 + r * this.rowStride;
                        idx2 = 2 * r;
                        idx3 = 2 * this.rows + 2 * r;
                        a[idx1] = t2[idx2];
                        a[idx1 + 1] = t2[idx2 + 1];
                        a[idx1 + 2] = t2[idx3];
                        a[idx1 + 3] = t2[idx3 + 1];
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (r = 0; r < this.rows; ++r) {
                    idx1 = idx0 + r * this.rowStride;
                    idx2 = 2 * r;
                    t2[idx2] = a[idx1];
                    t2[idx2 + 1] = a[idx1 + 1];
                }
                this.fftRows.complexForward(t2, 0);
                for (r = 0; r < this.rows; ++r) {
                    idx1 = idx0 + r * this.rowStride;
                    idx2 = 2 * r;
                    a[idx1] = t2[idx2];
                    a[idx1 + 1] = t2[idx2 + 1];
                }
            }
        } else {
            for (int s3 = 0; s3 < this.slices; ++s3) {
                int idx3;
                int idx2;
                int idx1;
                int r;
                int idx0 = s3 * this.sliceStride;
                if (icr == 0) {
                    for (r = 0; r < this.rows; ++r) {
                        this.fftColumns.complexInverse(a, idx0 + r * this.rowStride, scale);
                    }
                }
                if (this.columns > 4) {
                    for (int c = 0; c < this.columns; c += 8) {
                        int idx5;
                        int idx4;
                        int r3;
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx1 = idx0 + r3 * this.rowStride + c;
                            idx2 = 2 * r3;
                            idx3 = 2 * this.rows + 2 * r3;
                            idx4 = idx3 + 2 * this.rows;
                            idx5 = idx4 + 2 * this.rows;
                            t2[idx2] = a[idx1];
                            t2[idx2 + 1] = a[idx1 + 1];
                            t2[idx3] = a[idx1 + 2];
                            t2[idx3 + 1] = a[idx1 + 3];
                            t2[idx4] = a[idx1 + 4];
                            t2[idx4 + 1] = a[idx1 + 5];
                            t2[idx5] = a[idx1 + 6];
                            t2[idx5 + 1] = a[idx1 + 7];
                        }
                        this.fftRows.complexInverse(t2, 0, scale);
                        this.fftRows.complexInverse(t2, 2 * this.rows, scale);
                        this.fftRows.complexInverse(t2, 4 * this.rows, scale);
                        this.fftRows.complexInverse(t2, 6 * this.rows, scale);
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx1 = idx0 + r3 * this.rowStride + c;
                            idx2 = 2 * r3;
                            idx3 = 2 * this.rows + 2 * r3;
                            idx4 = idx3 + 2 * this.rows;
                            idx5 = idx4 + 2 * this.rows;
                            a[idx1] = t2[idx2];
                            a[idx1 + 1] = t2[idx2 + 1];
                            a[idx1 + 2] = t2[idx3];
                            a[idx1 + 3] = t2[idx3 + 1];
                            a[idx1 + 4] = t2[idx4];
                            a[idx1 + 5] = t2[idx4 + 1];
                            a[idx1 + 6] = t2[idx5];
                            a[idx1 + 7] = t2[idx5 + 1];
                        }
                    }
                } else if (this.columns == 4) {
                    for (r = 0; r < this.rows; ++r) {
                        idx1 = idx0 + r * this.rowStride;
                        idx2 = 2 * r;
                        idx3 = 2 * this.rows + 2 * r;
                        t2[idx2] = a[idx1];
                        t2[idx2 + 1] = a[idx1 + 1];
                        t2[idx3] = a[idx1 + 2];
                        t2[idx3 + 1] = a[idx1 + 3];
                    }
                    this.fftRows.complexInverse(t2, 0, scale);
                    this.fftRows.complexInverse(t2, 2 * this.rows, scale);
                    for (r = 0; r < this.rows; ++r) {
                        idx1 = idx0 + r * this.rowStride;
                        idx2 = 2 * r;
                        idx3 = 2 * this.rows + 2 * r;
                        a[idx1] = t2[idx2];
                        a[idx1 + 1] = t2[idx2 + 1];
                        a[idx1 + 2] = t2[idx3];
                        a[idx1 + 3] = t2[idx3 + 1];
                    }
                } else if (this.columns == 2) {
                    for (r = 0; r < this.rows; ++r) {
                        idx1 = idx0 + r * this.rowStride;
                        idx2 = 2 * r;
                        t2[idx2] = a[idx1];
                        t2[idx2 + 1] = a[idx1 + 1];
                    }
                    this.fftRows.complexInverse(t2, 0, scale);
                    for (r = 0; r < this.rows; ++r) {
                        idx1 = idx0 + r * this.rowStride;
                        idx2 = 2 * r;
                        a[idx1] = t2[idx2];
                        a[idx1 + 1] = t2[idx2 + 1];
                    }
                }
                if (icr == 0) continue;
                for (r = 0; r < this.rows; ++r) {
                    this.fftColumns.realInverse(a, idx0 + r * this.rowStride, scale);
                }
            }
        }
    }

    private void xdft3da_sub1(long icr, int isgn, DoubleLargeArray a, boolean scale) {
        long nt = this.slicesl;
        if (nt < this.rowsl) {
            nt = this.rowsl;
        }
        nt *= 8L;
        if (this.columnsl == 4L) {
            nt >>= 1;
        } else if (this.columnsl < 4L) {
            nt >>= 2;
        }
        DoubleLargeArray t2 = new DoubleLargeArray(nt);
        if (isgn == -1) {
            for (long s2 = 0L; s2 < this.slicesl; ++s2) {
                long idx3;
                long idx2;
                long idx1;
                long r;
                long idx0 = s2 * this.sliceStridel;
                if (icr == 0L) {
                    for (r = 0L; r < this.rowsl; ++r) {
                        this.fftColumns.complexForward(a, idx0 + r * this.rowStridel);
                    }
                } else {
                    for (r = 0L; r < this.rowsl; ++r) {
                        this.fftColumns.realForward(a, idx0 + r * this.rowStridel);
                    }
                }
                if (this.columnsl > 4L) {
                    for (long c = 0L; c < this.columnsl; c += 8L) {
                        long idx5;
                        long idx4;
                        long r2;
                        for (r2 = 0L; r2 < this.rowsl; ++r2) {
                            idx1 = idx0 + r2 * this.rowStridel + c;
                            idx2 = 2L * r2;
                            idx3 = 2L * this.rowsl + 2L * r2;
                            idx4 = idx3 + 2L * this.rowsl;
                            idx5 = idx4 + 2L * this.rowsl;
                            t2.setDouble(idx2, a.getDouble(idx1));
                            t2.setDouble(idx2 + 1L, a.getDouble(idx1 + 1L));
                            t2.setDouble(idx3, a.getDouble(idx1 + 2L));
                            t2.setDouble(idx3 + 1L, a.getDouble(idx1 + 3L));
                            t2.setDouble(idx4, a.getDouble(idx1 + 4L));
                            t2.setDouble(idx4 + 1L, a.getDouble(idx1 + 5L));
                            t2.setDouble(idx5, a.getDouble(idx1 + 6L));
                            t2.setDouble(idx5 + 1L, a.getDouble(idx1 + 7L));
                        }
                        this.fftRows.complexForward(t2, 0L);
                        this.fftRows.complexForward(t2, 2L * this.rowsl);
                        this.fftRows.complexForward(t2, 4L * this.rowsl);
                        this.fftRows.complexForward(t2, 6L * this.rowsl);
                        for (r2 = 0L; r2 < this.rowsl; ++r2) {
                            idx1 = idx0 + r2 * this.rowStridel + c;
                            idx2 = 2L * r2;
                            idx3 = 2L * this.rowsl + 2L * r2;
                            idx4 = idx3 + 2L * this.rowsl;
                            idx5 = idx4 + 2L * this.rowsl;
                            a.setDouble(idx1, t2.getDouble(idx2));
                            a.setDouble(idx1 + 1L, t2.getDouble(idx2 + 1L));
                            a.setDouble(idx1 + 2L, t2.getDouble(idx3));
                            a.setDouble(idx1 + 3L, t2.getDouble(idx3 + 1L));
                            a.setDouble(idx1 + 4L, t2.getDouble(idx4));
                            a.setDouble(idx1 + 5L, t2.getDouble(idx4 + 1L));
                            a.setDouble(idx1 + 6L, t2.getDouble(idx5));
                            a.setDouble(idx1 + 7L, t2.getDouble(idx5 + 1L));
                        }
                    }
                    continue;
                }
                if (this.columnsl == 4L) {
                    for (r = 0L; r < this.rowsl; ++r) {
                        idx1 = idx0 + r * this.rowStridel;
                        idx2 = 2L * r;
                        idx3 = 2L * this.rowsl + 2L * r;
                        t2.setDouble(idx2, a.getDouble(idx1));
                        t2.setDouble(idx2 + 1L, a.getDouble(idx1 + 1L));
                        t2.setDouble(idx3, a.getDouble(idx1 + 2L));
                        t2.setDouble(idx3 + 1L, a.getDouble(idx1 + 3L));
                    }
                    this.fftRows.complexForward(t2, 0L);
                    this.fftRows.complexForward(t2, 2L * this.rowsl);
                    for (r = 0L; r < this.rowsl; ++r) {
                        idx1 = idx0 + r * this.rowStridel;
                        idx2 = 2L * r;
                        idx3 = 2L * this.rowsl + 2L * r;
                        a.setDouble(idx1, t2.getDouble(idx2));
                        a.setDouble(idx1 + 1L, t2.getDouble(idx2 + 1L));
                        a.setDouble(idx1 + 2L, t2.getDouble(idx3));
                        a.setDouble(idx1 + 3L, t2.getDouble(idx3 + 1L));
                    }
                    continue;
                }
                if (this.columnsl != 2L) continue;
                for (r = 0L; r < this.rowsl; ++r) {
                    idx1 = idx0 + r * this.rowStridel;
                    idx2 = 2L * r;
                    t2.setDouble(idx2, a.getDouble(idx1));
                    t2.setDouble(idx2 + 1L, a.getDouble(idx1 + 1L));
                }
                this.fftRows.complexForward(t2, 0L);
                for (r = 0L; r < this.rowsl; ++r) {
                    idx1 = idx0 + r * this.rowStridel;
                    idx2 = 2L * r;
                    a.setDouble(idx1, t2.getDouble(idx2));
                    a.setDouble(idx1 + 1L, t2.getDouble(idx2 + 1L));
                }
            }
        } else {
            for (long s3 = 0L; s3 < this.slicesl; ++s3) {
                long idx3;
                long idx2;
                long idx1;
                long r;
                long idx0 = s3 * this.sliceStridel;
                if (icr == 0L) {
                    for (r = 0L; r < this.rowsl; ++r) {
                        this.fftColumns.complexInverse(a, idx0 + r * this.rowStridel, scale);
                    }
                }
                if (this.columnsl > 4L) {
                    for (long c = 0L; c < this.columnsl; c += 8L) {
                        long idx5;
                        long idx4;
                        long r3;
                        for (r3 = 0L; r3 < this.rowsl; ++r3) {
                            idx1 = idx0 + r3 * this.rowStridel + c;
                            idx2 = 2L * r3;
                            idx3 = 2L * this.rowsl + 2L * r3;
                            idx4 = idx3 + 2L * this.rowsl;
                            idx5 = idx4 + 2L * this.rowsl;
                            t2.setDouble(idx2, a.getDouble(idx1));
                            t2.setDouble(idx2 + 1L, a.getDouble(idx1 + 1L));
                            t2.setDouble(idx3, a.getDouble(idx1 + 2L));
                            t2.setDouble(idx3 + 1L, a.getDouble(idx1 + 3L));
                            t2.setDouble(idx4, a.getDouble(idx1 + 4L));
                            t2.setDouble(idx4 + 1L, a.getDouble(idx1 + 5L));
                            t2.setDouble(idx5, a.getDouble(idx1 + 6L));
                            t2.setDouble(idx5 + 1L, a.getDouble(idx1 + 7L));
                        }
                        this.fftRows.complexInverse(t2, 0L, scale);
                        this.fftRows.complexInverse(t2, 2L * this.rowsl, scale);
                        this.fftRows.complexInverse(t2, 4L * this.rowsl, scale);
                        this.fftRows.complexInverse(t2, 6L * this.rowsl, scale);
                        for (r3 = 0L; r3 < this.rowsl; ++r3) {
                            idx1 = idx0 + r3 * this.rowStridel + c;
                            idx2 = 2L * r3;
                            idx3 = 2L * this.rowsl + 2L * r3;
                            idx4 = idx3 + 2L * this.rowsl;
                            idx5 = idx4 + 2L * this.rowsl;
                            a.setDouble(idx1, t2.getDouble(idx2));
                            a.setDouble(idx1 + 1L, t2.getDouble(idx2 + 1L));
                            a.setDouble(idx1 + 2L, t2.getDouble(idx3));
                            a.setDouble(idx1 + 3L, t2.getDouble(idx3 + 1L));
                            a.setDouble(idx1 + 4L, t2.getDouble(idx4));
                            a.setDouble(idx1 + 5L, t2.getDouble(idx4 + 1L));
                            a.setDouble(idx1 + 6L, t2.getDouble(idx5));
                            a.setDouble(idx1 + 7L, t2.getDouble(idx5 + 1L));
                        }
                    }
                } else if (this.columnsl == 4L) {
                    for (r = 0L; r < this.rowsl; ++r) {
                        idx1 = idx0 + r * this.rowStridel;
                        idx2 = 2L * r;
                        idx3 = 2L * this.rowsl + 2L * r;
                        t2.setDouble(idx2, a.getDouble(idx1));
                        t2.setDouble(idx2 + 1L, a.getDouble(idx1 + 1L));
                        t2.setDouble(idx3, a.getDouble(idx1 + 2L));
                        t2.setDouble(idx3 + 1L, a.getDouble(idx1 + 3L));
                    }
                    this.fftRows.complexInverse(t2, 0L, scale);
                    this.fftRows.complexInverse(t2, 2L * this.rowsl, scale);
                    for (r = 0L; r < this.rowsl; ++r) {
                        idx1 = idx0 + r * this.rowStridel;
                        idx2 = 2L * r;
                        idx3 = 2L * this.rowsl + 2L * r;
                        a.setDouble(idx1, t2.getDouble(idx2));
                        a.setDouble(idx1 + 1L, t2.getDouble(idx2 + 1L));
                        a.setDouble(idx1 + 2L, t2.getDouble(idx3));
                        a.setDouble(idx1 + 3L, t2.getDouble(idx3 + 1L));
                    }
                } else if (this.columnsl == 2L) {
                    for (r = 0L; r < this.rowsl; ++r) {
                        idx1 = idx0 + r * this.rowStridel;
                        idx2 = 2L * r;
                        t2.setDouble(idx2, a.getDouble(idx1));
                        t2.setDouble(idx2 + 1L, a.getDouble(idx1 + 1L));
                    }
                    this.fftRows.complexInverse(t2, 0L, scale);
                    for (r = 0L; r < this.rowsl; ++r) {
                        idx1 = idx0 + r * this.rowStridel;
                        idx2 = 2L * r;
                        a.setDouble(idx1, t2.getDouble(idx2));
                        a.setDouble(idx1 + 1L, t2.getDouble(idx2 + 1L));
                    }
                }
                if (icr == 0L) continue;
                for (r = 0L; r < this.rowsl; ++r) {
                    this.fftColumns.realInverse(a, idx0 + r * this.rowStridel, scale);
                }
            }
        }
    }

    private void xdft3da_sub2(int icr, int isgn, double[] a, boolean scale) {
        int nt = this.slices;
        if (nt < this.rows) {
            nt = this.rows;
        }
        nt *= 8;
        if (this.columns == 4) {
            nt >>= 1;
        } else if (this.columns < 4) {
            nt >>= 2;
        }
        double[] t2 = new double[nt];
        if (isgn == -1) {
            for (int s2 = 0; s2 < this.slices; ++s2) {
                int idx3;
                int idx2;
                int idx1;
                int r;
                int idx0 = s2 * this.sliceStride;
                if (icr == 0) {
                    for (r = 0; r < this.rows; ++r) {
                        this.fftColumns.complexForward(a, idx0 + r * this.rowStride);
                    }
                } else {
                    for (r = 0; r < this.rows; ++r) {
                        this.fftColumns.realForward(a, idx0 + r * this.rowStride);
                    }
                }
                if (this.columns > 4) {
                    for (int c = 0; c < this.columns; c += 8) {
                        int idx5;
                        int idx4;
                        int r2;
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            idx1 = idx0 + r2 * this.rowStride + c;
                            idx2 = 2 * r2;
                            idx3 = 2 * this.rows + 2 * r2;
                            idx4 = idx3 + 2 * this.rows;
                            idx5 = idx4 + 2 * this.rows;
                            t2[idx2] = a[idx1];
                            t2[idx2 + 1] = a[idx1 + 1];
                            t2[idx3] = a[idx1 + 2];
                            t2[idx3 + 1] = a[idx1 + 3];
                            t2[idx4] = a[idx1 + 4];
                            t2[idx4 + 1] = a[idx1 + 5];
                            t2[idx5] = a[idx1 + 6];
                            t2[idx5 + 1] = a[idx1 + 7];
                        }
                        this.fftRows.complexForward(t2, 0);
                        this.fftRows.complexForward(t2, 2 * this.rows);
                        this.fftRows.complexForward(t2, 4 * this.rows);
                        this.fftRows.complexForward(t2, 6 * this.rows);
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            idx1 = idx0 + r2 * this.rowStride + c;
                            idx2 = 2 * r2;
                            idx3 = 2 * this.rows + 2 * r2;
                            idx4 = idx3 + 2 * this.rows;
                            idx5 = idx4 + 2 * this.rows;
                            a[idx1] = t2[idx2];
                            a[idx1 + 1] = t2[idx2 + 1];
                            a[idx1 + 2] = t2[idx3];
                            a[idx1 + 3] = t2[idx3 + 1];
                            a[idx1 + 4] = t2[idx4];
                            a[idx1 + 5] = t2[idx4 + 1];
                            a[idx1 + 6] = t2[idx5];
                            a[idx1 + 7] = t2[idx5 + 1];
                        }
                    }
                    continue;
                }
                if (this.columns == 4) {
                    for (r = 0; r < this.rows; ++r) {
                        idx1 = idx0 + r * this.rowStride;
                        idx2 = 2 * r;
                        idx3 = 2 * this.rows + 2 * r;
                        t2[idx2] = a[idx1];
                        t2[idx2 + 1] = a[idx1 + 1];
                        t2[idx3] = a[idx1 + 2];
                        t2[idx3 + 1] = a[idx1 + 3];
                    }
                    this.fftRows.complexForward(t2, 0);
                    this.fftRows.complexForward(t2, 2 * this.rows);
                    for (r = 0; r < this.rows; ++r) {
                        idx1 = idx0 + r * this.rowStride;
                        idx2 = 2 * r;
                        idx3 = 2 * this.rows + 2 * r;
                        a[idx1] = t2[idx2];
                        a[idx1 + 1] = t2[idx2 + 1];
                        a[idx1 + 2] = t2[idx3];
                        a[idx1 + 3] = t2[idx3 + 1];
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (r = 0; r < this.rows; ++r) {
                    idx1 = idx0 + r * this.rowStride;
                    idx2 = 2 * r;
                    t2[idx2] = a[idx1];
                    t2[idx2 + 1] = a[idx1 + 1];
                }
                this.fftRows.complexForward(t2, 0);
                for (r = 0; r < this.rows; ++r) {
                    idx1 = idx0 + r * this.rowStride;
                    idx2 = 2 * r;
                    a[idx1] = t2[idx2];
                    a[idx1 + 1] = t2[idx2 + 1];
                }
            }
        } else {
            for (int s3 = 0; s3 < this.slices; ++s3) {
                int idx3;
                int idx2;
                int idx1;
                int r;
                int idx0 = s3 * this.sliceStride;
                if (icr == 0) {
                    for (r = 0; r < this.rows; ++r) {
                        this.fftColumns.complexInverse(a, idx0 + r * this.rowStride, scale);
                    }
                } else {
                    for (r = 0; r < this.rows; ++r) {
                        this.fftColumns.realInverse2(a, idx0 + r * this.rowStride, scale);
                    }
                }
                if (this.columns > 4) {
                    for (int c = 0; c < this.columns; c += 8) {
                        int idx5;
                        int idx4;
                        int r3;
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx1 = idx0 + r3 * this.rowStride + c;
                            idx2 = 2 * r3;
                            idx3 = 2 * this.rows + 2 * r3;
                            idx4 = idx3 + 2 * this.rows;
                            idx5 = idx4 + 2 * this.rows;
                            t2[idx2] = a[idx1];
                            t2[idx2 + 1] = a[idx1 + 1];
                            t2[idx3] = a[idx1 + 2];
                            t2[idx3 + 1] = a[idx1 + 3];
                            t2[idx4] = a[idx1 + 4];
                            t2[idx4 + 1] = a[idx1 + 5];
                            t2[idx5] = a[idx1 + 6];
                            t2[idx5 + 1] = a[idx1 + 7];
                        }
                        this.fftRows.complexInverse(t2, 0, scale);
                        this.fftRows.complexInverse(t2, 2 * this.rows, scale);
                        this.fftRows.complexInverse(t2, 4 * this.rows, scale);
                        this.fftRows.complexInverse(t2, 6 * this.rows, scale);
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx1 = idx0 + r3 * this.rowStride + c;
                            idx2 = 2 * r3;
                            idx3 = 2 * this.rows + 2 * r3;
                            idx4 = idx3 + 2 * this.rows;
                            idx5 = idx4 + 2 * this.rows;
                            a[idx1] = t2[idx2];
                            a[idx1 + 1] = t2[idx2 + 1];
                            a[idx1 + 2] = t2[idx3];
                            a[idx1 + 3] = t2[idx3 + 1];
                            a[idx1 + 4] = t2[idx4];
                            a[idx1 + 5] = t2[idx4 + 1];
                            a[idx1 + 6] = t2[idx5];
                            a[idx1 + 7] = t2[idx5 + 1];
                        }
                    }
                    continue;
                }
                if (this.columns == 4) {
                    for (r = 0; r < this.rows; ++r) {
                        idx1 = idx0 + r * this.rowStride;
                        idx2 = 2 * r;
                        idx3 = 2 * this.rows + 2 * r;
                        t2[idx2] = a[idx1];
                        t2[idx2 + 1] = a[idx1 + 1];
                        t2[idx3] = a[idx1 + 2];
                        t2[idx3 + 1] = a[idx1 + 3];
                    }
                    this.fftRows.complexInverse(t2, 0, scale);
                    this.fftRows.complexInverse(t2, 2 * this.rows, scale);
                    for (r = 0; r < this.rows; ++r) {
                        idx1 = idx0 + r * this.rowStride;
                        idx2 = 2 * r;
                        idx3 = 2 * this.rows + 2 * r;
                        a[idx1] = t2[idx2];
                        a[idx1 + 1] = t2[idx2 + 1];
                        a[idx1 + 2] = t2[idx3];
                        a[idx1 + 3] = t2[idx3 + 1];
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (r = 0; r < this.rows; ++r) {
                    idx1 = idx0 + r * this.rowStride;
                    idx2 = 2 * r;
                    t2[idx2] = a[idx1];
                    t2[idx2 + 1] = a[idx1 + 1];
                }
                this.fftRows.complexInverse(t2, 0, scale);
                for (r = 0; r < this.rows; ++r) {
                    idx1 = idx0 + r * this.rowStride;
                    idx2 = 2 * r;
                    a[idx1] = t2[idx2];
                    a[idx1 + 1] = t2[idx2 + 1];
                }
            }
        }
    }

    private void xdft3da_sub2(long icr, int isgn, DoubleLargeArray a, boolean scale) {
        long nt = this.slicesl;
        if (nt < this.rowsl) {
            nt = this.rowsl;
        }
        nt *= 8L;
        if (this.columnsl == 4L) {
            nt >>= 1;
        } else if (this.columnsl < 4L) {
            nt >>= 2;
        }
        DoubleLargeArray t2 = new DoubleLargeArray(nt);
        if (isgn == -1) {
            for (long s2 = 0L; s2 < this.slicesl; ++s2) {
                long idx3;
                long idx2;
                long idx1;
                long r;
                long idx0 = s2 * this.sliceStridel;
                if (icr == 0L) {
                    for (r = 0L; r < this.rowsl; ++r) {
                        this.fftColumns.complexForward(a, idx0 + r * this.rowStridel);
                    }
                } else {
                    for (r = 0L; r < this.rowsl; ++r) {
                        this.fftColumns.realForward(a, idx0 + r * this.rowStridel);
                    }
                }
                if (this.columnsl > 4L) {
                    for (long c = 0L; c < this.columnsl; c += 8L) {
                        long idx5;
                        long idx4;
                        long r2;
                        for (r2 = 0L; r2 < this.rowsl; ++r2) {
                            idx1 = idx0 + r2 * this.rowStridel + c;
                            idx2 = 2L * r2;
                            idx3 = 2L * this.rowsl + 2L * r2;
                            idx4 = idx3 + 2L * this.rowsl;
                            idx5 = idx4 + 2L * this.rowsl;
                            t2.setDouble(idx2, a.getDouble(idx1));
                            t2.setDouble(idx2 + 1L, a.getDouble(idx1 + 1L));
                            t2.setDouble(idx3, a.getDouble(idx1 + 2L));
                            t2.setDouble(idx3 + 1L, a.getDouble(idx1 + 3L));
                            t2.setDouble(idx4, a.getDouble(idx1 + 4L));
                            t2.setDouble(idx4 + 1L, a.getDouble(idx1 + 5L));
                            t2.setDouble(idx5, a.getDouble(idx1 + 6L));
                            t2.setDouble(idx5 + 1L, a.getDouble(idx1 + 7L));
                        }
                        this.fftRows.complexForward(t2, 0L);
                        this.fftRows.complexForward(t2, 2L * this.rowsl);
                        this.fftRows.complexForward(t2, 4L * this.rowsl);
                        this.fftRows.complexForward(t2, 6L * this.rowsl);
                        for (r2 = 0L; r2 < this.rowsl; ++r2) {
                            idx1 = idx0 + r2 * this.rowStridel + c;
                            idx2 = 2L * r2;
                            idx3 = 2L * this.rowsl + 2L * r2;
                            idx4 = idx3 + 2L * this.rowsl;
                            idx5 = idx4 + 2L * this.rowsl;
                            a.setDouble(idx1, t2.getDouble(idx2));
                            a.setDouble(idx1 + 1L, t2.getDouble(idx2 + 1L));
                            a.setDouble(idx1 + 2L, t2.getDouble(idx3));
                            a.setDouble(idx1 + 3L, t2.getDouble(idx3 + 1L));
                            a.setDouble(idx1 + 4L, t2.getDouble(idx4));
                            a.setDouble(idx1 + 5L, t2.getDouble(idx4 + 1L));
                            a.setDouble(idx1 + 6L, t2.getDouble(idx5));
                            a.setDouble(idx1 + 7L, t2.getDouble(idx5 + 1L));
                        }
                    }
                    continue;
                }
                if (this.columnsl == 4L) {
                    for (r = 0L; r < this.rowsl; ++r) {
                        idx1 = idx0 + r * this.rowStridel;
                        idx2 = 2L * r;
                        idx3 = 2L * this.rowsl + 2L * r;
                        t2.setDouble(idx2, a.getDouble(idx1));
                        t2.setDouble(idx2 + 1L, a.getDouble(idx1 + 1L));
                        t2.setDouble(idx3, a.getDouble(idx1 + 2L));
                        t2.setDouble(idx3 + 1L, a.getDouble(idx1 + 3L));
                    }
                    this.fftRows.complexForward(t2, 0L);
                    this.fftRows.complexForward(t2, 2L * this.rowsl);
                    for (r = 0L; r < this.rowsl; ++r) {
                        idx1 = idx0 + r * this.rowStridel;
                        idx2 = 2L * r;
                        idx3 = 2L * this.rowsl + 2L * r;
                        a.setDouble(idx1, t2.getDouble(idx2));
                        a.setDouble(idx1 + 1L, t2.getDouble(idx2 + 1L));
                        a.setDouble(idx1 + 2L, t2.getDouble(idx3));
                        a.setDouble(idx1 + 3L, t2.getDouble(idx3 + 1L));
                    }
                    continue;
                }
                if (this.columnsl != 2L) continue;
                for (r = 0L; r < this.rowsl; ++r) {
                    idx1 = idx0 + r * this.rowStridel;
                    idx2 = 2L * r;
                    t2.setDouble(idx2, a.getDouble(idx1));
                    t2.setDouble(idx2 + 1L, a.getDouble(idx1 + 1L));
                }
                this.fftRows.complexForward(t2, 0L);
                for (r = 0L; r < this.rowsl; ++r) {
                    idx1 = idx0 + r * this.rowStridel;
                    idx2 = 2L * r;
                    a.setDouble(idx1, t2.getDouble(idx2));
                    a.setDouble(idx1 + 1L, t2.getDouble(idx2 + 1L));
                }
            }
        } else {
            for (long s3 = 0L; s3 < this.slicesl; ++s3) {
                long idx3;
                long idx2;
                long idx1;
                long r;
                long idx0 = s3 * this.sliceStridel;
                if (icr == 0L) {
                    for (r = 0L; r < this.rowsl; ++r) {
                        this.fftColumns.complexInverse(a, idx0 + r * this.rowStridel, scale);
                    }
                } else {
                    for (r = 0L; r < this.rowsl; ++r) {
                        this.fftColumns.realInverse2(a, idx0 + r * this.rowStridel, scale);
                    }
                }
                if (this.columnsl > 4L) {
                    for (long c = 0L; c < this.columnsl; c += 8L) {
                        long idx5;
                        long idx4;
                        long r3;
                        for (r3 = 0L; r3 < this.rowsl; ++r3) {
                            idx1 = idx0 + r3 * this.rowStridel + c;
                            idx2 = 2L * r3;
                            idx3 = 2L * this.rowsl + 2L * r3;
                            idx4 = idx3 + 2L * this.rowsl;
                            idx5 = idx4 + 2L * this.rowsl;
                            t2.setDouble(idx2, a.getDouble(idx1));
                            t2.setDouble(idx2 + 1L, a.getDouble(idx1 + 1L));
                            t2.setDouble(idx3, a.getDouble(idx1 + 2L));
                            t2.setDouble(idx3 + 1L, a.getDouble(idx1 + 3L));
                            t2.setDouble(idx4, a.getDouble(idx1 + 4L));
                            t2.setDouble(idx4 + 1L, a.getDouble(idx1 + 5L));
                            t2.setDouble(idx5, a.getDouble(idx1 + 6L));
                            t2.setDouble(idx5 + 1L, a.getDouble(idx1 + 7L));
                        }
                        this.fftRows.complexInverse(t2, 0L, scale);
                        this.fftRows.complexInverse(t2, 2L * this.rowsl, scale);
                        this.fftRows.complexInverse(t2, 4L * this.rowsl, scale);
                        this.fftRows.complexInverse(t2, 6L * this.rowsl, scale);
                        for (r3 = 0L; r3 < this.rowsl; ++r3) {
                            idx1 = idx0 + r3 * this.rowStridel + c;
                            idx2 = 2L * r3;
                            idx3 = 2L * this.rowsl + 2L * r3;
                            idx4 = idx3 + 2L * this.rowsl;
                            idx5 = idx4 + 2L * this.rowsl;
                            a.setDouble(idx1, t2.getDouble(idx2));
                            a.setDouble(idx1 + 1L, t2.getDouble(idx2 + 1L));
                            a.setDouble(idx1 + 2L, t2.getDouble(idx3));
                            a.setDouble(idx1 + 3L, t2.getDouble(idx3 + 1L));
                            a.setDouble(idx1 + 4L, t2.getDouble(idx4));
                            a.setDouble(idx1 + 5L, t2.getDouble(idx4 + 1L));
                            a.setDouble(idx1 + 6L, t2.getDouble(idx5));
                            a.setDouble(idx1 + 7L, t2.getDouble(idx5 + 1L));
                        }
                    }
                    continue;
                }
                if (this.columnsl == 4L) {
                    for (r = 0L; r < this.rowsl; ++r) {
                        idx1 = idx0 + r * this.rowStridel;
                        idx2 = 2L * r;
                        idx3 = 2L * this.rowsl + 2L * r;
                        t2.setDouble(idx2, a.getDouble(idx1));
                        t2.setDouble(idx2 + 1L, a.getDouble(idx1 + 1L));
                        t2.setDouble(idx3, a.getDouble(idx1 + 2L));
                        t2.setDouble(idx3 + 1L, a.getDouble(idx1 + 3L));
                    }
                    this.fftRows.complexInverse(t2, 0L, scale);
                    this.fftRows.complexInverse(t2, 2L * this.rowsl, scale);
                    for (r = 0L; r < this.rowsl; ++r) {
                        idx1 = idx0 + r * this.rowStridel;
                        idx2 = 2L * r;
                        idx3 = 2L * this.rowsl + 2L * r;
                        a.setDouble(idx1, t2.getDouble(idx2));
                        a.setDouble(idx1 + 1L, t2.getDouble(idx2 + 1L));
                        a.setDouble(idx1 + 2L, t2.getDouble(idx3));
                        a.setDouble(idx1 + 3L, t2.getDouble(idx3 + 1L));
                    }
                    continue;
                }
                if (this.columnsl != 2L) continue;
                for (r = 0L; r < this.rowsl; ++r) {
                    idx1 = idx0 + r * this.rowStridel;
                    idx2 = 2L * r;
                    t2.setDouble(idx2, a.getDouble(idx1));
                    t2.setDouble(idx2 + 1L, a.getDouble(idx1 + 1L));
                }
                this.fftRows.complexInverse(t2, 0L, scale);
                for (r = 0L; r < this.rowsl; ++r) {
                    idx1 = idx0 + r * this.rowStridel;
                    idx2 = 2L * r;
                    a.setDouble(idx1, t2.getDouble(idx2));
                    a.setDouble(idx1 + 1L, t2.getDouble(idx2 + 1L));
                }
            }
        }
    }

    private void xdft3da_sub1(int icr, int isgn, double[][][] a, boolean scale) {
        int nt = this.slices;
        if (nt < this.rows) {
            nt = this.rows;
        }
        nt *= 8;
        if (this.columns == 4) {
            nt >>= 1;
        } else if (this.columns < 4) {
            nt >>= 2;
        }
        double[] t2 = new double[nt];
        if (isgn == -1) {
            for (int s2 = 0; s2 < this.slices; ++s2) {
                int idx3;
                int idx2;
                int r;
                if (icr == 0) {
                    for (r = 0; r < this.rows; ++r) {
                        this.fftColumns.complexForward(a[s2][r]);
                    }
                } else {
                    for (r = 0; r < this.rows; ++r) {
                        this.fftColumns.realForward(a[s2][r], 0);
                    }
                }
                if (this.columns > 4) {
                    for (int c = 0; c < this.columns; c += 8) {
                        int idx5;
                        int idx4;
                        int r2;
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            idx2 = 2 * r2;
                            idx3 = 2 * this.rows + 2 * r2;
                            idx4 = idx3 + 2 * this.rows;
                            idx5 = idx4 + 2 * this.rows;
                            t2[idx2] = a[s2][r2][c];
                            t2[idx2 + 1] = a[s2][r2][c + 1];
                            t2[idx3] = a[s2][r2][c + 2];
                            t2[idx3 + 1] = a[s2][r2][c + 3];
                            t2[idx4] = a[s2][r2][c + 4];
                            t2[idx4 + 1] = a[s2][r2][c + 5];
                            t2[idx5] = a[s2][r2][c + 6];
                            t2[idx5 + 1] = a[s2][r2][c + 7];
                        }
                        this.fftRows.complexForward(t2, 0);
                        this.fftRows.complexForward(t2, 2 * this.rows);
                        this.fftRows.complexForward(t2, 4 * this.rows);
                        this.fftRows.complexForward(t2, 6 * this.rows);
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            idx2 = 2 * r2;
                            idx3 = 2 * this.rows + 2 * r2;
                            idx4 = idx3 + 2 * this.rows;
                            idx5 = idx4 + 2 * this.rows;
                            a[s2][r2][c] = t2[idx2];
                            a[s2][r2][c + 1] = t2[idx2 + 1];
                            a[s2][r2][c + 2] = t2[idx3];
                            a[s2][r2][c + 3] = t2[idx3 + 1];
                            a[s2][r2][c + 4] = t2[idx4];
                            a[s2][r2][c + 5] = t2[idx4 + 1];
                            a[s2][r2][c + 6] = t2[idx5];
                            a[s2][r2][c + 7] = t2[idx5 + 1];
                        }
                    }
                    continue;
                }
                if (this.columns == 4) {
                    for (r = 0; r < this.rows; ++r) {
                        idx2 = 2 * r;
                        idx3 = 2 * this.rows + 2 * r;
                        t2[idx2] = a[s2][r][0];
                        t2[idx2 + 1] = a[s2][r][1];
                        t2[idx3] = a[s2][r][2];
                        t2[idx3 + 1] = a[s2][r][3];
                    }
                    this.fftRows.complexForward(t2, 0);
                    this.fftRows.complexForward(t2, 2 * this.rows);
                    for (r = 0; r < this.rows; ++r) {
                        idx2 = 2 * r;
                        idx3 = 2 * this.rows + 2 * r;
                        a[s2][r][0] = t2[idx2];
                        a[s2][r][1] = t2[idx2 + 1];
                        a[s2][r][2] = t2[idx3];
                        a[s2][r][3] = t2[idx3 + 1];
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (r = 0; r < this.rows; ++r) {
                    idx2 = 2 * r;
                    t2[idx2] = a[s2][r][0];
                    t2[idx2 + 1] = a[s2][r][1];
                }
                this.fftRows.complexForward(t2, 0);
                for (r = 0; r < this.rows; ++r) {
                    idx2 = 2 * r;
                    a[s2][r][0] = t2[idx2];
                    a[s2][r][1] = t2[idx2 + 1];
                }
            }
        } else {
            for (int s3 = 0; s3 < this.slices; ++s3) {
                int idx3;
                int idx2;
                int r;
                if (icr == 0) {
                    for (r = 0; r < this.rows; ++r) {
                        this.fftColumns.complexInverse(a[s3][r], scale);
                    }
                }
                if (this.columns > 4) {
                    for (int c = 0; c < this.columns; c += 8) {
                        int idx5;
                        int idx4;
                        int r3;
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx2 = 2 * r3;
                            idx3 = 2 * this.rows + 2 * r3;
                            idx4 = idx3 + 2 * this.rows;
                            idx5 = idx4 + 2 * this.rows;
                            t2[idx2] = a[s3][r3][c];
                            t2[idx2 + 1] = a[s3][r3][c + 1];
                            t2[idx3] = a[s3][r3][c + 2];
                            t2[idx3 + 1] = a[s3][r3][c + 3];
                            t2[idx4] = a[s3][r3][c + 4];
                            t2[idx4 + 1] = a[s3][r3][c + 5];
                            t2[idx5] = a[s3][r3][c + 6];
                            t2[idx5 + 1] = a[s3][r3][c + 7];
                        }
                        this.fftRows.complexInverse(t2, 0, scale);
                        this.fftRows.complexInverse(t2, 2 * this.rows, scale);
                        this.fftRows.complexInverse(t2, 4 * this.rows, scale);
                        this.fftRows.complexInverse(t2, 6 * this.rows, scale);
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx2 = 2 * r3;
                            idx3 = 2 * this.rows + 2 * r3;
                            idx4 = idx3 + 2 * this.rows;
                            idx5 = idx4 + 2 * this.rows;
                            a[s3][r3][c] = t2[idx2];
                            a[s3][r3][c + 1] = t2[idx2 + 1];
                            a[s3][r3][c + 2] = t2[idx3];
                            a[s3][r3][c + 3] = t2[idx3 + 1];
                            a[s3][r3][c + 4] = t2[idx4];
                            a[s3][r3][c + 5] = t2[idx4 + 1];
                            a[s3][r3][c + 6] = t2[idx5];
                            a[s3][r3][c + 7] = t2[idx5 + 1];
                        }
                    }
                } else if (this.columns == 4) {
                    for (r = 0; r < this.rows; ++r) {
                        idx2 = 2 * r;
                        idx3 = 2 * this.rows + 2 * r;
                        t2[idx2] = a[s3][r][0];
                        t2[idx2 + 1] = a[s3][r][1];
                        t2[idx3] = a[s3][r][2];
                        t2[idx3 + 1] = a[s3][r][3];
                    }
                    this.fftRows.complexInverse(t2, 0, scale);
                    this.fftRows.complexInverse(t2, 2 * this.rows, scale);
                    for (r = 0; r < this.rows; ++r) {
                        idx2 = 2 * r;
                        idx3 = 2 * this.rows + 2 * r;
                        a[s3][r][0] = t2[idx2];
                        a[s3][r][1] = t2[idx2 + 1];
                        a[s3][r][2] = t2[idx3];
                        a[s3][r][3] = t2[idx3 + 1];
                    }
                } else if (this.columns == 2) {
                    for (r = 0; r < this.rows; ++r) {
                        idx2 = 2 * r;
                        t2[idx2] = a[s3][r][0];
                        t2[idx2 + 1] = a[s3][r][1];
                    }
                    this.fftRows.complexInverse(t2, 0, scale);
                    for (r = 0; r < this.rows; ++r) {
                        idx2 = 2 * r;
                        a[s3][r][0] = t2[idx2];
                        a[s3][r][1] = t2[idx2 + 1];
                    }
                }
                if (icr == 0) continue;
                for (r = 0; r < this.rows; ++r) {
                    this.fftColumns.realInverse(a[s3][r], scale);
                }
            }
        }
    }

    private void xdft3da_sub2(int icr, int isgn, double[][][] a, boolean scale) {
        int nt = this.slices;
        if (nt < this.rows) {
            nt = this.rows;
        }
        nt *= 8;
        if (this.columns == 4) {
            nt >>= 1;
        } else if (this.columns < 4) {
            nt >>= 2;
        }
        double[] t2 = new double[nt];
        if (isgn == -1) {
            for (int s2 = 0; s2 < this.slices; ++s2) {
                int idx3;
                int idx2;
                int r;
                if (icr == 0) {
                    for (r = 0; r < this.rows; ++r) {
                        this.fftColumns.complexForward(a[s2][r]);
                    }
                } else {
                    for (r = 0; r < this.rows; ++r) {
                        this.fftColumns.realForward(a[s2][r]);
                    }
                }
                if (this.columns > 4) {
                    for (int c = 0; c < this.columns; c += 8) {
                        int idx5;
                        int idx4;
                        int r2;
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            idx2 = 2 * r2;
                            idx3 = 2 * this.rows + 2 * r2;
                            idx4 = idx3 + 2 * this.rows;
                            idx5 = idx4 + 2 * this.rows;
                            t2[idx2] = a[s2][r2][c];
                            t2[idx2 + 1] = a[s2][r2][c + 1];
                            t2[idx3] = a[s2][r2][c + 2];
                            t2[idx3 + 1] = a[s2][r2][c + 3];
                            t2[idx4] = a[s2][r2][c + 4];
                            t2[idx4 + 1] = a[s2][r2][c + 5];
                            t2[idx5] = a[s2][r2][c + 6];
                            t2[idx5 + 1] = a[s2][r2][c + 7];
                        }
                        this.fftRows.complexForward(t2, 0);
                        this.fftRows.complexForward(t2, 2 * this.rows);
                        this.fftRows.complexForward(t2, 4 * this.rows);
                        this.fftRows.complexForward(t2, 6 * this.rows);
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            idx2 = 2 * r2;
                            idx3 = 2 * this.rows + 2 * r2;
                            idx4 = idx3 + 2 * this.rows;
                            idx5 = idx4 + 2 * this.rows;
                            a[s2][r2][c] = t2[idx2];
                            a[s2][r2][c + 1] = t2[idx2 + 1];
                            a[s2][r2][c + 2] = t2[idx3];
                            a[s2][r2][c + 3] = t2[idx3 + 1];
                            a[s2][r2][c + 4] = t2[idx4];
                            a[s2][r2][c + 5] = t2[idx4 + 1];
                            a[s2][r2][c + 6] = t2[idx5];
                            a[s2][r2][c + 7] = t2[idx5 + 1];
                        }
                    }
                    continue;
                }
                if (this.columns == 4) {
                    for (r = 0; r < this.rows; ++r) {
                        idx2 = 2 * r;
                        idx3 = 2 * this.rows + 2 * r;
                        t2[idx2] = a[s2][r][0];
                        t2[idx2 + 1] = a[s2][r][1];
                        t2[idx3] = a[s2][r][2];
                        t2[idx3 + 1] = a[s2][r][3];
                    }
                    this.fftRows.complexForward(t2, 0);
                    this.fftRows.complexForward(t2, 2 * this.rows);
                    for (r = 0; r < this.rows; ++r) {
                        idx2 = 2 * r;
                        idx3 = 2 * this.rows + 2 * r;
                        a[s2][r][0] = t2[idx2];
                        a[s2][r][1] = t2[idx2 + 1];
                        a[s2][r][2] = t2[idx3];
                        a[s2][r][3] = t2[idx3 + 1];
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (r = 0; r < this.rows; ++r) {
                    idx2 = 2 * r;
                    t2[idx2] = a[s2][r][0];
                    t2[idx2 + 1] = a[s2][r][1];
                }
                this.fftRows.complexForward(t2, 0);
                for (r = 0; r < this.rows; ++r) {
                    idx2 = 2 * r;
                    a[s2][r][0] = t2[idx2];
                    a[s2][r][1] = t2[idx2 + 1];
                }
            }
        } else {
            for (int s3 = 0; s3 < this.slices; ++s3) {
                int idx3;
                int idx2;
                int r;
                if (icr == 0) {
                    for (r = 0; r < this.rows; ++r) {
                        this.fftColumns.complexInverse(a[s3][r], scale);
                    }
                } else {
                    for (r = 0; r < this.rows; ++r) {
                        this.fftColumns.realInverse2(a[s3][r], 0, scale);
                    }
                }
                if (this.columns > 4) {
                    for (int c = 0; c < this.columns; c += 8) {
                        int idx5;
                        int idx4;
                        int r3;
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx2 = 2 * r3;
                            idx3 = 2 * this.rows + 2 * r3;
                            idx4 = idx3 + 2 * this.rows;
                            idx5 = idx4 + 2 * this.rows;
                            t2[idx2] = a[s3][r3][c];
                            t2[idx2 + 1] = a[s3][r3][c + 1];
                            t2[idx3] = a[s3][r3][c + 2];
                            t2[idx3 + 1] = a[s3][r3][c + 3];
                            t2[idx4] = a[s3][r3][c + 4];
                            t2[idx4 + 1] = a[s3][r3][c + 5];
                            t2[idx5] = a[s3][r3][c + 6];
                            t2[idx5 + 1] = a[s3][r3][c + 7];
                        }
                        this.fftRows.complexInverse(t2, 0, scale);
                        this.fftRows.complexInverse(t2, 2 * this.rows, scale);
                        this.fftRows.complexInverse(t2, 4 * this.rows, scale);
                        this.fftRows.complexInverse(t2, 6 * this.rows, scale);
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx2 = 2 * r3;
                            idx3 = 2 * this.rows + 2 * r3;
                            idx4 = idx3 + 2 * this.rows;
                            idx5 = idx4 + 2 * this.rows;
                            a[s3][r3][c] = t2[idx2];
                            a[s3][r3][c + 1] = t2[idx2 + 1];
                            a[s3][r3][c + 2] = t2[idx3];
                            a[s3][r3][c + 3] = t2[idx3 + 1];
                            a[s3][r3][c + 4] = t2[idx4];
                            a[s3][r3][c + 5] = t2[idx4 + 1];
                            a[s3][r3][c + 6] = t2[idx5];
                            a[s3][r3][c + 7] = t2[idx5 + 1];
                        }
                    }
                    continue;
                }
                if (this.columns == 4) {
                    for (r = 0; r < this.rows; ++r) {
                        idx2 = 2 * r;
                        idx3 = 2 * this.rows + 2 * r;
                        t2[idx2] = a[s3][r][0];
                        t2[idx2 + 1] = a[s3][r][1];
                        t2[idx3] = a[s3][r][2];
                        t2[idx3 + 1] = a[s3][r][3];
                    }
                    this.fftRows.complexInverse(t2, 0, scale);
                    this.fftRows.complexInverse(t2, 2 * this.rows, scale);
                    for (r = 0; r < this.rows; ++r) {
                        idx2 = 2 * r;
                        idx3 = 2 * this.rows + 2 * r;
                        a[s3][r][0] = t2[idx2];
                        a[s3][r][1] = t2[idx2 + 1];
                        a[s3][r][2] = t2[idx3];
                        a[s3][r][3] = t2[idx3 + 1];
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (r = 0; r < this.rows; ++r) {
                    idx2 = 2 * r;
                    t2[idx2] = a[s3][r][0];
                    t2[idx2 + 1] = a[s3][r][1];
                }
                this.fftRows.complexInverse(t2, 0, scale);
                for (r = 0; r < this.rows; ++r) {
                    idx2 = 2 * r;
                    a[s3][r][0] = t2[idx2];
                    a[s3][r][1] = t2[idx2 + 1];
                }
            }
        }
    }

    private void cdft3db_sub(int isgn, double[] a, boolean scale) {
        block31: {
            double[] t2;
            block29: {
                block32: {
                    block30: {
                        int nt = this.slices;
                        if (nt < this.rows) {
                            nt = this.rows;
                        }
                        nt *= 8;
                        if (this.columns == 4) {
                            nt >>= 1;
                        } else if (this.columns < 4) {
                            nt >>= 2;
                        }
                        t2 = new double[nt];
                        if (isgn != -1) break block29;
                        if (this.columns <= 4) break block30;
                        for (int r = 0; r < this.rows; ++r) {
                            int idx0 = r * this.rowStride;
                            for (int c = 0; c < this.columns; c += 8) {
                                int idx5;
                                int idx4;
                                int idx3;
                                int idx2;
                                int idx1;
                                int s2;
                                for (s2 = 0; s2 < this.slices; ++s2) {
                                    idx1 = s2 * this.sliceStride + idx0 + c;
                                    idx2 = 2 * s2;
                                    idx3 = 2 * this.slices + 2 * s2;
                                    idx4 = idx3 + 2 * this.slices;
                                    idx5 = idx4 + 2 * this.slices;
                                    t2[idx2] = a[idx1];
                                    t2[idx2 + 1] = a[idx1 + 1];
                                    t2[idx3] = a[idx1 + 2];
                                    t2[idx3 + 1] = a[idx1 + 3];
                                    t2[idx4] = a[idx1 + 4];
                                    t2[idx4 + 1] = a[idx1 + 5];
                                    t2[idx5] = a[idx1 + 6];
                                    t2[idx5 + 1] = a[idx1 + 7];
                                }
                                this.fftSlices.complexForward(t2, 0);
                                this.fftSlices.complexForward(t2, 2 * this.slices);
                                this.fftSlices.complexForward(t2, 4 * this.slices);
                                this.fftSlices.complexForward(t2, 6 * this.slices);
                                for (s2 = 0; s2 < this.slices; ++s2) {
                                    idx1 = s2 * this.sliceStride + idx0 + c;
                                    idx2 = 2 * s2;
                                    idx3 = 2 * this.slices + 2 * s2;
                                    idx4 = idx3 + 2 * this.slices;
                                    idx5 = idx4 + 2 * this.slices;
                                    a[idx1] = t2[idx2];
                                    a[idx1 + 1] = t2[idx2 + 1];
                                    a[idx1 + 2] = t2[idx3];
                                    a[idx1 + 3] = t2[idx3 + 1];
                                    a[idx1 + 4] = t2[idx4];
                                    a[idx1 + 5] = t2[idx4 + 1];
                                    a[idx1 + 6] = t2[idx5];
                                    a[idx1 + 7] = t2[idx5 + 1];
                                }
                            }
                        }
                        break block31;
                    }
                    if (this.columns != 4) break block32;
                    for (int r = 0; r < this.rows; ++r) {
                        int idx3;
                        int idx2;
                        int idx1;
                        int s3;
                        int idx0 = r * this.rowStride;
                        for (s3 = 0; s3 < this.slices; ++s3) {
                            idx1 = s3 * this.sliceStride + idx0;
                            idx2 = 2 * s3;
                            idx3 = 2 * this.slices + 2 * s3;
                            t2[idx2] = a[idx1];
                            t2[idx2 + 1] = a[idx1 + 1];
                            t2[idx3] = a[idx1 + 2];
                            t2[idx3 + 1] = a[idx1 + 3];
                        }
                        this.fftSlices.complexForward(t2, 0);
                        this.fftSlices.complexForward(t2, 2 * this.slices);
                        for (s3 = 0; s3 < this.slices; ++s3) {
                            idx1 = s3 * this.sliceStride + idx0;
                            idx2 = 2 * s3;
                            idx3 = 2 * this.slices + 2 * s3;
                            a[idx1] = t2[idx2];
                            a[idx1 + 1] = t2[idx2 + 1];
                            a[idx1 + 2] = t2[idx3];
                            a[idx1 + 3] = t2[idx3 + 1];
                        }
                    }
                    break block31;
                }
                if (this.columns != 2) break block31;
                for (int r = 0; r < this.rows; ++r) {
                    int idx2;
                    int idx1;
                    int s4;
                    int idx0 = r * this.rowStride;
                    for (s4 = 0; s4 < this.slices; ++s4) {
                        idx1 = s4 * this.sliceStride + idx0;
                        idx2 = 2 * s4;
                        t2[idx2] = a[idx1];
                        t2[idx2 + 1] = a[idx1 + 1];
                    }
                    this.fftSlices.complexForward(t2, 0);
                    for (s4 = 0; s4 < this.slices; ++s4) {
                        idx1 = s4 * this.sliceStride + idx0;
                        idx2 = 2 * s4;
                        a[idx1] = t2[idx2];
                        a[idx1 + 1] = t2[idx2 + 1];
                    }
                }
                break block31;
            }
            if (this.columns > 4) {
                for (int r = 0; r < this.rows; ++r) {
                    int idx0 = r * this.rowStride;
                    for (int c = 0; c < this.columns; c += 8) {
                        int idx5;
                        int idx4;
                        int idx3;
                        int idx2;
                        int idx1;
                        int s5;
                        for (s5 = 0; s5 < this.slices; ++s5) {
                            idx1 = s5 * this.sliceStride + idx0 + c;
                            idx2 = 2 * s5;
                            idx3 = 2 * this.slices + 2 * s5;
                            idx4 = idx3 + 2 * this.slices;
                            idx5 = idx4 + 2 * this.slices;
                            t2[idx2] = a[idx1];
                            t2[idx2 + 1] = a[idx1 + 1];
                            t2[idx3] = a[idx1 + 2];
                            t2[idx3 + 1] = a[idx1 + 3];
                            t2[idx4] = a[idx1 + 4];
                            t2[idx4 + 1] = a[idx1 + 5];
                            t2[idx5] = a[idx1 + 6];
                            t2[idx5 + 1] = a[idx1 + 7];
                        }
                        this.fftSlices.complexInverse(t2, 0, scale);
                        this.fftSlices.complexInverse(t2, 2 * this.slices, scale);
                        this.fftSlices.complexInverse(t2, 4 * this.slices, scale);
                        this.fftSlices.complexInverse(t2, 6 * this.slices, scale);
                        for (s5 = 0; s5 < this.slices; ++s5) {
                            idx1 = s5 * this.sliceStride + idx0 + c;
                            idx2 = 2 * s5;
                            idx3 = 2 * this.slices + 2 * s5;
                            idx4 = idx3 + 2 * this.slices;
                            idx5 = idx4 + 2 * this.slices;
                            a[idx1] = t2[idx2];
                            a[idx1 + 1] = t2[idx2 + 1];
                            a[idx1 + 2] = t2[idx3];
                            a[idx1 + 3] = t2[idx3 + 1];
                            a[idx1 + 4] = t2[idx4];
                            a[idx1 + 5] = t2[idx4 + 1];
                            a[idx1 + 6] = t2[idx5];
                            a[idx1 + 7] = t2[idx5 + 1];
                        }
                    }
                }
            } else if (this.columns == 4) {
                for (int r = 0; r < this.rows; ++r) {
                    int idx3;
                    int idx2;
                    int idx1;
                    int s6;
                    int idx0 = r * this.rowStride;
                    for (s6 = 0; s6 < this.slices; ++s6) {
                        idx1 = s6 * this.sliceStride + idx0;
                        idx2 = 2 * s6;
                        idx3 = 2 * this.slices + 2 * s6;
                        t2[idx2] = a[idx1];
                        t2[idx2 + 1] = a[idx1 + 1];
                        t2[idx3] = a[idx1 + 2];
                        t2[idx3 + 1] = a[idx1 + 3];
                    }
                    this.fftSlices.complexInverse(t2, 0, scale);
                    this.fftSlices.complexInverse(t2, 2 * this.slices, scale);
                    for (s6 = 0; s6 < this.slices; ++s6) {
                        idx1 = s6 * this.sliceStride + idx0;
                        idx2 = 2 * s6;
                        idx3 = 2 * this.slices + 2 * s6;
                        a[idx1] = t2[idx2];
                        a[idx1 + 1] = t2[idx2 + 1];
                        a[idx1 + 2] = t2[idx3];
                        a[idx1 + 3] = t2[idx3 + 1];
                    }
                }
            } else if (this.columns == 2) {
                for (int r = 0; r < this.rows; ++r) {
                    int idx2;
                    int idx1;
                    int s7;
                    int idx0 = r * this.rowStride;
                    for (s7 = 0; s7 < this.slices; ++s7) {
                        idx1 = s7 * this.sliceStride + idx0;
                        idx2 = 2 * s7;
                        t2[idx2] = a[idx1];
                        t2[idx2 + 1] = a[idx1 + 1];
                    }
                    this.fftSlices.complexInverse(t2, 0, scale);
                    for (s7 = 0; s7 < this.slices; ++s7) {
                        idx1 = s7 * this.sliceStride + idx0;
                        idx2 = 2 * s7;
                        a[idx1] = t2[idx2];
                        a[idx1 + 1] = t2[idx2 + 1];
                    }
                }
            }
        }
    }

    private void cdft3db_sub(int isgn, DoubleLargeArray a, boolean scale) {
        block31: {
            DoubleLargeArray t2;
            block29: {
                block32: {
                    block30: {
                        long nt = this.slicesl;
                        if (nt < this.rowsl) {
                            nt = this.rowsl;
                        }
                        nt *= 8L;
                        if (this.columnsl == 4L) {
                            nt >>= 1;
                        } else if (this.columnsl < 4L) {
                            nt >>= 2;
                        }
                        t2 = new DoubleLargeArray(nt);
                        if (isgn != -1) break block29;
                        if (this.columnsl <= 4L) break block30;
                        for (long r = 0L; r < this.rowsl; ++r) {
                            long idx0 = r * this.rowStridel;
                            for (long c = 0L; c < this.columnsl; c += 8L) {
                                long idx5;
                                long idx4;
                                long idx3;
                                long idx2;
                                long idx1;
                                long s2;
                                for (s2 = 0L; s2 < this.slicesl; ++s2) {
                                    idx1 = s2 * this.sliceStridel + idx0 + c;
                                    idx2 = 2L * s2;
                                    idx3 = 2L * this.slicesl + 2L * s2;
                                    idx4 = idx3 + 2L * this.slicesl;
                                    idx5 = idx4 + 2L * this.slicesl;
                                    t2.setDouble(idx2, a.getDouble(idx1));
                                    t2.setDouble(idx2 + 1L, a.getDouble(idx1 + 1L));
                                    t2.setDouble(idx3, a.getDouble(idx1 + 2L));
                                    t2.setDouble(idx3 + 1L, a.getDouble(idx1 + 3L));
                                    t2.setDouble(idx4, a.getDouble(idx1 + 4L));
                                    t2.setDouble(idx4 + 1L, a.getDouble(idx1 + 5L));
                                    t2.setDouble(idx5, a.getDouble(idx1 + 6L));
                                    t2.setDouble(idx5 + 1L, a.getDouble(idx1 + 7L));
                                }
                                this.fftSlices.complexForward(t2, 0L);
                                this.fftSlices.complexForward(t2, 2L * this.slicesl);
                                this.fftSlices.complexForward(t2, 4L * this.slicesl);
                                this.fftSlices.complexForward(t2, 6L * this.slicesl);
                                for (s2 = 0L; s2 < this.slicesl; ++s2) {
                                    idx1 = s2 * this.sliceStridel + idx0 + c;
                                    idx2 = 2L * s2;
                                    idx3 = 2L * this.slicesl + 2L * s2;
                                    idx4 = idx3 + 2L * this.slicesl;
                                    idx5 = idx4 + 2L * this.slicesl;
                                    a.setDouble(idx1, t2.getDouble(idx2));
                                    a.setDouble(idx1 + 1L, t2.getDouble(idx2 + 1L));
                                    a.setDouble(idx1 + 2L, t2.getDouble(idx3));
                                    a.setDouble(idx1 + 3L, t2.getDouble(idx3 + 1L));
                                    a.setDouble(idx1 + 4L, t2.getDouble(idx4));
                                    a.setDouble(idx1 + 5L, t2.getDouble(idx4 + 1L));
                                    a.setDouble(idx1 + 6L, t2.getDouble(idx5));
                                    a.setDouble(idx1 + 7L, t2.getDouble(idx5 + 1L));
                                }
                            }
                        }
                        break block31;
                    }
                    if (this.columnsl != 4L) break block32;
                    for (long r = 0L; r < this.rowsl; ++r) {
                        long idx3;
                        long idx2;
                        long idx1;
                        long s3;
                        long idx0 = r * this.rowStridel;
                        for (s3 = 0L; s3 < this.slicesl; ++s3) {
                            idx1 = s3 * this.sliceStridel + idx0;
                            idx2 = 2L * s3;
                            idx3 = 2L * this.slicesl + 2L * s3;
                            t2.setDouble(idx2, a.getDouble(idx1));
                            t2.setDouble(idx2 + 1L, a.getDouble(idx1 + 1L));
                            t2.setDouble(idx3, a.getDouble(idx1 + 2L));
                            t2.setDouble(idx3 + 1L, a.getDouble(idx1 + 3L));
                        }
                        this.fftSlices.complexForward(t2, 0L);
                        this.fftSlices.complexForward(t2, 2L * this.slicesl);
                        for (s3 = 0L; s3 < this.slicesl; ++s3) {
                            idx1 = s3 * this.sliceStridel + idx0;
                            idx2 = 2L * s3;
                            idx3 = 2L * this.slicesl + 2L * s3;
                            a.setDouble(idx1, t2.getDouble(idx2));
                            a.setDouble(idx1 + 1L, t2.getDouble(idx2 + 1L));
                            a.setDouble(idx1 + 2L, t2.getDouble(idx3));
                            a.setDouble(idx1 + 3L, t2.getDouble(idx3 + 1L));
                        }
                    }
                    break block31;
                }
                if (this.columnsl != 2L) break block31;
                for (long r = 0L; r < this.rowsl; ++r) {
                    long idx2;
                    long idx1;
                    long s4;
                    long idx0 = r * this.rowStridel;
                    for (s4 = 0L; s4 < this.slicesl; ++s4) {
                        idx1 = s4 * this.sliceStridel + idx0;
                        idx2 = 2L * s4;
                        t2.setDouble(idx2, a.getDouble(idx1));
                        t2.setDouble(idx2 + 1L, a.getDouble(idx1 + 1L));
                    }
                    this.fftSlices.complexForward(t2, 0L);
                    for (s4 = 0L; s4 < this.slicesl; ++s4) {
                        idx1 = s4 * this.sliceStridel + idx0;
                        idx2 = 2L * s4;
                        a.setDouble(idx1, t2.getDouble(idx2));
                        a.setDouble(idx1 + 1L, t2.getDouble(idx2 + 1L));
                    }
                }
                break block31;
            }
            if (this.columnsl > 4L) {
                for (long r = 0L; r < this.rowsl; ++r) {
                    long idx0 = r * this.rowStridel;
                    for (long c = 0L; c < this.columnsl; c += 8L) {
                        long idx5;
                        long idx4;
                        long idx3;
                        long idx2;
                        long idx1;
                        long s5;
                        for (s5 = 0L; s5 < this.slicesl; ++s5) {
                            idx1 = s5 * this.sliceStridel + idx0 + c;
                            idx2 = 2L * s5;
                            idx3 = 2L * this.slicesl + 2L * s5;
                            idx4 = idx3 + 2L * this.slicesl;
                            idx5 = idx4 + 2L * this.slicesl;
                            t2.setDouble(idx2, a.getDouble(idx1));
                            t2.setDouble(idx2 + 1L, a.getDouble(idx1 + 1L));
                            t2.setDouble(idx3, a.getDouble(idx1 + 2L));
                            t2.setDouble(idx3 + 1L, a.getDouble(idx1 + 3L));
                            t2.setDouble(idx4, a.getDouble(idx1 + 4L));
                            t2.setDouble(idx4 + 1L, a.getDouble(idx1 + 5L));
                            t2.setDouble(idx5, a.getDouble(idx1 + 6L));
                            t2.setDouble(idx5 + 1L, a.getDouble(idx1 + 7L));
                        }
                        this.fftSlices.complexInverse(t2, 0L, scale);
                        this.fftSlices.complexInverse(t2, 2L * this.slicesl, scale);
                        this.fftSlices.complexInverse(t2, 4L * this.slicesl, scale);
                        this.fftSlices.complexInverse(t2, 6L * this.slicesl, scale);
                        for (s5 = 0L; s5 < this.slicesl; ++s5) {
                            idx1 = s5 * this.sliceStridel + idx0 + c;
                            idx2 = 2L * s5;
                            idx3 = 2L * this.slicesl + 2L * s5;
                            idx4 = idx3 + 2L * this.slicesl;
                            idx5 = idx4 + 2L * this.slicesl;
                            a.setDouble(idx1, t2.getDouble(idx2));
                            a.setDouble(idx1 + 1L, t2.getDouble(idx2 + 1L));
                            a.setDouble(idx1 + 2L, t2.getDouble(idx3));
                            a.setDouble(idx1 + 3L, t2.getDouble(idx3 + 1L));
                            a.setDouble(idx1 + 4L, t2.getDouble(idx4));
                            a.setDouble(idx1 + 5L, t2.getDouble(idx4 + 1L));
                            a.setDouble(idx1 + 6L, t2.getDouble(idx5));
                            a.setDouble(idx1 + 7L, t2.getDouble(idx5 + 1L));
                        }
                    }
                }
            } else if (this.columnsl == 4L) {
                for (long r = 0L; r < this.rowsl; ++r) {
                    long idx3;
                    long idx2;
                    long idx1;
                    long s6;
                    long idx0 = r * this.rowStridel;
                    for (s6 = 0L; s6 < this.slicesl; ++s6) {
                        idx1 = s6 * this.sliceStridel + idx0;
                        idx2 = 2L * s6;
                        idx3 = 2L * this.slicesl + 2L * s6;
                        t2.setDouble(idx2, a.getDouble(idx1));
                        t2.setDouble(idx2 + 1L, a.getDouble(idx1 + 1L));
                        t2.setDouble(idx3, a.getDouble(idx1 + 2L));
                        t2.setDouble(idx3 + 1L, a.getDouble(idx1 + 3L));
                    }
                    this.fftSlices.complexInverse(t2, 0L, scale);
                    this.fftSlices.complexInverse(t2, 2L * this.slicesl, scale);
                    for (s6 = 0L; s6 < this.slicesl; ++s6) {
                        idx1 = s6 * this.sliceStridel + idx0;
                        idx2 = 2L * s6;
                        idx3 = 2L * this.slicesl + 2L * s6;
                        a.setDouble(idx1, t2.getDouble(idx2));
                        a.setDouble(idx1 + 1L, t2.getDouble(idx2 + 1L));
                        a.setDouble(idx1 + 2L, t2.getDouble(idx3));
                        a.setDouble(idx1 + 3L, t2.getDouble(idx3 + 1L));
                    }
                }
            } else if (this.columnsl == 2L) {
                for (long r = 0L; r < this.rowsl; ++r) {
                    long idx2;
                    long idx1;
                    long s7;
                    long idx0 = r * this.rowStridel;
                    for (s7 = 0L; s7 < this.slicesl; ++s7) {
                        idx1 = s7 * this.sliceStridel + idx0;
                        idx2 = 2L * s7;
                        t2.setDouble(idx2, a.getDouble(idx1));
                        t2.setDouble(idx2 + 1L, a.getDouble(idx1 + 1L));
                    }
                    this.fftSlices.complexInverse(t2, 0L, scale);
                    for (s7 = 0L; s7 < this.slicesl; ++s7) {
                        idx1 = s7 * this.sliceStridel + idx0;
                        idx2 = 2L * s7;
                        a.setDouble(idx1, t2.getDouble(idx2));
                        a.setDouble(idx1 + 1L, t2.getDouble(idx2 + 1L));
                    }
                }
            }
        }
    }

    private void cdft3db_sub(int isgn, double[][][] a, boolean scale) {
        block31: {
            double[] t2;
            block29: {
                block32: {
                    block30: {
                        int nt = this.slices;
                        if (nt < this.rows) {
                            nt = this.rows;
                        }
                        nt *= 8;
                        if (this.columns == 4) {
                            nt >>= 1;
                        } else if (this.columns < 4) {
                            nt >>= 2;
                        }
                        t2 = new double[nt];
                        if (isgn != -1) break block29;
                        if (this.columns <= 4) break block30;
                        for (int r = 0; r < this.rows; ++r) {
                            for (int c = 0; c < this.columns; c += 8) {
                                int idx5;
                                int idx4;
                                int idx3;
                                int idx2;
                                int s2;
                                for (s2 = 0; s2 < this.slices; ++s2) {
                                    idx2 = 2 * s2;
                                    idx3 = 2 * this.slices + 2 * s2;
                                    idx4 = idx3 + 2 * this.slices;
                                    idx5 = idx4 + 2 * this.slices;
                                    t2[idx2] = a[s2][r][c];
                                    t2[idx2 + 1] = a[s2][r][c + 1];
                                    t2[idx3] = a[s2][r][c + 2];
                                    t2[idx3 + 1] = a[s2][r][c + 3];
                                    t2[idx4] = a[s2][r][c + 4];
                                    t2[idx4 + 1] = a[s2][r][c + 5];
                                    t2[idx5] = a[s2][r][c + 6];
                                    t2[idx5 + 1] = a[s2][r][c + 7];
                                }
                                this.fftSlices.complexForward(t2, 0);
                                this.fftSlices.complexForward(t2, 2 * this.slices);
                                this.fftSlices.complexForward(t2, 4 * this.slices);
                                this.fftSlices.complexForward(t2, 6 * this.slices);
                                for (s2 = 0; s2 < this.slices; ++s2) {
                                    idx2 = 2 * s2;
                                    idx3 = 2 * this.slices + 2 * s2;
                                    idx4 = idx3 + 2 * this.slices;
                                    idx5 = idx4 + 2 * this.slices;
                                    a[s2][r][c] = t2[idx2];
                                    a[s2][r][c + 1] = t2[idx2 + 1];
                                    a[s2][r][c + 2] = t2[idx3];
                                    a[s2][r][c + 3] = t2[idx3 + 1];
                                    a[s2][r][c + 4] = t2[idx4];
                                    a[s2][r][c + 5] = t2[idx4 + 1];
                                    a[s2][r][c + 6] = t2[idx5];
                                    a[s2][r][c + 7] = t2[idx5 + 1];
                                }
                            }
                        }
                        break block31;
                    }
                    if (this.columns != 4) break block32;
                    for (int r = 0; r < this.rows; ++r) {
                        int idx3;
                        int idx2;
                        int s3;
                        for (s3 = 0; s3 < this.slices; ++s3) {
                            idx2 = 2 * s3;
                            idx3 = 2 * this.slices + 2 * s3;
                            t2[idx2] = a[s3][r][0];
                            t2[idx2 + 1] = a[s3][r][1];
                            t2[idx3] = a[s3][r][2];
                            t2[idx3 + 1] = a[s3][r][3];
                        }
                        this.fftSlices.complexForward(t2, 0);
                        this.fftSlices.complexForward(t2, 2 * this.slices);
                        for (s3 = 0; s3 < this.slices; ++s3) {
                            idx2 = 2 * s3;
                            idx3 = 2 * this.slices + 2 * s3;
                            a[s3][r][0] = t2[idx2];
                            a[s3][r][1] = t2[idx2 + 1];
                            a[s3][r][2] = t2[idx3];
                            a[s3][r][3] = t2[idx3 + 1];
                        }
                    }
                    break block31;
                }
                if (this.columns != 2) break block31;
                for (int r = 0; r < this.rows; ++r) {
                    int idx2;
                    int s4;
                    for (s4 = 0; s4 < this.slices; ++s4) {
                        idx2 = 2 * s4;
                        t2[idx2] = a[s4][r][0];
                        t2[idx2 + 1] = a[s4][r][1];
                    }
                    this.fftSlices.complexForward(t2, 0);
                    for (s4 = 0; s4 < this.slices; ++s4) {
                        idx2 = 2 * s4;
                        a[s4][r][0] = t2[idx2];
                        a[s4][r][1] = t2[idx2 + 1];
                    }
                }
                break block31;
            }
            if (this.columns > 4) {
                for (int r = 0; r < this.rows; ++r) {
                    for (int c = 0; c < this.columns; c += 8) {
                        int idx5;
                        int idx4;
                        int idx3;
                        int idx2;
                        int s5;
                        for (s5 = 0; s5 < this.slices; ++s5) {
                            idx2 = 2 * s5;
                            idx3 = 2 * this.slices + 2 * s5;
                            idx4 = idx3 + 2 * this.slices;
                            idx5 = idx4 + 2 * this.slices;
                            t2[idx2] = a[s5][r][c];
                            t2[idx2 + 1] = a[s5][r][c + 1];
                            t2[idx3] = a[s5][r][c + 2];
                            t2[idx3 + 1] = a[s5][r][c + 3];
                            t2[idx4] = a[s5][r][c + 4];
                            t2[idx4 + 1] = a[s5][r][c + 5];
                            t2[idx5] = a[s5][r][c + 6];
                            t2[idx5 + 1] = a[s5][r][c + 7];
                        }
                        this.fftSlices.complexInverse(t2, 0, scale);
                        this.fftSlices.complexInverse(t2, 2 * this.slices, scale);
                        this.fftSlices.complexInverse(t2, 4 * this.slices, scale);
                        this.fftSlices.complexInverse(t2, 6 * this.slices, scale);
                        for (s5 = 0; s5 < this.slices; ++s5) {
                            idx2 = 2 * s5;
                            idx3 = 2 * this.slices + 2 * s5;
                            idx4 = idx3 + 2 * this.slices;
                            idx5 = idx4 + 2 * this.slices;
                            a[s5][r][c] = t2[idx2];
                            a[s5][r][c + 1] = t2[idx2 + 1];
                            a[s5][r][c + 2] = t2[idx3];
                            a[s5][r][c + 3] = t2[idx3 + 1];
                            a[s5][r][c + 4] = t2[idx4];
                            a[s5][r][c + 5] = t2[idx4 + 1];
                            a[s5][r][c + 6] = t2[idx5];
                            a[s5][r][c + 7] = t2[idx5 + 1];
                        }
                    }
                }
            } else if (this.columns == 4) {
                for (int r = 0; r < this.rows; ++r) {
                    int idx3;
                    int idx2;
                    int s6;
                    for (s6 = 0; s6 < this.slices; ++s6) {
                        idx2 = 2 * s6;
                        idx3 = 2 * this.slices + 2 * s6;
                        t2[idx2] = a[s6][r][0];
                        t2[idx2 + 1] = a[s6][r][1];
                        t2[idx3] = a[s6][r][2];
                        t2[idx3 + 1] = a[s6][r][3];
                    }
                    this.fftSlices.complexInverse(t2, 0, scale);
                    this.fftSlices.complexInverse(t2, 2 * this.slices, scale);
                    for (s6 = 0; s6 < this.slices; ++s6) {
                        idx2 = 2 * s6;
                        idx3 = 2 * this.slices + 2 * s6;
                        a[s6][r][0] = t2[idx2];
                        a[s6][r][1] = t2[idx2 + 1];
                        a[s6][r][2] = t2[idx3];
                        a[s6][r][3] = t2[idx3 + 1];
                    }
                }
            } else if (this.columns == 2) {
                for (int r = 0; r < this.rows; ++r) {
                    int idx2;
                    int s7;
                    for (s7 = 0; s7 < this.slices; ++s7) {
                        idx2 = 2 * s7;
                        t2[idx2] = a[s7][r][0];
                        t2[idx2 + 1] = a[s7][r][1];
                    }
                    this.fftSlices.complexInverse(t2, 0, scale);
                    for (s7 = 0; s7 < this.slices; ++s7) {
                        idx2 = 2 * s7;
                        a[s7][r][0] = t2[idx2];
                        a[s7][r][1] = t2[idx2 + 1];
                    }
                }
            }
        }
    }

    private void xdft3da_subth1(final int icr, final int isgn, final double[] a, final boolean scale) {
        final int nthreads = FastMath.min(ConcurrencyUtils.getNumberOfThreads(), this.slices);
        int nt = this.slices;
        if (nt < this.rows) {
            nt = this.rows;
        }
        nt *= 8;
        if (this.columns == 4) {
            nt >>= 1;
        } else if (this.columns < 4) {
            nt >>= 2;
        }
        final int ntf = nt;
        Future[] futures = new Future[nthreads];
        for (int i = 0; i < nthreads; ++i) {
            final int n0 = i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    double[] t2 = new double[ntf];
                    if (isgn == -1) {
                        for (int s2 = n0; s2 < DoubleFFT_3D.this.slices; s2 += nthreads) {
                            int idx3;
                            int idx2;
                            int idx1;
                            int r;
                            int idx0 = s2 * DoubleFFT_3D.this.sliceStride;
                            if (icr == 0) {
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    DoubleFFT_3D.this.fftColumns.complexForward(a, idx0 + r * DoubleFFT_3D.this.rowStride);
                                }
                            } else {
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    DoubleFFT_3D.this.fftColumns.realForward(a, idx0 + r * DoubleFFT_3D.this.rowStride);
                                }
                            }
                            if (DoubleFFT_3D.this.columns > 4) {
                                for (int c = 0; c < DoubleFFT_3D.this.columns; c += 8) {
                                    int idx5;
                                    int idx4;
                                    int r2;
                                    for (r2 = 0; r2 < DoubleFFT_3D.this.rows; ++r2) {
                                        idx1 = idx0 + r2 * DoubleFFT_3D.this.rowStride + c;
                                        idx2 = 2 * r2;
                                        idx3 = 2 * DoubleFFT_3D.this.rows + 2 * r2;
                                        idx4 = idx3 + 2 * DoubleFFT_3D.this.rows;
                                        idx5 = idx4 + 2 * DoubleFFT_3D.this.rows;
                                        t2[idx2] = a[idx1];
                                        t2[idx2 + 1] = a[idx1 + 1];
                                        t2[idx3] = a[idx1 + 2];
                                        t2[idx3 + 1] = a[idx1 + 3];
                                        t2[idx4] = a[idx1 + 4];
                                        t2[idx4 + 1] = a[idx1 + 5];
                                        t2[idx5] = a[idx1 + 6];
                                        t2[idx5 + 1] = a[idx1 + 7];
                                    }
                                    DoubleFFT_3D.this.fftRows.complexForward(t2, 0);
                                    DoubleFFT_3D.this.fftRows.complexForward(t2, 2 * DoubleFFT_3D.this.rows);
                                    DoubleFFT_3D.this.fftRows.complexForward(t2, 4 * DoubleFFT_3D.this.rows);
                                    DoubleFFT_3D.this.fftRows.complexForward(t2, 6 * DoubleFFT_3D.this.rows);
                                    for (r2 = 0; r2 < DoubleFFT_3D.this.rows; ++r2) {
                                        idx1 = idx0 + r2 * DoubleFFT_3D.this.rowStride + c;
                                        idx2 = 2 * r2;
                                        idx3 = 2 * DoubleFFT_3D.this.rows + 2 * r2;
                                        idx4 = idx3 + 2 * DoubleFFT_3D.this.rows;
                                        idx5 = idx4 + 2 * DoubleFFT_3D.this.rows;
                                        a[idx1] = t2[idx2];
                                        a[idx1 + 1] = t2[idx2 + 1];
                                        a[idx1 + 2] = t2[idx3];
                                        a[idx1 + 3] = t2[idx3 + 1];
                                        a[idx1 + 4] = t2[idx4];
                                        a[idx1 + 5] = t2[idx4 + 1];
                                        a[idx1 + 6] = t2[idx5];
                                        a[idx1 + 7] = t2[idx5 + 1];
                                    }
                                }
                                continue;
                            }
                            if (DoubleFFT_3D.this.columns == 4) {
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    idx1 = idx0 + r * DoubleFFT_3D.this.rowStride;
                                    idx2 = 2 * r;
                                    idx3 = 2 * DoubleFFT_3D.this.rows + 2 * r;
                                    t2[idx2] = a[idx1];
                                    t2[idx2 + 1] = a[idx1 + 1];
                                    t2[idx3] = a[idx1 + 2];
                                    t2[idx3 + 1] = a[idx1 + 3];
                                }
                                DoubleFFT_3D.this.fftRows.complexForward(t2, 0);
                                DoubleFFT_3D.this.fftRows.complexForward(t2, 2 * DoubleFFT_3D.this.rows);
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    idx1 = idx0 + r * DoubleFFT_3D.this.rowStride;
                                    idx2 = 2 * r;
                                    idx3 = 2 * DoubleFFT_3D.this.rows + 2 * r;
                                    a[idx1] = t2[idx2];
                                    a[idx1 + 1] = t2[idx2 + 1];
                                    a[idx1 + 2] = t2[idx3];
                                    a[idx1 + 3] = t2[idx3 + 1];
                                }
                                continue;
                            }
                            if (DoubleFFT_3D.this.columns != 2) continue;
                            for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                idx1 = idx0 + r * DoubleFFT_3D.this.rowStride;
                                idx2 = 2 * r;
                                t2[idx2] = a[idx1];
                                t2[idx2 + 1] = a[idx1 + 1];
                            }
                            DoubleFFT_3D.this.fftRows.complexForward(t2, 0);
                            for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                idx1 = idx0 + r * DoubleFFT_3D.this.rowStride;
                                idx2 = 2 * r;
                                a[idx1] = t2[idx2];
                                a[idx1 + 1] = t2[idx2 + 1];
                            }
                        }
                    } else {
                        for (int s3 = n0; s3 < DoubleFFT_3D.this.slices; s3 += nthreads) {
                            int idx3;
                            int idx2;
                            int idx1;
                            int r;
                            int idx0 = s3 * DoubleFFT_3D.this.sliceStride;
                            if (icr == 0) {
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    DoubleFFT_3D.this.fftColumns.complexInverse(a, idx0 + r * DoubleFFT_3D.this.rowStride, scale);
                                }
                            }
                            if (DoubleFFT_3D.this.columns > 4) {
                                for (int c = 0; c < DoubleFFT_3D.this.columns; c += 8) {
                                    int idx5;
                                    int idx4;
                                    int r3;
                                    for (r3 = 0; r3 < DoubleFFT_3D.this.rows; ++r3) {
                                        idx1 = idx0 + r3 * DoubleFFT_3D.this.rowStride + c;
                                        idx2 = 2 * r3;
                                        idx3 = 2 * DoubleFFT_3D.this.rows + 2 * r3;
                                        idx4 = idx3 + 2 * DoubleFFT_3D.this.rows;
                                        idx5 = idx4 + 2 * DoubleFFT_3D.this.rows;
                                        t2[idx2] = a[idx1];
                                        t2[idx2 + 1] = a[idx1 + 1];
                                        t2[idx3] = a[idx1 + 2];
                                        t2[idx3 + 1] = a[idx1 + 3];
                                        t2[idx4] = a[idx1 + 4];
                                        t2[idx4 + 1] = a[idx1 + 5];
                                        t2[idx5] = a[idx1 + 6];
                                        t2[idx5 + 1] = a[idx1 + 7];
                                    }
                                    DoubleFFT_3D.this.fftRows.complexInverse(t2, 0, scale);
                                    DoubleFFT_3D.this.fftRows.complexInverse(t2, 2 * DoubleFFT_3D.this.rows, scale);
                                    DoubleFFT_3D.this.fftRows.complexInverse(t2, 4 * DoubleFFT_3D.this.rows, scale);
                                    DoubleFFT_3D.this.fftRows.complexInverse(t2, 6 * DoubleFFT_3D.this.rows, scale);
                                    for (r3 = 0; r3 < DoubleFFT_3D.this.rows; ++r3) {
                                        idx1 = idx0 + r3 * DoubleFFT_3D.this.rowStride + c;
                                        idx2 = 2 * r3;
                                        idx3 = 2 * DoubleFFT_3D.this.rows + 2 * r3;
                                        idx4 = idx3 + 2 * DoubleFFT_3D.this.rows;
                                        idx5 = idx4 + 2 * DoubleFFT_3D.this.rows;
                                        a[idx1] = t2[idx2];
                                        a[idx1 + 1] = t2[idx2 + 1];
                                        a[idx1 + 2] = t2[idx3];
                                        a[idx1 + 3] = t2[idx3 + 1];
                                        a[idx1 + 4] = t2[idx4];
                                        a[idx1 + 5] = t2[idx4 + 1];
                                        a[idx1 + 6] = t2[idx5];
                                        a[idx1 + 7] = t2[idx5 + 1];
                                    }
                                }
                            } else if (DoubleFFT_3D.this.columns == 4) {
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    idx1 = idx0 + r * DoubleFFT_3D.this.rowStride;
                                    idx2 = 2 * r;
                                    idx3 = 2 * DoubleFFT_3D.this.rows + 2 * r;
                                    t2[idx2] = a[idx1];
                                    t2[idx2 + 1] = a[idx1 + 1];
                                    t2[idx3] = a[idx1 + 2];
                                    t2[idx3 + 1] = a[idx1 + 3];
                                }
                                DoubleFFT_3D.this.fftRows.complexInverse(t2, 0, scale);
                                DoubleFFT_3D.this.fftRows.complexInverse(t2, 2 * DoubleFFT_3D.this.rows, scale);
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    idx1 = idx0 + r * DoubleFFT_3D.this.rowStride;
                                    idx2 = 2 * r;
                                    idx3 = 2 * DoubleFFT_3D.this.rows + 2 * r;
                                    a[idx1] = t2[idx2];
                                    a[idx1 + 1] = t2[idx2 + 1];
                                    a[idx1 + 2] = t2[idx3];
                                    a[idx1 + 3] = t2[idx3 + 1];
                                }
                            } else if (DoubleFFT_3D.this.columns == 2) {
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    idx1 = idx0 + r * DoubleFFT_3D.this.rowStride;
                                    idx2 = 2 * r;
                                    t2[idx2] = a[idx1];
                                    t2[idx2 + 1] = a[idx1 + 1];
                                }
                                DoubleFFT_3D.this.fftRows.complexInverse(t2, 0, scale);
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    idx1 = idx0 + r * DoubleFFT_3D.this.rowStride;
                                    idx2 = 2 * r;
                                    a[idx1] = t2[idx2];
                                    a[idx1 + 1] = t2[idx2 + 1];
                                }
                            }
                            if (icr == 0) continue;
                            for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                DoubleFFT_3D.this.fftColumns.realInverse(a, idx0 + r * DoubleFFT_3D.this.rowStride, scale);
                            }
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void xdft3da_subth1(final long icr, final int isgn, final DoubleLargeArray a, final boolean scale) {
        final int nthreads = (int)FastMath.min((long)ConcurrencyUtils.getNumberOfThreads(), this.slicesl);
        long nt = this.slicesl;
        if (nt < this.rowsl) {
            nt = this.rowsl;
        }
        nt *= 8L;
        if (this.columnsl == 4L) {
            nt >>= 1;
        } else if (this.columnsl < 4L) {
            nt >>= 2;
        }
        final long ntf = nt;
        Future[] futures = new Future[nthreads];
        for (int i = 0; i < nthreads; ++i) {
            final long n0 = i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    DoubleLargeArray t2 = new DoubleLargeArray(ntf);
                    if (isgn == -1) {
                        for (long s2 = n0; s2 < DoubleFFT_3D.this.slicesl; s2 += (long)nthreads) {
                            long idx3;
                            long idx2;
                            long idx1;
                            long r;
                            long idx0 = s2 * DoubleFFT_3D.this.sliceStridel;
                            if (icr == 0L) {
                                for (r = 0L; r < DoubleFFT_3D.this.rowsl; ++r) {
                                    DoubleFFT_3D.this.fftColumns.complexForward(a, idx0 + r * DoubleFFT_3D.this.rowStridel);
                                }
                            } else {
                                for (r = 0L; r < DoubleFFT_3D.this.rowsl; ++r) {
                                    DoubleFFT_3D.this.fftColumns.realForward(a, idx0 + r * DoubleFFT_3D.this.rowStridel);
                                }
                            }
                            if (DoubleFFT_3D.this.columnsl > 4L) {
                                for (long c = 0L; c < DoubleFFT_3D.this.columnsl; c += 8L) {
                                    long idx5;
                                    long idx4;
                                    long r2;
                                    for (r2 = 0L; r2 < DoubleFFT_3D.this.rowsl; ++r2) {
                                        idx1 = idx0 + r2 * DoubleFFT_3D.this.rowStridel + c;
                                        idx2 = 2L * r2;
                                        idx3 = 2L * DoubleFFT_3D.this.rowsl + 2L * r2;
                                        idx4 = idx3 + 2L * DoubleFFT_3D.this.rowsl;
                                        idx5 = idx4 + 2L * DoubleFFT_3D.this.rowsl;
                                        t2.setDouble(idx2, a.getDouble(idx1));
                                        t2.setDouble(idx2 + 1L, a.getDouble(idx1 + 1L));
                                        t2.setDouble(idx3, a.getDouble(idx1 + 2L));
                                        t2.setDouble(idx3 + 1L, a.getDouble(idx1 + 3L));
                                        t2.setDouble(idx4, a.getDouble(idx1 + 4L));
                                        t2.setDouble(idx4 + 1L, a.getDouble(idx1 + 5L));
                                        t2.setDouble(idx5, a.getDouble(idx1 + 6L));
                                        t2.setDouble(idx5 + 1L, a.getDouble(idx1 + 7L));
                                    }
                                    DoubleFFT_3D.this.fftRows.complexForward(t2, 0L);
                                    DoubleFFT_3D.this.fftRows.complexForward(t2, 2L * DoubleFFT_3D.this.rowsl);
                                    DoubleFFT_3D.this.fftRows.complexForward(t2, 4L * DoubleFFT_3D.this.rowsl);
                                    DoubleFFT_3D.this.fftRows.complexForward(t2, 6L * DoubleFFT_3D.this.rowsl);
                                    for (r2 = 0L; r2 < DoubleFFT_3D.this.rowsl; ++r2) {
                                        idx1 = idx0 + r2 * DoubleFFT_3D.this.rowStridel + c;
                                        idx2 = 2L * r2;
                                        idx3 = 2L * DoubleFFT_3D.this.rowsl + 2L * r2;
                                        idx4 = idx3 + 2L * DoubleFFT_3D.this.rowsl;
                                        idx5 = idx4 + 2L * DoubleFFT_3D.this.rowsl;
                                        a.setDouble(idx1, t2.getDouble(idx2));
                                        a.setDouble(idx1 + 1L, t2.getDouble(idx2 + 1L));
                                        a.setDouble(idx1 + 2L, t2.getDouble(idx3));
                                        a.setDouble(idx1 + 3L, t2.getDouble(idx3 + 1L));
                                        a.setDouble(idx1 + 4L, t2.getDouble(idx4));
                                        a.setDouble(idx1 + 5L, t2.getDouble(idx4 + 1L));
                                        a.setDouble(idx1 + 6L, t2.getDouble(idx5));
                                        a.setDouble(idx1 + 7L, t2.getDouble(idx5 + 1L));
                                    }
                                }
                                continue;
                            }
                            if (DoubleFFT_3D.this.columnsl == 4L) {
                                for (r = 0L; r < DoubleFFT_3D.this.rowsl; ++r) {
                                    idx1 = idx0 + r * DoubleFFT_3D.this.rowStridel;
                                    idx2 = 2L * r;
                                    idx3 = 2L * DoubleFFT_3D.this.rowsl + 2L * r;
                                    t2.setDouble(idx2, a.getDouble(idx1));
                                    t2.setDouble(idx2 + 1L, a.getDouble(idx1 + 1L));
                                    t2.setDouble(idx3, a.getDouble(idx1 + 2L));
                                    t2.setDouble(idx3 + 1L, a.getDouble(idx1 + 3L));
                                }
                                DoubleFFT_3D.this.fftRows.complexForward(t2, 0L);
                                DoubleFFT_3D.this.fftRows.complexForward(t2, 2L * DoubleFFT_3D.this.rowsl);
                                for (r = 0L; r < DoubleFFT_3D.this.rowsl; ++r) {
                                    idx1 = idx0 + r * DoubleFFT_3D.this.rowStridel;
                                    idx2 = 2L * r;
                                    idx3 = 2L * DoubleFFT_3D.this.rowsl + 2L * r;
                                    a.setDouble(idx1, t2.getDouble(idx2));
                                    a.setDouble(idx1 + 1L, t2.getDouble(idx2 + 1L));
                                    a.setDouble(idx1 + 2L, t2.getDouble(idx3));
                                    a.setDouble(idx1 + 3L, t2.getDouble(idx3 + 1L));
                                }
                                continue;
                            }
                            if (DoubleFFT_3D.this.columnsl != 2L) continue;
                            for (r = 0L; r < DoubleFFT_3D.this.rowsl; ++r) {
                                idx1 = idx0 + r * DoubleFFT_3D.this.rowStridel;
                                idx2 = 2L * r;
                                t2.setDouble(idx2, a.getDouble(idx1));
                                t2.setDouble(idx2 + 1L, a.getDouble(idx1 + 1L));
                            }
                            DoubleFFT_3D.this.fftRows.complexForward(t2, 0L);
                            for (r = 0L; r < DoubleFFT_3D.this.rowsl; ++r) {
                                idx1 = idx0 + r * DoubleFFT_3D.this.rowStridel;
                                idx2 = 2L * r;
                                a.setDouble(idx1, t2.getDouble(idx2));
                                a.setDouble(idx1 + 1L, t2.getDouble(idx2 + 1L));
                            }
                        }
                    } else {
                        for (long s3 = n0; s3 < DoubleFFT_3D.this.slicesl; s3 += (long)nthreads) {
                            long idx3;
                            long idx2;
                            long idx1;
                            long r;
                            long idx0 = s3 * DoubleFFT_3D.this.sliceStridel;
                            if (icr == 0L) {
                                for (r = 0L; r < DoubleFFT_3D.this.rowsl; ++r) {
                                    DoubleFFT_3D.this.fftColumns.complexInverse(a, idx0 + r * DoubleFFT_3D.this.rowStridel, scale);
                                }
                            }
                            if (DoubleFFT_3D.this.columnsl > 4L) {
                                for (long c = 0L; c < DoubleFFT_3D.this.columnsl; c += 8L) {
                                    long idx5;
                                    long idx4;
                                    long r3;
                                    for (r3 = 0L; r3 < DoubleFFT_3D.this.rowsl; ++r3) {
                                        idx1 = idx0 + r3 * DoubleFFT_3D.this.rowStridel + c;
                                        idx2 = 2L * r3;
                                        idx3 = 2L * DoubleFFT_3D.this.rowsl + 2L * r3;
                                        idx4 = idx3 + 2L * DoubleFFT_3D.this.rowsl;
                                        idx5 = idx4 + 2L * DoubleFFT_3D.this.rowsl;
                                        t2.setDouble(idx2, a.getDouble(idx1));
                                        t2.setDouble(idx2 + 1L, a.getDouble(idx1 + 1L));
                                        t2.setDouble(idx3, a.getDouble(idx1 + 2L));
                                        t2.setDouble(idx3 + 1L, a.getDouble(idx1 + 3L));
                                        t2.setDouble(idx4, a.getDouble(idx1 + 4L));
                                        t2.setDouble(idx4 + 1L, a.getDouble(idx1 + 5L));
                                        t2.setDouble(idx5, a.getDouble(idx1 + 6L));
                                        t2.setDouble(idx5 + 1L, a.getDouble(idx1 + 7L));
                                    }
                                    DoubleFFT_3D.this.fftRows.complexInverse(t2, 0L, scale);
                                    DoubleFFT_3D.this.fftRows.complexInverse(t2, 2L * DoubleFFT_3D.this.rowsl, scale);
                                    DoubleFFT_3D.this.fftRows.complexInverse(t2, 4L * DoubleFFT_3D.this.rowsl, scale);
                                    DoubleFFT_3D.this.fftRows.complexInverse(t2, 6L * DoubleFFT_3D.this.rowsl, scale);
                                    for (r3 = 0L; r3 < DoubleFFT_3D.this.rowsl; ++r3) {
                                        idx1 = idx0 + r3 * DoubleFFT_3D.this.rowStridel + c;
                                        idx2 = 2L * r3;
                                        idx3 = 2L * DoubleFFT_3D.this.rowsl + 2L * r3;
                                        idx4 = idx3 + 2L * DoubleFFT_3D.this.rowsl;
                                        idx5 = idx4 + 2L * DoubleFFT_3D.this.rowsl;
                                        a.setDouble(idx1, t2.getDouble(idx2));
                                        a.setDouble(idx1 + 1L, t2.getDouble(idx2 + 1L));
                                        a.setDouble(idx1 + 2L, t2.getDouble(idx3));
                                        a.setDouble(idx1 + 3L, t2.getDouble(idx3 + 1L));
                                        a.setDouble(idx1 + 4L, t2.getDouble(idx4));
                                        a.setDouble(idx1 + 5L, t2.getDouble(idx4 + 1L));
                                        a.setDouble(idx1 + 6L, t2.getDouble(idx5));
                                        a.setDouble(idx1 + 7L, t2.getDouble(idx5 + 1L));
                                    }
                                }
                            } else if (DoubleFFT_3D.this.columnsl == 4L) {
                                for (r = 0L; r < DoubleFFT_3D.this.rowsl; ++r) {
                                    idx1 = idx0 + r * DoubleFFT_3D.this.rowStridel;
                                    idx2 = 2L * r;
                                    idx3 = 2L * DoubleFFT_3D.this.rowsl + 2L * r;
                                    t2.setDouble(idx2, a.getDouble(idx1));
                                    t2.setDouble(idx2 + 1L, a.getDouble(idx1 + 1L));
                                    t2.setDouble(idx3, a.getDouble(idx1 + 2L));
                                    t2.setDouble(idx3 + 1L, a.getDouble(idx1 + 3L));
                                }
                                DoubleFFT_3D.this.fftRows.complexInverse(t2, 0L, scale);
                                DoubleFFT_3D.this.fftRows.complexInverse(t2, 2L * DoubleFFT_3D.this.rowsl, scale);
                                for (r = 0L; r < DoubleFFT_3D.this.rowsl; ++r) {
                                    idx1 = idx0 + r * DoubleFFT_3D.this.rowStridel;
                                    idx2 = 2L * r;
                                    idx3 = 2L * DoubleFFT_3D.this.rowsl + 2L * r;
                                    a.setDouble(idx1, t2.getDouble(idx2));
                                    a.setDouble(idx1 + 1L, t2.getDouble(idx2 + 1L));
                                    a.setDouble(idx1 + 2L, t2.getDouble(idx3));
                                    a.setDouble(idx1 + 3L, t2.getDouble(idx3 + 1L));
                                }
                            } else if (DoubleFFT_3D.this.columnsl == 2L) {
                                for (r = 0L; r < DoubleFFT_3D.this.rowsl; ++r) {
                                    idx1 = idx0 + r * DoubleFFT_3D.this.rowStridel;
                                    idx2 = 2L * r;
                                    t2.setDouble(idx2, a.getDouble(idx1));
                                    t2.setDouble(idx2 + 1L, a.getDouble(idx1 + 1L));
                                }
                                DoubleFFT_3D.this.fftRows.complexInverse(t2, 0L, scale);
                                for (r = 0L; r < DoubleFFT_3D.this.rowsl; ++r) {
                                    idx1 = idx0 + r * DoubleFFT_3D.this.rowStridel;
                                    idx2 = 2L * r;
                                    a.setDouble(idx1, t2.getDouble(idx2));
                                    a.setDouble(idx1 + 1L, t2.getDouble(idx2 + 1L));
                                }
                            }
                            if (icr == 0L) continue;
                            for (r = 0L; r < DoubleFFT_3D.this.rowsl; ++r) {
                                DoubleFFT_3D.this.fftColumns.realInverse(a, idx0 + r * DoubleFFT_3D.this.rowStridel, scale);
                            }
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void xdft3da_subth2(final int icr, final int isgn, final double[] a, final boolean scale) {
        final int nthreads = FastMath.min(ConcurrencyUtils.getNumberOfThreads(), this.slices);
        int nt = this.slices;
        if (nt < this.rows) {
            nt = this.rows;
        }
        nt *= 8;
        if (this.columns == 4) {
            nt >>= 1;
        } else if (this.columns < 4) {
            nt >>= 2;
        }
        final int ntf = nt;
        Future[] futures = new Future[nthreads];
        for (int i = 0; i < nthreads; ++i) {
            final int n0 = i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    double[] t2 = new double[ntf];
                    if (isgn == -1) {
                        for (int s2 = n0; s2 < DoubleFFT_3D.this.slices; s2 += nthreads) {
                            int idx3;
                            int idx2;
                            int idx1;
                            int r;
                            int idx0 = s2 * DoubleFFT_3D.this.sliceStride;
                            if (icr == 0) {
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    DoubleFFT_3D.this.fftColumns.complexForward(a, idx0 + r * DoubleFFT_3D.this.rowStride);
                                }
                            } else {
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    DoubleFFT_3D.this.fftColumns.realForward(a, idx0 + r * DoubleFFT_3D.this.rowStride);
                                }
                            }
                            if (DoubleFFT_3D.this.columns > 4) {
                                for (int c = 0; c < DoubleFFT_3D.this.columns; c += 8) {
                                    int idx5;
                                    int idx4;
                                    int r2;
                                    for (r2 = 0; r2 < DoubleFFT_3D.this.rows; ++r2) {
                                        idx1 = idx0 + r2 * DoubleFFT_3D.this.rowStride + c;
                                        idx2 = 2 * r2;
                                        idx3 = 2 * DoubleFFT_3D.this.rows + 2 * r2;
                                        idx4 = idx3 + 2 * DoubleFFT_3D.this.rows;
                                        idx5 = idx4 + 2 * DoubleFFT_3D.this.rows;
                                        t2[idx2] = a[idx1];
                                        t2[idx2 + 1] = a[idx1 + 1];
                                        t2[idx3] = a[idx1 + 2];
                                        t2[idx3 + 1] = a[idx1 + 3];
                                        t2[idx4] = a[idx1 + 4];
                                        t2[idx4 + 1] = a[idx1 + 5];
                                        t2[idx5] = a[idx1 + 6];
                                        t2[idx5 + 1] = a[idx1 + 7];
                                    }
                                    DoubleFFT_3D.this.fftRows.complexForward(t2, 0);
                                    DoubleFFT_3D.this.fftRows.complexForward(t2, 2 * DoubleFFT_3D.this.rows);
                                    DoubleFFT_3D.this.fftRows.complexForward(t2, 4 * DoubleFFT_3D.this.rows);
                                    DoubleFFT_3D.this.fftRows.complexForward(t2, 6 * DoubleFFT_3D.this.rows);
                                    for (r2 = 0; r2 < DoubleFFT_3D.this.rows; ++r2) {
                                        idx1 = idx0 + r2 * DoubleFFT_3D.this.rowStride + c;
                                        idx2 = 2 * r2;
                                        idx3 = 2 * DoubleFFT_3D.this.rows + 2 * r2;
                                        idx4 = idx3 + 2 * DoubleFFT_3D.this.rows;
                                        idx5 = idx4 + 2 * DoubleFFT_3D.this.rows;
                                        a[idx1] = t2[idx2];
                                        a[idx1 + 1] = t2[idx2 + 1];
                                        a[idx1 + 2] = t2[idx3];
                                        a[idx1 + 3] = t2[idx3 + 1];
                                        a[idx1 + 4] = t2[idx4];
                                        a[idx1 + 5] = t2[idx4 + 1];
                                        a[idx1 + 6] = t2[idx5];
                                        a[idx1 + 7] = t2[idx5 + 1];
                                    }
                                }
                                continue;
                            }
                            if (DoubleFFT_3D.this.columns == 4) {
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    idx1 = idx0 + r * DoubleFFT_3D.this.rowStride;
                                    idx2 = 2 * r;
                                    idx3 = 2 * DoubleFFT_3D.this.rows + 2 * r;
                                    t2[idx2] = a[idx1];
                                    t2[idx2 + 1] = a[idx1 + 1];
                                    t2[idx3] = a[idx1 + 2];
                                    t2[idx3 + 1] = a[idx1 + 3];
                                }
                                DoubleFFT_3D.this.fftRows.complexForward(t2, 0);
                                DoubleFFT_3D.this.fftRows.complexForward(t2, 2 * DoubleFFT_3D.this.rows);
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    idx1 = idx0 + r * DoubleFFT_3D.this.rowStride;
                                    idx2 = 2 * r;
                                    idx3 = 2 * DoubleFFT_3D.this.rows + 2 * r;
                                    a[idx1] = t2[idx2];
                                    a[idx1 + 1] = t2[idx2 + 1];
                                    a[idx1 + 2] = t2[idx3];
                                    a[idx1 + 3] = t2[idx3 + 1];
                                }
                                continue;
                            }
                            if (DoubleFFT_3D.this.columns != 2) continue;
                            for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                idx1 = idx0 + r * DoubleFFT_3D.this.rowStride;
                                idx2 = 2 * r;
                                t2[idx2] = a[idx1];
                                t2[idx2 + 1] = a[idx1 + 1];
                            }
                            DoubleFFT_3D.this.fftRows.complexForward(t2, 0);
                            for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                idx1 = idx0 + r * DoubleFFT_3D.this.rowStride;
                                idx2 = 2 * r;
                                a[idx1] = t2[idx2];
                                a[idx1 + 1] = t2[idx2 + 1];
                            }
                        }
                    } else {
                        for (int s3 = n0; s3 < DoubleFFT_3D.this.slices; s3 += nthreads) {
                            int idx3;
                            int idx2;
                            int idx1;
                            int r;
                            int idx0 = s3 * DoubleFFT_3D.this.sliceStride;
                            if (icr == 0) {
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    DoubleFFT_3D.this.fftColumns.complexInverse(a, idx0 + r * DoubleFFT_3D.this.rowStride, scale);
                                }
                            } else {
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    DoubleFFT_3D.this.fftColumns.realInverse2(a, idx0 + r * DoubleFFT_3D.this.rowStride, scale);
                                }
                            }
                            if (DoubleFFT_3D.this.columns > 4) {
                                for (int c = 0; c < DoubleFFT_3D.this.columns; c += 8) {
                                    int idx5;
                                    int idx4;
                                    int r3;
                                    for (r3 = 0; r3 < DoubleFFT_3D.this.rows; ++r3) {
                                        idx1 = idx0 + r3 * DoubleFFT_3D.this.rowStride + c;
                                        idx2 = 2 * r3;
                                        idx3 = 2 * DoubleFFT_3D.this.rows + 2 * r3;
                                        idx4 = idx3 + 2 * DoubleFFT_3D.this.rows;
                                        idx5 = idx4 + 2 * DoubleFFT_3D.this.rows;
                                        t2[idx2] = a[idx1];
                                        t2[idx2 + 1] = a[idx1 + 1];
                                        t2[idx3] = a[idx1 + 2];
                                        t2[idx3 + 1] = a[idx1 + 3];
                                        t2[idx4] = a[idx1 + 4];
                                        t2[idx4 + 1] = a[idx1 + 5];
                                        t2[idx5] = a[idx1 + 6];
                                        t2[idx5 + 1] = a[idx1 + 7];
                                    }
                                    DoubleFFT_3D.this.fftRows.complexInverse(t2, 0, scale);
                                    DoubleFFT_3D.this.fftRows.complexInverse(t2, 2 * DoubleFFT_3D.this.rows, scale);
                                    DoubleFFT_3D.this.fftRows.complexInverse(t2, 4 * DoubleFFT_3D.this.rows, scale);
                                    DoubleFFT_3D.this.fftRows.complexInverse(t2, 6 * DoubleFFT_3D.this.rows, scale);
                                    for (r3 = 0; r3 < DoubleFFT_3D.this.rows; ++r3) {
                                        idx1 = idx0 + r3 * DoubleFFT_3D.this.rowStride + c;
                                        idx2 = 2 * r3;
                                        idx3 = 2 * DoubleFFT_3D.this.rows + 2 * r3;
                                        idx4 = idx3 + 2 * DoubleFFT_3D.this.rows;
                                        idx5 = idx4 + 2 * DoubleFFT_3D.this.rows;
                                        a[idx1] = t2[idx2];
                                        a[idx1 + 1] = t2[idx2 + 1];
                                        a[idx1 + 2] = t2[idx3];
                                        a[idx1 + 3] = t2[idx3 + 1];
                                        a[idx1 + 4] = t2[idx4];
                                        a[idx1 + 5] = t2[idx4 + 1];
                                        a[idx1 + 6] = t2[idx5];
                                        a[idx1 + 7] = t2[idx5 + 1];
                                    }
                                }
                                continue;
                            }
                            if (DoubleFFT_3D.this.columns == 4) {
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    idx1 = idx0 + r * DoubleFFT_3D.this.rowStride;
                                    idx2 = 2 * r;
                                    idx3 = 2 * DoubleFFT_3D.this.rows + 2 * r;
                                    t2[idx2] = a[idx1];
                                    t2[idx2 + 1] = a[idx1 + 1];
                                    t2[idx3] = a[idx1 + 2];
                                    t2[idx3 + 1] = a[idx1 + 3];
                                }
                                DoubleFFT_3D.this.fftRows.complexInverse(t2, 0, scale);
                                DoubleFFT_3D.this.fftRows.complexInverse(t2, 2 * DoubleFFT_3D.this.rows, scale);
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    idx1 = idx0 + r * DoubleFFT_3D.this.rowStride;
                                    idx2 = 2 * r;
                                    idx3 = 2 * DoubleFFT_3D.this.rows + 2 * r;
                                    a[idx1] = t2[idx2];
                                    a[idx1 + 1] = t2[idx2 + 1];
                                    a[idx1 + 2] = t2[idx3];
                                    a[idx1 + 3] = t2[idx3 + 1];
                                }
                                continue;
                            }
                            if (DoubleFFT_3D.this.columns != 2) continue;
                            for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                idx1 = idx0 + r * DoubleFFT_3D.this.rowStride;
                                idx2 = 2 * r;
                                t2[idx2] = a[idx1];
                                t2[idx2 + 1] = a[idx1 + 1];
                            }
                            DoubleFFT_3D.this.fftRows.complexInverse(t2, 0, scale);
                            for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                idx1 = idx0 + r * DoubleFFT_3D.this.rowStride;
                                idx2 = 2 * r;
                                a[idx1] = t2[idx2];
                                a[idx1 + 1] = t2[idx2 + 1];
                            }
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void xdft3da_subth2(final long icr, final int isgn, final DoubleLargeArray a, final boolean scale) {
        final int nthreads = (int)FastMath.min((long)ConcurrencyUtils.getNumberOfThreads(), this.slicesl);
        long nt = this.slicesl;
        if (nt < this.rowsl) {
            nt = this.rowsl;
        }
        nt *= 8L;
        if (this.columnsl == 4L) {
            nt >>= 1;
        } else if (this.columnsl < 4L) {
            nt >>= 2;
        }
        final long ntf = nt;
        Future[] futures = new Future[nthreads];
        for (int i = 0; i < nthreads; ++i) {
            final long n0 = i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    DoubleLargeArray t2 = new DoubleLargeArray(ntf);
                    if (isgn == -1) {
                        for (long s2 = n0; s2 < DoubleFFT_3D.this.slicesl; s2 += (long)nthreads) {
                            long idx3;
                            long idx2;
                            long idx1;
                            long r;
                            long idx0 = s2 * DoubleFFT_3D.this.sliceStridel;
                            if (icr == 0L) {
                                for (r = 0L; r < DoubleFFT_3D.this.rowsl; ++r) {
                                    DoubleFFT_3D.this.fftColumns.complexForward(a, idx0 + r * DoubleFFT_3D.this.rowStridel);
                                }
                            } else {
                                for (r = 0L; r < DoubleFFT_3D.this.rowsl; ++r) {
                                    DoubleFFT_3D.this.fftColumns.realForward(a, idx0 + r * DoubleFFT_3D.this.rowStridel);
                                }
                            }
                            if (DoubleFFT_3D.this.columnsl > 4L) {
                                for (long c = 0L; c < DoubleFFT_3D.this.columnsl; c += 8L) {
                                    long idx5;
                                    long idx4;
                                    long r2;
                                    for (r2 = 0L; r2 < DoubleFFT_3D.this.rowsl; ++r2) {
                                        idx1 = idx0 + r2 * DoubleFFT_3D.this.rowStridel + c;
                                        idx2 = 2L * r2;
                                        idx3 = 2L * DoubleFFT_3D.this.rowsl + 2L * r2;
                                        idx4 = idx3 + 2L * DoubleFFT_3D.this.rowsl;
                                        idx5 = idx4 + 2L * DoubleFFT_3D.this.rowsl;
                                        t2.setDouble(idx2, a.getDouble(idx1));
                                        t2.setDouble(idx2 + 1L, a.getDouble(idx1 + 1L));
                                        t2.setDouble(idx3, a.getDouble(idx1 + 2L));
                                        t2.setDouble(idx3 + 1L, a.getDouble(idx1 + 3L));
                                        t2.setDouble(idx4, a.getDouble(idx1 + 4L));
                                        t2.setDouble(idx4 + 1L, a.getDouble(idx1 + 5L));
                                        t2.setDouble(idx5, a.getDouble(idx1 + 6L));
                                        t2.setDouble(idx5 + 1L, a.getDouble(idx1 + 7L));
                                    }
                                    DoubleFFT_3D.this.fftRows.complexForward(t2, 0L);
                                    DoubleFFT_3D.this.fftRows.complexForward(t2, 2L * DoubleFFT_3D.this.rowsl);
                                    DoubleFFT_3D.this.fftRows.complexForward(t2, 4L * DoubleFFT_3D.this.rowsl);
                                    DoubleFFT_3D.this.fftRows.complexForward(t2, 6L * DoubleFFT_3D.this.rowsl);
                                    for (r2 = 0L; r2 < DoubleFFT_3D.this.rowsl; ++r2) {
                                        idx1 = idx0 + r2 * DoubleFFT_3D.this.rowStridel + c;
                                        idx2 = 2L * r2;
                                        idx3 = 2L * DoubleFFT_3D.this.rowsl + 2L * r2;
                                        idx4 = idx3 + 2L * DoubleFFT_3D.this.rowsl;
                                        idx5 = idx4 + 2L * DoubleFFT_3D.this.rowsl;
                                        a.setDouble(idx1, t2.getDouble(idx2));
                                        a.setDouble(idx1 + 1L, t2.getDouble(idx2 + 1L));
                                        a.setDouble(idx1 + 2L, t2.getDouble(idx3));
                                        a.setDouble(idx1 + 3L, t2.getDouble(idx3 + 1L));
                                        a.setDouble(idx1 + 4L, t2.getDouble(idx4));
                                        a.setDouble(idx1 + 5L, t2.getDouble(idx4 + 1L));
                                        a.setDouble(idx1 + 6L, t2.getDouble(idx5));
                                        a.setDouble(idx1 + 7L, t2.getDouble(idx5 + 1L));
                                    }
                                }
                                continue;
                            }
                            if (DoubleFFT_3D.this.columnsl == 4L) {
                                for (r = 0L; r < DoubleFFT_3D.this.rowsl; ++r) {
                                    idx1 = idx0 + r * DoubleFFT_3D.this.rowStridel;
                                    idx2 = 2L * r;
                                    idx3 = 2L * DoubleFFT_3D.this.rowsl + 2L * r;
                                    t2.setDouble(idx2, a.getDouble(idx1));
                                    t2.setDouble(idx2 + 1L, a.getDouble(idx1 + 1L));
                                    t2.setDouble(idx3, a.getDouble(idx1 + 2L));
                                    t2.setDouble(idx3 + 1L, a.getDouble(idx1 + 3L));
                                }
                                DoubleFFT_3D.this.fftRows.complexForward(t2, 0L);
                                DoubleFFT_3D.this.fftRows.complexForward(t2, 2L * DoubleFFT_3D.this.rowsl);
                                for (r = 0L; r < DoubleFFT_3D.this.rowsl; ++r) {
                                    idx1 = idx0 + r * DoubleFFT_3D.this.rowStridel;
                                    idx2 = 2L * r;
                                    idx3 = 2L * DoubleFFT_3D.this.rowsl + 2L * r;
                                    a.setDouble(idx1, t2.getDouble(idx2));
                                    a.setDouble(idx1 + 1L, t2.getDouble(idx2 + 1L));
                                    a.setDouble(idx1 + 2L, t2.getDouble(idx3));
                                    a.setDouble(idx1 + 3L, t2.getDouble(idx3 + 1L));
                                }
                                continue;
                            }
                            if (DoubleFFT_3D.this.columnsl != 2L) continue;
                            for (r = 0L; r < DoubleFFT_3D.this.rowsl; ++r) {
                                idx1 = idx0 + r * DoubleFFT_3D.this.rowStridel;
                                idx2 = 2L * r;
                                t2.setDouble(idx2, a.getDouble(idx1));
                                t2.setDouble(idx2 + 1L, a.getDouble(idx1 + 1L));
                            }
                            DoubleFFT_3D.this.fftRows.complexForward(t2, 0L);
                            for (r = 0L; r < DoubleFFT_3D.this.rowsl; ++r) {
                                idx1 = idx0 + r * DoubleFFT_3D.this.rowStridel;
                                idx2 = 2L * r;
                                a.setDouble(idx1, t2.getDouble(idx2));
                                a.setDouble(idx1 + 1L, t2.getDouble(idx2 + 1L));
                            }
                        }
                    } else {
                        for (long s3 = n0; s3 < DoubleFFT_3D.this.slicesl; s3 += (long)nthreads) {
                            long idx3;
                            long idx2;
                            long idx1;
                            long r;
                            long idx0 = s3 * DoubleFFT_3D.this.sliceStridel;
                            if (icr == 0L) {
                                for (r = 0L; r < DoubleFFT_3D.this.rowsl; ++r) {
                                    DoubleFFT_3D.this.fftColumns.complexInverse(a, idx0 + r * DoubleFFT_3D.this.rowStridel, scale);
                                }
                            } else {
                                for (r = 0L; r < DoubleFFT_3D.this.rowsl; ++r) {
                                    DoubleFFT_3D.this.fftColumns.realInverse2(a, idx0 + r * DoubleFFT_3D.this.rowStridel, scale);
                                }
                            }
                            if (DoubleFFT_3D.this.columnsl > 4L) {
                                for (long c = 0L; c < DoubleFFT_3D.this.columnsl; c += 8L) {
                                    long idx5;
                                    long idx4;
                                    long r3;
                                    for (r3 = 0L; r3 < DoubleFFT_3D.this.rowsl; ++r3) {
                                        idx1 = idx0 + r3 * DoubleFFT_3D.this.rowStridel + c;
                                        idx2 = 2L * r3;
                                        idx3 = 2L * DoubleFFT_3D.this.rowsl + 2L * r3;
                                        idx4 = idx3 + 2L * DoubleFFT_3D.this.rowsl;
                                        idx5 = idx4 + 2L * DoubleFFT_3D.this.rowsl;
                                        t2.setDouble(idx2, a.getDouble(idx1));
                                        t2.setDouble(idx2 + 1L, a.getDouble(idx1 + 1L));
                                        t2.setDouble(idx3, a.getDouble(idx1 + 2L));
                                        t2.setDouble(idx3 + 1L, a.getDouble(idx1 + 3L));
                                        t2.setDouble(idx4, a.getDouble(idx1 + 4L));
                                        t2.setDouble(idx4 + 1L, a.getDouble(idx1 + 5L));
                                        t2.setDouble(idx5, a.getDouble(idx1 + 6L));
                                        t2.setDouble(idx5 + 1L, a.getDouble(idx1 + 7L));
                                    }
                                    DoubleFFT_3D.this.fftRows.complexInverse(t2, 0L, scale);
                                    DoubleFFT_3D.this.fftRows.complexInverse(t2, 2L * DoubleFFT_3D.this.rowsl, scale);
                                    DoubleFFT_3D.this.fftRows.complexInverse(t2, 4L * DoubleFFT_3D.this.rowsl, scale);
                                    DoubleFFT_3D.this.fftRows.complexInverse(t2, 6L * DoubleFFT_3D.this.rowsl, scale);
                                    for (r3 = 0L; r3 < DoubleFFT_3D.this.rowsl; ++r3) {
                                        idx1 = idx0 + r3 * DoubleFFT_3D.this.rowStridel + c;
                                        idx2 = 2L * r3;
                                        idx3 = 2L * DoubleFFT_3D.this.rowsl + 2L * r3;
                                        idx4 = idx3 + 2L * DoubleFFT_3D.this.rowsl;
                                        idx5 = idx4 + 2L * DoubleFFT_3D.this.rowsl;
                                        a.setDouble(idx1, t2.getDouble(idx2));
                                        a.setDouble(idx1 + 1L, t2.getDouble(idx2 + 1L));
                                        a.setDouble(idx1 + 2L, t2.getDouble(idx3));
                                        a.setDouble(idx1 + 3L, t2.getDouble(idx3 + 1L));
                                        a.setDouble(idx1 + 4L, t2.getDouble(idx4));
                                        a.setDouble(idx1 + 5L, t2.getDouble(idx4 + 1L));
                                        a.setDouble(idx1 + 6L, t2.getDouble(idx5));
                                        a.setDouble(idx1 + 7L, t2.getDouble(idx5 + 1L));
                                    }
                                }
                                continue;
                            }
                            if (DoubleFFT_3D.this.columnsl == 4L) {
                                for (r = 0L; r < DoubleFFT_3D.this.rowsl; ++r) {
                                    idx1 = idx0 + r * DoubleFFT_3D.this.rowStridel;
                                    idx2 = 2L * r;
                                    idx3 = 2L * DoubleFFT_3D.this.rowsl + 2L * r;
                                    t2.setDouble(idx2, a.getDouble(idx1));
                                    t2.setDouble(idx2 + 1L, a.getDouble(idx1 + 1L));
                                    t2.setDouble(idx3, a.getDouble(idx1 + 2L));
                                    t2.setDouble(idx3 + 1L, a.getDouble(idx1 + 3L));
                                }
                                DoubleFFT_3D.this.fftRows.complexInverse(t2, 0L, scale);
                                DoubleFFT_3D.this.fftRows.complexInverse(t2, 2L * DoubleFFT_3D.this.rowsl, scale);
                                for (r = 0L; r < DoubleFFT_3D.this.rowsl; ++r) {
                                    idx1 = idx0 + r * DoubleFFT_3D.this.rowStridel;
                                    idx2 = 2L * r;
                                    idx3 = 2L * DoubleFFT_3D.this.rowsl + 2L * r;
                                    a.setDouble(idx1, t2.getDouble(idx2));
                                    a.setDouble(idx1 + 1L, t2.getDouble(idx2 + 1L));
                                    a.setDouble(idx1 + 2L, t2.getDouble(idx3));
                                    a.setDouble(idx1 + 3L, t2.getDouble(idx3 + 1L));
                                }
                                continue;
                            }
                            if (DoubleFFT_3D.this.columnsl != 2L) continue;
                            for (r = 0L; r < DoubleFFT_3D.this.rowsl; ++r) {
                                idx1 = idx0 + r * DoubleFFT_3D.this.rowStridel;
                                idx2 = 2L * r;
                                t2.setDouble(idx2, a.getDouble(idx1));
                                t2.setDouble(idx2 + 1L, a.getDouble(idx1 + 1L));
                            }
                            DoubleFFT_3D.this.fftRows.complexInverse(t2, 0L, scale);
                            for (r = 0L; r < DoubleFFT_3D.this.rowsl; ++r) {
                                idx1 = idx0 + r * DoubleFFT_3D.this.rowStridel;
                                idx2 = 2L * r;
                                a.setDouble(idx1, t2.getDouble(idx2));
                                a.setDouble(idx1 + 1L, t2.getDouble(idx2 + 1L));
                            }
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void xdft3da_subth1(final int icr, final int isgn, final double[][][] a, final boolean scale) {
        final int nthreads = FastMath.min(ConcurrencyUtils.getNumberOfThreads(), this.slices);
        int nt = this.slices;
        if (nt < this.rows) {
            nt = this.rows;
        }
        nt *= 8;
        if (this.columns == 4) {
            nt >>= 1;
        } else if (this.columns < 4) {
            nt >>= 2;
        }
        final int ntf = nt;
        Future[] futures = new Future[nthreads];
        for (int i = 0; i < nthreads; ++i) {
            final int n0 = i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    double[] t2 = new double[ntf];
                    if (isgn == -1) {
                        for (int s2 = n0; s2 < DoubleFFT_3D.this.slices; s2 += nthreads) {
                            int idx3;
                            int idx2;
                            int r;
                            if (icr == 0) {
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    DoubleFFT_3D.this.fftColumns.complexForward(a[s2][r]);
                                }
                            } else {
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    DoubleFFT_3D.this.fftColumns.realForward(a[s2][r], 0);
                                }
                            }
                            if (DoubleFFT_3D.this.columns > 4) {
                                for (int c = 0; c < DoubleFFT_3D.this.columns; c += 8) {
                                    int idx5;
                                    int idx4;
                                    int r2;
                                    for (r2 = 0; r2 < DoubleFFT_3D.this.rows; ++r2) {
                                        idx2 = 2 * r2;
                                        idx3 = 2 * DoubleFFT_3D.this.rows + 2 * r2;
                                        idx4 = idx3 + 2 * DoubleFFT_3D.this.rows;
                                        idx5 = idx4 + 2 * DoubleFFT_3D.this.rows;
                                        t2[idx2] = a[s2][r2][c];
                                        t2[idx2 + 1] = a[s2][r2][c + 1];
                                        t2[idx3] = a[s2][r2][c + 2];
                                        t2[idx3 + 1] = a[s2][r2][c + 3];
                                        t2[idx4] = a[s2][r2][c + 4];
                                        t2[idx4 + 1] = a[s2][r2][c + 5];
                                        t2[idx5] = a[s2][r2][c + 6];
                                        t2[idx5 + 1] = a[s2][r2][c + 7];
                                    }
                                    DoubleFFT_3D.this.fftRows.complexForward(t2, 0);
                                    DoubleFFT_3D.this.fftRows.complexForward(t2, 2 * DoubleFFT_3D.this.rows);
                                    DoubleFFT_3D.this.fftRows.complexForward(t2, 4 * DoubleFFT_3D.this.rows);
                                    DoubleFFT_3D.this.fftRows.complexForward(t2, 6 * DoubleFFT_3D.this.rows);
                                    for (r2 = 0; r2 < DoubleFFT_3D.this.rows; ++r2) {
                                        idx2 = 2 * r2;
                                        idx3 = 2 * DoubleFFT_3D.this.rows + 2 * r2;
                                        idx4 = idx3 + 2 * DoubleFFT_3D.this.rows;
                                        idx5 = idx4 + 2 * DoubleFFT_3D.this.rows;
                                        a[s2][r2][c] = t2[idx2];
                                        a[s2][r2][c + 1] = t2[idx2 + 1];
                                        a[s2][r2][c + 2] = t2[idx3];
                                        a[s2][r2][c + 3] = t2[idx3 + 1];
                                        a[s2][r2][c + 4] = t2[idx4];
                                        a[s2][r2][c + 5] = t2[idx4 + 1];
                                        a[s2][r2][c + 6] = t2[idx5];
                                        a[s2][r2][c + 7] = t2[idx5 + 1];
                                    }
                                }
                                continue;
                            }
                            if (DoubleFFT_3D.this.columns == 4) {
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    idx2 = 2 * r;
                                    idx3 = 2 * DoubleFFT_3D.this.rows + 2 * r;
                                    t2[idx2] = a[s2][r][0];
                                    t2[idx2 + 1] = a[s2][r][1];
                                    t2[idx3] = a[s2][r][2];
                                    t2[idx3 + 1] = a[s2][r][3];
                                }
                                DoubleFFT_3D.this.fftRows.complexForward(t2, 0);
                                DoubleFFT_3D.this.fftRows.complexForward(t2, 2 * DoubleFFT_3D.this.rows);
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    idx2 = 2 * r;
                                    idx3 = 2 * DoubleFFT_3D.this.rows + 2 * r;
                                    a[s2][r][0] = t2[idx2];
                                    a[s2][r][1] = t2[idx2 + 1];
                                    a[s2][r][2] = t2[idx3];
                                    a[s2][r][3] = t2[idx3 + 1];
                                }
                                continue;
                            }
                            if (DoubleFFT_3D.this.columns != 2) continue;
                            for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                idx2 = 2 * r;
                                t2[idx2] = a[s2][r][0];
                                t2[idx2 + 1] = a[s2][r][1];
                            }
                            DoubleFFT_3D.this.fftRows.complexForward(t2, 0);
                            for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                idx2 = 2 * r;
                                a[s2][r][0] = t2[idx2];
                                a[s2][r][1] = t2[idx2 + 1];
                            }
                        }
                    } else {
                        for (int s3 = n0; s3 < DoubleFFT_3D.this.slices; s3 += nthreads) {
                            int idx3;
                            int idx2;
                            int r;
                            if (icr == 0) {
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    DoubleFFT_3D.this.fftColumns.complexInverse(a[s3][r], scale);
                                }
                            }
                            if (DoubleFFT_3D.this.columns > 4) {
                                for (int c = 0; c < DoubleFFT_3D.this.columns; c += 8) {
                                    int idx5;
                                    int idx4;
                                    int r3;
                                    for (r3 = 0; r3 < DoubleFFT_3D.this.rows; ++r3) {
                                        idx2 = 2 * r3;
                                        idx3 = 2 * DoubleFFT_3D.this.rows + 2 * r3;
                                        idx4 = idx3 + 2 * DoubleFFT_3D.this.rows;
                                        idx5 = idx4 + 2 * DoubleFFT_3D.this.rows;
                                        t2[idx2] = a[s3][r3][c];
                                        t2[idx2 + 1] = a[s3][r3][c + 1];
                                        t2[idx3] = a[s3][r3][c + 2];
                                        t2[idx3 + 1] = a[s3][r3][c + 3];
                                        t2[idx4] = a[s3][r3][c + 4];
                                        t2[idx4 + 1] = a[s3][r3][c + 5];
                                        t2[idx5] = a[s3][r3][c + 6];
                                        t2[idx5 + 1] = a[s3][r3][c + 7];
                                    }
                                    DoubleFFT_3D.this.fftRows.complexInverse(t2, 0, scale);
                                    DoubleFFT_3D.this.fftRows.complexInverse(t2, 2 * DoubleFFT_3D.this.rows, scale);
                                    DoubleFFT_3D.this.fftRows.complexInverse(t2, 4 * DoubleFFT_3D.this.rows, scale);
                                    DoubleFFT_3D.this.fftRows.complexInverse(t2, 6 * DoubleFFT_3D.this.rows, scale);
                                    for (r3 = 0; r3 < DoubleFFT_3D.this.rows; ++r3) {
                                        idx2 = 2 * r3;
                                        idx3 = 2 * DoubleFFT_3D.this.rows + 2 * r3;
                                        idx4 = idx3 + 2 * DoubleFFT_3D.this.rows;
                                        idx5 = idx4 + 2 * DoubleFFT_3D.this.rows;
                                        a[s3][r3][c] = t2[idx2];
                                        a[s3][r3][c + 1] = t2[idx2 + 1];
                                        a[s3][r3][c + 2] = t2[idx3];
                                        a[s3][r3][c + 3] = t2[idx3 + 1];
                                        a[s3][r3][c + 4] = t2[idx4];
                                        a[s3][r3][c + 5] = t2[idx4 + 1];
                                        a[s3][r3][c + 6] = t2[idx5];
                                        a[s3][r3][c + 7] = t2[idx5 + 1];
                                    }
                                }
                            } else if (DoubleFFT_3D.this.columns == 4) {
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    idx2 = 2 * r;
                                    idx3 = 2 * DoubleFFT_3D.this.rows + 2 * r;
                                    t2[idx2] = a[s3][r][0];
                                    t2[idx2 + 1] = a[s3][r][1];
                                    t2[idx3] = a[s3][r][2];
                                    t2[idx3 + 1] = a[s3][r][3];
                                }
                                DoubleFFT_3D.this.fftRows.complexInverse(t2, 0, scale);
                                DoubleFFT_3D.this.fftRows.complexInverse(t2, 2 * DoubleFFT_3D.this.rows, scale);
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    idx2 = 2 * r;
                                    idx3 = 2 * DoubleFFT_3D.this.rows + 2 * r;
                                    a[s3][r][0] = t2[idx2];
                                    a[s3][r][1] = t2[idx2 + 1];
                                    a[s3][r][2] = t2[idx3];
                                    a[s3][r][3] = t2[idx3 + 1];
                                }
                            } else if (DoubleFFT_3D.this.columns == 2) {
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    idx2 = 2 * r;
                                    t2[idx2] = a[s3][r][0];
                                    t2[idx2 + 1] = a[s3][r][1];
                                }
                                DoubleFFT_3D.this.fftRows.complexInverse(t2, 0, scale);
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    idx2 = 2 * r;
                                    a[s3][r][0] = t2[idx2];
                                    a[s3][r][1] = t2[idx2 + 1];
                                }
                            }
                            if (icr == 0) continue;
                            for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                DoubleFFT_3D.this.fftColumns.realInverse(a[s3][r], scale);
                            }
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void xdft3da_subth2(final int icr, final int isgn, final double[][][] a, final boolean scale) {
        final int nthreads = FastMath.min(ConcurrencyUtils.getNumberOfThreads(), this.slices);
        int nt = this.slices;
        if (nt < this.rows) {
            nt = this.rows;
        }
        nt *= 8;
        if (this.columns == 4) {
            nt >>= 1;
        } else if (this.columns < 4) {
            nt >>= 2;
        }
        final int ntf = nt;
        Future[] futures = new Future[nthreads];
        for (int i = 0; i < nthreads; ++i) {
            final int n0 = i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    double[] t2 = new double[ntf];
                    if (isgn == -1) {
                        for (int s2 = n0; s2 < DoubleFFT_3D.this.slices; s2 += nthreads) {
                            int idx3;
                            int idx2;
                            int r;
                            if (icr == 0) {
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    DoubleFFT_3D.this.fftColumns.complexForward(a[s2][r]);
                                }
                            } else {
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    DoubleFFT_3D.this.fftColumns.realForward(a[s2][r]);
                                }
                            }
                            if (DoubleFFT_3D.this.columns > 4) {
                                for (int c = 0; c < DoubleFFT_3D.this.columns; c += 8) {
                                    int idx5;
                                    int idx4;
                                    int r2;
                                    for (r2 = 0; r2 < DoubleFFT_3D.this.rows; ++r2) {
                                        idx2 = 2 * r2;
                                        idx3 = 2 * DoubleFFT_3D.this.rows + 2 * r2;
                                        idx4 = idx3 + 2 * DoubleFFT_3D.this.rows;
                                        idx5 = idx4 + 2 * DoubleFFT_3D.this.rows;
                                        t2[idx2] = a[s2][r2][c];
                                        t2[idx2 + 1] = a[s2][r2][c + 1];
                                        t2[idx3] = a[s2][r2][c + 2];
                                        t2[idx3 + 1] = a[s2][r2][c + 3];
                                        t2[idx4] = a[s2][r2][c + 4];
                                        t2[idx4 + 1] = a[s2][r2][c + 5];
                                        t2[idx5] = a[s2][r2][c + 6];
                                        t2[idx5 + 1] = a[s2][r2][c + 7];
                                    }
                                    DoubleFFT_3D.this.fftRows.complexForward(t2, 0);
                                    DoubleFFT_3D.this.fftRows.complexForward(t2, 2 * DoubleFFT_3D.this.rows);
                                    DoubleFFT_3D.this.fftRows.complexForward(t2, 4 * DoubleFFT_3D.this.rows);
                                    DoubleFFT_3D.this.fftRows.complexForward(t2, 6 * DoubleFFT_3D.this.rows);
                                    for (r2 = 0; r2 < DoubleFFT_3D.this.rows; ++r2) {
                                        idx2 = 2 * r2;
                                        idx3 = 2 * DoubleFFT_3D.this.rows + 2 * r2;
                                        idx4 = idx3 + 2 * DoubleFFT_3D.this.rows;
                                        idx5 = idx4 + 2 * DoubleFFT_3D.this.rows;
                                        a[s2][r2][c] = t2[idx2];
                                        a[s2][r2][c + 1] = t2[idx2 + 1];
                                        a[s2][r2][c + 2] = t2[idx3];
                                        a[s2][r2][c + 3] = t2[idx3 + 1];
                                        a[s2][r2][c + 4] = t2[idx4];
                                        a[s2][r2][c + 5] = t2[idx4 + 1];
                                        a[s2][r2][c + 6] = t2[idx5];
                                        a[s2][r2][c + 7] = t2[idx5 + 1];
                                    }
                                }
                                continue;
                            }
                            if (DoubleFFT_3D.this.columns == 4) {
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    idx2 = 2 * r;
                                    idx3 = 2 * DoubleFFT_3D.this.rows + 2 * r;
                                    t2[idx2] = a[s2][r][0];
                                    t2[idx2 + 1] = a[s2][r][1];
                                    t2[idx3] = a[s2][r][2];
                                    t2[idx3 + 1] = a[s2][r][3];
                                }
                                DoubleFFT_3D.this.fftRows.complexForward(t2, 0);
                                DoubleFFT_3D.this.fftRows.complexForward(t2, 2 * DoubleFFT_3D.this.rows);
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    idx2 = 2 * r;
                                    idx3 = 2 * DoubleFFT_3D.this.rows + 2 * r;
                                    a[s2][r][0] = t2[idx2];
                                    a[s2][r][1] = t2[idx2 + 1];
                                    a[s2][r][2] = t2[idx3];
                                    a[s2][r][3] = t2[idx3 + 1];
                                }
                                continue;
                            }
                            if (DoubleFFT_3D.this.columns != 2) continue;
                            for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                idx2 = 2 * r;
                                t2[idx2] = a[s2][r][0];
                                t2[idx2 + 1] = a[s2][r][1];
                            }
                            DoubleFFT_3D.this.fftRows.complexForward(t2, 0);
                            for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                idx2 = 2 * r;
                                a[s2][r][0] = t2[idx2];
                                a[s2][r][1] = t2[idx2 + 1];
                            }
                        }
                    } else {
                        for (int s3 = n0; s3 < DoubleFFT_3D.this.slices; s3 += nthreads) {
                            int idx3;
                            int idx2;
                            int r;
                            if (icr == 0) {
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    DoubleFFT_3D.this.fftColumns.complexInverse(a[s3][r], scale);
                                }
                            } else {
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    DoubleFFT_3D.this.fftColumns.realInverse2(a[s3][r], 0, scale);
                                }
                            }
                            if (DoubleFFT_3D.this.columns > 4) {
                                for (int c = 0; c < DoubleFFT_3D.this.columns; c += 8) {
                                    int idx5;
                                    int idx4;
                                    int r3;
                                    for (r3 = 0; r3 < DoubleFFT_3D.this.rows; ++r3) {
                                        idx2 = 2 * r3;
                                        idx3 = 2 * DoubleFFT_3D.this.rows + 2 * r3;
                                        idx4 = idx3 + 2 * DoubleFFT_3D.this.rows;
                                        idx5 = idx4 + 2 * DoubleFFT_3D.this.rows;
                                        t2[idx2] = a[s3][r3][c];
                                        t2[idx2 + 1] = a[s3][r3][c + 1];
                                        t2[idx3] = a[s3][r3][c + 2];
                                        t2[idx3 + 1] = a[s3][r3][c + 3];
                                        t2[idx4] = a[s3][r3][c + 4];
                                        t2[idx4 + 1] = a[s3][r3][c + 5];
                                        t2[idx5] = a[s3][r3][c + 6];
                                        t2[idx5 + 1] = a[s3][r3][c + 7];
                                    }
                                    DoubleFFT_3D.this.fftRows.complexInverse(t2, 0, scale);
                                    DoubleFFT_3D.this.fftRows.complexInverse(t2, 2 * DoubleFFT_3D.this.rows, scale);
                                    DoubleFFT_3D.this.fftRows.complexInverse(t2, 4 * DoubleFFT_3D.this.rows, scale);
                                    DoubleFFT_3D.this.fftRows.complexInverse(t2, 6 * DoubleFFT_3D.this.rows, scale);
                                    for (r3 = 0; r3 < DoubleFFT_3D.this.rows; ++r3) {
                                        idx2 = 2 * r3;
                                        idx3 = 2 * DoubleFFT_3D.this.rows + 2 * r3;
                                        idx4 = idx3 + 2 * DoubleFFT_3D.this.rows;
                                        idx5 = idx4 + 2 * DoubleFFT_3D.this.rows;
                                        a[s3][r3][c] = t2[idx2];
                                        a[s3][r3][c + 1] = t2[idx2 + 1];
                                        a[s3][r3][c + 2] = t2[idx3];
                                        a[s3][r3][c + 3] = t2[idx3 + 1];
                                        a[s3][r3][c + 4] = t2[idx4];
                                        a[s3][r3][c + 5] = t2[idx4 + 1];
                                        a[s3][r3][c + 6] = t2[idx5];
                                        a[s3][r3][c + 7] = t2[idx5 + 1];
                                    }
                                }
                                continue;
                            }
                            if (DoubleFFT_3D.this.columns == 4) {
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    idx2 = 2 * r;
                                    idx3 = 2 * DoubleFFT_3D.this.rows + 2 * r;
                                    t2[idx2] = a[s3][r][0];
                                    t2[idx2 + 1] = a[s3][r][1];
                                    t2[idx3] = a[s3][r][2];
                                    t2[idx3 + 1] = a[s3][r][3];
                                }
                                DoubleFFT_3D.this.fftRows.complexInverse(t2, 0, scale);
                                DoubleFFT_3D.this.fftRows.complexInverse(t2, 2 * DoubleFFT_3D.this.rows, scale);
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    idx2 = 2 * r;
                                    idx3 = 2 * DoubleFFT_3D.this.rows + 2 * r;
                                    a[s3][r][0] = t2[idx2];
                                    a[s3][r][1] = t2[idx2 + 1];
                                    a[s3][r][2] = t2[idx3];
                                    a[s3][r][3] = t2[idx3 + 1];
                                }
                                continue;
                            }
                            if (DoubleFFT_3D.this.columns != 2) continue;
                            for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                idx2 = 2 * r;
                                t2[idx2] = a[s3][r][0];
                                t2[idx2 + 1] = a[s3][r][1];
                            }
                            DoubleFFT_3D.this.fftRows.complexInverse(t2, 0, scale);
                            for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                idx2 = 2 * r;
                                a[s3][r][0] = t2[idx2];
                                a[s3][r][1] = t2[idx2 + 1];
                            }
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void cdft3db_subth(final int isgn, final double[] a, final boolean scale) {
        final int nthreads = FastMath.min(ConcurrencyUtils.getNumberOfThreads(), this.rows);
        int nt = this.slices;
        if (nt < this.rows) {
            nt = this.rows;
        }
        nt *= 8;
        if (this.columns == 4) {
            nt >>= 1;
        } else if (this.columns < 4) {
            nt >>= 2;
        }
        final int ntf = nt;
        Future[] futures = new Future[nthreads];
        for (int i = 0; i < nthreads; ++i) {
            final int n0 = i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block27: {
                        double[] t2;
                        block25: {
                            block28: {
                                block26: {
                                    t2 = new double[ntf];
                                    if (isgn != -1) break block25;
                                    if (DoubleFFT_3D.this.columns <= 4) break block26;
                                    for (int r = n0; r < DoubleFFT_3D.this.rows; r += nthreads) {
                                        int idx0 = r * DoubleFFT_3D.this.rowStride;
                                        for (int c = 0; c < DoubleFFT_3D.this.columns; c += 8) {
                                            int idx5;
                                            int idx4;
                                            int idx3;
                                            int idx2;
                                            int idx1;
                                            int s2;
                                            for (s2 = 0; s2 < DoubleFFT_3D.this.slices; ++s2) {
                                                idx1 = s2 * DoubleFFT_3D.this.sliceStride + idx0 + c;
                                                idx2 = 2 * s2;
                                                idx3 = 2 * DoubleFFT_3D.this.slices + 2 * s2;
                                                idx4 = idx3 + 2 * DoubleFFT_3D.this.slices;
                                                idx5 = idx4 + 2 * DoubleFFT_3D.this.slices;
                                                t2[idx2] = a[idx1];
                                                t2[idx2 + 1] = a[idx1 + 1];
                                                t2[idx3] = a[idx1 + 2];
                                                t2[idx3 + 1] = a[idx1 + 3];
                                                t2[idx4] = a[idx1 + 4];
                                                t2[idx4 + 1] = a[idx1 + 5];
                                                t2[idx5] = a[idx1 + 6];
                                                t2[idx5 + 1] = a[idx1 + 7];
                                            }
                                            DoubleFFT_3D.this.fftSlices.complexForward(t2, 0);
                                            DoubleFFT_3D.this.fftSlices.complexForward(t2, 2 * DoubleFFT_3D.this.slices);
                                            DoubleFFT_3D.this.fftSlices.complexForward(t2, 4 * DoubleFFT_3D.this.slices);
                                            DoubleFFT_3D.this.fftSlices.complexForward(t2, 6 * DoubleFFT_3D.this.slices);
                                            for (s2 = 0; s2 < DoubleFFT_3D.this.slices; ++s2) {
                                                idx1 = s2 * DoubleFFT_3D.this.sliceStride + idx0 + c;
                                                idx2 = 2 * s2;
                                                idx3 = 2 * DoubleFFT_3D.this.slices + 2 * s2;
                                                idx4 = idx3 + 2 * DoubleFFT_3D.this.slices;
                                                idx5 = idx4 + 2 * DoubleFFT_3D.this.slices;
                                                a[idx1] = t2[idx2];
                                                a[idx1 + 1] = t2[idx2 + 1];
                                                a[idx1 + 2] = t2[idx3];
                                                a[idx1 + 3] = t2[idx3 + 1];
                                                a[idx1 + 4] = t2[idx4];
                                                a[idx1 + 5] = t2[idx4 + 1];
                                                a[idx1 + 6] = t2[idx5];
                                                a[idx1 + 7] = t2[idx5 + 1];
                                            }
                                        }
                                    }
                                    break block27;
                                }
                                if (DoubleFFT_3D.this.columns != 4) break block28;
                                for (int r = n0; r < DoubleFFT_3D.this.rows; r += nthreads) {
                                    int idx3;
                                    int idx2;
                                    int idx1;
                                    int s3;
                                    int idx0 = r * DoubleFFT_3D.this.rowStride;
                                    for (s3 = 0; s3 < DoubleFFT_3D.this.slices; ++s3) {
                                        idx1 = s3 * DoubleFFT_3D.this.sliceStride + idx0;
                                        idx2 = 2 * s3;
                                        idx3 = 2 * DoubleFFT_3D.this.slices + 2 * s3;
                                        t2[idx2] = a[idx1];
                                        t2[idx2 + 1] = a[idx1 + 1];
                                        t2[idx3] = a[idx1 + 2];
                                        t2[idx3 + 1] = a[idx1 + 3];
                                    }
                                    DoubleFFT_3D.this.fftSlices.complexForward(t2, 0);
                                    DoubleFFT_3D.this.fftSlices.complexForward(t2, 2 * DoubleFFT_3D.this.slices);
                                    for (s3 = 0; s3 < DoubleFFT_3D.this.slices; ++s3) {
                                        idx1 = s3 * DoubleFFT_3D.this.sliceStride + idx0;
                                        idx2 = 2 * s3;
                                        idx3 = 2 * DoubleFFT_3D.this.slices + 2 * s3;
                                        a[idx1] = t2[idx2];
                                        a[idx1 + 1] = t2[idx2 + 1];
                                        a[idx1 + 2] = t2[idx3];
                                        a[idx1 + 3] = t2[idx3 + 1];
                                    }
                                }
                                break block27;
                            }
                            if (DoubleFFT_3D.this.columns != 2) break block27;
                            for (int r = n0; r < DoubleFFT_3D.this.rows; r += nthreads) {
                                int idx2;
                                int idx1;
                                int s4;
                                int idx0 = r * DoubleFFT_3D.this.rowStride;
                                for (s4 = 0; s4 < DoubleFFT_3D.this.slices; ++s4) {
                                    idx1 = s4 * DoubleFFT_3D.this.sliceStride + idx0;
                                    idx2 = 2 * s4;
                                    t2[idx2] = a[idx1];
                                    t2[idx2 + 1] = a[idx1 + 1];
                                }
                                DoubleFFT_3D.this.fftSlices.complexForward(t2, 0);
                                for (s4 = 0; s4 < DoubleFFT_3D.this.slices; ++s4) {
                                    idx1 = s4 * DoubleFFT_3D.this.sliceStride + idx0;
                                    idx2 = 2 * s4;
                                    a[idx1] = t2[idx2];
                                    a[idx1 + 1] = t2[idx2 + 1];
                                }
                            }
                            break block27;
                        }
                        if (DoubleFFT_3D.this.columns > 4) {
                            for (int r = n0; r < DoubleFFT_3D.this.rows; r += nthreads) {
                                int idx0 = r * DoubleFFT_3D.this.rowStride;
                                for (int c = 0; c < DoubleFFT_3D.this.columns; c += 8) {
                                    int idx5;
                                    int idx4;
                                    int idx3;
                                    int idx2;
                                    int idx1;
                                    int s5;
                                    for (s5 = 0; s5 < DoubleFFT_3D.this.slices; ++s5) {
                                        idx1 = s5 * DoubleFFT_3D.this.sliceStride + idx0 + c;
                                        idx2 = 2 * s5;
                                        idx3 = 2 * DoubleFFT_3D.this.slices + 2 * s5;
                                        idx4 = idx3 + 2 * DoubleFFT_3D.this.slices;
                                        idx5 = idx4 + 2 * DoubleFFT_3D.this.slices;
                                        t2[idx2] = a[idx1];
                                        t2[idx2 + 1] = a[idx1 + 1];
                                        t2[idx3] = a[idx1 + 2];
                                        t2[idx3 + 1] = a[idx1 + 3];
                                        t2[idx4] = a[idx1 + 4];
                                        t2[idx4 + 1] = a[idx1 + 5];
                                        t2[idx5] = a[idx1 + 6];
                                        t2[idx5 + 1] = a[idx1 + 7];
                                    }
                                    DoubleFFT_3D.this.fftSlices.complexInverse(t2, 0, scale);
                                    DoubleFFT_3D.this.fftSlices.complexInverse(t2, 2 * DoubleFFT_3D.this.slices, scale);
                                    DoubleFFT_3D.this.fftSlices.complexInverse(t2, 4 * DoubleFFT_3D.this.slices, scale);
                                    DoubleFFT_3D.this.fftSlices.complexInverse(t2, 6 * DoubleFFT_3D.this.slices, scale);
                                    for (s5 = 0; s5 < DoubleFFT_3D.this.slices; ++s5) {
                                        idx1 = s5 * DoubleFFT_3D.this.sliceStride + idx0 + c;
                                        idx2 = 2 * s5;
                                        idx3 = 2 * DoubleFFT_3D.this.slices + 2 * s5;
                                        idx4 = idx3 + 2 * DoubleFFT_3D.this.slices;
                                        idx5 = idx4 + 2 * DoubleFFT_3D.this.slices;
                                        a[idx1] = t2[idx2];
                                        a[idx1 + 1] = t2[idx2 + 1];
                                        a[idx1 + 2] = t2[idx3];
                                        a[idx1 + 3] = t2[idx3 + 1];
                                        a[idx1 + 4] = t2[idx4];
                                        a[idx1 + 5] = t2[idx4 + 1];
                                        a[idx1 + 6] = t2[idx5];
                                        a[idx1 + 7] = t2[idx5 + 1];
                                    }
                                }
                            }
                        } else if (DoubleFFT_3D.this.columns == 4) {
                            for (int r = n0; r < DoubleFFT_3D.this.rows; r += nthreads) {
                                int idx3;
                                int idx2;
                                int idx1;
                                int s6;
                                int idx0 = r * DoubleFFT_3D.this.rowStride;
                                for (s6 = 0; s6 < DoubleFFT_3D.this.slices; ++s6) {
                                    idx1 = s6 * DoubleFFT_3D.this.sliceStride + idx0;
                                    idx2 = 2 * s6;
                                    idx3 = 2 * DoubleFFT_3D.this.slices + 2 * s6;
                                    t2[idx2] = a[idx1];
                                    t2[idx2 + 1] = a[idx1 + 1];
                                    t2[idx3] = a[idx1 + 2];
                                    t2[idx3 + 1] = a[idx1 + 3];
                                }
                                DoubleFFT_3D.this.fftSlices.complexInverse(t2, 0, scale);
                                DoubleFFT_3D.this.fftSlices.complexInverse(t2, 2 * DoubleFFT_3D.this.slices, scale);
                                for (s6 = 0; s6 < DoubleFFT_3D.this.slices; ++s6) {
                                    idx1 = s6 * DoubleFFT_3D.this.sliceStride + idx0;
                                    idx2 = 2 * s6;
                                    idx3 = 2 * DoubleFFT_3D.this.slices + 2 * s6;
                                    a[idx1] = t2[idx2];
                                    a[idx1 + 1] = t2[idx2 + 1];
                                    a[idx1 + 2] = t2[idx3];
                                    a[idx1 + 3] = t2[idx3 + 1];
                                }
                            }
                        } else if (DoubleFFT_3D.this.columns == 2) {
                            for (int r = n0; r < DoubleFFT_3D.this.rows; r += nthreads) {
                                int idx2;
                                int idx1;
                                int s7;
                                int idx0 = r * DoubleFFT_3D.this.rowStride;
                                for (s7 = 0; s7 < DoubleFFT_3D.this.slices; ++s7) {
                                    idx1 = s7 * DoubleFFT_3D.this.sliceStride + idx0;
                                    idx2 = 2 * s7;
                                    t2[idx2] = a[idx1];
                                    t2[idx2 + 1] = a[idx1 + 1];
                                }
                                DoubleFFT_3D.this.fftSlices.complexInverse(t2, 0, scale);
                                for (s7 = 0; s7 < DoubleFFT_3D.this.slices; ++s7) {
                                    idx1 = s7 * DoubleFFT_3D.this.sliceStride + idx0;
                                    idx2 = 2 * s7;
                                    a[idx1] = t2[idx2];
                                    a[idx1 + 1] = t2[idx2 + 1];
                                }
                            }
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void cdft3db_subth(final int isgn, final DoubleLargeArray a, final boolean scale) {
        final int nthreads = (int)FastMath.min((long)ConcurrencyUtils.getNumberOfThreads(), this.rowsl);
        long nt = this.slicesl;
        if (nt < this.rowsl) {
            nt = this.rowsl;
        }
        nt *= 8L;
        if (this.columnsl == 4L) {
            nt >>= 1;
        } else if (this.columnsl < 4L) {
            nt >>= 2;
        }
        final long ntf = nt;
        Future[] futures = new Future[nthreads];
        for (int i = 0; i < nthreads; ++i) {
            final long n0 = i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block27: {
                        DoubleLargeArray t2;
                        block25: {
                            block28: {
                                block26: {
                                    t2 = new DoubleLargeArray(ntf);
                                    if (isgn != -1) break block25;
                                    if (DoubleFFT_3D.this.columnsl <= 4L) break block26;
                                    for (long r = n0; r < DoubleFFT_3D.this.rowsl; r += (long)nthreads) {
                                        long idx0 = r * DoubleFFT_3D.this.rowStridel;
                                        for (long c = 0L; c < DoubleFFT_3D.this.columnsl; c += 8L) {
                                            long idx5;
                                            long idx4;
                                            long idx3;
                                            long idx2;
                                            long idx1;
                                            long s2;
                                            for (s2 = 0L; s2 < DoubleFFT_3D.this.slicesl; ++s2) {
                                                idx1 = s2 * DoubleFFT_3D.this.sliceStridel + idx0 + c;
                                                idx2 = 2L * s2;
                                                idx3 = 2L * DoubleFFT_3D.this.slicesl + 2L * s2;
                                                idx4 = idx3 + 2L * DoubleFFT_3D.this.slicesl;
                                                idx5 = idx4 + 2L * DoubleFFT_3D.this.slicesl;
                                                t2.setDouble(idx2, a.getDouble(idx1));
                                                t2.setDouble(idx2 + 1L, a.getDouble(idx1 + 1L));
                                                t2.setDouble(idx3, a.getDouble(idx1 + 2L));
                                                t2.setDouble(idx3 + 1L, a.getDouble(idx1 + 3L));
                                                t2.setDouble(idx4, a.getDouble(idx1 + 4L));
                                                t2.setDouble(idx4 + 1L, a.getDouble(idx1 + 5L));
                                                t2.setDouble(idx5, a.getDouble(idx1 + 6L));
                                                t2.setDouble(idx5 + 1L, a.getDouble(idx1 + 7L));
                                            }
                                            DoubleFFT_3D.this.fftSlices.complexForward(t2, 0L);
                                            DoubleFFT_3D.this.fftSlices.complexForward(t2, 2L * DoubleFFT_3D.this.slicesl);
                                            DoubleFFT_3D.this.fftSlices.complexForward(t2, 4L * DoubleFFT_3D.this.slicesl);
                                            DoubleFFT_3D.this.fftSlices.complexForward(t2, 6L * DoubleFFT_3D.this.slicesl);
                                            for (s2 = 0L; s2 < DoubleFFT_3D.this.slicesl; ++s2) {
                                                idx1 = s2 * DoubleFFT_3D.this.sliceStridel + idx0 + c;
                                                idx2 = 2L * s2;
                                                idx3 = 2L * DoubleFFT_3D.this.slicesl + 2L * s2;
                                                idx4 = idx3 + 2L * DoubleFFT_3D.this.slicesl;
                                                idx5 = idx4 + 2L * DoubleFFT_3D.this.slicesl;
                                                a.setDouble(idx1, t2.getDouble(idx2));
                                                a.setDouble(idx1 + 1L, t2.getDouble(idx2 + 1L));
                                                a.setDouble(idx1 + 2L, t2.getDouble(idx3));
                                                a.setDouble(idx1 + 3L, t2.getDouble(idx3 + 1L));
                                                a.setDouble(idx1 + 4L, t2.getDouble(idx4));
                                                a.setDouble(idx1 + 5L, t2.getDouble(idx4 + 1L));
                                                a.setDouble(idx1 + 6L, t2.getDouble(idx5));
                                                a.setDouble(idx1 + 7L, t2.getDouble(idx5 + 1L));
                                            }
                                        }
                                    }
                                    break block27;
                                }
                                if (DoubleFFT_3D.this.columnsl != 4L) break block28;
                                for (long r = n0; r < DoubleFFT_3D.this.rowsl; r += (long)nthreads) {
                                    long idx3;
                                    long idx2;
                                    long idx1;
                                    long s3;
                                    long idx0 = r * DoubleFFT_3D.this.rowStridel;
                                    for (s3 = 0L; s3 < DoubleFFT_3D.this.slicesl; ++s3) {
                                        idx1 = s3 * DoubleFFT_3D.this.sliceStridel + idx0;
                                        idx2 = 2L * s3;
                                        idx3 = 2L * DoubleFFT_3D.this.slicesl + 2L * s3;
                                        t2.setDouble(idx2, a.getDouble(idx1));
                                        t2.setDouble(idx2 + 1L, a.getDouble(idx1 + 1L));
                                        t2.setDouble(idx3, a.getDouble(idx1 + 2L));
                                        t2.setDouble(idx3 + 1L, a.getDouble(idx1 + 3L));
                                    }
                                    DoubleFFT_3D.this.fftSlices.complexForward(t2, 0L);
                                    DoubleFFT_3D.this.fftSlices.complexForward(t2, 2L * DoubleFFT_3D.this.slicesl);
                                    for (s3 = 0L; s3 < DoubleFFT_3D.this.slicesl; ++s3) {
                                        idx1 = s3 * DoubleFFT_3D.this.sliceStridel + idx0;
                                        idx2 = 2L * s3;
                                        idx3 = 2L * DoubleFFT_3D.this.slicesl + 2L * s3;
                                        a.setDouble(idx1, t2.getDouble(idx2));
                                        a.setDouble(idx1 + 1L, t2.getDouble(idx2 + 1L));
                                        a.setDouble(idx1 + 2L, t2.getDouble(idx3));
                                        a.setDouble(idx1 + 3L, t2.getDouble(idx3 + 1L));
                                    }
                                }
                                break block27;
                            }
                            if (DoubleFFT_3D.this.columnsl != 2L) break block27;
                            for (long r = n0; r < DoubleFFT_3D.this.rowsl; r += (long)nthreads) {
                                long idx2;
                                long idx1;
                                long s4;
                                long idx0 = r * DoubleFFT_3D.this.rowStridel;
                                for (s4 = 0L; s4 < DoubleFFT_3D.this.slicesl; ++s4) {
                                    idx1 = s4 * DoubleFFT_3D.this.sliceStridel + idx0;
                                    idx2 = 2L * s4;
                                    t2.setDouble(idx2, a.getDouble(idx1));
                                    t2.setDouble(idx2 + 1L, a.getDouble(idx1 + 1L));
                                }
                                DoubleFFT_3D.this.fftSlices.complexForward(t2, 0L);
                                for (s4 = 0L; s4 < DoubleFFT_3D.this.slicesl; ++s4) {
                                    idx1 = s4 * DoubleFFT_3D.this.sliceStridel + idx0;
                                    idx2 = 2L * s4;
                                    a.setDouble(idx1, t2.getDouble(idx2));
                                    a.setDouble(idx1 + 1L, t2.getDouble(idx2 + 1L));
                                }
                            }
                            break block27;
                        }
                        if (DoubleFFT_3D.this.columnsl > 4L) {
                            for (long r = n0; r < DoubleFFT_3D.this.rowsl; r += (long)nthreads) {
                                long idx0 = r * DoubleFFT_3D.this.rowStridel;
                                for (long c = 0L; c < DoubleFFT_3D.this.columnsl; c += 8L) {
                                    long idx5;
                                    long idx4;
                                    long idx3;
                                    long idx2;
                                    long idx1;
                                    long s5;
                                    for (s5 = 0L; s5 < DoubleFFT_3D.this.slicesl; ++s5) {
                                        idx1 = s5 * DoubleFFT_3D.this.sliceStridel + idx0 + c;
                                        idx2 = 2L * s5;
                                        idx3 = 2L * DoubleFFT_3D.this.slicesl + 2L * s5;
                                        idx4 = idx3 + 2L * DoubleFFT_3D.this.slicesl;
                                        idx5 = idx4 + 2L * DoubleFFT_3D.this.slicesl;
                                        t2.setDouble(idx2, a.getDouble(idx1));
                                        t2.setDouble(idx2 + 1L, a.getDouble(idx1 + 1L));
                                        t2.setDouble(idx3, a.getDouble(idx1 + 2L));
                                        t2.setDouble(idx3 + 1L, a.getDouble(idx1 + 3L));
                                        t2.setDouble(idx4, a.getDouble(idx1 + 4L));
                                        t2.setDouble(idx4 + 1L, a.getDouble(idx1 + 5L));
                                        t2.setDouble(idx5, a.getDouble(idx1 + 6L));
                                        t2.setDouble(idx5 + 1L, a.getDouble(idx1 + 7L));
                                    }
                                    DoubleFFT_3D.this.fftSlices.complexInverse(t2, 0L, scale);
                                    DoubleFFT_3D.this.fftSlices.complexInverse(t2, 2L * DoubleFFT_3D.this.slicesl, scale);
                                    DoubleFFT_3D.this.fftSlices.complexInverse(t2, 4L * DoubleFFT_3D.this.slicesl, scale);
                                    DoubleFFT_3D.this.fftSlices.complexInverse(t2, 6L * DoubleFFT_3D.this.slicesl, scale);
                                    for (s5 = 0L; s5 < DoubleFFT_3D.this.slicesl; ++s5) {
                                        idx1 = s5 * DoubleFFT_3D.this.sliceStridel + idx0 + c;
                                        idx2 = 2L * s5;
                                        idx3 = 2L * DoubleFFT_3D.this.slicesl + 2L * s5;
                                        idx4 = idx3 + 2L * DoubleFFT_3D.this.slicesl;
                                        idx5 = idx4 + 2L * DoubleFFT_3D.this.slicesl;
                                        a.setDouble(idx1, t2.getDouble(idx2));
                                        a.setDouble(idx1 + 1L, t2.getDouble(idx2 + 1L));
                                        a.setDouble(idx1 + 2L, t2.getDouble(idx3));
                                        a.setDouble(idx1 + 3L, t2.getDouble(idx3 + 1L));
                                        a.setDouble(idx1 + 4L, t2.getDouble(idx4));
                                        a.setDouble(idx1 + 5L, t2.getDouble(idx4 + 1L));
                                        a.setDouble(idx1 + 6L, t2.getDouble(idx5));
                                        a.setDouble(idx1 + 7L, t2.getDouble(idx5 + 1L));
                                    }
                                }
                            }
                        } else if (DoubleFFT_3D.this.columnsl == 4L) {
                            for (long r = n0; r < DoubleFFT_3D.this.rowsl; r += (long)nthreads) {
                                long idx3;
                                long idx2;
                                long idx1;
                                long s6;
                                long idx0 = r * DoubleFFT_3D.this.rowStridel;
                                for (s6 = 0L; s6 < DoubleFFT_3D.this.slicesl; ++s6) {
                                    idx1 = s6 * DoubleFFT_3D.this.sliceStridel + idx0;
                                    idx2 = 2L * s6;
                                    idx3 = 2L * DoubleFFT_3D.this.slicesl + 2L * s6;
                                    t2.setDouble(idx2, a.getDouble(idx1));
                                    t2.setDouble(idx2 + 1L, a.getDouble(idx1 + 1L));
                                    t2.setDouble(idx3, a.getDouble(idx1 + 2L));
                                    t2.setDouble(idx3 + 1L, a.getDouble(idx1 + 3L));
                                }
                                DoubleFFT_3D.this.fftSlices.complexInverse(t2, 0L, scale);
                                DoubleFFT_3D.this.fftSlices.complexInverse(t2, 2L * DoubleFFT_3D.this.slicesl, scale);
                                for (s6 = 0L; s6 < DoubleFFT_3D.this.slicesl; ++s6) {
                                    idx1 = s6 * DoubleFFT_3D.this.sliceStridel + idx0;
                                    idx2 = 2L * s6;
                                    idx3 = 2L * DoubleFFT_3D.this.slicesl + 2L * s6;
                                    a.setDouble(idx1, t2.getDouble(idx2));
                                    a.setDouble(idx1 + 1L, t2.getDouble(idx2 + 1L));
                                    a.setDouble(idx1 + 2L, t2.getDouble(idx3));
                                    a.setDouble(idx1 + 3L, t2.getDouble(idx3 + 1L));
                                }
                            }
                        } else if (DoubleFFT_3D.this.columnsl == 2L) {
                            for (long r = n0; r < DoubleFFT_3D.this.rowsl; r += (long)nthreads) {
                                long idx2;
                                long idx1;
                                long s7;
                                long idx0 = r * DoubleFFT_3D.this.rowStridel;
                                for (s7 = 0L; s7 < DoubleFFT_3D.this.slicesl; ++s7) {
                                    idx1 = s7 * DoubleFFT_3D.this.sliceStridel + idx0;
                                    idx2 = 2L * s7;
                                    t2.setDouble(idx2, a.getDouble(idx1));
                                    t2.setDouble(idx2 + 1L, a.getDouble(idx1 + 1L));
                                }
                                DoubleFFT_3D.this.fftSlices.complexInverse(t2, 0L, scale);
                                for (s7 = 0L; s7 < DoubleFFT_3D.this.slicesl; ++s7) {
                                    idx1 = s7 * DoubleFFT_3D.this.sliceStridel + idx0;
                                    idx2 = 2L * s7;
                                    a.setDouble(idx1, t2.getDouble(idx2));
                                    a.setDouble(idx1 + 1L, t2.getDouble(idx2 + 1L));
                                }
                            }
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void cdft3db_subth(final int isgn, final double[][][] a, final boolean scale) {
        final int nthreads = FastMath.min(ConcurrencyUtils.getNumberOfThreads(), this.rows);
        int nt = this.slices;
        if (nt < this.rows) {
            nt = this.rows;
        }
        nt *= 8;
        if (this.columns == 4) {
            nt >>= 1;
        } else if (this.columns < 4) {
            nt >>= 2;
        }
        final int ntf = nt;
        Future[] futures = new Future[nthreads];
        for (int i = 0; i < nthreads; ++i) {
            final int n0 = i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block27: {
                        double[] t2;
                        block25: {
                            block28: {
                                block26: {
                                    t2 = new double[ntf];
                                    if (isgn != -1) break block25;
                                    if (DoubleFFT_3D.this.columns <= 4) break block26;
                                    for (int r = n0; r < DoubleFFT_3D.this.rows; r += nthreads) {
                                        for (int c = 0; c < DoubleFFT_3D.this.columns; c += 8) {
                                            int idx5;
                                            int idx4;
                                            int idx3;
                                            int idx2;
                                            int s2;
                                            for (s2 = 0; s2 < DoubleFFT_3D.this.slices; ++s2) {
                                                idx2 = 2 * s2;
                                                idx3 = 2 * DoubleFFT_3D.this.slices + 2 * s2;
                                                idx4 = idx3 + 2 * DoubleFFT_3D.this.slices;
                                                idx5 = idx4 + 2 * DoubleFFT_3D.this.slices;
                                                t2[idx2] = a[s2][r][c];
                                                t2[idx2 + 1] = a[s2][r][c + 1];
                                                t2[idx3] = a[s2][r][c + 2];
                                                t2[idx3 + 1] = a[s2][r][c + 3];
                                                t2[idx4] = a[s2][r][c + 4];
                                                t2[idx4 + 1] = a[s2][r][c + 5];
                                                t2[idx5] = a[s2][r][c + 6];
                                                t2[idx5 + 1] = a[s2][r][c + 7];
                                            }
                                            DoubleFFT_3D.this.fftSlices.complexForward(t2, 0);
                                            DoubleFFT_3D.this.fftSlices.complexForward(t2, 2 * DoubleFFT_3D.this.slices);
                                            DoubleFFT_3D.this.fftSlices.complexForward(t2, 4 * DoubleFFT_3D.this.slices);
                                            DoubleFFT_3D.this.fftSlices.complexForward(t2, 6 * DoubleFFT_3D.this.slices);
                                            for (s2 = 0; s2 < DoubleFFT_3D.this.slices; ++s2) {
                                                idx2 = 2 * s2;
                                                idx3 = 2 * DoubleFFT_3D.this.slices + 2 * s2;
                                                idx4 = idx3 + 2 * DoubleFFT_3D.this.slices;
                                                idx5 = idx4 + 2 * DoubleFFT_3D.this.slices;
                                                a[s2][r][c] = t2[idx2];
                                                a[s2][r][c + 1] = t2[idx2 + 1];
                                                a[s2][r][c + 2] = t2[idx3];
                                                a[s2][r][c + 3] = t2[idx3 + 1];
                                                a[s2][r][c + 4] = t2[idx4];
                                                a[s2][r][c + 5] = t2[idx4 + 1];
                                                a[s2][r][c + 6] = t2[idx5];
                                                a[s2][r][c + 7] = t2[idx5 + 1];
                                            }
                                        }
                                    }
                                    break block27;
                                }
                                if (DoubleFFT_3D.this.columns != 4) break block28;
                                for (int r = n0; r < DoubleFFT_3D.this.rows; r += nthreads) {
                                    int idx3;
                                    int idx2;
                                    int s3;
                                    for (s3 = 0; s3 < DoubleFFT_3D.this.slices; ++s3) {
                                        idx2 = 2 * s3;
                                        idx3 = 2 * DoubleFFT_3D.this.slices + 2 * s3;
                                        t2[idx2] = a[s3][r][0];
                                        t2[idx2 + 1] = a[s3][r][1];
                                        t2[idx3] = a[s3][r][2];
                                        t2[idx3 + 1] = a[s3][r][3];
                                    }
                                    DoubleFFT_3D.this.fftSlices.complexForward(t2, 0);
                                    DoubleFFT_3D.this.fftSlices.complexForward(t2, 2 * DoubleFFT_3D.this.slices);
                                    for (s3 = 0; s3 < DoubleFFT_3D.this.slices; ++s3) {
                                        idx2 = 2 * s3;
                                        idx3 = 2 * DoubleFFT_3D.this.slices + 2 * s3;
                                        a[s3][r][0] = t2[idx2];
                                        a[s3][r][1] = t2[idx2 + 1];
                                        a[s3][r][2] = t2[idx3];
                                        a[s3][r][3] = t2[idx3 + 1];
                                    }
                                }
                                break block27;
                            }
                            if (DoubleFFT_3D.this.columns != 2) break block27;
                            for (int r = n0; r < DoubleFFT_3D.this.rows; r += nthreads) {
                                int idx2;
                                int s4;
                                for (s4 = 0; s4 < DoubleFFT_3D.this.slices; ++s4) {
                                    idx2 = 2 * s4;
                                    t2[idx2] = a[s4][r][0];
                                    t2[idx2 + 1] = a[s4][r][1];
                                }
                                DoubleFFT_3D.this.fftSlices.complexForward(t2, 0);
                                for (s4 = 0; s4 < DoubleFFT_3D.this.slices; ++s4) {
                                    idx2 = 2 * s4;
                                    a[s4][r][0] = t2[idx2];
                                    a[s4][r][1] = t2[idx2 + 1];
                                }
                            }
                            break block27;
                        }
                        if (DoubleFFT_3D.this.columns > 4) {
                            for (int r = n0; r < DoubleFFT_3D.this.rows; r += nthreads) {
                                for (int c = 0; c < DoubleFFT_3D.this.columns; c += 8) {
                                    int idx5;
                                    int idx4;
                                    int idx3;
                                    int idx2;
                                    int s5;
                                    for (s5 = 0; s5 < DoubleFFT_3D.this.slices; ++s5) {
                                        idx2 = 2 * s5;
                                        idx3 = 2 * DoubleFFT_3D.this.slices + 2 * s5;
                                        idx4 = idx3 + 2 * DoubleFFT_3D.this.slices;
                                        idx5 = idx4 + 2 * DoubleFFT_3D.this.slices;
                                        t2[idx2] = a[s5][r][c];
                                        t2[idx2 + 1] = a[s5][r][c + 1];
                                        t2[idx3] = a[s5][r][c + 2];
                                        t2[idx3 + 1] = a[s5][r][c + 3];
                                        t2[idx4] = a[s5][r][c + 4];
                                        t2[idx4 + 1] = a[s5][r][c + 5];
                                        t2[idx5] = a[s5][r][c + 6];
                                        t2[idx5 + 1] = a[s5][r][c + 7];
                                    }
                                    DoubleFFT_3D.this.fftSlices.complexInverse(t2, 0, scale);
                                    DoubleFFT_3D.this.fftSlices.complexInverse(t2, 2 * DoubleFFT_3D.this.slices, scale);
                                    DoubleFFT_3D.this.fftSlices.complexInverse(t2, 4 * DoubleFFT_3D.this.slices, scale);
                                    DoubleFFT_3D.this.fftSlices.complexInverse(t2, 6 * DoubleFFT_3D.this.slices, scale);
                                    for (s5 = 0; s5 < DoubleFFT_3D.this.slices; ++s5) {
                                        idx2 = 2 * s5;
                                        idx3 = 2 * DoubleFFT_3D.this.slices + 2 * s5;
                                        idx4 = idx3 + 2 * DoubleFFT_3D.this.slices;
                                        idx5 = idx4 + 2 * DoubleFFT_3D.this.slices;
                                        a[s5][r][c] = t2[idx2];
                                        a[s5][r][c + 1] = t2[idx2 + 1];
                                        a[s5][r][c + 2] = t2[idx3];
                                        a[s5][r][c + 3] = t2[idx3 + 1];
                                        a[s5][r][c + 4] = t2[idx4];
                                        a[s5][r][c + 5] = t2[idx4 + 1];
                                        a[s5][r][c + 6] = t2[idx5];
                                        a[s5][r][c + 7] = t2[idx5 + 1];
                                    }
                                }
                            }
                        } else if (DoubleFFT_3D.this.columns == 4) {
                            for (int r = n0; r < DoubleFFT_3D.this.rows; r += nthreads) {
                                int idx3;
                                int idx2;
                                int s6;
                                for (s6 = 0; s6 < DoubleFFT_3D.this.slices; ++s6) {
                                    idx2 = 2 * s6;
                                    idx3 = 2 * DoubleFFT_3D.this.slices + 2 * s6;
                                    t2[idx2] = a[s6][r][0];
                                    t2[idx2 + 1] = a[s6][r][1];
                                    t2[idx3] = a[s6][r][2];
                                    t2[idx3 + 1] = a[s6][r][3];
                                }
                                DoubleFFT_3D.this.fftSlices.complexInverse(t2, 0, scale);
                                DoubleFFT_3D.this.fftSlices.complexInverse(t2, 2 * DoubleFFT_3D.this.slices, scale);
                                for (s6 = 0; s6 < DoubleFFT_3D.this.slices; ++s6) {
                                    idx2 = 2 * s6;
                                    idx3 = 2 * DoubleFFT_3D.this.slices + 2 * s6;
                                    a[s6][r][0] = t2[idx2];
                                    a[s6][r][1] = t2[idx2 + 1];
                                    a[s6][r][2] = t2[idx3];
                                    a[s6][r][3] = t2[idx3 + 1];
                                }
                            }
                        } else if (DoubleFFT_3D.this.columns == 2) {
                            for (int r = n0; r < DoubleFFT_3D.this.rows; r += nthreads) {
                                int idx2;
                                int s7;
                                for (s7 = 0; s7 < DoubleFFT_3D.this.slices; ++s7) {
                                    idx2 = 2 * s7;
                                    t2[idx2] = a[s7][r][0];
                                    t2[idx2 + 1] = a[s7][r][1];
                                }
                                DoubleFFT_3D.this.fftSlices.complexInverse(t2, 0, scale);
                                for (s7 = 0; s7 < DoubleFFT_3D.this.slices; ++s7) {
                                    idx2 = 2 * s7;
                                    a[s7][r][0] = t2[idx2];
                                    a[s7][r][1] = t2[idx2 + 1];
                                }
                            }
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void rdft3d_sub(int isgn, double[] a) {
        int n1h = this.slices >> 1;
        int n2h = this.rows >> 1;
        if (isgn < 0) {
            int l;
            int k;
            double xi;
            int idx4;
            int idx3;
            int idx2;
            int idx1;
            for (int i = 1; i < n1h; ++i) {
                int j = this.slices - i;
                idx1 = i * this.sliceStride;
                idx2 = j * this.sliceStride;
                idx3 = i * this.sliceStride + n2h * this.rowStride;
                idx4 = j * this.sliceStride + n2h * this.rowStride;
                xi = a[idx1] - a[idx2];
                int n = idx1;
                a[n] = a[n] + a[idx2];
                a[idx2] = xi;
                xi = a[idx2 + 1] - a[idx1 + 1];
                int n2 = idx1 + 1;
                a[n2] = a[n2] + a[idx2 + 1];
                a[idx2 + 1] = xi;
                xi = a[idx3] - a[idx4];
                int n3 = idx3;
                a[n3] = a[n3] + a[idx4];
                a[idx4] = xi;
                xi = a[idx4 + 1] - a[idx3 + 1];
                int n4 = idx3 + 1;
                a[n4] = a[n4] + a[idx4 + 1];
                a[idx4 + 1] = xi;
                for (k = 1; k < n2h; ++k) {
                    l = this.rows - k;
                    idx1 = i * this.sliceStride + k * this.rowStride;
                    idx2 = j * this.sliceStride + l * this.rowStride;
                    xi = a[idx1] - a[idx2];
                    int n5 = idx1;
                    a[n5] = a[n5] + a[idx2];
                    a[idx2] = xi;
                    xi = a[idx2 + 1] - a[idx1 + 1];
                    int n6 = idx1 + 1;
                    a[n6] = a[n6] + a[idx2 + 1];
                    a[idx2 + 1] = xi;
                    idx3 = j * this.sliceStride + k * this.rowStride;
                    idx4 = i * this.sliceStride + l * this.rowStride;
                    xi = a[idx3] - a[idx4];
                    int n7 = idx3;
                    a[n7] = a[n7] + a[idx4];
                    a[idx4] = xi;
                    xi = a[idx4 + 1] - a[idx3 + 1];
                    int n8 = idx3 + 1;
                    a[n8] = a[n8] + a[idx4 + 1];
                    a[idx4 + 1] = xi;
                }
            }
            for (k = 1; k < n2h; ++k) {
                l = this.rows - k;
                idx1 = k * this.rowStride;
                idx2 = l * this.rowStride;
                xi = a[idx1] - a[idx2];
                int n = idx1;
                a[n] = a[n] + a[idx2];
                a[idx2] = xi;
                xi = a[idx2 + 1] - a[idx1 + 1];
                int n9 = idx1 + 1;
                a[n9] = a[n9] + a[idx2 + 1];
                a[idx2 + 1] = xi;
                idx3 = n1h * this.sliceStride + k * this.rowStride;
                idx4 = n1h * this.sliceStride + l * this.rowStride;
                xi = a[idx3] - a[idx4];
                int n10 = idx3;
                a[n10] = a[n10] + a[idx4];
                a[idx4] = xi;
                xi = a[idx4 + 1] - a[idx3 + 1];
                int n11 = idx3 + 1;
                a[n11] = a[n11] + a[idx4 + 1];
                a[idx4 + 1] = xi;
            }
        } else {
            int l;
            int k;
            int idx4;
            int idx3;
            int idx2;
            int idx1;
            for (int i = 1; i < n1h; ++i) {
                int j = this.slices - i;
                idx1 = j * this.sliceStride;
                idx2 = i * this.sliceStride;
                a[idx1] = 0.5 * (a[idx2] - a[idx1]);
                int n = idx2;
                a[n] = a[n] - a[idx1];
                a[idx1 + 1] = 0.5 * (a[idx2 + 1] + a[idx1 + 1]);
                int n12 = idx2 + 1;
                a[n12] = a[n12] - a[idx1 + 1];
                idx3 = j * this.sliceStride + n2h * this.rowStride;
                idx4 = i * this.sliceStride + n2h * this.rowStride;
                a[idx3] = 0.5 * (a[idx4] - a[idx3]);
                int n13 = idx4;
                a[n13] = a[n13] - a[idx3];
                a[idx3 + 1] = 0.5 * (a[idx4 + 1] + a[idx3 + 1]);
                int n14 = idx4 + 1;
                a[n14] = a[n14] - a[idx3 + 1];
                for (k = 1; k < n2h; ++k) {
                    l = this.rows - k;
                    idx1 = j * this.sliceStride + l * this.rowStride;
                    idx2 = i * this.sliceStride + k * this.rowStride;
                    a[idx1] = 0.5 * (a[idx2] - a[idx1]);
                    int n15 = idx2;
                    a[n15] = a[n15] - a[idx1];
                    a[idx1 + 1] = 0.5 * (a[idx2 + 1] + a[idx1 + 1]);
                    int n16 = idx2 + 1;
                    a[n16] = a[n16] - a[idx1 + 1];
                    idx3 = i * this.sliceStride + l * this.rowStride;
                    idx4 = j * this.sliceStride + k * this.rowStride;
                    a[idx3] = 0.5 * (a[idx4] - a[idx3]);
                    int n17 = idx4;
                    a[n17] = a[n17] - a[idx3];
                    a[idx3 + 1] = 0.5 * (a[idx4 + 1] + a[idx3 + 1]);
                    int n18 = idx4 + 1;
                    a[n18] = a[n18] - a[idx3 + 1];
                }
            }
            for (k = 1; k < n2h; ++k) {
                l = this.rows - k;
                idx1 = l * this.rowStride;
                idx2 = k * this.rowStride;
                a[idx1] = 0.5 * (a[idx2] - a[idx1]);
                int n = idx2;
                a[n] = a[n] - a[idx1];
                a[idx1 + 1] = 0.5 * (a[idx2 + 1] + a[idx1 + 1]);
                int n19 = idx2 + 1;
                a[n19] = a[n19] - a[idx1 + 1];
                idx3 = n1h * this.sliceStride + l * this.rowStride;
                idx4 = n1h * this.sliceStride + k * this.rowStride;
                a[idx3] = 0.5 * (a[idx4] - a[idx3]);
                int n20 = idx4;
                a[n20] = a[n20] - a[idx3];
                a[idx3 + 1] = 0.5 * (a[idx4 + 1] + a[idx3 + 1]);
                int n21 = idx4 + 1;
                a[n21] = a[n21] - a[idx3 + 1];
            }
        }
    }

    private void rdft3d_sub(int isgn, DoubleLargeArray a) {
        long n1h = this.slicesl >> 1;
        long n2h = this.rowsl >> 1;
        if (isgn < 0) {
            long l;
            long k;
            double xi;
            long idx4;
            long idx3;
            long idx2;
            long idx1;
            for (long i = 1L; i < n1h; ++i) {
                long j = this.slicesl - i;
                idx1 = i * this.sliceStridel;
                idx2 = j * this.sliceStridel;
                idx3 = i * this.sliceStridel + n2h * this.rowStridel;
                idx4 = j * this.sliceStridel + n2h * this.rowStridel;
                xi = a.getDouble(idx1) - a.getDouble(idx2);
                a.setDouble(idx1, a.getDouble(idx1) + a.getDouble(idx2));
                a.setDouble(idx2, xi);
                xi = a.getDouble(idx2 + 1L) - a.getDouble(idx1 + 1L);
                a.setDouble(idx1 + 1L, a.getDouble(idx1 + 1L) + a.getDouble(idx2 + 1L));
                a.setDouble(idx2 + 1L, xi);
                xi = a.getDouble(idx3) - a.getDouble(idx4);
                a.setDouble(idx3, a.getDouble(idx3) + a.getDouble(idx4));
                a.setDouble(idx4, xi);
                xi = a.getDouble(idx4 + 1L) - a.getDouble(idx3 + 1L);
                a.setDouble(idx3 + 1L, a.getDouble(idx3 + 1L) + a.getDouble(idx4 + 1L));
                a.setDouble(idx4 + 1L, xi);
                for (k = 1L; k < n2h; ++k) {
                    l = this.rowsl - k;
                    idx1 = i * this.sliceStridel + k * this.rowStridel;
                    idx2 = j * this.sliceStridel + l * this.rowStridel;
                    xi = a.getDouble(idx1) - a.getDouble(idx2);
                    a.setDouble(idx1, a.getDouble(idx1) + a.getDouble(idx2));
                    a.setDouble(idx2, xi);
                    xi = a.getDouble(idx2 + 1L) - a.getDouble(idx1 + 1L);
                    a.setDouble(idx1 + 1L, a.getDouble(idx1 + 1L) + a.getDouble(idx2 + 1L));
                    a.setDouble(idx2 + 1L, xi);
                    idx3 = j * this.sliceStridel + k * this.rowStridel;
                    idx4 = i * this.sliceStridel + l * this.rowStridel;
                    xi = a.getDouble(idx3) - a.getDouble(idx4);
                    a.setDouble(idx3, a.getDouble(idx3) + a.getDouble(idx4));
                    a.setDouble(idx4, xi);
                    xi = a.getDouble(idx4 + 1L) - a.getDouble(idx3 + 1L);
                    a.setDouble(idx3 + 1L, a.getDouble(idx3 + 1L) + a.getDouble(idx4 + 1L));
                    a.setDouble(idx4 + 1L, xi);
                }
            }
            for (k = 1L; k < n2h; ++k) {
                l = this.rowsl - k;
                idx1 = k * this.rowStridel;
                idx2 = l * this.rowStridel;
                xi = a.getDouble(idx1) - a.getDouble(idx2);
                a.setDouble(idx1, a.getDouble(idx1) + a.getDouble(idx2));
                a.setDouble(idx2, xi);
                xi = a.getDouble(idx2 + 1L) - a.getDouble(idx1 + 1L);
                a.setDouble(idx1 + 1L, a.getDouble(idx1 + 1L) + a.getDouble(idx2 + 1L));
                a.setDouble(idx2 + 1L, xi);
                idx3 = n1h * this.sliceStridel + k * this.rowStridel;
                idx4 = n1h * this.sliceStridel + l * this.rowStridel;
                xi = a.getDouble(idx3) - a.getDouble(idx4);
                a.setDouble(idx3, a.getDouble(idx3) + a.getDouble(idx4));
                a.setDouble(idx4, xi);
                xi = a.getDouble(idx4 + 1L) - a.getDouble(idx3 + 1L);
                a.setDouble(idx3 + 1L, a.getDouble(idx3 + 1L) + a.getDouble(idx4 + 1L));
                a.setDouble(idx4 + 1L, xi);
            }
        } else {
            long l;
            long k;
            long idx4;
            long idx3;
            long idx2;
            long idx1;
            for (long i = 1L; i < n1h; ++i) {
                long j = this.slicesl - i;
                idx1 = j * this.sliceStridel;
                idx2 = i * this.sliceStridel;
                a.setDouble(idx1, 0.5 * (a.getDouble(idx2) - a.getDouble(idx1)));
                a.setDouble(idx2, a.getDouble(idx2) - a.getDouble(idx1));
                a.setDouble(idx1 + 1L, 0.5 * (a.getDouble(idx2 + 1L) + a.getDouble(idx1 + 1L)));
                a.setDouble(idx2 + 1L, a.getDouble(idx2 + 1L) - a.getDouble(idx1 + 1L));
                idx3 = j * this.sliceStridel + n2h * this.rowStridel;
                idx4 = i * this.sliceStridel + n2h * this.rowStridel;
                a.setDouble(idx3, 0.5 * (a.getDouble(idx4) - a.getDouble(idx3)));
                a.setDouble(idx4, a.getDouble(idx4) - a.getDouble(idx3));
                a.setDouble(idx3 + 1L, 0.5 * (a.getDouble(idx4 + 1L) + a.getDouble(idx3 + 1L)));
                a.setDouble(idx4 + 1L, a.getDouble(idx4 + 1L) - a.getDouble(idx3 + 1L));
                for (k = 1L; k < n2h; ++k) {
                    l = this.rowsl - k;
                    idx1 = j * this.sliceStridel + l * this.rowStridel;
                    idx2 = i * this.sliceStridel + k * this.rowStridel;
                    a.setDouble(idx1, 0.5 * (a.getDouble(idx2) - a.getDouble(idx1)));
                    a.setDouble(idx2, a.getDouble(idx2) - a.getDouble(idx1));
                    a.setDouble(idx1 + 1L, 0.5 * (a.getDouble(idx2 + 1L) + a.getDouble(idx1 + 1L)));
                    a.setDouble(idx2 + 1L, a.getDouble(idx2 + 1L) - a.getDouble(idx1 + 1L));
                    idx3 = i * this.sliceStridel + l * this.rowStridel;
                    idx4 = j * this.sliceStridel + k * this.rowStridel;
                    a.setDouble(idx3, 0.5 * (a.getDouble(idx4) - a.getDouble(idx3)));
                    a.setDouble(idx4, a.getDouble(idx4) - a.getDouble(idx3));
                    a.setDouble(idx3 + 1L, 0.5 * (a.getDouble(idx4 + 1L) + a.getDouble(idx3 + 1L)));
                    a.setDouble(idx4 + 1L, a.getDouble(idx4 + 1L) - a.getDouble(idx3 + 1L));
                }
            }
            for (k = 1L; k < n2h; ++k) {
                l = this.rowsl - k;
                idx1 = l * this.rowStridel;
                idx2 = k * this.rowStridel;
                a.setDouble(idx1, 0.5 * (a.getDouble(idx2) - a.getDouble(idx1)));
                a.setDouble(idx2, a.getDouble(idx2) - a.getDouble(idx1));
                a.setDouble(idx1 + 1L, 0.5 * (a.getDouble(idx2 + 1L) + a.getDouble(idx1 + 1L)));
                a.setDouble(idx2 + 1L, a.getDouble(idx2 + 1L) - a.getDouble(idx1 + 1L));
                idx3 = n1h * this.sliceStridel + l * this.rowStridel;
                idx4 = n1h * this.sliceStridel + k * this.rowStridel;
                a.setDouble(idx3, 0.5 * (a.getDouble(idx4) - a.getDouble(idx3)));
                a.setDouble(idx4, a.getDouble(idx4) - a.getDouble(idx3));
                a.setDouble(idx3 + 1L, 0.5 * (a.getDouble(idx4 + 1L) + a.getDouble(idx3 + 1L)));
                a.setDouble(idx4 + 1L, a.getDouble(idx4 + 1L) - a.getDouble(idx3 + 1L));
            }
        }
    }

    private void rdft3d_sub(int isgn, double[][][] a) {
        int n1h = this.slices >> 1;
        int n2h = this.rows >> 1;
        if (isgn < 0) {
            int l;
            int k;
            double xi;
            for (int i = 1; i < n1h; ++i) {
                int j = this.slices - i;
                xi = a[i][0][0] - a[j][0][0];
                double[] dArray = a[i][0];
                dArray[0] = dArray[0] + a[j][0][0];
                a[j][0][0] = xi;
                xi = a[j][0][1] - a[i][0][1];
                double[] dArray2 = a[i][0];
                dArray2[1] = dArray2[1] + a[j][0][1];
                a[j][0][1] = xi;
                xi = a[i][n2h][0] - a[j][n2h][0];
                double[] dArray3 = a[i][n2h];
                dArray3[0] = dArray3[0] + a[j][n2h][0];
                a[j][n2h][0] = xi;
                xi = a[j][n2h][1] - a[i][n2h][1];
                double[] dArray4 = a[i][n2h];
                dArray4[1] = dArray4[1] + a[j][n2h][1];
                a[j][n2h][1] = xi;
                for (k = 1; k < n2h; ++k) {
                    l = this.rows - k;
                    xi = a[i][k][0] - a[j][l][0];
                    double[] dArray5 = a[i][k];
                    dArray5[0] = dArray5[0] + a[j][l][0];
                    a[j][l][0] = xi;
                    xi = a[j][l][1] - a[i][k][1];
                    double[] dArray6 = a[i][k];
                    dArray6[1] = dArray6[1] + a[j][l][1];
                    a[j][l][1] = xi;
                    xi = a[j][k][0] - a[i][l][0];
                    double[] dArray7 = a[j][k];
                    dArray7[0] = dArray7[0] + a[i][l][0];
                    a[i][l][0] = xi;
                    xi = a[i][l][1] - a[j][k][1];
                    double[] dArray8 = a[j][k];
                    dArray8[1] = dArray8[1] + a[i][l][1];
                    a[i][l][1] = xi;
                }
            }
            for (k = 1; k < n2h; ++k) {
                l = this.rows - k;
                xi = a[0][k][0] - a[0][l][0];
                double[] dArray = a[0][k];
                dArray[0] = dArray[0] + a[0][l][0];
                a[0][l][0] = xi;
                xi = a[0][l][1] - a[0][k][1];
                double[] dArray9 = a[0][k];
                dArray9[1] = dArray9[1] + a[0][l][1];
                a[0][l][1] = xi;
                xi = a[n1h][k][0] - a[n1h][l][0];
                double[] dArray10 = a[n1h][k];
                dArray10[0] = dArray10[0] + a[n1h][l][0];
                a[n1h][l][0] = xi;
                xi = a[n1h][l][1] - a[n1h][k][1];
                double[] dArray11 = a[n1h][k];
                dArray11[1] = dArray11[1] + a[n1h][l][1];
                a[n1h][l][1] = xi;
            }
        } else {
            int l;
            int k;
            for (int i = 1; i < n1h; ++i) {
                int j = this.slices - i;
                a[j][0][0] = 0.5 * (a[i][0][0] - a[j][0][0]);
                double[] dArray = a[i][0];
                dArray[0] = dArray[0] - a[j][0][0];
                a[j][0][1] = 0.5 * (a[i][0][1] + a[j][0][1]);
                double[] dArray12 = a[i][0];
                dArray12[1] = dArray12[1] - a[j][0][1];
                a[j][n2h][0] = 0.5 * (a[i][n2h][0] - a[j][n2h][0]);
                double[] dArray13 = a[i][n2h];
                dArray13[0] = dArray13[0] - a[j][n2h][0];
                a[j][n2h][1] = 0.5 * (a[i][n2h][1] + a[j][n2h][1]);
                double[] dArray14 = a[i][n2h];
                dArray14[1] = dArray14[1] - a[j][n2h][1];
                for (k = 1; k < n2h; ++k) {
                    l = this.rows - k;
                    a[j][l][0] = 0.5 * (a[i][k][0] - a[j][l][0]);
                    double[] dArray15 = a[i][k];
                    dArray15[0] = dArray15[0] - a[j][l][0];
                    a[j][l][1] = 0.5 * (a[i][k][1] + a[j][l][1]);
                    double[] dArray16 = a[i][k];
                    dArray16[1] = dArray16[1] - a[j][l][1];
                    a[i][l][0] = 0.5 * (a[j][k][0] - a[i][l][0]);
                    double[] dArray17 = a[j][k];
                    dArray17[0] = dArray17[0] - a[i][l][0];
                    a[i][l][1] = 0.5 * (a[j][k][1] + a[i][l][1]);
                    double[] dArray18 = a[j][k];
                    dArray18[1] = dArray18[1] - a[i][l][1];
                }
            }
            for (k = 1; k < n2h; ++k) {
                l = this.rows - k;
                a[0][l][0] = 0.5 * (a[0][k][0] - a[0][l][0]);
                double[] dArray = a[0][k];
                dArray[0] = dArray[0] - a[0][l][0];
                a[0][l][1] = 0.5 * (a[0][k][1] + a[0][l][1]);
                double[] dArray19 = a[0][k];
                dArray19[1] = dArray19[1] - a[0][l][1];
                a[n1h][l][0] = 0.5 * (a[n1h][k][0] - a[n1h][l][0]);
                double[] dArray20 = a[n1h][k];
                dArray20[0] = dArray20[0] - a[n1h][l][0];
                a[n1h][l][1] = 0.5 * (a[n1h][k][1] + a[n1h][l][1]);
                double[] dArray21 = a[n1h][k];
                dArray21[1] = dArray21[1] - a[n1h][l][1];
            }
        }
    }

    private void fillSymmetric(final double[][][] a) {
        int idx1;
        final int twon3 = 2 * this.columns;
        final int n2d2 = this.rows / 2;
        int n1d2 = this.slices / 2;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.useThreads && this.slices >= nthreads) {
            int lastSlice;
            int firstSlice;
            Future[] futures = new Future[nthreads];
            int p = this.slices / nthreads;
            for (int l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                            int idx1 = (DoubleFFT_3D.this.slices - s2) % DoubleFFT_3D.this.slices;
                            for (int r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                int idx2 = (DoubleFFT_3D.this.rows - r) % DoubleFFT_3D.this.rows;
                                for (int c = 1; c < DoubleFFT_3D.this.columns; c += 2) {
                                    int idx3 = twon3 - c;
                                    a[idx1][idx2][idx3] = -a[s2][r][c + 2];
                                    a[idx1][idx2][idx3 - 1] = a[s2][r][c + 1];
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            for (int l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                            int idx1 = (DoubleFFT_3D.this.slices - s2) % DoubleFFT_3D.this.slices;
                            for (int r = 1; r < n2d2; ++r) {
                                int idx2 = DoubleFFT_3D.this.rows - r;
                                a[idx1][r][((DoubleFFT_3D)DoubleFFT_3D.this).columns] = a[s2][idx2][1];
                                a[s2][idx2][((DoubleFFT_3D)DoubleFFT_3D.this).columns] = a[s2][idx2][1];
                                a[idx1][r][((DoubleFFT_3D)DoubleFFT_3D.this).columns + 1] = -a[s2][idx2][0];
                                a[s2][idx2][((DoubleFFT_3D)DoubleFFT_3D.this).columns + 1] = a[s2][idx2][0];
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            for (int l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                            int idx1 = (DoubleFFT_3D.this.slices - s2) % DoubleFFT_3D.this.slices;
                            for (int r = 1; r < n2d2; ++r) {
                                int idx2 = DoubleFFT_3D.this.rows - r;
                                a[idx1][idx2][0] = a[s2][r][0];
                                a[idx1][idx2][1] = -a[s2][r][1];
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            int idx2;
            int r;
            int s2;
            for (s2 = 0; s2 < this.slices; ++s2) {
                idx1 = (this.slices - s2) % this.slices;
                for (r = 0; r < this.rows; ++r) {
                    idx2 = (this.rows - r) % this.rows;
                    for (int c = 1; c < this.columns; c += 2) {
                        int idx3 = twon3 - c;
                        a[idx1][idx2][idx3] = -a[s2][r][c + 2];
                        a[idx1][idx2][idx3 - 1] = a[s2][r][c + 1];
                    }
                }
            }
            for (s2 = 0; s2 < this.slices; ++s2) {
                idx1 = (this.slices - s2) % this.slices;
                for (r = 1; r < n2d2; ++r) {
                    idx2 = this.rows - r;
                    a[idx1][r][this.columns] = a[s2][idx2][1];
                    a[s2][idx2][this.columns] = a[s2][idx2][1];
                    a[idx1][r][this.columns + 1] = -a[s2][idx2][0];
                    a[s2][idx2][this.columns + 1] = a[s2][idx2][0];
                }
            }
            for (s2 = 0; s2 < this.slices; ++s2) {
                idx1 = (this.slices - s2) % this.slices;
                for (r = 1; r < n2d2; ++r) {
                    idx2 = this.rows - r;
                    a[idx1][idx2][0] = a[s2][r][0];
                    a[idx1][idx2][1] = -a[s2][r][1];
                }
            }
        }
        for (int s3 = 1; s3 < n1d2; ++s3) {
            idx1 = this.slices - s3;
            a[s3][0][this.columns] = a[idx1][0][1];
            a[idx1][0][this.columns] = a[idx1][0][1];
            a[s3][0][this.columns + 1] = -a[idx1][0][0];
            a[idx1][0][this.columns + 1] = a[idx1][0][0];
            a[s3][n2d2][this.columns] = a[idx1][n2d2][1];
            a[idx1][n2d2][this.columns] = a[idx1][n2d2][1];
            a[s3][n2d2][this.columns + 1] = -a[idx1][n2d2][0];
            a[idx1][n2d2][this.columns + 1] = a[idx1][n2d2][0];
            a[idx1][0][0] = a[s3][0][0];
            a[idx1][0][1] = -a[s3][0][1];
            a[idx1][n2d2][0] = a[s3][n2d2][0];
            a[idx1][n2d2][1] = -a[s3][n2d2][1];
        }
        a[0][0][this.columns] = a[0][0][1];
        a[0][0][1] = 0.0;
        a[0][n2d2][this.columns] = a[0][n2d2][1];
        a[0][n2d2][1] = 0.0;
        a[n1d2][0][this.columns] = a[n1d2][0][1];
        a[n1d2][0][1] = 0.0;
        a[n1d2][n2d2][this.columns] = a[n1d2][n2d2][1];
        a[n1d2][n2d2][1] = 0.0;
        a[n1d2][0][this.columns + 1] = 0.0;
        a[n1d2][n2d2][this.columns + 1] = 0.0;
    }

    private void fillSymmetric(final double[] a) {
        int idx2;
        int idx1;
        int idx6;
        int idx5;
        int idx4;
        int idx3;
        final int twon3 = 2 * this.columns;
        final int n2d2 = this.rows / 2;
        int n1d2 = this.slices / 2;
        final int twoSliceStride = this.rows * twon3;
        final int twoRowStride = twon3;
        for (int s2 = this.slices - 1; s2 >= 1; --s2) {
            idx3 = s2 * this.sliceStride;
            idx4 = 2 * idx3;
            for (int r = 0; r < this.rows; ++r) {
                idx5 = r * this.rowStride;
                idx6 = 2 * idx5;
                for (int c = 0; c < this.columns; c += 2) {
                    idx1 = idx3 + idx5 + c;
                    idx2 = idx4 + idx6 + c;
                    a[idx2] = a[idx1];
                    a[idx1] = 0.0;
                    a[++idx2] = a[++idx1];
                    a[idx1] = 0.0;
                }
            }
        }
        for (int r = 1; r < this.rows; ++r) {
            idx3 = (this.rows - r) * this.rowStride;
            idx4 = (this.rows - r) * twoRowStride;
            for (int c = 0; c < this.columns; c += 2) {
                idx1 = idx3 + c;
                idx2 = idx4 + c;
                a[idx2] = a[idx1];
                a[idx1] = 0.0;
                a[++idx2] = a[++idx1];
                a[idx1] = 0.0;
            }
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.useThreads && this.slices >= nthreads) {
            int lastSlice;
            int firstSlice;
            Future[] futures = new Future[nthreads];
            int p = this.slices / nthreads;
            for (int l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                            int idx3 = (DoubleFFT_3D.this.slices - s2) % DoubleFFT_3D.this.slices * twoSliceStride;
                            int idx5 = s2 * twoSliceStride;
                            for (int r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                int idx4 = (DoubleFFT_3D.this.rows - r) % DoubleFFT_3D.this.rows * twoRowStride;
                                int idx6 = r * twoRowStride;
                                for (int c = 1; c < DoubleFFT_3D.this.columns; c += 2) {
                                    int idx1 = idx3 + idx4 + twon3 - c;
                                    int idx2 = idx5 + idx6 + c;
                                    a[idx1] = -a[idx2 + 2];
                                    a[idx1 - 1] = a[idx2 + 1];
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            for (int l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                            int idx5 = (DoubleFFT_3D.this.slices - s2) % DoubleFFT_3D.this.slices * twoSliceStride;
                            int idx6 = s2 * twoSliceStride;
                            for (int r = 1; r < n2d2; ++r) {
                                int idx4 = idx6 + (DoubleFFT_3D.this.rows - r) * twoRowStride;
                                int idx1 = idx5 + r * twoRowStride + DoubleFFT_3D.this.columns;
                                int idx2 = idx4 + DoubleFFT_3D.this.columns;
                                int idx3 = idx4 + 1;
                                a[idx1] = a[idx3];
                                a[idx2] = a[idx3];
                                a[idx1 + 1] = -a[idx4];
                                a[idx2 + 1] = a[idx4];
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            for (int l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s2 = firstSlice; s2 < lastSlice; ++s2) {
                            int idx3 = (DoubleFFT_3D.this.slices - s2) % DoubleFFT_3D.this.slices * twoSliceStride;
                            int idx4 = s2 * twoSliceStride;
                            for (int r = 1; r < n2d2; ++r) {
                                int idx1 = idx3 + (DoubleFFT_3D.this.rows - r) * twoRowStride;
                                int idx2 = idx4 + r * twoRowStride;
                                a[idx1] = a[idx2];
                                a[idx1 + 1] = -a[idx2 + 1];
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            int r;
            int s3;
            for (s3 = 0; s3 < this.slices; ++s3) {
                idx3 = (this.slices - s3) % this.slices * twoSliceStride;
                idx5 = s3 * twoSliceStride;
                for (r = 0; r < this.rows; ++r) {
                    idx4 = (this.rows - r) % this.rows * twoRowStride;
                    idx6 = r * twoRowStride;
                    for (int c = 1; c < this.columns; c += 2) {
                        idx1 = idx3 + idx4 + twon3 - c;
                        idx2 = idx5 + idx6 + c;
                        a[idx1] = -a[idx2 + 2];
                        a[idx1 - 1] = a[idx2 + 1];
                    }
                }
            }
            for (s3 = 0; s3 < this.slices; ++s3) {
                idx5 = (this.slices - s3) % this.slices * twoSliceStride;
                idx6 = s3 * twoSliceStride;
                for (r = 1; r < n2d2; ++r) {
                    idx4 = idx6 + (this.rows - r) * twoRowStride;
                    idx1 = idx5 + r * twoRowStride + this.columns;
                    idx2 = idx4 + this.columns;
                    idx3 = idx4 + 1;
                    a[idx1] = a[idx3];
                    a[idx2] = a[idx3];
                    a[idx1 + 1] = -a[idx4];
                    a[idx2 + 1] = a[idx4];
                }
            }
            for (s3 = 0; s3 < this.slices; ++s3) {
                idx3 = (this.slices - s3) % this.slices * twoSliceStride;
                idx4 = s3 * twoSliceStride;
                for (r = 1; r < n2d2; ++r) {
                    idx1 = idx3 + (this.rows - r) * twoRowStride;
                    idx2 = idx4 + r * twoRowStride;
                    a[idx1] = a[idx2];
                    a[idx1 + 1] = -a[idx2 + 1];
                }
            }
        }
        for (int s4 = 1; s4 < n1d2; ++s4) {
            idx1 = s4 * twoSliceStride;
            idx2 = (this.slices - s4) * twoSliceStride;
            idx3 = n2d2 * twoRowStride;
            idx4 = idx1 + idx3;
            idx5 = idx2 + idx3;
            a[idx1 + this.columns] = a[idx2 + 1];
            a[idx2 + this.columns] = a[idx2 + 1];
            a[idx1 + this.columns + 1] = -a[idx2];
            a[idx2 + this.columns + 1] = a[idx2];
            a[idx4 + this.columns] = a[idx5 + 1];
            a[idx5 + this.columns] = a[idx5 + 1];
            a[idx4 + this.columns + 1] = -a[idx5];
            a[idx5 + this.columns + 1] = a[idx5];
            a[idx2] = a[idx1];
            a[idx2 + 1] = -a[idx1 + 1];
            a[idx5] = a[idx4];
            a[idx5 + 1] = -a[idx4 + 1];
        }
        a[this.columns] = a[1];
        a[1] = 0.0;
        idx1 = n2d2 * twoRowStride;
        idx2 = n1d2 * twoSliceStride;
        idx3 = idx1 + idx2;
        a[idx1 + this.columns] = a[idx1 + 1];
        a[idx1 + 1] = 0.0;
        a[idx2 + this.columns] = a[idx2 + 1];
        a[idx2 + 1] = 0.0;
        a[idx3 + this.columns] = a[idx3 + 1];
        a[idx3 + 1] = 0.0;
        a[idx2 + this.columns + 1] = 0.0;
        a[idx3 + this.columns + 1] = 0.0;
    }

    private void fillSymmetric(final DoubleLargeArray a) {
        long idx2;
        long idx1;
        long idx6;
        long idx5;
        long idx4;
        long idx3;
        final long twon3 = 2L * this.columnsl;
        final long n2d2 = this.rowsl / 2L;
        long n1d2 = this.slicesl / 2L;
        final long twoSliceStride = this.rowsl * twon3;
        final long twoRowStride = twon3;
        for (long s2 = this.slicesl - 1L; s2 >= 1L; --s2) {
            idx3 = s2 * this.sliceStridel;
            idx4 = 2L * idx3;
            for (long r = 0L; r < this.rowsl; ++r) {
                idx5 = r * this.rowStridel;
                idx6 = 2L * idx5;
                for (long c = 0L; c < this.columnsl; c += 2L) {
                    idx1 = idx3 + idx5 + c;
                    idx2 = idx4 + idx6 + c;
                    a.setDouble(idx2, a.getDouble(idx1));
                    a.setDouble(idx1, 0.0);
                    a.setDouble(++idx2, a.getDouble(++idx1));
                    a.setDouble(idx1, 0.0);
                }
            }
        }
        for (long r = 1L; r < this.rowsl; ++r) {
            idx3 = (this.rowsl - r) * this.rowStridel;
            idx4 = (this.rowsl - r) * twoRowStride;
            for (long c = 0L; c < this.columnsl; c += 2L) {
                idx1 = idx3 + c;
                idx2 = idx4 + c;
                a.setDouble(idx2, a.getDouble(idx1));
                a.setDouble(idx1, 0.0);
                a.setDouble(++idx2, a.getDouble(++idx1));
                a.setDouble(idx1, 0.0);
            }
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.useThreads && this.slicesl >= (long)nthreads) {
            long lastSlice;
            long firstSlice;
            Future[] futures = new Future[nthreads];
            long p = this.slicesl / (long)nthreads;
            for (int l = 0; l < nthreads; ++l) {
                firstSlice = (long)l * p;
                lastSlice = l == nthreads - 1 ? this.slicesl : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long s2 = firstSlice; s2 < lastSlice; ++s2) {
                            long idx3 = (DoubleFFT_3D.this.slicesl - s2) % DoubleFFT_3D.this.slicesl * twoSliceStride;
                            long idx5 = s2 * twoSliceStride;
                            for (long r = 0L; r < DoubleFFT_3D.this.rowsl; ++r) {
                                long idx4 = (DoubleFFT_3D.this.rowsl - r) % DoubleFFT_3D.this.rowsl * twoRowStride;
                                long idx6 = r * twoRowStride;
                                for (long c = 1L; c < DoubleFFT_3D.this.columnsl; c += 2L) {
                                    long idx1 = idx3 + idx4 + twon3 - c;
                                    long idx2 = idx5 + idx6 + c;
                                    a.setDouble(idx1, -a.getDouble(idx2 + 2L));
                                    a.setDouble(idx1 - 1L, a.getDouble(idx2 + 1L));
                                }
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            for (int l = 0; l < nthreads; ++l) {
                firstSlice = (long)l * p;
                lastSlice = l == nthreads - 1 ? this.slicesl : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long s2 = firstSlice; s2 < lastSlice; ++s2) {
                            long idx5 = (DoubleFFT_3D.this.slicesl - s2) % DoubleFFT_3D.this.slicesl * twoSliceStride;
                            long idx6 = s2 * twoSliceStride;
                            for (long r = 1L; r < n2d2; ++r) {
                                long idx4 = idx6 + (DoubleFFT_3D.this.rowsl - r) * twoRowStride;
                                long idx1 = idx5 + r * twoRowStride + DoubleFFT_3D.this.columnsl;
                                long idx2 = idx4 + DoubleFFT_3D.this.columnsl;
                                long idx3 = idx4 + 1L;
                                a.setDouble(idx1, a.getDouble(idx3));
                                a.setDouble(idx2, a.getDouble(idx3));
                                a.setDouble(idx1 + 1L, -a.getDouble(idx4));
                                a.setDouble(idx2 + 1L, a.getDouble(idx4));
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            for (int l = 0; l < nthreads; ++l) {
                firstSlice = (long)l * p;
                lastSlice = l == nthreads - 1 ? this.slicesl : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long s2 = firstSlice; s2 < lastSlice; ++s2) {
                            long idx3 = (DoubleFFT_3D.this.slicesl - s2) % DoubleFFT_3D.this.slicesl * twoSliceStride;
                            long idx4 = s2 * twoSliceStride;
                            for (long r = 1L; r < n2d2; ++r) {
                                long idx1 = idx3 + (DoubleFFT_3D.this.rowsl - r) * twoRowStride;
                                long idx2 = idx4 + r * twoRowStride;
                                a.setDouble(idx1, a.getDouble(idx2));
                                a.setDouble(idx1 + 1L, -a.getDouble(idx2 + 1L));
                            }
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(futures);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(DoubleFFT_3D.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            long r;
            long s3;
            for (s3 = 0L; s3 < this.slicesl; ++s3) {
                idx3 = (this.slicesl - s3) % this.slicesl * twoSliceStride;
                idx5 = s3 * twoSliceStride;
                for (r = 0L; r < this.rowsl; ++r) {
                    idx4 = (this.rowsl - r) % this.rowsl * twoRowStride;
                    idx6 = r * twoRowStride;
                    for (long c = 1L; c < this.columnsl; c += 2L) {
                        idx1 = idx3 + idx4 + twon3 - c;
                        idx2 = idx5 + idx6 + c;
                        a.setDouble(idx1, -a.getDouble(idx2 + 2L));
                        a.setDouble(idx1 - 1L, a.getDouble(idx2 + 1L));
                    }
                }
            }
            for (s3 = 0L; s3 < this.slicesl; ++s3) {
                idx5 = (this.slicesl - s3) % this.slicesl * twoSliceStride;
                idx6 = s3 * twoSliceStride;
                for (r = 1L; r < n2d2; ++r) {
                    idx4 = idx6 + (this.rowsl - r) * twoRowStride;
                    idx1 = idx5 + r * twoRowStride + this.columnsl;
                    idx2 = idx4 + this.columnsl;
                    idx3 = idx4 + 1L;
                    a.setDouble(idx1, a.getDouble(idx3));
                    a.setDouble(idx2, a.getDouble(idx3));
                    a.setDouble(idx1 + 1L, -a.getDouble(idx4));
                    a.setDouble(idx2 + 1L, a.getDouble(idx4));
                }
            }
            for (s3 = 0L; s3 < this.slicesl; ++s3) {
                idx3 = (this.slicesl - s3) % this.slicesl * twoSliceStride;
                idx4 = s3 * twoSliceStride;
                for (r = 1L; r < n2d2; ++r) {
                    idx1 = idx3 + (this.rowsl - r) * twoRowStride;
                    idx2 = idx4 + r * twoRowStride;
                    a.setDouble(idx1, a.getDouble(idx2));
                    a.setDouble(idx1 + 1L, -a.getDouble(idx2 + 1L));
                }
            }
        }
        for (long s4 = 1L; s4 < n1d2; ++s4) {
            idx1 = s4 * twoSliceStride;
            idx2 = (this.slicesl - s4) * twoSliceStride;
            idx3 = n2d2 * twoRowStride;
            idx4 = idx1 + idx3;
            idx5 = idx2 + idx3;
            a.setDouble(idx1 + this.columnsl, a.getDouble(idx2 + 1L));
            a.setDouble(idx2 + this.columnsl, a.getDouble(idx2 + 1L));
            a.setDouble(idx1 + this.columnsl + 1L, -a.getDouble(idx2));
            a.setDouble(idx2 + this.columnsl + 1L, a.getDouble(idx2));
            a.setDouble(idx4 + this.columnsl, a.getDouble(idx5 + 1L));
            a.setDouble(idx5 + this.columnsl, a.getDouble(idx5 + 1L));
            a.setDouble(idx4 + this.columnsl + 1L, -a.getDouble(idx5));
            a.setDouble(idx5 + this.columnsl + 1L, a.getDouble(idx5));
            a.setDouble(idx2, a.getDouble(idx1));
            a.setDouble(idx2 + 1L, -a.getDouble(idx1 + 1L));
            a.setDouble(idx5, a.getDouble(idx4));
            a.setDouble(idx5 + 1L, -a.getDouble(idx4 + 1L));
        }
        a.setDouble(this.columnsl, a.getDouble(1L));
        a.setDouble(1L, 0.0);
        idx1 = n2d2 * twoRowStride;
        idx2 = n1d2 * twoSliceStride;
        idx3 = idx1 + idx2;
        a.setDouble(idx1 + this.columnsl, a.getDouble(idx1 + 1L));
        a.setDouble(idx1 + 1L, 0.0);
        a.setDouble(idx2 + this.columnsl, a.getDouble(idx2 + 1L));
        a.setDouble(idx2 + 1L, 0.0);
        a.setDouble(idx3 + this.columnsl, a.getDouble(idx3 + 1L));
        a.setDouble(idx3 + 1L, 0.0);
        a.setDouble(idx2 + this.columnsl + 1L, 0.0);
        a.setDouble(idx3 + this.columnsl + 1L, 0.0);
    }
}

