/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.load.converter;

import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.queryengine.plan.statement.StatementNode;
import org.apache.iotdb.db.queryengine.plan.statement.StatementVisitor;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertBaseStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertMultiTabletsStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertTabletStatement;
import org.apache.iotdb.rpc.TSStatusCode;

public class LoadConvertedInsertTabletStatementTSStatusVisitor
extends StatementVisitor<TSStatus, TSStatus> {
    private final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();

    @Override
    public TSStatus visitNode(StatementNode node, TSStatus context) {
        return context;
    }

    @Override
    public TSStatus visitInsertTablet(InsertTabletStatement insertTabletStatement, TSStatus context) {
        return this.visitInsertBase(insertTabletStatement, context);
    }

    @Override
    public TSStatus visitInsertMultiTablets(InsertMultiTabletsStatement insertMultiTabletsStatement, TSStatus context) {
        return this.visitInsertBase(insertMultiTabletsStatement, context);
    }

    private TSStatus visitInsertBase(InsertBaseStatement insertBaseStatement, TSStatus context) {
        if (context.getCode() == TSStatusCode.SYSTEM_READ_ONLY.getStatusCode() || context.getCode() == TSStatusCode.WRITE_PROCESS_REJECT.getStatusCode()) {
            return new TSStatus(TSStatusCode.LOAD_TEMPORARY_UNAVAILABLE_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        if (context.getCode() == TSStatusCode.OUT_OF_TTL.getStatusCode()) {
            return new TSStatus(TSStatusCode.LOAD_IDEMPOTENT_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        if (context.getCode() == TSStatusCode.METADATA_ERROR.getStatusCode() && context.getMessage().contains("registered type") && this.config.isEnablePartialInsert()) {
            return new TSStatus(TSStatusCode.LOAD_IDEMPOTENT_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        return (TSStatus)this.visitStatement(insertBaseStatement, context);
    }
}

