/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.core.type;

import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.metrics.core.type.IoTDBTimerHistogramSnapshot;
import org.apache.iotdb.metrics.core.type.IoTDBTimerMBean;
import org.apache.iotdb.metrics.type.HistogramSnapshot;
import org.apache.iotdb.metrics.type.Timer;
import org.apache.iotdb.metrics.utils.AbstractMetricMBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBTimer
extends AbstractMetricMBean
implements Timer,
IoTDBTimerMBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoTDBTimer.class);
    io.micrometer.core.instrument.Timer timer;

    public IoTDBTimer(io.micrometer.core.instrument.Timer timer) {
        this.timer = timer;
    }

    public void update(long duration, TimeUnit unit) {
        this.timer.record(duration, unit);
    }

    public HistogramSnapshot takeSnapshot() {
        try {
            return new IoTDBTimerHistogramSnapshot(this.timer);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            LOGGER.warn("Detected an error while taking snapshot, may cause a miss during this recording.", (Throwable)e);
            return null;
        }
    }

    @Override
    public double getSum() {
        return Optional.ofNullable(this.takeSnapshot()).map(HistogramSnapshot::getSum).orElse(0.0);
    }

    @Override
    public double getMax() {
        return Optional.ofNullable(this.takeSnapshot()).map(HistogramSnapshot::getMax).orElse(0.0);
    }

    @Override
    public double getMean() {
        return Optional.ofNullable(this.takeSnapshot()).map(HistogramSnapshot::getMean).orElse(0.0);
    }

    @Override
    public int getSize() {
        return Optional.ofNullable(this.takeSnapshot()).map(HistogramSnapshot::size).orElse(0);
    }

    @Override
    public double get50thPercentile() {
        return Optional.ofNullable(this.takeSnapshot()).map(histogramSnapshot -> histogramSnapshot.getValue(0.5)).orElse(0.0);
    }

    @Override
    public double get99thPercentile() {
        return Optional.ofNullable(this.takeSnapshot()).map(histogramSnapshot -> histogramSnapshot.getValue(0.99)).orElse(0.0);
    }

    @Override
    public long getCount() {
        return this.timer.count();
    }
}

