/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryUpdateDetails;

public class DeleteRawModifiedDetails
extends HistoryUpdateDetails
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=686");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=688");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=687");
    private final Boolean isDeleteModified;
    private final DateTime startTime;
    private final DateTime endTime;

    public DeleteRawModifiedDetails(NodeId nodeId, Boolean isDeleteModified, DateTime startTime, DateTime endTime) {
        super(nodeId);
        this.isDeleteModified = isDeleteModified;
        this.startTime = startTime;
        this.endTime = endTime;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public Boolean getIsDeleteModified() {
        return this.isDeleteModified;
    }

    public DateTime getStartTime() {
        return this.startTime;
    }

    public DateTime getEndTime() {
        return this.endTime;
    }

    protected DeleteRawModifiedDetails(DeleteRawModifiedDetailsBuilder<?, ?> b) {
        super((HistoryUpdateDetails.HistoryUpdateDetailsBuilder<?, ?>)b);
        this.isDeleteModified = ((DeleteRawModifiedDetailsBuilder)b).isDeleteModified;
        this.startTime = ((DeleteRawModifiedDetailsBuilder)b).startTime;
        this.endTime = ((DeleteRawModifiedDetailsBuilder)b).endTime;
    }

    public static DeleteRawModifiedDetailsBuilder<?, ?> builder() {
        return new DeleteRawModifiedDetailsBuilderImpl();
    }

    public DeleteRawModifiedDetailsBuilder<?, ?> toBuilder() {
        return new DeleteRawModifiedDetailsBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeleteRawModifiedDetails)) {
            return false;
        }
        DeleteRawModifiedDetails other = (DeleteRawModifiedDetails)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$isDeleteModified = this.getIsDeleteModified();
        Boolean other$isDeleteModified = other.getIsDeleteModified();
        if (this$isDeleteModified == null ? other$isDeleteModified != null : !((Object)this$isDeleteModified).equals(other$isDeleteModified)) {
            return false;
        }
        DateTime this$startTime = this.getStartTime();
        DateTime other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        DateTime this$endTime = this.getEndTime();
        DateTime other$endTime = other.getEndTime();
        return !(this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DeleteRawModifiedDetails;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $isDeleteModified = this.getIsDeleteModified();
        result = result * 59 + ($isDeleteModified == null ? 43 : ((Object)$isDeleteModified).hashCode());
        DateTime $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        DateTime $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "DeleteRawModifiedDetails(isDeleteModified=" + this.getIsDeleteModified() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ")";
    }

    private static final class DeleteRawModifiedDetailsBuilderImpl
    extends DeleteRawModifiedDetailsBuilder<DeleteRawModifiedDetails, DeleteRawModifiedDetailsBuilderImpl> {
        private DeleteRawModifiedDetailsBuilderImpl() {
        }

        @Override
        protected DeleteRawModifiedDetailsBuilderImpl self() {
            return this;
        }

        @Override
        public DeleteRawModifiedDetails build() {
            return new DeleteRawModifiedDetails(this);
        }
    }

    public static abstract class DeleteRawModifiedDetailsBuilder<C extends DeleteRawModifiedDetails, B extends DeleteRawModifiedDetailsBuilder<C, B>>
    extends HistoryUpdateDetails.HistoryUpdateDetailsBuilder<C, B> {
        private Boolean isDeleteModified;
        private DateTime startTime;
        private DateTime endTime;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            DeleteRawModifiedDetailsBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(DeleteRawModifiedDetails instance, DeleteRawModifiedDetailsBuilder<?, ?> b) {
            b.isDeleteModified(instance.isDeleteModified);
            b.startTime(instance.startTime);
            b.endTime(instance.endTime);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B isDeleteModified(Boolean isDeleteModified) {
            this.isDeleteModified = isDeleteModified;
            return (B)this.self();
        }

        public B startTime(DateTime startTime) {
            this.startTime = startTime;
            return (B)this.self();
        }

        public B endTime(DateTime endTime) {
            this.endTime = endTime;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "DeleteRawModifiedDetails.DeleteRawModifiedDetailsBuilder(super=" + super.toString() + ", isDeleteModified=" + this.isDeleteModified + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<DeleteRawModifiedDetails> {
        @Override
        public Class<DeleteRawModifiedDetails> getType() {
            return DeleteRawModifiedDetails.class;
        }

        @Override
        public DeleteRawModifiedDetails decode(SerializationContext context, UaDecoder decoder) {
            NodeId nodeId = decoder.readNodeId("NodeId");
            Boolean isDeleteModified = decoder.readBoolean("IsDeleteModified");
            DateTime startTime = decoder.readDateTime("StartTime");
            DateTime endTime = decoder.readDateTime("EndTime");
            return new DeleteRawModifiedDetails(nodeId, isDeleteModified, startTime, endTime);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, DeleteRawModifiedDetails value) {
            encoder.writeNodeId("NodeId", value.getNodeId());
            encoder.writeBoolean("IsDeleteModified", value.getIsDeleteModified());
            encoder.writeDateTime("StartTime", value.getStartTime());
            encoder.writeDateTime("EndTime", value.getEndTime());
        }
    }
}

