/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.server.interactive;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.livy.LivyClientBuilder;
import org.apache.livy.LivyConf;
import org.apache.livy.LivyConf$;
import org.apache.livy.Logging;
import org.apache.livy.client.common.ClientConf;
import org.apache.livy.rsc.RSCClient;
import org.apache.livy.rsc.RSCConf;
import org.apache.livy.server.interactive.CreateInteractiveRequest;
import org.apache.livy.server.interactive.InteractiveRecoveryMetadata;
import org.apache.livy.server.interactive.InteractiveSession;
import org.apache.livy.server.interactive.InteractiveSession$;
import org.apache.livy.server.interactive.InteractiveSession$$anonfun$3$;
import org.apache.livy.server.recovery.SessionStore;
import org.apache.livy.sessions.Kind;
import org.apache.livy.sessions.Session$;
import org.apache.livy.sessions.SessionState;
import org.apache.livy.utils.LivySparkUtils$;
import org.apache.livy.utils.SparkApp;
import org.apache.livy.utils.SparkApp$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.sys.package$;
import scala.util.Random$;
import scala.util.Try$;
import scala.util.matching.Regex;

public final class InteractiveSession$
implements Logging {
    public static final InteractiveSession$ MODULE$;
    private final String SPARK_YARN_IS_PYTHON;
    private final String RECOVERY_SESSION_TYPE;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new InteractiveSession$();
    }

    private Logger logger$lzycompute() {
        InteractiveSession$ interactiveSession$ = this;
        synchronized (interactiveSession$) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public void trace(Function0<Object> message) {
        Logging.class.trace((Logging)this, message);
    }

    public void debug(Function0<Object> message) {
        Logging.class.debug((Logging)this, message);
    }

    public void info(Function0<Object> message) {
        Logging.class.info((Logging)this, message);
    }

    public void warn(Function0<Object> message) {
        Logging.class.warn((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.class.warn((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.class.error((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.class.error((Logging)this, message);
    }

    public String SPARK_YARN_IS_PYTHON() {
        return this.SPARK_YARN_IS_PYTHON;
    }

    public String RECOVERY_SESSION_TYPE() {
        return this.RECOVERY_SESSION_TYPE;
    }

    public InteractiveSession create(int id, String owner, Option<String> proxyUser, LivyConf livyConf, CreateInteractiveRequest request, SessionStore sessionStore, Option<SparkApp> mockApp, Option<RSCClient> mockClient) {
        String appTag = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"livy-session-", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)id), Random$.MODULE$.alphanumeric().take(8).mkString()}));
        Option client = mockClient.orElse((Function0)new Serializable(id, owner, proxyUser, livyConf, request, appTag){
            public static final long serialVersionUID = 0L;
            public final int id$1;
            public final String owner$1;
            private final Option proxyUser$1;
            private final LivyConf livyConf$1;
            public final CreateInteractiveRequest request$1;
            private final String appTag$1;

            public final Option<RSCClient> apply() {
                scala.collection.immutable.Map<String, String> conf2 = SparkApp$.MODULE$.prepareSparkConf(this.appTag$1, this.livyConf$1, Session$.MODULE$.prepareConf(this.request$1.conf(), (Seq<String>)this.request$1.jars(), (Seq<String>)this.request$1.files(), (Seq<String>)this.request$1.archives(), (Seq<String>)this.request$1.pyFiles(), this.livyConf$1));
                scala.collection.mutable.Map<String, String> builderProperties = InteractiveSession$.MODULE$.prepareBuilderProp(conf2, this.request$1.kind(), this.livyConf$1);
                scala.collection.immutable.Map userOpts = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.driver.cores"), (Object)this.request$1.driverCores().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(int x$1) {
                        return ((Object)BoxesRunTime.boxToInteger((int)x$1)).toString();
                    }
                })), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.driver.memory"), (Object)this.request$1.driverMemory().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String x$2) {
                        return x$2.toString();
                    }
                })), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.executor.cores"), (Object)this.request$1.executorCores().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(int x$3) {
                        return ((Object)BoxesRunTime.boxToInteger((int)x$3)).toString();
                    }
                })), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.executor.memory"), (Object)this.request$1.executorMemory().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String x$4) {
                        return x$4.toString();
                    }
                })), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.executor.instances"), (Object)this.request$1.numExecutors().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(int x$5) {
                        return ((Object)BoxesRunTime.boxToInteger((int)x$5)).toString();
                    }
                })), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.app.name"), (Object)this.request$1.name().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String x$6) {
                        return x$6.toString();
                    }
                })), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.yarn.queue"), this.request$1.queue())}));
                userOpts.foreach((Function1)new Serializable(this, builderProperties){
                    public static final long serialVersionUID = 0L;
                    public final scala.collection.mutable.Map builderProperties$1;

                    public final void apply(Tuple2<String, Option<String>> x0$1) {
                        Tuple2<String, Option<String>> tuple2 = x0$1;
                        if (tuple2 != null) {
                            String key = (String)tuple2._1();
                            Option opt = (Option)tuple2._2();
                            opt.foreach((Function1)new Serializable(this, key){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun$3$$anonfun$apply$1 $outer;
                                private final String key$1;

                                public final Option<String> apply(String value) {
                                    return this.$outer.builderProperties$1.put((Object)this.key$1, (Object)value);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.key$1 = key$1;
                                }
                            });
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.builderProperties$1 = builderProperties$1;
                    }
                });
                builderProperties.getOrElseUpdate((Object)"spark.app.name", (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.3 $outer;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"livy-session-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.id$1)}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                InteractiveSession$.MODULE$.info((Function0<Object>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.3 $outer;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Creating Interactive session ", ": [owner: ", ", request: ", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.id$1), this.$outer.owner$1, this.$outer.request$1}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                LivyClientBuilder builder = new LivyClientBuilder().setAll((Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter(builderProperties).asJava()).setConf("livy.client.session-id", ((Object)BoxesRunTime.boxToInteger((int)this.id$1)).toString()).setConf(RSCConf.Entry.DRIVER_CLASS.key(), "org.apache.livy.repl.ReplDriver").setConf(RSCConf.Entry.PROXY_USER.key(), (String)this.proxyUser$1.orNull(Predef$.MODULE$.$conforms())).setURI(new URI("rsc:/"));
                return Option$.MODULE$.apply((Object)((RSCClient)builder.build()));
            }
            {
                this.id$1 = id$1;
                this.owner$1 = owner$1;
                this.proxyUser$1 = proxyUser$1;
                this.livyConf$1 = livyConf$1;
                this.request$1 = request$1;
                this.appTag$1 = appTag$1;
            }
        });
        return new InteractiveSession(id, (Option<String>)None$.MODULE$, appTag, (Option<RSCClient>)client, (SessionState)SessionState.Starting$.MODULE$, request.kind(), request.heartbeatTimeoutInSecond(), livyConf, owner, proxyUser, sessionStore, mockApp);
    }

    public Option<SparkApp> create$default$7() {
        return None$.MODULE$;
    }

    public Option<RSCClient> create$default$8() {
        return None$.MODULE$;
    }

    public InteractiveSession recover(InteractiveRecoveryMetadata metadata, LivyConf livyConf, SessionStore sessionStore, Option<SparkApp> mockApp, Option<RSCClient> mockClient) {
        Option client = mockClient.orElse((Function0)new Serializable(metadata){
            public static final long serialVersionUID = 0L;
            private final InteractiveRecoveryMetadata metadata$1;

            public final Option<RSCClient> apply() {
                return this.metadata$1.rscDriverUri().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final RSCClient apply(URI uri) {
                        LivyClientBuilder builder = new LivyClientBuilder().setURI(uri);
                        return (RSCClient)builder.build();
                    }
                });
            }
            {
                this.metadata$1 = metadata$1;
            }
        });
        return new InteractiveSession(metadata.id(), metadata.appId(), metadata.appTag(), (Option<RSCClient>)client, (SessionState)SessionState.Recovering$.MODULE$, metadata.kind(), metadata.heartbeatTimeoutS(), livyConf, metadata.owner(), metadata.proxyUser(), sessionStore, mockApp);
    }

    public Option<SparkApp> recover$default$4() {
        return None$.MODULE$;
    }

    public Option<RSCClient> recover$default$5() {
        return None$.MODULE$;
    }

    @VisibleForTesting
    public scala.collection.mutable.Map<String, String> prepareBuilderProp(scala.collection.immutable.Map<String, String> conf2, Kind kind, LivyConf livyConf) {
        scala.collection.mutable.Map builderProperties = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        builderProperties.$plus$plus$eq(conf2);
        Nil$ pySparkFiles = LivyConf$.MODULE$.TEST_MODE() ? Nil$.MODULE$ : this.findPySparkArchives$1(livyConf);
        Object object = pySparkFiles.nonEmpty() ? builderProperties.put((Object)this.SPARK_YARN_IS_PYTHON(), (Object)"true") : BoxedUnit.UNIT;
        this.mergeConfList$1((Seq)pySparkFiles, LivyConf$.MODULE$.SPARK_PY_FILES(), builderProperties);
        None$ sparkRArchive = LivyConf$.MODULE$.TEST_MODE() ? None$.MODULE$ : this.findSparkRArchive$1(livyConf);
        sparkRArchive.foreach((Function1)new Serializable(builderProperties){
            public static final long serialVersionUID = 0L;
            private final scala.collection.mutable.Map builderProperties$2;

            public final Option<String> apply(String archive) {
                return this.builderProperties$2.put((Object)RSCConf.Entry.SPARKR_PACKAGE.key(), (Object)new StringBuilder().append((Object)archive).append((Object)"#sparkr").toString());
            }
            {
                this.builderProperties$2 = builderProperties$2;
            }
        });
        builderProperties.put((Object)RSCConf.Entry.SESSION_KIND.key(), (Object)kind.toString());
        Option$.MODULE$.apply((Object)livyConf.get(LivyConf$.MODULE$.RSC_JARS())).foreach((Function1)new Serializable(builderProperties){
            public static final long serialVersionUID = 0L;
            private final scala.collection.mutable.Map builderProperties$2;

            public final String apply(String x$15) {
                return (String)this.builderProperties$2.getOrElseUpdate((Object)RSCConf.Entry.LIVY_JARS.key(), (Function0)new Serializable(this, x$15){
                    public static final long serialVersionUID = 0L;
                    private final String x$15$1;

                    public final String apply() {
                        return this.x$15$1;
                    }
                    {
                        this.x$15$1 = x$15$1;
                    }
                });
            }
            {
                this.builderProperties$2 = builderProperties$2;
            }
        });
        Predef$.MODULE$.require(livyConf.get(LivyConf$.MODULE$.LIVY_SPARK_VERSION()) != null);
        Predef$.MODULE$.require(livyConf.get(LivyConf$.MODULE$.LIVY_SPARK_SCALA_VERSION()) != null);
        Tuple2<Object, Object> tuple2 = LivySparkUtils$.MODULE$.formatSparkVersion(livyConf.get(LivyConf$.MODULE$.LIVY_SPARK_VERSION()));
        if (tuple2 != null) {
            Option option;
            int sparkMajorVersion;
            int n;
            int sparkMajorVersion2 = n = (sparkMajorVersion = tuple2._1$mcI$sp());
            String scalaVersion = livyConf.get(LivyConf$.MODULE$.LIVY_SPARK_SCALA_VERSION());
            this.mergeConfList$1((Seq)this.livyJars$1(livyConf, scalaVersion), LivyConf$.MODULE$.SPARK_JARS(), builderProperties);
            boolean enableHiveContext = livyConf.getBoolean(LivyConf$.MODULE$.ENABLE_HIVE_CONTEXT());
            builderProperties.put((Object)"spark.livy.spark_major_version", (Object)((Object)BoxesRunTime.boxToInteger((int)sparkMajorVersion2)).toString());
            if (sparkMajorVersion2 <= 1) {
                option = builderProperties.put((Object)"spark.repl.enableHiveContext", (Object)((Object)BoxesRunTime.boxToBoolean((boolean)livyConf.getBoolean(LivyConf$.MODULE$.ENABLE_HIVE_CONTEXT()))).toString());
            } else {
                String confVal = enableHiveContext ? "hive" : "in-memory";
                option = builderProperties.put((Object)"spark.sql.catalogImplementation", (Object)confVal);
            }
            if (enableHiveContext) {
                this.mergeHiveSiteAndHiveDeps$1(sparkMajorVersion2, conf2, livyConf, builderProperties);
            }
            return builderProperties;
        }
        throw new MatchError(tuple2);
    }

    private final List livyJars$1(LivyConf livyConf, String scalaVersion) {
        return (List)Option$.MODULE$.apply((Object)livyConf.get(LivyConf$.MODULE$.REPL_JARS())).map((Function1)new Serializable(scalaVersion){
            public static final long serialVersionUID = 0L;
            public final String scalaVersion$1;

            public final List<String> apply(String jars) {
                Regex regex = new StringOps(Predef$.MODULE$.augmentString("[\\w-]+_(\\d\\.\\d\\d).*\\.jar")).r();
                return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])jars.split(",")).filter((Function1)new Serializable(this, regex){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.livyJars.1.1 $outer;
                    private final Regex regex$1;

                    public final boolean apply(String name) {
                        boolean bl;
                        String string = new Path(name).getName();
                        Option option = this.regex$1.unapplySeq((CharSequence)string);
                        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
                            String ver;
                            String string2 = ver = (String)((LinearSeqOptimized)option.get()).apply(0);
                            String string3 = this.$outer.scalaVersion$1;
                            bl = !(string2 != null ? !string2.equals(string3) : string3 != null);
                        } else {
                            bl = name.endsWith(".jar");
                        }
                        return bl;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.regex$1 = regex$1;
                    }
                })).toList();
            }
            {
                this.scalaVersion$1 = scalaVersion$1;
            }
        }).getOrElse((Function0)new Serializable(scalaVersion){
            public static final long serialVersionUID = 0L;
            public final String scalaVersion$1;

            public final List<String> apply() {
                String home = (String)package$.MODULE$.env().apply((Object)"LIVY_HOME");
                File jars = (File)Option$.MODULE$.apply((Object)new File(home, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"repl_", "-jars"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.scalaVersion$1})))).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(File x$7) {
                        return x$7.isDirectory();
                    }
                }).getOrElse((Function0)new Serializable(this, home){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.livyJars.1.2 $outer;
                    private final String home$1;

                    public final File apply() {
                        return new File(this.home$1, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"repl/scala-", "/target/jars"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.scalaVersion$1})));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.home$1 = home$1;
                    }
                });
                Predef$.MODULE$.require(jars.isDirectory(), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Cannot find Livy REPL jars.";
                    }
                });
                return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])jars.listFiles()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(File x$8) {
                        return x$8.getAbsolutePath();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toList();
            }
            {
                this.scalaVersion$1 = scalaVersion$1;
            }
        });
    }

    private final Option findSparkRArchive$1(LivyConf livyConf$2) {
        return Option$.MODULE$.apply((Object)livyConf$2.get(RSCConf.Entry.SPARKR_PACKAGE.key())).orElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<String> apply() {
                return package$.MODULE$.env().get((Object)"SPARK_HOME").flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Option<String> apply(String x0$2) {
                        Some some;
                        String string = x0$2;
                        String path = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{string, "R", "lib", "sparkr.zip"}))).mkString(File.separator);
                        File rArchivesFile = new File(path);
                        if (rArchivesFile.exists()) {
                            some = new Some((Object)rArchivesFile.getAbsolutePath());
                        } else {
                            InteractiveSession$.MODULE$.warn((Function0<Object>)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "sparkr.zip not found; cannot start R interpreter.";
                                }
                            });
                            some = None$.MODULE$;
                        }
                        Some some2 = some;
                        return some2;
                    }
                });
            }
        });
    }

    private final Seq datanucleusJars$1(LivyConf livyConf, int sparkMajorVersion) {
        Seq seq;
        if (new StringOps(Predef$.MODULE$.augmentString((String)package$.MODULE$.env().getOrElse((Object)"LIVY_INTEGRATION_TEST", (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "false";
            }
        }))).toBoolean()) {
            seq = (Seq)Seq$.MODULE$.empty();
        } else {
            Seq jars;
            File file;
            String sparkHome2 = (String)livyConf.sparkHome().get();
            int n = sparkMajorVersion;
            switch (n) {
                default: {
                    throw new RuntimeException(new StringBuilder().append((Object)"Unsupported spark major version:").append((Object)BoxesRunTime.boxToInteger((int)sparkMajorVersion)).toString());
                }
                case 2: {
                    if (new File(sparkHome2, "RELEASE").isFile()) {
                        file = new File(sparkHome2, "jars");
                        break;
                    }
                    if (new File(sparkHome2, "assembly/target/scala-2.11/jars").isDirectory()) {
                        file = new File(sparkHome2, "assembly/target/scala-2.11/jars");
                        break;
                    }
                    file = new File(sparkHome2, "assembly/target/scala-2.10/jars");
                    break;
                }
                case 1: {
                    file = new File(sparkHome2, "RELEASE").isFile() ? new File(sparkHome2, "lib") : new File(sparkHome2, "lib_managed/jars");
                }
            }
            File libdir = file;
            Seq seq2 = jars = libdir.isDirectory() ? Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])libdir.listFiles()).filter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(File x$9) {
                    return x$9.getName().startsWith("datanucleus-");
                }
            })).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(File x$10) {
                    return x$10.getAbsolutePath();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toSeq() : (Seq)Seq$.MODULE$.empty();
            if (jars.isEmpty()) {
                this.warn((Function0<Object>)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "datanucleus jars can not be found";
                    }
                });
            }
            seq = jars;
        }
        return seq;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final Tuple2 hiveSiteFile$1(String[] sparkFiles, LivyConf livyConf) {
        Tuple2 tuple2;
        if (Predef$.MODULE$.refArrayOps((Object[])sparkFiles).exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$11) {
                Object object = Predef$.MODULE$.refArrayOps((Object[])x$11.split("/")).last();
                String string = "hive-site.xml";
                return !(object != null ? !object.equals(string) : string != null);
            }
        })) {
            tuple2 = new Tuple2((Object)None$.MODULE$, (Object)BoxesRunTime.boxToBoolean((boolean)true));
            return tuple2;
        }
        URL hiveSiteURL = this.getClass().getResource("/hive-site.xml");
        if (hiveSiteURL != null) {
            String string = hiveSiteURL.getProtocol();
            String string2 = "file";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                tuple2 = new Tuple2((Object)new Some((Object)new File(hiveSiteURL.toURI())), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                return tuple2;
            }
        }
        tuple2 = new Tuple2((Object)None$.MODULE$, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        return tuple2;
    }

    private final Seq findPySparkArchives$1(LivyConf livyConf$2) {
        return (Seq)Option$.MODULE$.apply((Object)livyConf$2.get((ClientConf.ConfEntry)RSCConf.Entry.PYSPARK_ARCHIVES)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<String> apply(String x$12) {
                return Predef$.MODULE$.refArrayOps((Object[])x$12.split(",")).toSeq();
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<String> apply() {
                return (Seq)package$.MODULE$.env().get((Object)"SPARK_HOME").map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Seq<String> apply(String x0$3) {
                        Seq seq;
                        String string = x0$3;
                        String pyLibPath = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{string, "python", "lib"}))).mkString(File.separator);
                        File pyArchivesFile = new File(pyLibPath, "pyspark.zip");
                        Option py4jFile = Try$.MODULE$.apply((Function0)new Serializable(this, pyLibPath){
                            public static final long serialVersionUID = 0L;
                            private final String pyLibPath$1;

                            public final File apply() {
                                return Files.newDirectoryStream(Paths.get(this.pyLibPath$1, new String[0]), "py4j-*-src.zip").iterator().next().toFile();
                            }
                            {
                                this.pyLibPath$1 = pyLibPath$1;
                            }
                        }).toOption();
                        if (pyArchivesFile.exists()) {
                            if (!py4jFile.isEmpty() && ((File)py4jFile.get()).exists()) {
                                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{pyArchivesFile.getAbsolutePath(), ((File)py4jFile.get()).getAbsolutePath()}));
                            } else {
                                InteractiveSession$.MODULE$.warn((Function0<Object>)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply() {
                                        return "py4j-*-src.zip not found; can start pyspark interpreter.";
                                    }
                                });
                                seq = (Seq)Seq$.MODULE$.empty();
                            }
                        } else {
                            InteractiveSession$.MODULE$.warn((Function0<Object>)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "pyspark.zip not found; cannot start pyspark interpreter.";
                                }
                            });
                            seq = (Seq)Seq$.MODULE$.empty();
                        }
                        Seq seq2 = seq;
                        return seq2;
                    }
                }).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Seq<Nothing$> apply() {
                        return (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
                    }
                });
            }
        });
    }

    private final void mergeConfList$1(Seq list, String key, scala.collection.mutable.Map builderProperties$2) {
        if (list.nonEmpty()) {
            Option option = builderProperties$2.get((Object)key);
            if (None$.MODULE$.equals(option)) {
                builderProperties$2.put((Object)key, (Object)list.mkString(","));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (option instanceof Some) {
                String oldList;
                Some some = (Some)option;
                String string = oldList = (String)some.x();
                String newList = list.toList().$colon$colon((Object)string).mkString(",");
                builderProperties$2.put((Object)key, (Object)newList);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)option);
            }
        }
    }

    private final void mergeHiveSiteAndHiveDeps$1(int sparkMajorVersion, scala.collection.immutable.Map conf$1, LivyConf livyConf$2, scala.collection.mutable.Map builderProperties$2) {
        Tuple2 tuple2;
        block5: {
            block3: {
                block4: {
                    block2: {
                        boolean bl;
                        String[] sparkFiles = (String[])conf$1.get((Object)"spark.files").map((Function1)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final String[] apply(String x$14) {
                                return x$14.split(",");
                            }
                        }).getOrElse((Function0)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final String[] apply() {
                                return (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
                            }
                        });
                        tuple2 = this.hiveSiteFile$1(sparkFiles, livyConf$2);
                        if (tuple2 == null || !(bl = tuple2._2$mcZ$sp())) break block2;
                        this.debug((Function0<Object>)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "Enable HiveContext because hive-site.xml is found in user request.";
                            }
                        });
                        this.mergeConfList$1(this.datanucleusJars$1(livyConf$2, sparkMajorVersion), LivyConf$.MODULE$.SPARK_JARS(), builderProperties$2);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block3;
                    }
                    if (tuple2 == null) break block4;
                    Option option = (Option)tuple2._1();
                    boolean bl = tuple2._2$mcZ$sp();
                    if (!(option instanceof Some)) break block4;
                    Some some = (Some)option;
                    File file = (File)some.x();
                    if (bl) break block4;
                    this.debug((Function0<Object>)new Serializable(file){
                        public static final long serialVersionUID = 0L;
                        private final File file$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)"Enable HiveContext because hive-site.xml is found under classpath, ").append((Object)this.file$1.getAbsolutePath()).toString();
                        }
                        {
                            this.file$1 = file$1;
                        }
                    });
                    this.mergeConfList$1((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{file.getAbsolutePath()})), LivyConf$.MODULE$.SPARK_FILES(), builderProperties$2);
                    this.mergeConfList$1(this.datanucleusJars$1(livyConf$2, sparkMajorVersion), LivyConf$.MODULE$.SPARK_JARS(), builderProperties$2);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (tuple2 == null) break block5;
                Option option = (Option)tuple2._1();
                boolean bl = tuple2._2$mcZ$sp();
                if (!None$.MODULE$.equals(option) || bl) break block5;
                this.warn((Function0<Object>)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Enable HiveContext but no hive-site.xml found under classpath or user request.";
                    }
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private InteractiveSession$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.SPARK_YARN_IS_PYTHON = "spark.yarn.isPython";
        this.RECOVERY_SESSION_TYPE = "interactive";
    }
}

