/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.trino.connector.catalog.jdbc.postgresql;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.type.CharType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.VarcharType;
import org.apache.gravitino.rel.types.Type;
import org.apache.gravitino.rel.types.Types;
import org.apache.gravitino.trino.connector.GravitinoErrorCode;
import org.apache.gravitino.trino.connector.util.GeneralDataTypeTransformer;

public class PostgreSQLDataTypeTransformer
extends GeneralDataTypeTransformer {
    private static final int POSTGRESQL_CHAR_LENGTH_LIMIT = 0xA00000;
    private static final int POSTGRESQL_VARCHAR_LENGTH_LIMIT = 0xA00000;

    @Override
    public io.trino.spi.type.Type getTrinoType(Type type) {
        if (type.name() == Type.Name.STRING) {
            return VarcharType.createUnboundedVarcharType();
        }
        if (Type.Name.TIMESTAMP == type.name()) {
            Types.TimestampType timestampType = (Types.TimestampType)type;
            if (timestampType.hasTimeZone()) {
                return TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS;
            }
            return TimestampType.TIMESTAMP_MICROS;
        }
        if (Type.Name.TIME == type.name()) {
            return TimeType.TIME_MICROS;
        }
        return super.getTrinoType(type);
    }

    @Override
    public Type getGravitinoType(io.trino.spi.type.Type type) {
        Class<?> typeClass = type.getClass();
        if (typeClass == CharType.class) {
            CharType charType = (CharType)type;
            if (charType.getLength() == 0) {
                throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_ILLEGAL_ARGUMENT, "PostgreSQL does not support the datatype CHAR with the length 0");
            }
            return Types.FixedCharType.of((int)charType.getLength());
        }
        if (typeClass == VarcharType.class) {
            VarcharType varcharType = (VarcharType)type;
            if (varcharType.getLength().isEmpty()) {
                return Types.StringType.get();
            }
            return Types.VarCharType.of((int)((Integer)varcharType.getLength().get()));
        }
        return super.getGravitinoType(type);
    }
}

