/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.dev.failsafe.internal;

import io.trino.jdbc.$internal.dev.failsafe.RateLimiter;
import io.trino.jdbc.$internal.dev.failsafe.RateLimiterConfig;
import io.trino.jdbc.$internal.dev.failsafe.internal.BurstyRateLimiterStats;
import io.trino.jdbc.$internal.dev.failsafe.internal.RateLimiterExecutor;
import io.trino.jdbc.$internal.dev.failsafe.internal.RateLimiterStats;
import io.trino.jdbc.$internal.dev.failsafe.internal.SmoothRateLimiterStats;
import io.trino.jdbc.$internal.dev.failsafe.internal.util.Assert;
import io.trino.jdbc.$internal.dev.failsafe.internal.util.Durations;
import io.trino.jdbc.$internal.dev.failsafe.spi.PolicyExecutor;
import java.time.Duration;
import java.util.concurrent.TimeUnit;

public class RateLimiterImpl<R>
implements RateLimiter<R> {
    private final RateLimiterConfig<R> config;
    private final RateLimiterStats stats;

    public RateLimiterImpl(RateLimiterConfig<R> config) {
        this(config, new RateLimiterStats.Stopwatch());
    }

    RateLimiterImpl(RateLimiterConfig<R> config, RateLimiterStats.Stopwatch stopwatch) {
        this.config = config;
        this.stats = config.getMaxRate() != null ? new SmoothRateLimiterStats(config, stopwatch) : new BurstyRateLimiterStats(config, stopwatch);
    }

    @Override
    public RateLimiterConfig<R> getConfig() {
        return this.config;
    }

    @Override
    public void acquirePermits(int permits) throws InterruptedException {
        long waitNanos = this.reservePermits(permits).toNanos();
        if (waitNanos > 0L) {
            TimeUnit.NANOSECONDS.sleep(waitNanos);
        }
    }

    @Override
    public Duration reservePermits(int permits) {
        Assert.isTrue(permits > 0, "permits must be > 0", new Object[0]);
        return Duration.ofNanos(this.stats.acquirePermits(permits, null));
    }

    @Override
    public boolean tryAcquirePermits(int permits) {
        return this.reservePermits(permits, Duration.ZERO) == 0L;
    }

    @Override
    public boolean tryAcquirePermits(int permits, Duration maxWaitTime) throws InterruptedException {
        long waitNanos = this.reservePermits(permits, maxWaitTime);
        if (waitNanos == -1L) {
            return false;
        }
        if (waitNanos > 0L) {
            TimeUnit.NANOSECONDS.sleep(waitNanos);
        }
        return true;
    }

    @Override
    public Duration tryReservePermits(int permits, Duration maxWaitTime) {
        return Duration.ofNanos(this.reservePermits(permits, maxWaitTime));
    }

    @Override
    public PolicyExecutor<R> toExecutor(int policyIndex) {
        return new RateLimiterExecutor(this, policyIndex);
    }

    long reservePermits(int permits, Duration maxWaitTime) {
        Assert.isTrue(permits > 0, "permits must be > 0", new Object[0]);
        Assert.notNull(maxWaitTime, "maxWaitTime");
        return this.stats.acquirePermits(permits, Durations.ofSafeNanos(maxWaitTime));
    }
}

