/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.trino.connector.catalog.jdbc.mysql;

import io.trino.spi.session.PropertyMetadata;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.gravitino.catalog.property.PropertyConverter;
import org.apache.gravitino.trino.connector.catalog.CatalogConnectorAdapter;
import org.apache.gravitino.trino.connector.catalog.CatalogConnectorMetadataAdapter;
import org.apache.gravitino.trino.connector.catalog.HasPropertyMeta;
import org.apache.gravitino.trino.connector.catalog.jdbc.JDBCCatalogPropertyConverter;
import org.apache.gravitino.trino.connector.catalog.jdbc.mysql.MySQLMetadataAdapter;
import org.apache.gravitino.trino.connector.catalog.jdbc.mysql.MySQLPropertyMeta;
import org.apache.gravitino.trino.connector.metadata.GravitinoCatalog;

public class MySQLConnectorAdapter
implements CatalogConnectorAdapter {
    private static final String CONNECTOR_MYSQL = "mysql";
    private final PropertyConverter catalogConverter = new JDBCCatalogPropertyConverter();
    private final HasPropertyMeta propertyMetadata = new MySQLPropertyMeta();

    @Override
    public Map<String, String> buildInternalConnectorConfig(GravitinoCatalog catalog) throws Exception {
        return this.catalogConverter.gravitinoToEngineProperties(catalog.getProperties());
    }

    @Override
    public String internalConnectorName() {
        return CONNECTOR_MYSQL;
    }

    @Override
    public CatalogConnectorMetadataAdapter getMetadataAdapter() {
        return new MySQLMetadataAdapter(this.getSchemaProperties(), this.getTableProperties(), Collections.emptyList());
    }

    @Override
    public List<PropertyMetadata<?>> getTableProperties() {
        return this.propertyMetadata.getTablePropertyMetadata();
    }

    @Override
    public List<PropertyMetadata<?>> getColumnProperties() {
        return this.propertyMetadata.getColumnPropertyMetadata();
    }
}

