/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basecluster.memberlist;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Expiry;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.Scheduler;
import java.net.InetSocketAddress;
import java.time.Duration;
import org.apache.bifromq.basecluster.memberlist.IHostAddressResolver;
import org.apache.bifromq.basecluster.membership.proto.HostEndpoint;
import org.checkerframework.checker.index.qual.NonNegative;

public class HostAddressResolver
implements IHostAddressResolver {
    private final LoadingCache<HostEndpoint, InetSocketAddress> hostAddressCache;

    public HostAddressResolver(final Duration expiryInterval, Duration refreshInterval) {
        this.hostAddressCache = Caffeine.newBuilder().scheduler(Scheduler.systemScheduler()).expireAfter((Expiry)new Expiry<HostEndpoint, InetSocketAddress>(){

            public long expireAfterCreate(HostEndpoint key, InetSocketAddress value, long currentTime) {
                if (value.isUnresolved()) {
                    return 0L;
                }
                return expiryInterval.toNanos();
            }

            public long expireAfterUpdate(HostEndpoint key, InetSocketAddress value, long currentTime, @NonNegative long currentDuration) {
                if (value.isUnresolved()) {
                    return 0L;
                }
                return expiryInterval.toNanos();
            }

            public long expireAfterRead(HostEndpoint key, InetSocketAddress value, long currentTime, @NonNegative long currentDuration) {
                return expiryInterval.toNanos();
            }
        }).refreshAfterWrite(refreshInterval).build(key -> new InetSocketAddress(key.getAddress(), key.getPort()));
    }

    @Override
    public InetSocketAddress resolve(HostEndpoint endpoint) {
        return (InetSocketAddress)this.hostAddressCache.get((Object)endpoint);
    }
}

