/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.store.range;

import com.google.protobuf.ByteString;
import org.apache.bifromq.basekv.proto.Boundary;
import org.apache.bifromq.basekv.store.api.IKVWriter;
import org.apache.bifromq.basekv.store.range.IKVLoadRecorder;

class LoadRecordableKVWriter
implements IKVWriter {
    private final IKVWriter delegate;
    private final IKVLoadRecorder recorder;

    public LoadRecordableKVWriter(IKVWriter delegate, IKVLoadRecorder recorder) {
        this.delegate = delegate;
        this.recorder = recorder;
    }

    public void delete(ByteString key) {
        long start = System.nanoTime();
        this.delegate.delete(key);
        this.recorder.record(key, System.nanoTime() - start);
    }

    public void clear(Boundary boundary) {
        long start = System.nanoTime();
        this.delegate.clear(boundary);
        this.recorder.record(System.nanoTime() - start);
    }

    public void insert(ByteString key, ByteString value) {
        long start = System.nanoTime();
        this.delegate.insert(key, value);
        this.recorder.record(key, System.nanoTime() - start);
    }

    public void put(ByteString key, ByteString value) {
        long start = System.nanoTime();
        this.delegate.put(key, value);
        this.recorder.record(key, System.nanoTime() - start);
    }
}

