/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.server;

import com.google.common.base.Preconditions;
import io.grpc.ServerServiceDefinition;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.bifromq.basekv.RPCBluePrint;
import org.apache.bifromq.basekv.server.BaseKVStoreServerBuilder;
import org.apache.bifromq.basekv.server.BaseKVStoreService;
import org.apache.bifromq.basekv.server.BaseKVStoreServiceBuilder;
import org.apache.bifromq.basekv.server.IBaseKVStoreServer;
import org.apache.bifromq.baserpc.BluePrint;
import org.apache.bifromq.baserpc.server.RPCServerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BaseKVStoreServer
implements IBaseKVStoreServer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseKVStoreServer.class);
    private final AtomicReference<State> state = new AtomicReference<State>(State.INIT);
    private final Map<String, BaseKVStoreService> storeServiceMap = new HashMap<String, BaseKVStoreService>();
    protected final Set<BindableStoreService> bindableStoreServices = new HashSet<BindableStoreService>();

    BaseKVStoreServer(BaseKVStoreServerBuilder builder) {
        for (BaseKVStoreServiceBuilder serviceBuilder : builder.serviceBuilders.values()) {
            BaseKVStoreService storeService = new BaseKVStoreService(serviceBuilder);
            this.bindableStoreServices.add(new BindableStoreService(storeService, serviceBuilder.rpcExecutor));
            this.storeServiceMap.put(storeService.clusterId(), storeService);
        }
        RPCServerBuilder rpcServerBuilder = builder.rpcServerBuilder;
        for (BindableStoreService bindable : this.bindableStoreServices) {
            rpcServerBuilder.bindService(bindable.serviceDefinition, bindable.bluePrint, bindable.metadata, Collections.emptySet(), bindable.executor);
        }
    }

    @Override
    public final String storeId(String clusterId) {
        Preconditions.checkState((this.state.get() == State.STARTED ? 1 : 0) != 0);
        return this.storeServiceMap.get(clusterId).storeId();
    }

    @Override
    public final void start() {
        if (this.state.compareAndSet(State.INIT, State.STARTING)) {
            try {
                log.debug("Starting BaseKVStore server for '{}'", this.storeServiceMap.keySet());
                this.storeServiceMap.values().forEach(BaseKVStoreService::start);
                log.debug("BaseKVStore server for '{}' started", this.storeServiceMap.keySet());
                this.state.set(State.STARTED);
            }
            catch (Throwable e) {
                this.state.set(State.FATAL_FAILURE);
                throw e;
            }
        }
    }

    @Override
    public void stop() {
        if (this.state.compareAndSet(State.STARTED, State.STOPPING)) {
            try {
                log.debug("Stopping BaseKVStore server[{}]", this.storeServiceMap.keySet());
                this.storeServiceMap.values().forEach(BaseKVStoreService::stop);
            }
            catch (Throwable e) {
                log.error("Failed to stop BaseKVStore server[{}]", this.storeServiceMap.keySet(), (Object)e);
            }
            finally {
                log.debug("BaseKVStore server[{}] stopped", this.storeServiceMap.keySet());
                this.state.set(State.STOPPED);
            }
        }
    }

    private static enum State {
        INIT,
        STARTING,
        STARTED,
        FATAL_FAILURE,
        STOPPING,
        STOPPED;

    }

    protected static class BindableStoreService {
        final ServerServiceDefinition serviceDefinition;
        final BluePrint bluePrint;
        final Map<String, String> metadata;
        final Executor executor;

        BindableStoreService(BaseKVStoreService storeService, Executor executor) {
            this.serviceDefinition = RPCBluePrint.scope((ServerServiceDefinition)storeService.bindService(), (String)storeService.clusterId());
            this.bluePrint = RPCBluePrint.build((String)storeService.clusterId());
            this.metadata = Collections.singletonMap("store_id", storeService.storeId());
            this.executor = executor;
        }
    }
}

