/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.raft;

import java.util.HashMap;
import java.util.Map;
import org.apache.bifromq.basekv.raft.IRaftNodeState;
import org.apache.bifromq.basekv.raft.proto.ClusterConfig;
import org.apache.bifromq.logger.MDCLogger;

class RaftLogger
extends MDCLogger {
    private static final String MDC_KEY_ID = "id";
    private static final String MDC_KEY_STATE = "state";
    private static final String MDC_KEY_LEADER = "leader";
    private static final String MDC_KEY_TERM = "term";
    private static final String MDC_KEY_FIRST = "first";
    private static final String MDC_KEY_LAST = "last";
    private static final String MDC_KEY_COMMIT = "commit";
    private static final String MDC_KEY_CONFIG = "config";
    private final IRaftNodeState state;
    private final ThreadLocal<Map<String, String>> extraContext = ThreadLocal.withInitial(HashMap::new);

    protected RaftLogger(IRaftNodeState state, String ... tags) {
        super(state.getClass().getName(), tags);
        this.state = state;
    }

    protected Map<String, String> extraContext() {
        Map<String, String> extraCtx = this.extraContext.get();
        extraCtx.put(MDC_KEY_ID, this.state.id());
        extraCtx.put(MDC_KEY_STATE, this.state.getState().name());
        extraCtx.put(MDC_KEY_LEADER, this.state.currentLeader());
        extraCtx.put(MDC_KEY_TERM, Long.toUnsignedString(this.state.currentTerm()));
        extraCtx.put(MDC_KEY_FIRST, Long.toUnsignedString(this.state.firstIndex()));
        extraCtx.put(MDC_KEY_LAST, Long.toUnsignedString(this.state.lastIndex()));
        extraCtx.put(MDC_KEY_COMMIT, Long.toUnsignedString(this.state.commitIndex()));
        extraCtx.put(MDC_KEY_CONFIG, this.printClusterConfig(this.state.latestClusterConfig()));
        return extraCtx;
    }

    private String printClusterConfig(ClusterConfig clusterConfig) {
        return String.format("[c:%s,v:%s,l:%s,nv:%s,nl:%s]", clusterConfig.getCorrelateId(), clusterConfig.getVotersList(), clusterConfig.getLearnersList(), clusterConfig.getNextVotersList(), clusterConfig.getNextLearnersList());
    }
}

