/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.raft;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.bifromq.basekv.raft.IRaftStateStore;
import org.apache.bifromq.basekv.raft.PeerLogTracker;
import org.apache.bifromq.basekv.raft.RaftConfig;
import org.apache.bifromq.basekv.raft.exception.ClusterConfigChangeException;
import org.apache.bifromq.basekv.raft.proto.ClusterConfig;
import org.apache.bifromq.basekv.raft.proto.LogEntry;
import org.apache.bifromq.basekv.raft.proto.RaftNodeSyncState;
import org.slf4j.Logger;

class RaftConfigChanger {
    private final RaftConfig config;
    private final IRaftStateStore stateStorage;
    private final PeerLogTracker peerLogTracker;
    private final Logger logger;
    private volatile State state = State.Waiting;
    private volatile CompletableFuture<Void> onDone;
    private long catchingUpElapsedTick = 0L;
    private long jointConfigIndex = 0L;
    private long targetConfigIndex = 0L;
    private ClusterConfig fallbackConfig;
    private ClusterConfig jointConfig;
    private ClusterConfig targetConfig;

    RaftConfigChanger(RaftConfig config, IRaftStateStore stateStorage, PeerLogTracker peerLogTracker, Logger logger) {
        this.config = config;
        this.stateStorage = stateStorage;
        this.peerLogTracker = peerLogTracker;
        this.logger = logger;
    }

    public State state() {
        return this.state;
    }

    public void submit(String correlateId, Set<String> nextVoters, Set<String> nextLearners, CompletableFuture<Void> onDone) {
        assert (this.state != State.Abort);
        try {
            if (this.state != State.Waiting) {
                throw ClusterConfigChangeException.concurrentChange();
            }
            if (nextVoters.isEmpty()) {
                throw ClusterConfigChangeException.emptyVoters();
            }
            if (this.isIntersect(nextVoters, nextLearners)) {
                throw ClusterConfigChangeException.learnersOverlap();
            }
            this.onDone = onDone;
            ClusterConfig latestConfig = this.stateStorage.latestClusterConfig();
            HashSet<String> allVoters = new HashSet<String>((Collection<String>)latestConfig.getNextVotersList());
            allVoters.addAll(nextVoters);
            HashSet<String> allLearners = new HashSet<String>((Collection<String>)latestConfig.getNextLearnersList());
            allLearners.addAll(nextLearners);
            this.fallbackConfig = latestConfig.toBuilder().setCorrelateId(correlateId).build();
            this.jointConfig = ClusterConfig.newBuilder().setCorrelateId(correlateId).addAllVoters((Iterable)latestConfig.getVotersList()).addAllLearners((Iterable)latestConfig.getLearnersList()).addAllNextVoters(allVoters).addAllNextLearners(allLearners).build();
            this.targetConfig = ClusterConfig.newBuilder().setCorrelateId(correlateId).addAllVoters(nextVoters).addAllLearners(nextLearners).build();
            HashSet<String> peersToStartTracking = new HashSet<String>(nextVoters);
            peersToStartTracking.addAll(nextLearners);
            this.peerLogTracker.startTracking(peersToStartTracking, true);
            this.catchingUpElapsedTick = 0L;
            this.jointConfigIndex = 0L;
            this.targetConfigIndex = 0L;
            this.state = State.CatchingUp;
        }
        catch (Throwable e) {
            onDone.completeExceptionally(e);
        }
    }

    public boolean tick(long currentTerm) {
        assert (this.state != State.Abort);
        if (this.state == State.CatchingUp) {
            ++this.catchingUpElapsedTick;
            if (this.catchingUpElapsedTick >= (long)this.config.getInstallSnapshotTimeoutTick() + 10L * (long)this.config.getElectionTimeoutTick()) {
                this.logger.debug("Catching up timeout, revert to previous config: correlateId={}", (Object)this.fallbackConfig.getCorrelateId());
                HashSet<String> peersToStopTracking = new HashSet<String>((Collection<String>)this.jointConfig.getNextVotersList());
                peersToStopTracking.addAll((Collection<String>)this.jointConfig.getNextLearnersList());
                peersToStopTracking.removeIf(arg_0 -> this.jointConfig.getVotersList().contains(arg_0));
                peersToStopTracking.removeIf(arg_0 -> this.jointConfig.getLearnersList().contains(arg_0));
                this.peerLogTracker.stopTracking(peersToStopTracking);
                this.targetConfigIndex = this.stateStorage.lastIndex() + 1L;
                LogEntry fallbackConfigEntry = LogEntry.newBuilder().setTerm(currentTerm).setIndex(this.targetConfigIndex).setConfig(this.fallbackConfig).build();
                this.stateStorage.append(Collections.singletonList(fallbackConfigEntry), true);
                this.peerLogTracker.replicateBy(this.stateStorage.local(), this.stateStorage.lastIndex());
                this.state = State.FallbackConfigCommitting;
                this.onDone.completeExceptionally(ClusterConfigChangeException.slowLearner());
                return true;
            }
            if (this.peersCatchUp()) {
                if (this.noChangeJoint(this.jointConfig)) {
                    this.targetConfigIndex = this.stateStorage.lastIndex() + 1L;
                    this.logger.debug("Peers have caught up, append target config as log entry[index={}]", (Object)this.targetConfigIndex);
                    LogEntry targetConfigEntry = LogEntry.newBuilder().setTerm(currentTerm).setIndex(this.targetConfigIndex).setConfig(this.targetConfig).build();
                    this.stateStorage.append(Collections.singletonList(targetConfigEntry), true);
                    this.peerLogTracker.replicateBy(this.stateStorage.local(), this.stateStorage.lastIndex());
                    this.state = State.TargetConfigCommitting;
                } else {
                    this.jointConfigIndex = this.stateStorage.lastIndex() + 1L;
                    this.logger.debug("Peers have caught up, append joint config as log entry[index={}]", (Object)this.jointConfigIndex);
                    LogEntry jointConfigEntry = LogEntry.newBuilder().setTerm(currentTerm).setIndex(this.jointConfigIndex).setConfig(this.jointConfig).build();
                    this.stateStorage.append(Collections.singletonList(jointConfigEntry), true);
                    this.peerLogTracker.replicateBy(this.stateStorage.local(), this.stateStorage.lastIndex());
                    this.state = State.JointConfigCommitting;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean commitTo(long commitIndex, long currentTerm) {
        assert (this.state != State.Abort);
        return switch (this.state) {
            case State.JointConfigCommitting -> {
                if (commitIndex >= this.jointConfigIndex) {
                    this.targetConfigIndex = this.stateStorage.lastIndex() + 1L;
                    if (!$assertionsDisabled && commitIndex >= this.targetConfigIndex) {
                        throw new AssertionError();
                    }
                    LogEntry targetConfigEntry = LogEntry.newBuilder().setTerm(currentTerm).setIndex(this.targetConfigIndex).setConfig(this.targetConfig).build();
                    this.stateStorage.append(Collections.singletonList(targetConfigEntry), true);
                    this.peerLogTracker.replicateBy(this.stateStorage.local(), this.stateStorage.lastIndex());
                    this.state = State.TargetConfigCommitting;
                    this.logger.debug("Joint config committed, append target config as log entry[index={}]", (Object)this.targetConfigIndex);
                    yield true;
                }
                yield false;
            }
            case State.TargetConfigCommitting -> {
                if (commitIndex >= this.targetConfigIndex) {
                    this.state = State.Waiting;
                    this.logger.debug("Target config committed at index[{}]", (Object)this.targetConfigIndex);
                    yield true;
                }
                yield false;
            }
            case State.FallbackConfigCommitting -> {
                if (commitIndex >= this.targetConfigIndex) {
                    this.state = State.Waiting;
                    this.logger.debug("Fallback config committed at index[{}]", (Object)this.targetConfigIndex);
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public void confirmCommit(boolean notifyRepStatus) {
        assert (this.state == State.Waiting && this.targetConfig != null);
        this.peerLogTracker.stopTracking(peerId -> !this.targetConfig.getVotersList().contains(peerId) && !this.targetConfig.getLearnersList().contains(peerId), notifyRepStatus);
        this.onDone.complete(null);
    }

    protected Set<String> remotePeers() {
        HashSet<String> all = new HashSet<String>();
        switch (this.state) {
            case Waiting: {
                ClusterConfig clusterConfig = this.stateStorage.latestClusterConfig();
                all.addAll((Collection<String>)clusterConfig.getVotersList());
                all.addAll((Collection<String>)clusterConfig.getLearnersList());
                all.remove(this.stateStorage.local());
                break;
            }
            case JointConfigCommitting: 
            case TargetConfigCommitting: 
            case FallbackConfigCommitting: 
            case CatchingUp: {
                all.addAll((Collection<String>)this.jointConfig.getVotersList());
                all.addAll((Collection<String>)this.jointConfig.getLearnersList());
                all.addAll((Collection<String>)this.jointConfig.getNextVotersList());
                all.addAll((Collection<String>)this.jointConfig.getNextLearnersList());
                all.remove(this.stateStorage.local());
                break;
            }
        }
        return all;
    }

    public ClusterConfig prevConfig() {
        return this.jointConfig;
    }

    public void abort(ClusterConfigChangeException e) {
        assert (this.state != State.Abort);
        switch (this.state) {
            case Waiting: {
                this.state = State.Abort;
                break;
            }
            case JointConfigCommitting: 
            case TargetConfigCommitting: 
            case FallbackConfigCommitting: 
            case CatchingUp: {
                this.logger.debug("Abort on-going cluster config change");
                this.state = State.Abort;
                this.onDone.completeExceptionally(e);
                break;
            }
        }
    }

    boolean peersCatchUp() {
        HashSet<String> remotePeers = new HashSet<String>((Collection<String>)this.jointConfig.getNextVotersList());
        return this.quorumCatchUp(remotePeers);
    }

    boolean quorumCatchUp(Set<String> peerIds) {
        long lastIndex = this.stateStorage.lastIndex();
        int nonCatchUpCount = 0;
        for (String peerId : peerIds) {
            if (this.peerLogTracker.status(peerId) != RaftNodeSyncState.Replicating) {
                ++nonCatchUpCount;
                continue;
            }
            long matchIndex = this.peerLogTracker.matchIndex(peerId);
            if (lastIndex == matchIndex) continue;
            if (this.peerLogTracker.catchupRate(peerId) > 0L) {
                long notReplicated = lastIndex - matchIndex;
                long ticksRequired = notReplicated / this.peerLogTracker.catchupRate(peerId);
                if (ticksRequired <= (long)this.config.getElectionTimeoutTick()) continue;
                ++nonCatchUpCount;
                continue;
            }
            ++nonCatchUpCount;
        }
        return nonCatchUpCount <= peerIds.size() - (peerIds.size() / 2 + 1);
    }

    boolean noChangeJoint(ClusterConfig clusterConfig) {
        return new HashSet(clusterConfig.getNextVotersList()).equals(new HashSet(clusterConfig.getVotersList())) && new HashSet(clusterConfig.getNextLearnersList()).equals(new HashSet(clusterConfig.getLearnersList()));
    }

    <T> boolean isIntersect(Set<T> s1, Set<T> s2) {
        Set<T> small = s1.size() > s2.size() ? s2 : s1;
        Set<T> large = s1.size() > s2.size() ? s1 : s2;
        for (T item : small) {
            if (!large.contains(item)) continue;
            return true;
        }
        return false;
    }

    static enum State {
        Abort,
        Waiting,
        CatchingUp,
        JointConfigCommitting,
        TargetConfigCommitting,
        FallbackConfigCommitting;

    }
}

