/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.apiserver.http.handler;

import io.reactivex.rxjava3.disposables.CompositeDisposable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.bifromq.apiserver.http.IHTTPRequestHandler;
import org.apache.bifromq.basekv.metaservice.IBaseKVMetaService;
import org.apache.bifromq.basekv.metaservice.IBaseKVStoreBalancerStatesProposer;

abstract class AbstractBalancerStateProposerHandler
implements IHTTPRequestHandler {
    protected final Map<String, IBaseKVStoreBalancerStatesProposer> balancerStateProposers = new ConcurrentHashMap<String, IBaseKVStoreBalancerStatesProposer>();
    private final IBaseKVMetaService metaService;
    private final CompositeDisposable disposable = new CompositeDisposable();

    protected AbstractBalancerStateProposerHandler(IBaseKVMetaService metaService) {
        this.metaService = metaService;
    }

    @Override
    public void start() {
        this.disposable.add(this.metaService.clusterIds().subscribe(clusterIds -> {
            this.balancerStateProposers.keySet().removeIf(clusterId -> !clusterIds.contains(clusterId));
            for (String clusterId2 : clusterIds) {
                this.balancerStateProposers.computeIfAbsent(clusterId2, arg_0 -> ((IBaseKVMetaService)this.metaService).balancerStatesProposer(arg_0));
            }
        }));
    }

    @Override
    public void close() {
        this.disposable.dispose();
        this.balancerStateProposers.values().forEach(IBaseKVStoreBalancerStatesProposer::stop);
    }
}

