/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.    
 */

package org.apache.bifromq.basecrdt.core.api;

import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.ToString;

@AllArgsConstructor(access = AccessLevel.PRIVATE)
@ToString
public final class EWFlagOperation implements ICRDTOperation {
    private static final EWFlagOperation DISABLE = new EWFlagOperation(Type.Disable);
    private static final EWFlagOperation ENABLE = new EWFlagOperation(Type.Enable);
    private static final EWFlagOperation RESET = new EWFlagOperation(Type.Reset);

    public enum Type {
        Disable, Enable, Reset
    }

    public final Type type;

    public static EWFlagOperation disable() {
        return DISABLE;
    }

    public static EWFlagOperation enable() {
        return ENABLE;
    }

    public static EWFlagOperation reset() {
        return RESET;
    }
}
