/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.websession;

import java.sql.Timestamp;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.binary.BinaryRawWriter;
import org.apache.ignite.binary.BinaryReader;
import org.apache.ignite.binary.BinaryWriter;
import org.apache.ignite.binary.Binarylizable;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;

public class PlatformDotNetSessionData
implements Binarylizable {
    private Map<String, byte[]> items;
    @GridToStringExclude
    private byte[] staticObjects;
    private int timeout;
    private long lockId;
    private UUID lockNodeId;
    private Timestamp lockTime;

    public Map<String, byte[]> items() {
        return this.items;
    }

    public byte[] staticObjects() {
        return this.staticObjects;
    }

    public int timeout() {
        return this.timeout;
    }

    public long lockId() {
        return this.lockId;
    }

    public UUID lockNodeId() {
        return this.lockNodeId;
    }

    public Timestamp lockTime() {
        return this.lockTime;
    }

    public boolean isLocked() {
        return this.lockTime != null;
    }

    public PlatformDotNetSessionData lock(UUID lockNodeId, long lockId, Timestamp lockTime) {
        assert (!this.isLocked());
        PlatformDotNetSessionData res = this.copyWithoutLockInfo();
        res.lockId = lockId;
        res.lockNodeId = lockNodeId;
        res.lockTime = lockTime;
        return res;
    }

    public PlatformDotNetSessionData unlock(UUID lockNodeId, long lockId) {
        assert (this.isLocked());
        if (!this.lockNodeId.equals(lockNodeId)) {
            throw new IllegalStateException("Can not unlock session data: lock node id check failed.");
        }
        if (this.lockId != lockId) {
            throw new IllegalStateException("Can not unlock session data: lock id check failed.");
        }
        return this.copyWithoutLockInfo();
    }

    public PlatformDotNetSessionData updateAndUnlock(UUID lockNodeId, long lockId, Map<String, byte[]> items, boolean isDiff, byte[] staticObjects, int timeout) {
        assert (items != null);
        PlatformDotNetSessionData res = this.unlock(lockNodeId, lockId);
        if (!isDiff) {
            this.items.clear();
        }
        for (Map.Entry<String, byte[]> e : items.entrySet()) {
            String key = e.getKey();
            byte[] val = e.getValue();
            if (val != null) {
                this.items.put(key, val);
                continue;
            }
            this.items.remove(key);
        }
        res.staticObjects = staticObjects;
        res.timeout = timeout;
        return res;
    }

    private PlatformDotNetSessionData copyWithoutLockInfo() {
        PlatformDotNetSessionData res = new PlatformDotNetSessionData();
        res.staticObjects = this.staticObjects;
        res.items = this.items;
        res.timeout = this.timeout;
        return res;
    }

    @Override
    public void writeBinary(BinaryWriter writer) throws BinaryObjectException {
        BinaryRawWriter raw = writer.rawWriter();
        this.writeBinary(raw);
    }

    public void writeBinary(BinaryRawWriter writer) {
        writer.writeInt(this.items.size());
        for (Map.Entry<String, byte[]> e : this.items.entrySet()) {
            writer.writeString(e.getKey());
            writer.writeByteArray(e.getValue());
        }
        writer.writeByteArray(this.staticObjects);
        writer.writeInt(this.timeout);
        writer.writeUuid(this.lockNodeId);
        writer.writeLong(this.lockId);
        writer.writeTimestamp(this.lockTime);
    }

    @Override
    public void readBinary(BinaryReader reader) throws BinaryObjectException {
        BinaryRawReader raw = reader.rawReader();
        this.readBinary(raw);
    }

    public void readBinary(BinaryRawReader reader) {
        this.items = new TreeMap<String, byte[]>();
        int cnt = reader.readInt();
        for (int i = 0; i < cnt; ++i) {
            this.items.put(reader.readString(), reader.readByteArray());
        }
        this.staticObjects = reader.readByteArray();
        this.timeout = reader.readInt();
        this.lockNodeId = reader.readUuid();
        this.lockId = reader.readLong();
        this.lockTime = reader.readTimestamp();
    }

    public String toString() {
        return S.toString(PlatformDotNetSessionData.class, this);
    }
}

