/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client.streamer;

import java.util.Collection;
import org.apache.ignite.IgniteException;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.processors.datastreamer.DataStreamerEntry;
import org.apache.ignite.internal.processors.datastreamer.DataStreamerImpl;
import org.apache.ignite.internal.processors.platform.PlatformContext;
import org.apache.ignite.internal.processors.platform.client.ClientConnectionContext;
import org.apache.ignite.internal.processors.platform.client.ClientLongResponse;
import org.apache.ignite.internal.processors.platform.client.ClientResponse;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheRequest;
import org.apache.ignite.internal.processors.platform.client.streamer.ClientDataStreamerHandle;
import org.apache.ignite.internal.processors.platform.client.streamer.ClientDataStreamerReader;
import org.apache.ignite.internal.processors.platform.client.streamer.ClientDataStreamerRequest;
import org.apache.ignite.stream.StreamReceiver;

public class ClientDataStreamerStartRequest
extends ClientDataStreamerRequest {
    private final int cacheId;
    private final byte flags;
    private final int perNodeBufferSize;
    private final int perThreadBufferSize;
    private final Object receiverObj;
    private final byte receiverPlatform;
    private final Collection<DataStreamerEntry> entries;

    public ClientDataStreamerStartRequest(BinaryReaderExImpl reader) {
        super(reader);
        this.cacheId = reader.readInt();
        this.flags = reader.readByte();
        this.perNodeBufferSize = reader.readInt();
        this.perThreadBufferSize = reader.readInt();
        this.receiverObj = reader.readObjectDetached();
        this.receiverPlatform = this.receiverObj == null ? (byte)0 : reader.readByte();
        this.entries = ClientDataStreamerReader.read(reader);
    }

    @Override
    public ClientResponse process(ClientConnectionContext ctx) {
        String cacheName = ClientCacheRequest.cacheDescriptor(ctx, this.cacheId).cacheName();
        DataStreamerImpl dataStreamer = (DataStreamerImpl)ctx.kernalContext().grid().dataStreamer(cacheName);
        try {
            boolean useThreadBuf;
            boolean close = (this.flags & 0x10) != 0;
            boolean keepBinary = (this.flags & 4) != 0;
            boolean flush = (this.flags & 8) != 0;
            boolean allowOverwrite = (this.flags & 1) != 0;
            boolean skipStore = (this.flags & 2) != 0;
            boolean bl = useThreadBuf = !close;
            if (this.perNodeBufferSize >= 0) {
                dataStreamer.perNodeBufferSize(this.perNodeBufferSize);
            } else if (this.entries != null && !this.entries.isEmpty() && close) {
                dataStreamer.perNodeBufferSize(this.entries.size());
            }
            if (this.perThreadBufferSize >= 0 && useThreadBuf) {
                dataStreamer.perThreadBufferSize(this.perThreadBufferSize);
            }
            dataStreamer.allowOverwrite(allowOverwrite);
            dataStreamer.skipStore(skipStore);
            dataStreamer.keepBinary(keepBinary);
            if (this.receiverObj != null) {
                dataStreamer.receiver(ClientDataStreamerStartRequest.createReceiver(ctx.kernalContext(), this.receiverObj, this.receiverPlatform, keepBinary));
            }
            if (this.entries != null) {
                dataStreamer.addDataInternal(this.entries, useThreadBuf);
            }
            if (flush) {
                dataStreamer.flush();
            }
            if (close) {
                dataStreamer.close();
                return new ClientLongResponse(this.requestId(), 0L);
            }
            long rsrcId = ctx.resources().put(new ClientDataStreamerHandle(dataStreamer));
            return new ClientLongResponse(this.requestId(), rsrcId);
        }
        catch (IllegalStateException unused) {
            return this.getInvalidNodeStateResponse();
        }
    }

    private static StreamReceiver createReceiver(GridKernalContext ctx, Object receiverObj, byte platform, boolean keepBinary) {
        if (receiverObj == null) {
            return null;
        }
        switch (platform) {
            case 1: {
                return (StreamReceiver)((BinaryObject)receiverObj).deserialize();
            }
            case 2: {
                PlatformContext platformCtx = ctx.platform().context();
                String curPlatform = platformCtx.platform();
                if (!"dotnet".equals(curPlatform)) {
                    throw new IgniteException("Stream receiver platform is dotnet, current platform is " + curPlatform);
                }
                return platformCtx.createStreamReceiver(receiverObj, 0L, keepBinary);
            }
        }
        throw new UnsupportedOperationException("Invalid stream receiver platform code: " + platform);
    }
}

