/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.thin;

import java.util.BitSet;
import java.util.Collection;
import java.util.EnumSet;

public enum ProtocolBitmaskFeature {
    USER_ATTRIBUTES(0),
    EXECUTE_TASK_BY_NAME(1),
    CLUSTER_STATES(2),
    CLUSTER_GROUP_GET_NODES_ENDPOINTS(3),
    CLUSTER_GROUPS(4),
    SERVICE_INVOKE(5),
    DEFAULT_QRY_TIMEOUT(6),
    QRY_PARTITIONS_BATCH_SIZE(7),
    BINARY_CONFIGURATION(8),
    GET_SERVICE_DESCRIPTORS(9),
    SERVICE_INVOKE_CALLCTX(10),
    HEARTBEAT(11),
    DATA_REPLICATION_OPERATIONS(12),
    ALL_AFFINITY_MAPPINGS(13),
    INDEX_QUERY(14),
    INDEX_QUERY_LIMIT(15),
    SERVICE_TOPOLOGY(16),
    CACHE_INVOKE(17),
    TX_AWARE_QUERIES(18),
    FORCE_DEACTIVATION_FLAG(19);

    private static final EnumSet<ProtocolBitmaskFeature> ALL_FEATURES_AS_ENUM_SET;
    private final int featureId;

    private ProtocolBitmaskFeature(int id) {
        this.featureId = id;
    }

    public int featureId() {
        return this.featureId;
    }

    public static EnumSet<ProtocolBitmaskFeature> enumSet(byte[] bytes) {
        EnumSet<ProtocolBitmaskFeature> set = EnumSet.noneOf(ProtocolBitmaskFeature.class);
        if (bytes == null) {
            return set;
        }
        BitSet bSet = BitSet.valueOf(bytes);
        for (ProtocolBitmaskFeature e : ProtocolBitmaskFeature.values()) {
            if (!bSet.get(e.featureId())) continue;
            set.add(e);
        }
        return set;
    }

    static byte[] featuresAsBytes(Collection<ProtocolBitmaskFeature> features) {
        BitSet set = new BitSet();
        for (ProtocolBitmaskFeature f : features) {
            set.set(f.featureId());
        }
        return set.toByteArray();
    }

    public static EnumSet<ProtocolBitmaskFeature> allFeaturesAsEnumSet() {
        return ALL_FEATURES_AS_ENUM_SET.clone();
    }

    static {
        ALL_FEATURES_AS_ENUM_SET = EnumSet.allOf(ProtocolBitmaskFeature.class);
    }
}

