/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.graph.id;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.UUID;
import org.apache.hugegraph.computer.core.common.SerialEnum;
import org.apache.hugegraph.computer.core.common.exception.ComputerException;
import org.apache.hugegraph.computer.core.graph.id.Id;
import org.apache.hugegraph.computer.core.graph.id.IdType;

public final class IdFactory {
    private static final Constructor<?> BYTES_ID_CONSTRUCTOR;
    private static final Method BYTES_ID_LONG_METHOD;
    private static final Method BYTES_ID_STRING_METHOD;
    private static final Method BYTES_ID_UUID_METHOD;
    private static final UUID EMPTY_UUID;

    public static Id createId(byte code) {
        IdType type = SerialEnum.fromCode(IdType.class, code);
        return IdFactory.createId(type);
    }

    public static Id createId(IdType type) {
        try {
            switch (type) {
                case LONG: {
                    return (Id)BYTES_ID_LONG_METHOD.invoke(null, 0L);
                }
                case UTF8: {
                    return (Id)BYTES_ID_STRING_METHOD.invoke(null, "");
                }
                case UUID: {
                    return (Id)BYTES_ID_UUID_METHOD.invoke(null, EMPTY_UUID);
                }
            }
            throw new ComputerException("Can't create Id for %s", type.name());
        }
        catch (Exception e) {
            throw new ComputerException("Failed to createId", e);
        }
    }

    public static Id createId() {
        try {
            return (Id)BYTES_ID_CONSTRUCTOR.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new ComputerException("Can't create Id for %s");
        }
    }

    static {
        EMPTY_UUID = new UUID(0L, 0L);
        try {
            Class<?> bytesIdClass = Class.forName("org.apache.hugegraph.computer.core.graph.id.BytesId");
            BYTES_ID_CONSTRUCTOR = bytesIdClass.getDeclaredConstructor(new Class[0]);
            BYTES_ID_CONSTRUCTOR.setAccessible(true);
            BYTES_ID_LONG_METHOD = bytesIdClass.getMethod("of", Long.TYPE);
            BYTES_ID_LONG_METHOD.setAccessible(false);
            BYTES_ID_STRING_METHOD = bytesIdClass.getMethod("of", String.class);
            BYTES_ID_STRING_METHOD.setAccessible(false);
            BYTES_ID_UUID_METHOD = bytesIdClass.getMethod("of", UUID.class);
            BYTES_ID_UUID_METHOD.setAccessible(false);
        }
        catch (Throwable e) {
            throw new ComputerException("Failed to reflection BytesId method", e);
        }
    }
}

