/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.network.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hugegraph.computer.core.network.buffer.NetworkBuffer;

public class NioBuffer
implements NetworkBuffer {
    private final ByteBuffer buffer;
    private final AtomicInteger referenceCount;

    public NioBuffer(ByteBuffer buffer) {
        this.buffer = buffer;
        this.referenceCount = new AtomicInteger(1);
    }

    @Override
    public int length() {
        return this.buffer.remaining();
    }

    @Override
    public NetworkBuffer retain() {
        this.referenceCount.incrementAndGet();
        return this;
    }

    @Override
    public NetworkBuffer release() {
        this.referenceCount.decrementAndGet();
        return this;
    }

    @Override
    public int referenceCount() {
        return this.referenceCount.get();
    }

    @Override
    public ByteBuffer nioByteBuffer() {
        return this.buffer.duplicate();
    }

    @Override
    public ByteBuf nettyByteBuf() {
        return Unpooled.wrappedBuffer((ByteBuffer)this.buffer);
    }

    @Override
    public byte[] copyToByteArray() {
        byte[] bytes = new byte[this.buffer.remaining()];
        this.buffer.duplicate().get(bytes);
        return bytes;
    }
}

