/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.aggregator;

import java.util.HashMap;
import java.util.Map;
import org.apache.hugegraph.computer.core.aggregator.Aggregator;
import org.apache.hugegraph.computer.core.aggregator.Aggregators;
import org.apache.hugegraph.computer.core.aggregator.RegisterAggregators;
import org.apache.hugegraph.computer.core.common.ComputerContext;
import org.apache.hugegraph.computer.core.config.Config;
import org.apache.hugegraph.computer.core.graph.value.Value;
import org.apache.hugegraph.computer.core.manager.Manager;
import org.apache.hugegraph.computer.core.rpc.AggregateRpcService;
import org.apache.hugegraph.util.E;

public class WorkerAggrManager
implements Manager {
    public static final String NAME = "worker_aggr";
    private final ComputerContext context;
    private AggregateRpcService service;
    private RegisterAggregators registerAggregators;
    private Map<String, Value> lastAggregators;
    private Aggregators currentAggregators;

    public WorkerAggrManager(ComputerContext context) {
        this.context = context;
        this.service = null;
        this.registerAggregators = new RegisterAggregators();
        this.lastAggregators = new HashMap<String, Value>();
        this.currentAggregators = new Aggregators();
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public void init(Config config) {
        this.registerAggregators = this.service().registeredAggregators();
        this.registerAggregators.repair(this.context);
    }

    @Override
    public void close(Config config) {
        this.registerAggregators.clear();
        this.lastAggregators.clear();
        this.currentAggregators.clear();
    }

    @Override
    public void beforeSuperstep(Config config, int superstep) {
        this.reloadAggregators();
    }

    @Override
    public void afterSuperstep(Config config, int superstep) {
        this.flushAggregators();
    }

    public void service(AggregateRpcService service) {
        E.checkNotNull((Object)service, (String)"service");
        this.service = service;
    }

    public <V extends Value> Aggregator<V> createAggregator(String name) {
        Aggregator<? extends Value> aggr = this.registerAggregators.copy(name);
        return aggr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V extends Value> void aggregateValue(String name, V value) {
        Aggregator aggr;
        E.checkArgument((value != null ? 1 : 0) != 0, (String)"Can't set value to null for aggregator '%s'", (Object[])new Object[]{name});
        Aggregator aggregator = aggr = this.currentAggregators.get(name, this.service());
        synchronized (aggregator) {
            aggr.aggregateValue(value);
        }
    }

    public <V extends Value> V aggregatedValue(String name) {
        Value value = this.lastAggregators.get(name);
        E.checkArgument((value != null ? 1 : 0) != 0, (String)"Can't find aggregator value with name '%s'", (Object[])new Object[]{name});
        return (V)value;
    }

    private void flushAggregators() {
        Map<String, Value> aggregators = this.currentAggregators.values();
        this.service().aggregateAggregators(aggregators);
        this.currentAggregators.clear();
    }

    private void reloadAggregators() {
        this.lastAggregators = this.service().listAggregators();
        E.checkNotNull(this.lastAggregators, (String)"lastAggregators");
        this.currentAggregators = new Aggregators(this.registerAggregators.copyAll());
    }

    private AggregateRpcService service() {
        E.checkArgumentNotNull((Object)this.service, (String)"Not init AggregateRpcService", (Object[])new Object[0]);
        return this.service;
    }
}

