# run with spark 3.1.X
wget https://repo1.maven.org/maven2/org/apache/hudi/hudi-utilities-bundle_2.12/0.14.1/hudi-utilities-bundle_2.12-0.14.1.jar;
for i in {0..4}; do
  spark-submit \
    --class org.apache.hudi.utilities.streamer.HoodieStreamer \
    hudi-utilities-bundle_2.12-0.14.1.jar \
    --table-type MERGE_ON_READ \
    --source-class org.apache.hudi.utilities.sources.JsonDFSSource \
    --source-ordering-field timestamp \
    --target-base-path /tmp/colstats-upgrade-test-v6/trips_logical_types_json  \
    --target-table trips_logical_types_json \
    --props file:///tmp/colstats-upgrade-test-v6/hudi.properties\
    --schemaprovider-class org.apache.hudi.utilities.schema.FilebasedSchemaProvider \
    --disable-compaction \
    --op UPSERT \
    --hoodie-conf hoodie.streamer.source.dfs.root=file:///tmp/colstats-upgrade-test-v6/data/data_$i
done;
cd /tmp/colstats-upgrade-test-v6;
zip -r  $HUDI_HOME/hudi-utilities/src/test/resources/col-stats/colstats-upgrade-test-v6.zip .;

