/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.reactor;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class IOReactorConfigTest {
    IOReactorConfigTest() {
    }

    @Test
    void testCustomIOReactorConfig() {
        IOReactorConfig reactorConfig = IOReactorConfig.custom().setSelectInterval(TimeValue.ofMilliseconds((long)500L)).setIoThreadCount(2).setSoTimeout(Timeout.ofSeconds((long)10L)).setSoReuseAddress(true).setSoLinger(TimeValue.ofSeconds((long)30L)).setSoKeepAlive(true).setTcpNoDelay(false).setTrafficClass(2).setSndBufSize(Short.MAX_VALUE).setRcvBufSize(8192).setBacklogSize(5).setTcpKeepIdle(100).setTcpKeepInterval(12).setTcpKeepCount(4).setSocksProxyAddress((SocketAddress)new InetSocketAddress(8888)).setSocksProxyUsername("socksProxyUsername").setSocksProxyPassword("socksProxyPassword").build();
        Assertions.assertEquals((Object)TimeValue.ofMilliseconds((long)500L), (Object)reactorConfig.getSelectInterval());
        Assertions.assertEquals((int)2, (int)reactorConfig.getIoThreadCount());
        Assertions.assertEquals((Object)Timeout.ofSeconds((long)10L), (Object)reactorConfig.getSoTimeout());
        Assertions.assertTrue((boolean)reactorConfig.isSoReuseAddress());
        Assertions.assertEquals((Object)TimeValue.ofSeconds((long)30L), (Object)reactorConfig.getSoLinger());
        Assertions.assertTrue((boolean)reactorConfig.isSoKeepAlive());
        Assertions.assertFalse((boolean)reactorConfig.isTcpNoDelay());
        Assertions.assertEquals((int)2, (int)reactorConfig.getTrafficClass());
        Assertions.assertEquals((int)Short.MAX_VALUE, (int)reactorConfig.getSndBufSize());
        Assertions.assertEquals((int)8192, (int)reactorConfig.getRcvBufSize());
        Assertions.assertEquals((int)5, (int)reactorConfig.getBacklogSize());
        Assertions.assertEquals((int)100, (int)reactorConfig.getTcpKeepIdle());
        Assertions.assertEquals((int)12, (int)reactorConfig.getTcpKeepInterval());
        Assertions.assertEquals((int)4, (int)reactorConfig.getTcpKeepCount());
        Assertions.assertEquals((Object)new InetSocketAddress(8888), (Object)reactorConfig.getSocksProxyAddress());
        Assertions.assertEquals((Object)"socksProxyUsername", (Object)reactorConfig.getSocksProxyUsername());
        Assertions.assertEquals((Object)"socksProxyPassword", (Object)reactorConfig.getSocksProxyPassword());
    }
}

