
CREATE TEMPORARY TABLE temptable (key1 INT, value1 STRING) PARTITIONED BY (ds STRING, hr STRING);

ALTER TABLE temptable ADD PARTITION (ds='2008-04-08', hr='3');
ALTER TABLE temptable ADD PARTITION (ds='2008-04-08', hr='4');
ALTER TABLE temptable ADD PARTITION (ds='2008-04-08', hr='5');
ALTER TABLE temptable ADD PARTITION (ds='2008-04-09', hr='5');
ALTER TABLE temptable ADD PARTITION (ds='2008-04-09', hr='6');
ALTER TABLE temptable ADD PARTITION (ds='2008-04-10', hr='5');
ALTER TABLE temptable ADD PARTITION (ds='2008-04-11', hr='5');

SHOW PARTITIONS temptable LIMIT 2;
SHOW PARTITIONS temptable PARTITION(ds='2008-04-08') LIMIT 2;
SHOW PARTITIONS temptable ORDER BY ds DESC, hr DESC;
SHOW PARTITIONS temptable ORDER BY ds DESC, hr DESC LIMIT 2;
SHOW PARTITIONS temptable WHERE ds > '2008-04-08' AND hr = '5';
SHOW PARTITIONS temptable WHERE ds > '2008-04-08' AND hr = '5' ORDER BY ds DESC;
SHOW PARTITIONS temptable WHERE ds > '2008-04-08' AND hr = '5' ORDER BY ds DESC LIMIT 2;
SHOW PARTITIONS temptable WHERE ds > '2008-04-08' AND hr >= '5' ORDER BY ds DESC, hr ASC;
SHOW PARTITIONS temptable WHERE ds > '2008-04-08' AND hr >= '5' ORDER BY ds DESC, hr ASC LIMIT 2;
