/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.remoting.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.epoll.Epoll;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.hertzbeat.common.entity.message.ClusterMsg;
import org.apache.hertzbeat.common.util.NetworkUtil;
import org.apache.hertzbeat.remoting.RemotingService;
import org.apache.hertzbeat.remoting.event.NettyEventListener;
import org.apache.hertzbeat.remoting.netty.NettyHook;
import org.apache.hertzbeat.remoting.netty.NettyRemotingProcessor;
import org.apache.hertzbeat.remoting.netty.ResponseFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NettyRemotingAbstract
implements RemotingService {
    private static final Logger log = LoggerFactory.getLogger(NettyRemotingAbstract.class);
    protected ConcurrentHashMap<ClusterMsg.MessageType, NettyRemotingProcessor> processorTable = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, ResponseFuture> responseTable = new ConcurrentHashMap();
    protected List<NettyHook> nettyHookList = new ArrayList<NettyHook>();
    protected NettyEventListener nettyEventListener;

    protected NettyRemotingAbstract(NettyEventListener nettyEventListener) {
        this.nettyEventListener = nettyEventListener;
    }

    public void registerProcessor(ClusterMsg.MessageType messageType, NettyRemotingProcessor processor) {
        this.processorTable.put(messageType, processor);
    }

    protected void processReceiveMsg(ChannelHandlerContext ctx, ClusterMsg.Message message) {
        if (ClusterMsg.Direction.REQUEST.equals((Object)message.getDirection())) {
            this.processRequestMsg(ctx, message);
        } else {
            this.processResponseMsg(ctx, message);
        }
    }

    protected void processRequestMsg(ChannelHandlerContext ctx, ClusterMsg.Message request) {
        this.doBeforeRequest(ctx, request);
        NettyRemotingProcessor processor = this.processorTable.get(request.getType());
        if (processor == null) {
            log.info("request type {} not supported", (Object)request.getType());
            return;
        }
        ClusterMsg.Message response = processor.handle(ctx, request);
        if (response != null) {
            ctx.writeAndFlush((Object)response);
        }
    }

    private void doBeforeRequest(ChannelHandlerContext ctx, ClusterMsg.Message request) {
        if (CollectionUtils.isEmpty(this.nettyHookList)) {
            return;
        }
        for (NettyHook nettyHook : this.nettyHookList) {
            nettyHook.doBeforeRequest(ctx, request);
        }
    }

    protected void processResponseMsg(ChannelHandlerContext ctx, ClusterMsg.Message response) {
        if (this.responseTable.containsKey(response.getIdentity())) {
            ResponseFuture responseFuture = this.responseTable.get(response.getIdentity());
            responseFuture.putResponse(response);
        } else {
            ClusterMsg.Message repMessage;
            NettyRemotingProcessor processor = this.processorTable.get(response.getType());
            if (processor != null && (repMessage = processor.handle(ctx, response)) != null) {
                ctx.writeAndFlush((Object)repMessage);
            }
        }
    }

    protected void sendMsgImpl(Channel channel, ClusterMsg.Message request) {
        channel.writeAndFlush((Object)request).addListener(future -> {
            if (!future.isSuccess()) {
                log.warn("send request message failed. address: {}, ", (Object)channel.remoteAddress(), (Object)future.cause());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ClusterMsg.Message sendMsgSyncImpl(Channel channel, ClusterMsg.Message request, int timeoutMillis) {
        String identity = request.getIdentity();
        try {
            ResponseFuture responseFuture = new ResponseFuture();
            this.responseTable.put(identity, responseFuture);
            channel.writeAndFlush((Object)request).addListener(future -> {
                if (!future.isSuccess()) {
                    this.responseTable.remove(identity);
                    log.warn("send request message failed. request: {}, address: {}, ", new Object[]{request, channel.remoteAddress(), future.cause()});
                }
            });
            ClusterMsg.Message response = responseFuture.waitResponse(timeoutMillis);
            if (response == null) {
                log.warn("get response message failed, message is null");
            }
            ClusterMsg.Message message = response;
            return message;
        }
        catch (InterruptedException e) {
            log.warn("get response message failed, ", (Throwable)e);
        }
        finally {
            this.responseTable.remove(identity);
        }
        return null;
    }

    protected void channelActive(ChannelHandlerContext ctx) throws Exception {
        if (this.nettyEventListener != null && ctx.channel().isActive()) {
            this.nettyEventListener.onChannelActive(ctx.channel());
        }
    }

    protected void channelIdle(ChannelHandlerContext ctx, Object evt) throws Exception {
        IdleStateEvent event = (IdleStateEvent)evt;
        if (this.nettyEventListener != null && event.state() == IdleState.ALL_IDLE) {
            ctx.channel().closeFuture();
            this.nettyEventListener.onChannelIdle(ctx.channel());
        }
    }

    protected boolean useEpoll() {
        return NetworkUtil.isLinuxPlatform() && Epoll.isAvailable();
    }
}

