/*
 * Decompiled with CFR 0.152.
 */
package com.usthe.sureness.configuration;

import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="sureness")
public class SurenessProperties {
    private boolean enable = true;
    private ContainerType container = ContainerType.Jakarta_Servlet;
    private AuthType[] auths = new AuthType[]{AuthType.BASIC, AuthType.JWT, AuthType.DIGEST};
    private JwtProperties jwt;
    private SessionProperties session;
    private WebSocketProperties websocket;
    private AnnotationProperties annotation;

    public AuthType[] getAuths() {
        return this.auths;
    }

    public void setAuths(AuthType[] auths) {
        this.auths = auths;
    }

    public JwtProperties getJwt() {
        return this.jwt;
    }

    public void setJwt(JwtProperties jwt) {
        this.jwt = jwt;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public AnnotationProperties getAnnotation() {
        return this.annotation;
    }

    public void setAnnotation(AnnotationProperties annotation) {
        this.annotation = annotation;
    }

    public ContainerType getContainer() {
        return this.container;
    }

    public void setContainer(ContainerType container) {
        this.container = container;
    }

    public SessionProperties getSession() {
        return this.session;
    }

    public void setSession(SessionProperties session) {
        this.session = session;
    }

    public WebSocketProperties getWebsocket() {
        return this.websocket;
    }

    public void setWebsocket(WebSocketProperties websocket) {
        this.websocket = websocket;
    }

    public static enum ContainerType {
        Servlet,
        Jakarta_Servlet,
        JAX_RS,
        Spring_Reactor;

    }

    public static enum AuthType {
        JWT,
        BASIC,
        DIGEST;

    }

    public static class JwtProperties {
        private String secret;

        public String getSecret() {
            return this.secret;
        }

        public void setSecret(String secret) {
            this.secret = secret;
        }
    }

    public static class AnnotationProperties {
        private boolean enable = false;
        private List<String> scanPackages;

        public boolean isEnable() {
            return this.enable;
        }

        public void setEnable(boolean enable) {
            this.enable = enable;
        }

        public List<String> getScanPackages() {
            return this.scanPackages;
        }

        public void setScanPackages(List<String> scanPackages) {
            this.scanPackages = scanPackages;
        }
    }

    public static class SessionProperties {
        private boolean enable = false;

        public boolean isEnable() {
            return this.enable;
        }

        public void setEnable(boolean enable) {
            this.enable = enable;
        }
    }

    public static class WebSocketProperties {
        private boolean enable = false;

        public boolean isEnable() {
            return this.enable;
        }

        public void setEnable(boolean enable) {
            this.enable = enable;
        }
    }
}

