/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.model.image.observation.autoconfigure;

import io.micrometer.observation.ObservationHandler;
import io.micrometer.tracing.Tracer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.image.ImageModel;
import org.springframework.ai.image.observation.ImageModelObservationContext;
import org.springframework.ai.image.observation.ImageModelPromptContentObservationHandler;
import org.springframework.ai.model.image.observation.autoconfigure.ImageObservationProperties;
import org.springframework.ai.observation.TracingAwareLoggingObservationHandler;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@AutoConfiguration(afterName={"org.springframework.boot.actuate.autoconfigure.observation.ObservationAutoConfiguration.class"})
@ConditionalOnClass(value={ImageModel.class})
@EnableConfigurationProperties(value={ImageObservationProperties.class})
public class ImageObservationAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(ImageObservationAutoConfiguration.class);

    private static void logPromptContentWarning() {
        logger.warn("You have enabled logging out the image prompt content with the risk of exposing sensitive or private information. Please, be careful!");
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingClass(value={"io.micrometer.tracing.Tracer"})
    static class TracerNotPresentObservationConfiguration {
        TracerNotPresentObservationConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="spring.ai.image.observations", name={"log-prompt"}, havingValue="true")
        ImageModelPromptContentObservationHandler imageModelPromptContentObservationHandler() {
            ImageObservationAutoConfiguration.logPromptContentWarning();
            return new ImageModelPromptContentObservationHandler();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Tracer.class})
    @ConditionalOnBean(value={Tracer.class})
    static class TracerPresentObservationConfiguration {
        TracerPresentObservationConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={ImageModelPromptContentObservationHandler.class}, name={"imageModelPromptContentObservationHandler"})
        @ConditionalOnProperty(prefix="spring.ai.image.observations", name={"log-prompt"}, havingValue="true")
        TracingAwareLoggingObservationHandler<ImageModelObservationContext> imageModelPromptContentObservationHandler(Tracer tracer) {
            ImageObservationAutoConfiguration.logPromptContentWarning();
            return new TracingAwareLoggingObservationHandler((ObservationHandler)new ImageModelPromptContentObservationHandler(), tracer);
        }
    }
}

