/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.security;

import org.apache.hertzbeat.collector.collect.ipmi2.protocol.common.IpmiCode;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.security.confidentiality.AesCbc128;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.security.confidentiality.IpmiConfidentiality;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.security.confidentiality.None;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.security.confidentiality.Xrc4128;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.security.confidentiality.Xrc440;
import org.apache.hertzbeat.collector.collect.ipmi2.utils.ByteConvertUtils;

public enum IpmiConfidentialityCode implements IpmiCode.Code
{
    NONE(0, None.class),
    AES_CBC_128(1, AesCbc128.class),
    xRC4_128(2, Xrc4128.class),
    xRC4_40(3, Xrc440.class);

    private final byte code;
    private final Class<? extends IpmiConfidentiality> confidentiality;

    private IpmiConfidentialityCode(int code, Class<? extends IpmiConfidentiality> confidentiality) {
        this.code = ByteConvertUtils.checkCastByte(code);
        this.confidentiality = confidentiality;
    }

    @Override
    public byte getCode() {
        return this.code;
    }

    public IpmiConfidentiality newIpmiConfidentiality() {
        if (this.confidentiality == null) {
            return null;
        }
        try {
            return this.confidentiality.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }
}

