/*
 * Decompiled with CFR 0.152.
 */
package com.usthe.sureness.util;

import com.usthe.sureness.processor.exception.ExtSurenessException;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.CompressionCodecs;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.UnsupportedJwtException;
import io.jsonwebtoken.security.Keys;
import io.jsonwebtoken.security.SignatureException;
import java.security.Key;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.xml.bind.DatatypeConverter;

public class JsonWebTokenUtil {
    private static final String DEFAULT_SECRET_KEY = "MIIEowIBAl+f/dKhaX0csgOCTlCxq20yhmUea6H6JIpST3ST1SE2RwpLnfKefTjsIfJLBa2YkhEqE/GtcHDTNe4CU6+9y/S5z50Kik70LsP43rRnLN7XNn4wARoQXizIv6MHUsIV+EFfiMw/x7R0ntu4aWr/CWuApcFaj4mWEa6EwrPHTZmbT5Mt45AM2UYhzDHK+0F0rUq3MwH+oXsm+L3F/zjjM6EByXIO+SV5+8tVt4bisXQ13rbN0oxhUZR73+LDj9mxa6rFhMW+lfxCyaFv0bwq2Eik0jdrKUtsA6bx3sDJeFV643R+YYzGMRIqcBIp6AKA98GM2RIqcBIp6-?::4390fsf4sdl6opf)4ZI:tdQMtcQQ14pkOAQdQ546";
    private static final int COUNT_3 = 3;
    private static final Pattern BASE64_PATTERN = Pattern.compile("^([A-Za-z0-9+/_-]+)(=*)$");
    private static Key secretKey;
    private static volatile boolean isUsedDefault;

    @Deprecated
    public static String issueJwt(String id, String subject, String issuer, Long period, List<String> roles, List<String> permissions, Boolean isRefresh) {
        HashMap<String, Object> customClaimMap = new HashMap<String, Object>(4);
        customClaimMap.put("roles", roles);
        customClaimMap.put("perms", permissions);
        customClaimMap.put("isRefresh", isRefresh);
        return JsonWebTokenUtil.issueJwtAll(id, subject, issuer, period, null, null, null, null, customClaimMap);
    }

    public static String issueJwt(String id, String subject, String issuer, Long period, List<String> roles) {
        Map<String, Object> customClaimMap = Collections.singletonMap("roles", roles);
        return JsonWebTokenUtil.issueJwtAll(id, subject, issuer, period, null, null, null, null, customClaimMap);
    }

    public static String issueJwt(String id, String subject, String issuer, Long period, String audience, String payload, Long notBefore, List<String> roles, Map<String, Object> headerMap, Map<String, Object> customClaimMap) {
        if (customClaimMap == null) {
            customClaimMap = Collections.singletonMap("roles", roles);
        } else {
            customClaimMap.put("roles", roles);
        }
        return JsonWebTokenUtil.issueJwtAll(id, subject, issuer, period, audience, payload, notBefore, headerMap, customClaimMap);
    }

    public static String issueJwt(String id, String subject, String issuer, Long period, List<String> roles, Map<String, Object> customClaimMap) {
        if (customClaimMap == null) {
            customClaimMap = new HashMap<String, Object>(8);
        }
        if (roles != null && !roles.isEmpty()) {
            customClaimMap.put("roles", roles);
        }
        return JsonWebTokenUtil.issueJwtAll(id, subject, issuer, period, null, null, null, null, customClaimMap);
    }

    public static String issueJwt(String subject, Long period, List<String> roles, Map<String, Object> customClaimMap) {
        String id = UUID.randomUUID().toString();
        String issuer = "sureness-token-server";
        return JsonWebTokenUtil.issueJwt(id, subject, issuer, period, roles, customClaimMap);
    }

    public static String issueJwt(String subject, Long period, List<String> roles) {
        String id = UUID.randomUUID().toString();
        String issuer = "sureness-token-server";
        return JsonWebTokenUtil.issueJwt(id, subject, issuer, period, roles, null);
    }

    public static String issueJwt(String subject, Long period) {
        String id = UUID.randomUUID().toString();
        String issuer = "sureness-token-server";
        return JsonWebTokenUtil.issueJwt(id, subject, issuer, period, null, null);
    }

    public static String issueJwt(String subject, Long period, Map<String, Object> customClaimMap) {
        String id = UUID.randomUUID().toString();
        String issuer = "sureness-token-server";
        return JsonWebTokenUtil.issueJwt(id, subject, issuer, period, null, customClaimMap);
    }

    public static String issueJwtAll(String id, String subject, String issuer, Long period, String audience, String payload, Long notBefore, Map<String, Object> headerMap, Map<String, Object> customClaimMap) {
        if (isUsedDefault) {
            throw new ExtSurenessException("Please config your custom jwt secret. JsonWebTokenUtil.setDefaultSecretKey | sureness.jwt.secret");
        }
        long currentTimeMillis = System.currentTimeMillis();
        JwtBuilder jwtBuilder = Jwts.builder();
        if (id != null) {
            jwtBuilder.setId(id);
        }
        if (subject != null) {
            jwtBuilder.setSubject(subject);
        }
        if (issuer != null) {
            jwtBuilder.setIssuer(issuer);
        }
        jwtBuilder.setIssuedAt(new Date(currentTimeMillis));
        if (null != period) {
            jwtBuilder.setExpiration(new Date(currentTimeMillis + period * 1000L));
        }
        if (null != audience) {
            jwtBuilder.setAudience(audience);
        }
        if (null != payload) {
            jwtBuilder.setPayload(payload);
        }
        if (null != notBefore) {
            jwtBuilder.setNotBefore(new Date(notBefore * 1000L));
        }
        if (null != headerMap) {
            jwtBuilder.setHeader(headerMap);
        }
        if (null != customClaimMap) {
            customClaimMap.forEach((arg_0, arg_1) -> ((JwtBuilder)jwtBuilder).claim(arg_0, arg_1));
        }
        jwtBuilder.compressWith(CompressionCodecs.DEFLATE);
        jwtBuilder.signWith(secretKey);
        return jwtBuilder.compact();
    }

    public static boolean isNotJsonWebToken(String jwt) {
        if (jwt == null || "".equals(jwt)) {
            return true;
        }
        String[] jwtArr = jwt.split("\\.");
        if (jwtArr.length != 3) {
            return true;
        }
        for (String jwtTmp : jwtArr) {
            if (BASE64_PATTERN.matcher(jwtTmp).matches()) continue;
            return true;
        }
        return false;
    }

    public static Claims parseJwt(String jwt) throws ExpiredJwtException, UnsupportedJwtException, MalformedJwtException, SignatureException, IllegalArgumentException {
        return (Claims)Jwts.parserBuilder().setSigningKey(secretKey).build().parseClaimsJws(jwt).getBody();
    }

    public static void setDefaultSecretKey(String secretNowKeyValue) {
        byte[] secretKeyBytes = DatatypeConverter.parseBase64Binary((String)secretNowKeyValue);
        secretKey = Keys.hmacShaKeyFor((byte[])secretKeyBytes);
        isUsedDefault = false;
    }

    static {
        isUsedDefault = true;
        byte[] secretKeyBytes = DatatypeConverter.parseBase64Binary((String)DEFAULT_SECRET_KEY);
        secretKey = Keys.hmacShaKeyFor((byte[])secretKeyBytes);
    }
}

