/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.factories;

import java.lang.reflect.Constructor;
import java.util.List;
import java.util.function.Function;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.chaos.actions.Action;
import org.apache.hadoop.hbase.chaos.factories.SlowDeterministicMonkeyFactory;
import org.apache.hbase.thirdparty.com.google.common.base.Splitter;
import org.apache.hbase.thirdparty.com.google.common.collect.Iterables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurableSlowDeterministicMonkeyFactory
extends SlowDeterministicMonkeyFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurableSlowDeterministicMonkeyFactory.class);
    static final String HEAVY_ACTIONS = "heavy.actions";
    static final String TABLE_PARAM = "\\$table_name";

    @Override
    protected Action[] getHeavyWeightedActions() {
        String actions = this.properties.getProperty(HEAVY_ACTIONS);
        if (actions == null || actions.isEmpty()) {
            return super.getHeavyWeightedActions();
        }
        try {
            List actionClasses = Splitter.on((char)';').splitToList((CharSequence)actions);
            Action[] heavyActions = new Action[actionClasses.size()];
            int i = 0;
            for (String action : actionClasses) {
                heavyActions[i++] = this.instantiateAction(action);
            }
            LOG.info("Created actions {}", (Object[])heavyActions);
            return heavyActions;
        }
        catch (Exception e) {
            LOG.error("Error trying to instantiate heavy actions. Returning null array.", (Throwable)e);
            return null;
        }
    }

    private Action instantiateAction(String actionString) throws Exception {
        Constructor<?>[] constructors;
        String packageName = "org.apache.hadoop.hbase.chaos.actions";
        Iterable classAndParams = Splitter.on((char)'(').split((CharSequence)Iterables.get((Iterable)Splitter.on((char)')').split((CharSequence)actionString), (int)0));
        String className = "org.apache.hadoop.hbase.chaos.actions." + (String)Iterables.get((Iterable)classAndParams, (int)0);
        String[] params = (String[])Splitter.on((char)',').splitToStream((CharSequence)((String)Iterables.get((Iterable)classAndParams, (int)1)).replaceAll(TABLE_PARAM, this.tableName.getNameAsString())).toArray(String[]::new);
        LOG.info("About to instantiate action class: {}; With constructor params: {}", (Object)className, (Object)params);
        Class<?> actionClass = Class.forName(className);
        for (Constructor<?> c : constructors = actionClass.getDeclaredConstructors()) {
            if (c.getParameterCount() != params.length) continue;
            Class<?>[] paramTypes = c.getParameterTypes();
            Object[] constructorParams = new Object[paramTypes.length];
            for (int i = 0; i < paramTypes.length; ++i) {
                constructorParams[i] = SupportedTypes.valueOf(paramTypes[i].getSimpleName().toUpperCase()).convert(params[i]);
            }
            return (Action)c.newInstance(constructorParams);
        }
        throw new IllegalArgumentException("Couldn't find any matching constructor for: " + actionString);
    }

    public static enum SupportedTypes {
        FLOAT(p -> Float.valueOf(Float.parseFloat(p))),
        LONG(p -> Long.parseLong(p)),
        INT(p -> Integer.parseInt(p)),
        TABLENAME(p -> TableName.valueOf((String)p));

        final Function<String, Object> converter;

        private SupportedTypes(Function<String, Object> converter) {
            this.converter = converter;
        }

        Object convert(String param) {
            return this.converter.apply(param);
        }
    }
}

