/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.chaos.actions.Action;
import org.apache.hadoop.hbase.client.Admin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlushTableAction
extends Action {
    private static final Logger LOG = LoggerFactory.getLogger(FlushTableAction.class);
    private final long sleepTime;
    private final TableName tableName;

    public FlushTableAction(TableName tableName) {
        this(-1, tableName);
    }

    public FlushTableAction(int sleepTime, TableName tableName) {
        this.sleepTime = sleepTime;
        this.tableName = tableName;
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    @Override
    public void perform() throws Exception {
        IntegrationTestingUtility util = this.context.getHBaseIntegrationTestingUtility();
        Admin admin = util.getAdmin();
        if (this.context.isStopping()) {
            return;
        }
        this.getLogger().info("Performing action: Flush table " + this.tableName);
        try {
            admin.flush(this.tableName);
        }
        catch (Exception ex) {
            this.getLogger().warn("Flush failed, might be caused by other chaos: " + ex.getMessage());
        }
        if (this.sleepTime > 0L) {
            Thread.sleep(this.sleepTime);
        }
    }
}

