/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.trigger;

import java.util.List;
import org.apache.commons.lang.NullArgumentException;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.trigger.ActionTime;
import org.apache.directory.api.ldap.trigger.LdapOperation;
import org.apache.directory.api.ldap.trigger.StoredProcedureOption;
import org.apache.directory.api.ldap.trigger.StoredProcedureParameter;

public class TriggerSpecification {
    private LdapOperation ldapOperation;
    private ActionTime actionTime;
    private List<SPSpec> spSpecs;

    public TriggerSpecification(LdapOperation ldapOperation, ActionTime actionTime, List<SPSpec> spSpecs) {
        if (ldapOperation == null || actionTime == null || spSpecs == null) {
            throw new NullArgumentException(I18n.err(I18n.ERR_04331, new Object[0]));
        }
        if (spSpecs.size() == 0) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_04332, new Object[0]));
        }
        this.ldapOperation = ldapOperation;
        this.actionTime = actionTime;
        this.spSpecs = spSpecs;
    }

    public ActionTime getActionTime() {
        return this.actionTime;
    }

    public LdapOperation getLdapOperation() {
        return this.ldapOperation;
    }

    public List<SPSpec> getSPSpecs() {
        return this.spSpecs;
    }

    public static class SPSpec {
        private String name;
        private List<StoredProcedureOption> options;
        private List<StoredProcedureParameter> parameters;

        public SPSpec(String name, List<StoredProcedureOption> options, List<StoredProcedureParameter> parameters) {
            this.name = name;
            this.options = options;
            this.parameters = parameters;
        }

        public String getName() {
            return this.name;
        }

        public List<StoredProcedureOption> getOptions() {
            return this.options;
        }

        public List<StoredProcedureParameter> getParameters() {
            return this.parameters;
        }

        public int hashCode() {
            int h = 37;
            h = h * 17 + (this.name == null ? 0 : this.name.hashCode());
            h = h * 17 + (this.options == null ? 0 : this.options.hashCode());
            h = h * 17 + (this.parameters == null ? 0 : this.parameters.hashCode());
            return h;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SPSpec other = (SPSpec)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.options == null ? other.options != null : !this.options.equals(other.options)) {
                return false;
            }
            return !(this.parameters == null ? other.parameters != null : !this.parameters.equals(other.parameters));
        }
    }
}

