/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.hadoop.hbase.rest.ProtobufMessageHandler;
import org.apache.hadoop.hbase.rest.model.CellModel;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.protobuf.CodedInputStream;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.yetus.audience.InterfaceAudience;

@XmlRootElement(name="Row")
@XmlAccessorType(value=XmlAccessType.NONE)
@InterfaceAudience.Private
public class RowModel
implements ProtobufMessageHandler,
Serializable {
    private static final long serialVersionUID = 1L;
    private byte[] key;
    private int keyOffset = 0;
    private int keyLength = -1;
    @JsonProperty(value="Cell")
    @XmlElement(name="Cell")
    private List<CellModel> cells = new ArrayList<CellModel>();

    public RowModel() {
    }

    public RowModel(String key) {
        this(Bytes.toBytes((String)key));
    }

    public RowModel(byte[] key) {
        this.setKey(key);
        this.cells = new ArrayList<CellModel>();
    }

    public RowModel(byte[] key, int keyOffset, int keyLength) {
        this.key = key;
        this.keyOffset = keyOffset;
        this.keyLength = keyLength;
        this.cells = new ArrayList<CellModel>();
    }

    public RowModel(String key, List<CellModel> cells) {
        this(Bytes.toBytes((String)key), cells);
    }

    public RowModel(byte[] key, List<CellModel> cells) {
        this(key);
        this.cells = cells;
    }

    public RowModel(byte[] key, int keyOffset, int keyLength, List<CellModel> cells) {
        this(key, keyOffset, keyLength);
        this.cells = cells;
    }

    public void addCell(CellModel cell) {
        this.cells.add(cell);
    }

    @XmlAttribute
    @JsonProperty(value="key")
    public byte[] getKey() {
        if (this.keyLength == -1) {
            return this.key;
        }
        byte[] retKey = new byte[this.keyLength];
        System.arraycopy(this.key, this.keyOffset, retKey, 0, this.keyLength);
        return retKey;
    }

    public byte[] getKeyArray() {
        return this.key;
    }

    @JsonProperty(value="key")
    public void setKey(byte[] key) {
        this.key = key;
        this.keyLength = -1;
    }

    public int getKeyOffset() {
        return this.keyOffset;
    }

    public int getKeyLength() {
        return this.keyLength;
    }

    public List<CellModel> getCells() {
        return this.cells;
    }

    @Override
    public Message messageFromObject() {
        throw new UnsupportedOperationException("no protobuf equivalent to RowModel");
    }

    @Override
    public ProtobufMessageHandler getObjectFromMessage(CodedInputStream is) throws IOException {
        throw new UnsupportedOperationException("no protobuf equivalent to RowModel");
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        RowModel rowModel = (RowModel)obj;
        return new EqualsBuilder().append(this.getKey(), rowModel.getKey()).append(this.cells, rowModel.cells).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.getKey()).append(this.cells).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("key", this.getKey()).append("cells", this.cells).toString();
    }
}

