/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree;

import java.io.IOException;
import java.lang.reflect.Array;
import org.apache.directory.mavibot.btree.BTree;
import org.apache.directory.mavibot.btree.Node;
import org.apache.directory.mavibot.btree.Page;

abstract class AbstractPage<K, V>
implements Page<K, V> {
    protected transient BTree<K, V> btree;
    protected long revision;
    protected K[] keys;
    protected int nbElems;
    private long offset = -1L;
    private long lastOffset = -1L;

    protected AbstractPage(BTree<K, V> btree) {
        this.btree = btree;
    }

    protected AbstractPage(BTree<K, V> btree, long revision, int nbElems) {
        this.btree = btree;
        this.revision = revision;
        this.nbElems = nbElems;
        Class<?> keyType = btree.getKeyType();
        this.keys = (Object[])Array.newInstance(keyType, nbElems);
    }

    protected int selectSibling(Node<K, V> parent, int parentPos) throws IOException {
        int nextPageSize;
        if (parentPos == 0) {
            return 1;
        }
        if (parentPos == parent.getNbElems()) {
            return parentPos - 1;
        }
        Page prevPage = parent.children[parentPos - 1].getValue(this.btree);
        Page nextPage = parent.children[parentPos + 1].getValue(this.btree);
        int prevPageSize = prevPage.getNbElems();
        if (prevPageSize >= (nextPageSize = nextPage.getNbElems())) {
            return parentPos - 1;
        }
        return parentPos + 1;
    }

    @Override
    public int getNbElems() {
        return this.nbElems;
    }

    @Override
    public int findPos(K key) {
        if (this.nbElems == 0) {
            return 0;
        }
        int min = 0;
        int max = this.nbElems - 1;
        while (min < max) {
            int middle = min + max + 1 >> 1;
            int comp = this.compare(this.keys[middle], key);
            if (comp < 0) {
                min = middle + 1;
                continue;
            }
            if (comp > 0) {
                max = middle - 1;
                continue;
            }
            return -(middle + 1);
        }
        int comp = this.compare(this.keys[max], key);
        if (comp == 0) {
            return -(max + 1);
        }
        if (comp < 0) {
            return max + 1;
        }
        return max;
    }

    private final int compare(K key1, K key2) {
        if (key1 == key2) {
            return 0;
        }
        if (key1 == null) {
            return 1;
        }
        if (key2 == null) {
            return -1;
        }
        return this.btree.getComparator().compare(key1, key2);
    }

    @Override
    public long getRevision() {
        return this.revision;
    }

    @Override
    public K getKey(int pos) {
        if (pos < this.nbElems) {
            return this.keys[pos];
        }
        return null;
    }

    void setKey(int pos, K key) {
        this.keys[pos] = key;
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    void setOffset(long offset) {
        this.offset = offset;
    }

    @Override
    public long getLastOffset() {
        return this.lastOffset;
    }

    void setLastOffset(long lastOffset) {
        this.lastOffset = lastOffset;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("r").append(this.revision);
        sb.append(", nbElems:").append(this.nbElems);
        if (this.offset > 0L) {
            sb.append(", offset:").append(this.offset);
        }
        return sb.toString();
    }

    @Override
    public String dumpPage(String tabs) {
        return "";
    }
}

