/*
 * Decompiled with CFR 0.152.
 */
package jdbm.htree;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Iterator;
import jdbm.I18n;
import jdbm.RecordManager;
import jdbm.helper.FastIterator;
import jdbm.helper.IterationException;
import jdbm.htree.HashBucket;
import jdbm.htree.HashNode;

final class HashDirectory
extends HashNode
implements Externalizable {
    static final long serialVersionUID = 1L;
    static final int MAX_CHILDREN = 256;
    static final int BIT_SIZE = 8;
    static final int MAX_DEPTH = 3;
    private long[] _children;
    private byte _depth;
    private transient RecordManager _recman;
    private transient long _recid;

    public HashDirectory() {
    }

    HashDirectory(byte depth) {
        this._depth = depth;
        this._children = new long[256];
    }

    void setPersistenceContext(RecordManager recman, long recid) {
        this._recman = recman;
        this._recid = recid;
    }

    long getRecid() {
        return this._recid;
    }

    boolean isEmpty() {
        for (int i = 0; i < this._children.length; ++i) {
            if (this._children[i] == 0L) continue;
            return false;
        }
        return true;
    }

    Object get(Object key) throws IOException {
        int hash = this.hashCode(key);
        long child_recid = this._children[hash];
        if (child_recid == 0L) {
            return null;
        }
        HashNode node = (HashNode)this._recman.fetch(child_recid);
        if (node instanceof HashDirectory) {
            HashDirectory dir = (HashDirectory)node;
            dir.setPersistenceContext(this._recman, child_recid);
            return dir.get(key);
        }
        HashBucket bucket = (HashBucket)node;
        return bucket.getValue(key);
    }

    Object put(Object key, Object value) throws IOException {
        if (value == null) {
            return this.remove(key);
        }
        int hash = this.hashCode(key);
        long child_recid = this._children[hash];
        if (child_recid == 0L) {
            long b_recid;
            HashBucket bucket = new HashBucket(this._depth + 1);
            Object existing = bucket.addElement(key, value);
            this._children[hash] = b_recid = this._recman.insert(bucket);
            this._recman.update(this._recid, this);
            return existing;
        }
        HashNode node = (HashNode)this._recman.fetch(child_recid);
        if (node instanceof HashDirectory) {
            HashDirectory dir = (HashDirectory)node;
            dir.setPersistenceContext(this._recman, child_recid);
            return dir.put(key, value);
        }
        HashBucket bucket = (HashBucket)node;
        if (bucket.hasRoom()) {
            Object existing = bucket.addElement(key, value);
            this._recman.update(child_recid, bucket);
            return existing;
        }
        if (this._depth == 3) {
            throw new RuntimeException(I18n.err(I18n.ERR_535, this._depth));
        }
        HashDirectory dir = new HashDirectory((byte)(this._depth + 1));
        long dir_recid = this._recman.insert(dir);
        dir.setPersistenceContext(this._recman, dir_recid);
        this._children[hash] = dir_recid;
        this._recman.update(this._recid, this);
        this._recman.delete(child_recid);
        ArrayList keys = bucket.getKeys();
        ArrayList values = bucket.getValues();
        int entries = keys.size();
        for (int i = 0; i < entries; ++i) {
            dir.put(keys.get(i), values.get(i));
        }
        return dir.put(key, value);
    }

    Object remove(Object key) throws IOException {
        int hash = this.hashCode(key);
        long child_recid = this._children[hash];
        if (child_recid == 0L) {
            return null;
        }
        HashNode node = (HashNode)this._recman.fetch(child_recid);
        if (node instanceof HashDirectory) {
            HashDirectory dir = (HashDirectory)node;
            dir.setPersistenceContext(this._recman, child_recid);
            Object existing = dir.remove(key);
            if (existing != null && dir.isEmpty()) {
                this._recman.delete(child_recid);
                this._children[hash] = 0L;
                this._recman.update(this._recid, this);
            }
            return existing;
        }
        HashBucket bucket = (HashBucket)node;
        Object existing = bucket.removeElement(key);
        if (existing != null) {
            if (bucket.getElementCount() >= 1) {
                this._recman.update(child_recid, bucket);
            } else {
                this._recman.delete(child_recid);
                this._children[hash] = 0L;
                this._recman.update(this._recid, this);
            }
        }
        return existing;
    }

    private int hashCode(Object key) {
        int hashMask = this.hashMask();
        int hash = key.hashCode();
        hash &= hashMask;
        hash >>>= (3 - this._depth) * 8;
        return hash %= 256;
    }

    int hashMask() {
        int bits = 255;
        int hashMask = bits << (3 - this._depth) * 8;
        return hashMask;
    }

    FastIterator keys() throws IOException {
        return new HDIterator(true);
    }

    FastIterator values() throws IOException {
        return new HDIterator(false);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(this._depth);
        out.writeObject(this._children);
    }

    @Override
    public synchronized void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._depth = in.readByte();
        this._children = (long[])in.readObject();
    }

    public class HDIterator
    extends FastIterator {
        private boolean _iterateKeys;
        private ArrayList _dirStack = new ArrayList();
        private ArrayList _childStack = new ArrayList();
        private HashDirectory _dir;
        private int _child;
        private Iterator _iter;

        HDIterator(boolean iterateKeys) throws IOException {
            this._dir = HashDirectory.this;
            this._child = -1;
            this._iterateKeys = iterateKeys;
            this.prepareNext();
        }

        @Override
        public Object next() {
            Object next = null;
            if (this._iter != null && this._iter.hasNext()) {
                next = this._iter.next();
            } else {
                try {
                    this.prepareNext();
                }
                catch (IOException except) {
                    throw new IterationException(except);
                }
                if (this._iter != null && this._iter.hasNext()) {
                    return this.next();
                }
            }
            return next;
        }

        private void prepareNext() throws IOException {
            long child_recid = 0L;
            do {
                ++this._child;
                if (this._child >= 256) {
                    if (this._dirStack.isEmpty()) {
                        return;
                    }
                    this._dir = (HashDirectory)this._dirStack.remove(this._dirStack.size() - 1);
                    this._child = (Integer)this._childStack.remove(this._childStack.size() - 1);
                    continue;
                }
                child_recid = this._dir._children[this._child];
            } while (child_recid == 0L);
            if (child_recid == 0L) {
                throw new Error("child_recid cannot be 0");
            }
            HashNode node = (HashNode)HashDirectory.this._recman.fetch(child_recid);
            if (node instanceof HashDirectory) {
                this._dirStack.add(this._dir);
                this._childStack.add(this._child);
                this._dir = (HashDirectory)node;
                this._child = -1;
                this._dir.setPersistenceContext(HashDirectory.this._recman, child_recid);
                this.prepareNext();
            } else {
                HashBucket bucket = (HashBucket)node;
                this._iter = this._iterateKeys ? bucket.getKeys().iterator() : bucket.getValues().iterator();
            }
        }
    }
}

