/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.ConnectionImplementation;
import org.apache.hadoop.hbase.client.ConnectionRegistry;
import org.apache.hadoop.hbase.client.MasterKeepAliveConnection;
import org.apache.hadoop.hbase.client.ShortCircuitMasterConnection;
import org.apache.hadoop.hbase.ipc.RpcCall;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProtos;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class ServerConnectionUtils {
    private ServerConnectionUtils() {
    }

    public static ClusterConnection createShortCircuitConnection(Configuration conf, User user, ServerName serverName, AdminProtos.AdminService.BlockingInterface admin, ClientProtos.ClientService.BlockingInterface client, ConnectionRegistry registry) throws IOException {
        if (user == null) {
            user = UserProvider.instantiate((Configuration)conf).getCurrent();
        }
        return new ShortCircuitingClusterConnection(conf, user, serverName, admin, client, registry);
    }

    public static final class ShortCircuitingClusterConnection
    extends ConnectionImplementation {
        private final ServerName serverName;
        private final AdminProtos.AdminService.BlockingInterface localHostAdmin;
        private final ClientProtos.ClientService.BlockingInterface localHostClient;
        private final ClientProtos.ClientService.BlockingInterface localClientServiceBlockingInterfaceWrapper;

        private ShortCircuitingClusterConnection(Configuration conf, User user, ServerName serverName, AdminProtos.AdminService.BlockingInterface admin, ClientProtos.ClientService.BlockingInterface client, ConnectionRegistry registry) throws IOException {
            super(conf, null, user, registry);
            this.serverName = serverName;
            this.localHostAdmin = admin;
            this.localHostClient = client;
            this.localClientServiceBlockingInterfaceWrapper = new ClientServiceBlockingInterfaceWrapper(this.localHostClient);
        }

        public AdminProtos.AdminService.BlockingInterface getAdmin(ServerName sn) throws IOException {
            return this.serverName.equals((Object)sn) ? this.localHostAdmin : super.getAdmin(sn);
        }

        public ClientProtos.ClientService.BlockingInterface getClient(ServerName sn) throws IOException {
            return this.serverName.equals((Object)sn) ? this.localClientServiceBlockingInterfaceWrapper : super.getClient(sn);
        }

        public MasterKeepAliveConnection getMaster() throws IOException {
            if (this.localHostClient instanceof MasterProtos.MasterService.BlockingInterface) {
                return new ShortCircuitMasterConnection((MasterProtos.MasterService.BlockingInterface)this.localHostClient);
            }
            return super.getMaster();
        }

        static class ClientServiceBlockingInterfaceWrapper
        implements ClientProtos.ClientService.BlockingInterface {
            private ClientProtos.ClientService.BlockingInterface target;

            ClientServiceBlockingInterfaceWrapper(ClientProtos.ClientService.BlockingInterface target) {
                this.target = target;
            }

            public ClientProtos.GetResponse get(RpcController controller, ClientProtos.GetRequest request) throws ServiceException {
                return this.doCall(controller, request, (c, r) -> this.target.get(c, r));
            }

            public ClientProtos.MultiResponse multi(RpcController controller, ClientProtos.MultiRequest request) throws ServiceException {
                return this.doCall(controller, request, (c, r) -> this.target.multi(c, r));
            }

            public ClientProtos.ScanResponse scan(RpcController controller, ClientProtos.ScanRequest request) throws ServiceException {
                return this.doCall(controller, request, (c, r) -> this.target.scan(c, r));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private <REQUEST, RESPONSE> RESPONSE doCall(RpcController controller, REQUEST request, Operation<REQUEST, RESPONSE> operation) throws ServiceException {
                Optional<RpcCall> rpcCallOptional = RpcServer.unsetCurrentCall();
                try {
                    RESPONSE RESPONSE = operation.call(controller, request);
                    return RESPONSE;
                }
                finally {
                    rpcCallOptional.ifPresent(RpcServer::setCurrentCall);
                }
            }

            public ClientProtos.MutateResponse mutate(RpcController controller, ClientProtos.MutateRequest request) throws ServiceException {
                return this.target.mutate(controller, request);
            }

            public ClientProtos.BulkLoadHFileResponse bulkLoadHFile(RpcController controller, ClientProtos.BulkLoadHFileRequest request) throws ServiceException {
                return this.target.bulkLoadHFile(controller, request);
            }

            public ClientProtos.PrepareBulkLoadResponse prepareBulkLoad(RpcController controller, ClientProtos.PrepareBulkLoadRequest request) throws ServiceException {
                return this.target.prepareBulkLoad(controller, request);
            }

            public ClientProtos.CleanupBulkLoadResponse cleanupBulkLoad(RpcController controller, ClientProtos.CleanupBulkLoadRequest request) throws ServiceException {
                return this.target.cleanupBulkLoad(controller, request);
            }

            public ClientProtos.CoprocessorServiceResponse execService(RpcController controller, ClientProtos.CoprocessorServiceRequest request) throws ServiceException {
                return this.target.execService(controller, request);
            }

            public ClientProtos.CoprocessorServiceResponse execRegionServerService(RpcController controller, ClientProtos.CoprocessorServiceRequest request) throws ServiceException {
                return this.target.execRegionServerService(controller, request);
            }

            static interface Operation<REQUEST, RESPONSE> {
                public RESPONSE call(RpcController var1, REQUEST var2) throws ServiceException;
            }
        }
    }
}

