/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.hbtop.screen.top;

import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class Paging {
    private int currentPosition;
    private int pageStartPosition;
    private int pageEndPosition;
    private int pageSize;
    private int recordsSize;

    public void init() {
        this.currentPosition = 0;
        this.pageStartPosition = 0;
        this.pageEndPosition = Math.min(this.pageSize, this.recordsSize);
    }

    public void updatePageSize(int pageSize) {
        this.pageSize = pageSize;
        if (pageSize == 0) {
            this.pageStartPosition = 0;
            this.pageEndPosition = 0;
        } else {
            this.pageEndPosition = this.pageStartPosition + pageSize;
            this.keepConsistent();
        }
    }

    public void updateRecordsSize(int recordsSize) {
        if (this.recordsSize == 0) {
            this.currentPosition = 0;
            this.pageStartPosition = 0;
            this.pageEndPosition = Math.min(this.pageSize, recordsSize);
            this.recordsSize = recordsSize;
        } else if (recordsSize == 0) {
            this.currentPosition = 0;
            this.pageStartPosition = 0;
            this.pageEndPosition = 0;
            this.recordsSize = recordsSize;
        } else {
            this.recordsSize = recordsSize;
            if (this.pageSize > 0) {
                this.pageEndPosition = this.pageStartPosition + this.pageSize;
                this.keepConsistent();
            }
        }
    }

    public void arrowUp() {
        if (this.currentPosition > 0) {
            --this.currentPosition;
            if (this.pageSize > 0) {
                this.keepConsistent();
            }
        }
    }

    public void arrowDown() {
        if (this.currentPosition < this.recordsSize - 1) {
            ++this.currentPosition;
            if (this.pageSize > 0) {
                this.keepConsistent();
            }
        }
    }

    public void pageUp() {
        if (this.pageSize > 0 && this.currentPosition > 0) {
            this.currentPosition -= this.pageSize;
            if (this.currentPosition < 0) {
                this.currentPosition = 0;
            }
            this.keepConsistent();
        }
    }

    public void pageDown() {
        if (this.pageSize > 0 && this.currentPosition < this.recordsSize - 1) {
            this.currentPosition += this.pageSize;
            if (this.currentPosition >= this.recordsSize) {
                this.currentPosition = this.recordsSize - 1;
            }
            this.pageStartPosition = this.currentPosition;
            this.pageEndPosition = this.pageStartPosition + this.pageSize;
            this.keepConsistent();
        }
    }

    private void keepConsistent() {
        if (this.currentPosition < this.pageStartPosition) {
            this.pageStartPosition = this.currentPosition;
            this.pageEndPosition = this.pageStartPosition + this.pageSize;
        } else if (this.currentPosition > this.recordsSize - 1) {
            this.currentPosition = this.recordsSize - 1;
            this.pageEndPosition = this.recordsSize;
            this.pageStartPosition = this.pageEndPosition - this.pageSize;
        } else if (this.currentPosition > this.pageEndPosition - 1) {
            this.pageEndPosition = this.currentPosition + 1;
            this.pageStartPosition = this.pageEndPosition - this.pageSize;
        }
        if (this.pageStartPosition < 0) {
            this.pageStartPosition = 0;
        }
        if (this.pageEndPosition > this.recordsSize) {
            this.pageEndPosition = this.recordsSize;
            this.pageStartPosition = this.pageEndPosition - this.pageSize;
            if (this.pageStartPosition < 0) {
                this.pageStartPosition = 0;
            }
        }
    }

    public int getCurrentPosition() {
        return this.currentPosition;
    }

    public int getPageStartPosition() {
        return this.pageStartPosition;
    }

    public int getPageEndPosition() {
        return this.pageEndPosition;
    }
}

