/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import com.google.common.collect.ImmutableMap;
import java.io.DataOutput;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationUtilsClient;
import org.apache.hadoop.hdfs.tools.DelegationTokenFetcher;
import org.apache.hadoop.hdfs.web.URLConnectionFactory;
import org.apache.hadoop.hdfs.web.WebHdfsConstants;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.token.Token;
import org.apache.log4j.Logger;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpChunkAggregator;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpRequestDecoder;
import org.jboss.netty.handler.codec.http.HttpResponseEncoder;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDelegationTokenRemoteFetcher {
    private static final Logger LOG = Logger.getLogger(TestDelegationTokenRemoteFetcher.class);
    private static final String EXP_DATE = "124123512361236";
    private static final String tokenFile = "http.file.dta";
    private static final URLConnectionFactory connectionFactory = URLConnectionFactory.DEFAULT_SYSTEM_CONNECTION_FACTORY;
    private int httpPort;
    private URI serviceUrl;
    private FileSystem fileSys;
    private Configuration conf;
    private ServerBootstrap bootstrap;
    private Token<DelegationTokenIdentifier> testToken;
    private volatile AssertionError assertionError;

    @Before
    public void init() throws Exception {
        this.conf = new Configuration();
        this.fileSys = FileSystem.getLocal((Configuration)this.conf);
        this.httpPort = NetUtils.getFreeSocketPort();
        this.serviceUrl = new URI("http://localhost:" + this.httpPort);
        this.testToken = TestDelegationTokenRemoteFetcher.createToken(this.serviceUrl);
    }

    @After
    public void clean() throws IOException {
        if (this.fileSys != null) {
            this.fileSys.delete(new Path(tokenFile), true);
        }
        if (this.bootstrap != null) {
            this.bootstrap.releaseExternalResources();
        }
    }

    @Test
    public void testTokenFetchFail() throws Exception {
        try {
            DelegationTokenFetcher.main((String[])new String[]{"-webservice=" + this.serviceUrl, tokenFile});
            Assert.fail((String)"Token fetcher shouldn't start in absense of NN");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testTokenRenewFail() throws AuthenticationException {
        try {
            DelegationUtilsClient.renewDelegationToken((URLConnectionFactory)connectionFactory, (URI)this.serviceUrl, this.testToken);
            Assert.fail((String)"Token fetcher shouldn't be able to renew tokens in absense of NN");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void expectedTokenCancelFail() throws AuthenticationException {
        try {
            DelegationUtilsClient.cancelDelegationToken((URLConnectionFactory)connectionFactory, (URI)this.serviceUrl, this.testToken);
            Assert.fail((String)"Token fetcher shouldn't be able to cancel tokens in absense of NN");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void expectedTokenRenewErrorHttpResponse() throws AuthenticationException, URISyntaxException {
        this.bootstrap = this.startHttpServer(this.httpPort, this.testToken, this.serviceUrl);
        try {
            DelegationUtilsClient.renewDelegationToken((URLConnectionFactory)connectionFactory, (URI)new URI(this.serviceUrl.toString() + "/exception"), TestDelegationTokenRemoteFetcher.createToken(this.serviceUrl));
            Assert.fail((String)"Token fetcher shouldn't be able to renew tokens using an invalid NN URL");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.assertionError != null) {
            throw this.assertionError;
        }
    }

    @Test
    public void testCancelTokenFromHttp() throws IOException, AuthenticationException {
        this.bootstrap = this.startHttpServer(this.httpPort, this.testToken, this.serviceUrl);
        DelegationUtilsClient.cancelDelegationToken((URLConnectionFactory)connectionFactory, (URI)this.serviceUrl, this.testToken);
        if (this.assertionError != null) {
            throw this.assertionError;
        }
    }

    @Test
    public void testRenewTokenFromHttp() throws IOException, NumberFormatException, AuthenticationException {
        this.bootstrap = this.startHttpServer(this.httpPort, this.testToken, this.serviceUrl);
        Assert.assertTrue((String)"testRenewTokenFromHttp error", (Long.parseLong(EXP_DATE) == DelegationUtilsClient.renewDelegationToken((URLConnectionFactory)connectionFactory, (URI)this.serviceUrl, this.testToken) ? 1 : 0) != 0);
        if (this.assertionError != null) {
            throw this.assertionError;
        }
    }

    @Test
    public void expectedTokenIsRetrievedFromHttp() throws Exception {
        this.bootstrap = this.startHttpServer(this.httpPort, this.testToken, this.serviceUrl);
        DelegationTokenFetcher.main((String[])new String[]{"-webservice=" + this.serviceUrl, tokenFile});
        Path p = new Path(this.fileSys.getWorkingDirectory(), tokenFile);
        Credentials creds = Credentials.readTokenStorageFile((Path)p, (Configuration)this.conf);
        Iterator itr = creds.getAllTokens().iterator();
        Assert.assertTrue((String)"token not exist error", (boolean)itr.hasNext());
        Token fetchedToken = (Token)itr.next();
        Assert.assertArrayEquals((String)"token wrong identifier error", (byte[])this.testToken.getIdentifier(), (byte[])fetchedToken.getIdentifier());
        Assert.assertArrayEquals((String)"token wrong password error", (byte[])this.testToken.getPassword(), (byte[])fetchedToken.getPassword());
        if (this.assertionError != null) {
            throw this.assertionError;
        }
    }

    private static Token<DelegationTokenIdentifier> createToken(URI serviceUri) {
        byte[] pw = "hadoop".getBytes();
        byte[] ident = new DelegationTokenIdentifier(new Text("owner"), new Text("renewer"), new Text("realuser")).getBytes();
        Text service = new Text(serviceUri.toString());
        return new Token(ident, pw, WebHdfsConstants.HFTP_TOKEN_KIND, service);
    }

    private ServerBootstrap startHttpServer(int port, final Token<DelegationTokenIdentifier> token, final URI url) {
        ServerBootstrap bootstrap = new ServerBootstrap((ChannelFactory)new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool()));
        bootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                return Channels.pipeline((ChannelHandler[])new ChannelHandler[]{new HttpRequestDecoder(), new HttpChunkAggregator(65536), new HttpResponseEncoder(), new CredentialsLogicHandler((Token<DelegationTokenIdentifier>)token, url.toString())});
            }
        });
        bootstrap.bind((SocketAddress)new InetSocketAddress("localhost", port));
        return bootstrap;
    }

    private final class CredentialsLogicHandler
    extends SimpleChannelUpstreamHandler {
        private final Token<DelegationTokenIdentifier> token;
        private final String serviceUrl;
        private final ImmutableMap<String, Handler> routes;

        public CredentialsLogicHandler(Token<DelegationTokenIdentifier> token, String serviceUrl) {
            this.routes = ImmutableMap.of((Object)"/exception", (Object)new ExceptionHandler(), (Object)"/cancelDelegationToken", (Object)new CancelHandler(), (Object)"/getDelegationToken", (Object)new FetchHandler(), (Object)"/renewDelegationToken", (Object)new RenewHandler());
            this.token = token;
            this.serviceUrl = serviceUrl;
        }

        public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
            HttpRequest request = (HttpRequest)e.getMessage();
            if (request.getMethod() == HttpMethod.OPTIONS) {
                DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
                response.headers().set("Set-Cookie", (Object)"hadoop-auth=1234");
                e.getChannel().write((Object)response).addListener(ChannelFutureListener.CLOSE);
            } else if (request.getMethod() != HttpMethod.GET) {
                e.getChannel().close();
            }
            for (Map.Entry entry : this.routes.entrySet()) {
                if (!request.getUri().contains((CharSequence)entry.getKey())) continue;
                Handler handler = (Handler)entry.getValue();
                try {
                    handler.handle(e.getChannel(), this.token, this.serviceUrl);
                }
                catch (AssertionError ee) {
                    TestDelegationTokenRemoteFetcher.this.assertionError = ee;
                    DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST);
                    response.setContent(ChannelBuffers.copiedBuffer((CharSequence)((Throwable)((Object)ee)).getMessage(), (Charset)Charset.defaultCharset()));
                    e.getChannel().write((Object)response).addListener(ChannelFutureListener.CLOSE);
                }
                return;
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
            Channel ch = e.getChannel();
            Throwable cause = e.getCause();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)cause.getMessage());
            }
            ch.close().addListener(ChannelFutureListener.CLOSE);
        }
    }

    private class CancelHandler
    implements Handler {
        private CancelHandler() {
        }

        @Override
        public void handle(Channel channel, Token<DelegationTokenIdentifier> token, String serviceUrl) throws IOException {
            Assert.assertEquals((Object)TestDelegationTokenRemoteFetcher.this.testToken, token);
            DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
            channel.write((Object)response).addListener(ChannelFutureListener.CLOSE);
        }
    }

    private class ExceptionHandler
    implements Handler {
        private ExceptionHandler() {
        }

        @Override
        public void handle(Channel channel, Token<DelegationTokenIdentifier> token, String serviceUrl) throws IOException {
            Assert.assertEquals((Object)TestDelegationTokenRemoteFetcher.this.testToken, token);
            DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.METHOD_NOT_ALLOWED);
            channel.write((Object)response).addListener(ChannelFutureListener.CLOSE);
        }
    }

    private class RenewHandler
    implements Handler {
        private RenewHandler() {
        }

        @Override
        public void handle(Channel channel, Token<DelegationTokenIdentifier> token, String serviceUrl) throws IOException {
            Assert.assertEquals((Object)TestDelegationTokenRemoteFetcher.this.testToken, token);
            byte[] bytes = TestDelegationTokenRemoteFetcher.EXP_DATE.getBytes();
            ChannelBuffer cbuffer = ChannelBuffers.buffer((int)bytes.length);
            cbuffer.writeBytes(bytes);
            DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
            response.headers().set("Content-Length", (Object)String.valueOf(bytes.length));
            response.setContent(cbuffer);
            channel.write((Object)response).addListener(ChannelFutureListener.CLOSE);
        }
    }

    private class FetchHandler
    implements Handler {
        private FetchHandler() {
        }

        @Override
        public void handle(Channel channel, Token<DelegationTokenIdentifier> token, String serviceUrl) throws IOException {
            Assert.assertEquals((Object)TestDelegationTokenRemoteFetcher.this.testToken, token);
            Credentials creds = new Credentials();
            creds.addToken(new Text(serviceUrl), token);
            DataOutputBuffer out = new DataOutputBuffer();
            creds.write((DataOutput)out);
            int fileLength = out.getData().length;
            ChannelBuffer cbuffer = ChannelBuffers.buffer((int)fileLength);
            cbuffer.writeBytes(out.getData());
            DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
            response.headers().set("Content-Length", (Object)String.valueOf(fileLength));
            response.setContent(cbuffer);
            channel.write((Object)response).addListener(ChannelFutureListener.CLOSE);
        }
    }

    private static interface Handler {
        public void handle(Channel var1, Token<DelegationTokenIdentifier> var2, String var3) throws IOException;
    }
}

