/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.namenode.NameNodeRpcServer;
import org.apache.hadoop.ipc.CallerContext;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.Assert;
import org.junit.Test;

public class TestNameNodeRpcServer {
    static final int ITERATIONS_TO_USE = 20;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNamenodeRpcBindAny() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.namenode.rpc-bind-host", "0.0.0.0");
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
            cluster.waitActive();
            Assert.assertEquals((Object)"0.0.0.0", (Object)((NameNodeRpcServer)cluster.getNameNodeRpc()).getClientRpcServer().getListenerAddress().getHostName());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
            conf.unset("dfs.namenode.rpc-bind-host");
        }
    }

    private static String getPreferredLocation(DistributedFileSystem fs, Path p) throws IOException {
        LocatedBlocks blocks = fs.getClient().getLocatedBlocks(p.toUri().getPath(), 0L);
        return blocks.get(0).getLocations()[0].getHostName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNamenodeRpcClientIpProxy() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.namenode.ip-proxy-users", "fake_joe");
        String[] racks = new String[]{"/rack1", "/rack2", "/rack3"};
        String[] hosts = new String[]{"node1", "node2", "node3"};
        MiniDFSCluster cluster = null;
        CallerContext original = CallerContext.getCurrent();
        try {
            String host;
            cluster = new MiniDFSCluster.Builder((Configuration)conf).racks(racks).hosts(hosts).numDataNodes(hosts.length).build();
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            Path fooName = fs.makeQualified(new Path("/foo"));
            FSDataOutputStream stream = fs.create(fooName);
            stream.write("Hello world!\n".getBytes(StandardCharsets.UTF_8));
            stream.close();
            StringBuilder contextStr = new StringBuilder("test,").append("clientIp").append(":").append(hosts[0]);
            CallerContext.setCurrent((CallerContext)new CallerContext.Builder(contextStr.toString()).build());
            for (int trial = 0; trial < 20 && hosts[0].equals(host = TestNameNodeRpcServer.getPreferredLocation(fs, fooName)); ++trial) {
                if (trial != 19) continue;
                Assert.assertNotEquals((String)"Failed to get non-node1", (Object)hosts[0], (Object)host);
            }
            UserGroupInformation joe = UserGroupInformation.createUserForTesting((String)"fake_joe", (String[])new String[]{"fake_group"});
            DistributedFileSystem joeFs = (DistributedFileSystem)DFSTestUtil.getFileSystemAs(joe, (Configuration)conf);
            for (int trial = 0; trial < 20; ++trial) {
                String host2 = TestNameNodeRpcServer.getPreferredLocation(joeFs, fooName);
                Assert.assertEquals((String)("Trial " + trial + " failed"), (Object)hosts[0], (Object)host2);
            }
        }
        finally {
            CallerContext.setCurrent((CallerContext)original);
            if (cluster != null) {
                cluster.shutdown();
            }
            conf.unset("dfs.namenode.ip-proxy-users");
        }
    }
}

