/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.MiniYARNCluster;
import org.apache.hadoop.yarn.server.resourcemanager.HATestUtil;
import org.junit.Assert;
import org.junit.Test;

public class TestMiniYarnCluster {
    @Test
    public void testTimelineServiceStartInMiniCluster() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        int numNodeManagers = 1;
        int numLocalDirs = 1;
        int numLogDirs = 1;
        conf.setBoolean("yarn.timeline-service.enabled", false);
        boolean enableAHS = false;
        try (MiniYARNCluster cluster = new MiniYARNCluster(TestMiniYarnCluster.class.getSimpleName(), numNodeManagers, numLocalDirs, numLogDirs, numLogDirs, enableAHS);){
            cluster.init((Configuration)conf);
            cluster.start();
            Assert.assertNull((String)"Timeline Service should not have been started", (Object)cluster.getApplicationHistoryServer());
        }
        conf.setBoolean("yarn.timeline-service.enabled", true);
        enableAHS = false;
        cluster = new MiniYARNCluster(TestMiniYarnCluster.class.getSimpleName(), numNodeManagers, numLocalDirs, numLogDirs, numLogDirs, enableAHS);
        var7_7 = null;
        try {
            cluster.init((Configuration)conf);
            String hostname = MiniYARNCluster.getHostname();
            Assert.assertEquals((Object)(hostname + ":0"), (Object)conf.get("yarn.timeline-service.address"));
            cluster.start();
            for (int wait = 0; cluster.getApplicationHistoryServer() == null && wait < 20; ++wait) {
                Thread.sleep(500L);
            }
            Assert.assertNotNull((String)"Timeline Service should have been started", (Object)cluster.getApplicationHistoryServer());
        }
        catch (Throwable x2) {
            var7_7 = x2;
            throw x2;
        }
        finally {
            if (cluster != null) {
                if (var7_7 != null) {
                    try {
                        cluster.close();
                    }
                    catch (Throwable x2) {
                        var7_7.addSuppressed(x2);
                    }
                } else {
                    cluster.close();
                }
            }
        }
        conf.setBoolean("yarn.timeline-service.enabled", false);
        enableAHS = true;
        cluster = new MiniYARNCluster(TestMiniYarnCluster.class.getSimpleName(), numNodeManagers, numLocalDirs, numLogDirs, numLogDirs, enableAHS);
        var7_7 = null;
        try {
            cluster.init((Configuration)conf);
            cluster.start();
            for (int wait = 0; cluster.getApplicationHistoryServer() == null && wait < 20; ++wait) {
                Thread.sleep(500L);
            }
            Assert.assertNotNull((String)"Timeline Service should have been started", (Object)cluster.getApplicationHistoryServer());
        }
        catch (Throwable throwable) {
            var7_7 = throwable;
            throw throwable;
        }
        finally {
            if (cluster != null) {
                if (var7_7 != null) {
                    try {
                        cluster.close();
                    }
                    catch (Throwable x2) {
                        var7_7.addSuppressed(x2);
                    }
                } else {
                    cluster.close();
                }
            }
        }
    }

    @Test
    public void testMultiRMConf() throws IOException {
        String RM1_NODE_ID = "rm1";
        String RM2_NODE_ID = "rm2";
        int RM1_PORT_BASE = 10000;
        int RM2_PORT_BASE = 20000;
        YarnConfiguration conf = new YarnConfiguration();
        conf.set("yarn.resourcemanager.cluster-id", "yarn-test-cluster");
        conf.setBoolean("yarn.resourcemanager.recovery.enabled", true);
        conf.setBoolean("yarn.resourcemanager.ha.enabled", true);
        conf.setBoolean("yarn.resourcemanager.ha.automatic-failover.enabled", false);
        conf.set("yarn.resourcemanager.ha.rm-ids", RM1_NODE_ID + "," + RM2_NODE_ID);
        HATestUtil.setRpcAddressForRM((String)RM1_NODE_ID, (int)RM1_PORT_BASE, (Configuration)conf);
        HATestUtil.setRpcAddressForRM((String)RM2_NODE_ID, (int)RM2_PORT_BASE, (Configuration)conf);
        conf.setBoolean("yarn.minicluster.fixed.ports", true);
        conf.setBoolean("yarn.minicluster.use-rpc", true);
        try (MiniYARNCluster cluster = new MiniYARNCluster(TestMiniYarnCluster.class.getName(), 2, 0, 1, 1);){
            cluster.init((Configuration)conf);
            Configuration conf1 = cluster.getResourceManager(0).getConfig();
            Configuration conf2 = cluster.getResourceManager(1).getConfig();
            Assert.assertFalse((conf1 == conf2 ? 1 : 0) != 0);
            Assert.assertEquals((Object)"0.0.0.0:18032", (Object)conf1.get(HAUtil.addSuffix((String)"yarn.resourcemanager.address", (String)RM1_NODE_ID)));
            Assert.assertEquals((Object)"0.0.0.0:28032", (Object)conf1.get(HAUtil.addSuffix((String)"yarn.resourcemanager.address", (String)RM2_NODE_ID)));
            Assert.assertEquals((Object)"rm1", (Object)conf1.get("yarn.resourcemanager.ha.id"));
            Assert.assertEquals((Object)"0.0.0.0:18032", (Object)conf2.get(HAUtil.addSuffix((String)"yarn.resourcemanager.address", (String)RM1_NODE_ID)));
            Assert.assertEquals((Object)"0.0.0.0:28032", (Object)conf2.get(HAUtil.addSuffix((String)"yarn.resourcemanager.address", (String)RM2_NODE_ID)));
            Assert.assertEquals((Object)"rm2", (Object)conf2.get("yarn.resourcemanager.ha.id"));
        }
    }
}

