/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.server.records.Version;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateVersionIncompatibleException;

public abstract class YarnConfigurationStore {
    public static final Log LOG = LogFactory.getLog(YarnConfigurationStore.class);

    public abstract void initialize(Configuration var1, Configuration var2, RMContext var3) throws Exception;

    public void close() throws IOException {
    }

    public abstract void logMutation(LogMutation var1) throws Exception;

    public abstract void confirmMutation(boolean var1) throws Exception;

    public abstract Configuration retrieve();

    public abstract List<LogMutation> getConfirmedConfHistory(long var1);

    protected abstract Version getConfStoreVersion() throws Exception;

    protected abstract void storeVersion() throws Exception;

    protected abstract Version getCurrentVersion();

    public void checkVersion() throws Exception {
        Version loadedVersion = this.getConfStoreVersion();
        LOG.info((Object)("Loaded configuration store version info " + loadedVersion));
        if (loadedVersion != null && loadedVersion.equals((Object)this.getCurrentVersion())) {
            return;
        }
        if (loadedVersion == null) {
            loadedVersion = this.getCurrentVersion();
        }
        if (!loadedVersion.isCompatibleTo(this.getCurrentVersion())) {
            throw new RMStateVersionIncompatibleException("Expecting configuration store version " + this.getCurrentVersion() + ", but loading version " + loadedVersion);
        }
        LOG.info((Object)("Storing configuration store version info " + this.getCurrentVersion()));
        this.storeVersion();
    }

    static class LogMutation
    implements Serializable {
        private Map<String, String> updates;
        private String user;

        LogMutation(Map<String, String> updates, String user) {
            this.updates = updates;
            this.user = user;
        }

        public Map<String, String> getUpdates() {
            return this.updates;
        }

        public String getUser() {
            return this.user;
        }
    }
}

