/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;

public class QueueMetricsForCustomResources {
    private final QueueMetricsCustomResource aggregatePreemptedSeconds = new QueueMetricsCustomResource();
    private final QueueMetricsCustomResource allocated = new QueueMetricsCustomResource();
    private final QueueMetricsCustomResource available = new QueueMetricsCustomResource();
    private final QueueMetricsCustomResource pending = new QueueMetricsCustomResource();
    private final QueueMetricsCustomResource reserved = new QueueMetricsCustomResource();

    public void increaseReserved(Resource res) {
        this.reserved.increase(res);
    }

    public void decreaseReserved(Resource res) {
        this.reserved.decrease(res);
    }

    public void setAvailable(Resource res) {
        this.available.set(res);
    }

    public void increasePending(Resource res, int containers) {
        this.pending.increaseWithMultiplier(res, containers);
    }

    public void decreasePending(Resource res) {
        this.pending.decrease(res);
    }

    public void decreasePending(Resource res, int containers) {
        this.pending.decreaseWithMultiplier(res, containers);
    }

    public void increaseAllocated(Resource res) {
        this.allocated.increase(res);
    }

    public void increaseAllocated(Resource res, int containers) {
        this.allocated.increaseWithMultiplier(res, containers);
    }

    public void decreaseAllocated(Resource res) {
        this.allocated.decrease(res);
    }

    public void decreaseAllocated(Resource res, int containers) {
        this.allocated.decreaseWithMultiplier(res, containers);
    }

    public void increaseAggregatedPreemptedSeconds(Resource res, long seconds) {
        this.aggregatePreemptedSeconds.increaseWithMultiplier(res, seconds);
    }

    Map<String, Long> getAllocatedValues() {
        return this.allocated.getValues();
    }

    Map<String, Long> getAvailableValues() {
        return this.available.getValues();
    }

    Map<String, Long> getPendingValues() {
        return this.pending.getValues();
    }

    Map<String, Long> getReservedValues() {
        return this.reserved.getValues();
    }

    QueueMetricsCustomResource getAggregatePreemptedSeconds() {
        return this.aggregatePreemptedSeconds;
    }

    public static class QueueMetricsCustomResource {
        private final Map<String, Long> values = Maps.newHashMap();

        protected void increase(Resource res) {
            if (ResourceUtils.getNumberOfKnownResourceTypes() > 2) {
                ResourceInformation[] resources = res.getResources();
                for (int i = 2; i < resources.length; ++i) {
                    ResourceInformation resource = resources[i];
                    if (!this.values.containsKey(resource.getName())) {
                        this.values.put(resource.getName(), 0L);
                    }
                    this.values.put(resource.getName(), this.values.get(resource.getName()) + resource.getValue());
                }
            }
        }

        void increaseWithMultiplier(Resource res, long multiplier) {
            if (ResourceUtils.getNumberOfKnownResourceTypes() > 2) {
                ResourceInformation[] resources = res.getResources();
                for (int i = 2; i < resources.length; ++i) {
                    ResourceInformation resource = resources[i];
                    if (!this.values.containsKey(resource.getName())) {
                        this.values.put(resource.getName(), 0L);
                    }
                    this.values.put(resource.getName(), this.values.get(resource.getName()) + resource.getValue() * multiplier);
                }
            }
        }

        protected void decrease(Resource res) {
            if (ResourceUtils.getNumberOfKnownResourceTypes() > 2) {
                ResourceInformation[] resources = res.getResources();
                for (int i = 2; i < resources.length; ++i) {
                    ResourceInformation resource = resources[i];
                    if (!this.values.containsKey(resource.getName())) {
                        this.values.put(resource.getName(), 0L);
                    }
                    this.values.put(resource.getName(), this.values.get(resource.getName()) - resource.getValue());
                }
            }
        }

        void decreaseWithMultiplier(Resource res, int containers) {
            if (ResourceUtils.getNumberOfKnownResourceTypes() > 2) {
                ResourceInformation[] resources = res.getResources();
                for (int i = 2; i < resources.length; ++i) {
                    ResourceInformation resource = resources[i];
                    if (!this.values.containsKey(resource.getName())) {
                        this.values.put(resource.getName(), 0L);
                    }
                    this.values.put(resource.getName(), this.values.get(resource.getName()) - resource.getValue() * (long)containers);
                }
            }
        }

        protected void set(Resource res) {
            if (ResourceUtils.getNumberOfKnownResourceTypes() > 2) {
                ResourceInformation[] resources = res.getResources();
                for (int i = 2; i < resources.length; ++i) {
                    ResourceInformation resource = resources[i];
                    this.values.put(resource.getName(), resource.getValue());
                }
            }
        }

        public Map<String, Long> getValues() {
            return this.values;
        }
    }
}

