/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.rmapp.monitor;

import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationTimeoutType;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.monitor.RMAppToMonitor;
import org.apache.hadoop.yarn.util.AbstractLivelinessMonitor;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.SystemClock;

public class RMAppLifetimeMonitor
extends AbstractLivelinessMonitor<RMAppToMonitor> {
    private static final Log LOG = LogFactory.getLog(RMAppLifetimeMonitor.class);
    private RMContext rmContext;

    public RMAppLifetimeMonitor(RMContext rmContext) {
        super(RMAppLifetimeMonitor.class.getName(), (Clock)SystemClock.getInstance());
        this.rmContext = rmContext;
    }

    protected void serviceInit(Configuration conf) throws Exception {
        long monitorInterval = conf.getLong("yarn.resourcemanager.application-timeouts.monitor.interval-ms", 3000L);
        if (monitorInterval <= 0L) {
            monitorInterval = 3000L;
        }
        this.setMonitorInterval(monitorInterval);
        this.setExpireInterval(0);
        this.setResetTimeOnStart(false);
        LOG.info((Object)("Application lifelime monitor interval set to " + monitorInterval + " ms."));
        super.serviceInit(conf);
    }

    protected synchronized void expire(RMAppToMonitor monitoredAppKey) {
        ApplicationId appId = monitoredAppKey.getApplicationId();
        RMApp app = (RMApp)this.rmContext.getRMApps().get(appId);
        if (app == null) {
            return;
        }
        String diagnostics = "Application is killed by ResourceManager as it has exceeded the lifetime period.";
        this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppEvent(appId, RMAppEventType.KILL, diagnostics));
    }

    public void registerApp(ApplicationId appId, ApplicationTimeoutType timeoutType, long expireTime) {
        RMAppToMonitor appToMonitor = new RMAppToMonitor(appId, timeoutType);
        this.register(appToMonitor, expireTime);
    }

    public void unregisterApp(ApplicationId appId, ApplicationTimeoutType timeoutType) {
        RMAppToMonitor remove = new RMAppToMonitor(appId, timeoutType);
        this.unregister(remove);
    }

    public void unregisterApp(ApplicationId appId, Set<ApplicationTimeoutType> timeoutTypes) {
        for (ApplicationTimeoutType timeoutType : timeoutTypes) {
            this.unregisterApp(appId, timeoutType);
        }
    }

    public void updateApplicationTimeouts(ApplicationId appId, Map<ApplicationTimeoutType, Long> timeouts) {
        for (Map.Entry<ApplicationTimeoutType, Long> entry : timeouts.entrySet()) {
            ApplicationTimeoutType timeoutType = entry.getKey();
            RMAppToMonitor update = new RMAppToMonitor(appId, timeoutType);
            this.register(update, entry.getValue());
        }
    }
}

