/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.metrics2.util.MBeans;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMNMInfoBeans;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNodeReport;
import org.mortbay.util.ajax.JSON;

public class RMNMInfo
implements RMNMInfoBeans {
    private static final Log LOG = LogFactory.getLog(RMNMInfo.class);
    private RMContext rmContext;
    private ResourceScheduler scheduler;

    public RMNMInfo(RMContext rmc, ResourceScheduler sched) {
        this.rmContext = rmc;
        this.scheduler = sched;
        try {
            StandardMBean bean = new StandardMBean(this, RMNMInfoBeans.class);
            MBeans.register((String)"ResourceManager", (String)"RMNMInfo", (Object)bean);
        }
        catch (NotCompliantMBeanException e) {
            LOG.warn((Object)"Error registering RMNMInfo MBean", (Throwable)e);
        }
        LOG.info((Object)"Registered RMNMInfo MBean");
    }

    @Override
    public String getLiveNodeManagers() {
        Collection nodes = this.rmContext.getRMNodes().values();
        ArrayList<InfoMap> nodesInfo = new ArrayList<InfoMap>();
        for (RMNode ni : nodes) {
            SchedulerNodeReport report = this.scheduler.getNodeReport(ni.getNodeID());
            InfoMap info = new InfoMap();
            info.put("HostName", ni.getHostName());
            info.put("Rack", ni.getRackName());
            info.put("State", ni.getState().toString());
            info.put("NodeId", ni.getNodeID());
            info.put("NodeHTTPAddress", ni.getHttpAddress());
            info.put("LastHealthUpdate", ni.getLastHealthReportTime());
            info.put("HealthReport", ni.getHealthReport());
            info.put("NodeManagerVersion", ni.getNodeManagerVersion());
            if (report != null) {
                info.put("NumContainers", report.getNumContainers());
                info.put("UsedMemoryMB", report.getUsedResource().getMemorySize());
                info.put("AvailableMemoryMB", report.getAvailableResource().getMemorySize());
            }
            nodesInfo.add(info);
        }
        return JSON.toString(nodesInfo);
    }

    static class InfoMap
    extends LinkedHashMap<String, Object> {
        private static final long serialVersionUID = 1L;

        InfoMap() {
        }
    }
}

