/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.testclassification.MetricsTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MetricsTests.class, SmallTests.class})
public class TestMetricsJvm {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMetricsJvm.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static Configuration conf;

    @BeforeClass
    public static void before() throws Exception {
        conf = UTIL.getConfiguration();
        conf.setInt("hbase.master.info.port", 0);
        UTIL.startMiniCluster();
    }

    @AfterClass
    public static void after() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testJvmMetrics() throws Exception {
        Pair<Integer, String> jmxPage = this.getJmxPage("?qry=Hadoop:service=HBase,name=JvmMetrics*");
        Assert.assertNotNull(jmxPage);
        Integer responseCode = (Integer)jmxPage.getFirst();
        String responseBody = (String)jmxPage.getSecond();
        Assert.assertEquals((long)200L, (long)responseCode.intValue());
        Assert.assertNotNull((Object)responseBody);
        this.assertNotFind("\"tag.ProcessName\"\\s*:\\s*\"IO\"", responseBody);
        this.assertReFind("\"tag.ProcessName\"\\s*:\\s*\"Master\"", responseBody);
    }

    private Pair<Integer, String> getJmxPage(String query) throws Exception {
        URL url = new URL("http://localhost:" + UTIL.getHBaseCluster().getMaster().getInfoServer().getPort() + "/jmx" + query);
        return this.getUrlContent(url);
    }

    private Pair<Integer, String> getUrlContent(URL url) throws Exception {
        try (CloseableHttpClient client = HttpClients.createDefault();){
            CloseableHttpResponse resp = client.execute((HttpUriRequest)new HttpGet(url.toURI()));
            int code = resp.getStatusLine().getStatusCode();
            if (code == 200) {
                Pair pair = new Pair((Object)code, (Object)EntityUtils.toString((HttpEntity)resp.getEntity()));
                return pair;
            }
            Pair pair = new Pair((Object)code, null);
            return pair;
        }
    }

    private void assertReFind(String re, String value) {
        Pattern p = Pattern.compile(re);
        Matcher m = p.matcher(value);
        TestCase.assertTrue((String)("'" + p + "' does not match " + value), (boolean)m.find());
    }

    private void assertNotFind(String re, String value) {
        Pattern p = Pattern.compile(re);
        Matcher m = p.matcher(value);
        TestCase.assertFalse((String)("'" + p + "' should not match " + value), (boolean)m.find());
    }
}

