/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.util.Random;
import org.apache.hadoop.hbase.KeyValue;

public class RandomKeyValueUtil {
    public static final String COLUMN_FAMILY_NAME = "_-myColumnFamily-_";
    private static final int MIN_ROW_OR_QUALIFIER_LENGTH = 64;
    private static final int MAX_ROW_OR_QUALIFIER_LENGTH = 128;

    public static final char randomReadableChar(Random rand) {
        int i = rand.nextInt(63);
        if (i < 26) {
            return (char)(65 + i);
        }
        if ((i -= 26) < 26) {
            return (char)(97 + i);
        }
        if ((i -= 26) < 10) {
            return (char)(48 + i);
        }
        assert ((i -= 10) == 0);
        return '_';
    }

    public static KeyValue randomKeyValue(Random rand) {
        return new KeyValue(RandomKeyValueUtil.randomRowOrQualifier(rand), COLUMN_FAMILY_NAME.getBytes(), RandomKeyValueUtil.randomRowOrQualifier(rand), RandomKeyValueUtil.randomValue(rand));
    }

    public static byte[] randomRowOrQualifier(Random rand) {
        StringBuilder field = new StringBuilder();
        int fieldLen = 64 + rand.nextInt(65);
        for (int i = 0; i < fieldLen; ++i) {
            field.append(RandomKeyValueUtil.randomReadableChar(rand));
        }
        return field.toString().getBytes();
    }

    public static byte[] randomValue(Random rand) {
        StringBuilder v = new StringBuilder();
        for (int j = 0; j < 1 + rand.nextInt(2000); ++j) {
            v.append((char)(32 + rand.nextInt(95)));
        }
        byte[] valueBytes = v.toString().getBytes();
        return valueBytes;
    }

    public static byte[] randomOrderedKey(Random rand, int i) {
        StringBuilder k = new StringBuilder();
        for (int bitIndex = 31; bitIndex >= 0; --bitIndex) {
            if ((i & 1 << bitIndex) == 0) {
                k.append("a");
                continue;
            }
            k.append("b");
        }
        for (int j = 0; j < rand.nextInt(50); ++j) {
            k.append(RandomKeyValueUtil.randomReadableChar(rand));
        }
        byte[] keyBytes = k.toString().getBytes();
        return keyBytes;
    }

    public static byte[] randomOrderedFixedLengthKey(Random rand, int i, int suffixLength) {
        StringBuilder k = new StringBuilder();
        for (int bitIndex = 31; bitIndex >= 0; --bitIndex) {
            if ((i & 1 << bitIndex) == 0) {
                k.append("a");
                continue;
            }
            k.append("b");
        }
        for (int j = 0; j < suffixLength; ++j) {
            k.append(RandomKeyValueUtil.randomReadableChar(rand));
        }
        byte[] keyBytes = k.toString().getBytes();
        return keyBytes;
    }

    public static byte[] randomFixedLengthValue(Random rand, int valueLength) {
        StringBuilder v = new StringBuilder();
        for (int j = 0; j < valueLength; ++j) {
            v.append((char)(32 + rand.nextInt(95)));
        }
        byte[] valueBytes = v.toString().getBytes();
        return valueBytes;
    }
}

