/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.EnumSet;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.MetaWithReplicasTestBase;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiscTests.class, MediumTests.class})
public class TestMetaReplicasAddressChange
extends MetaWithReplicasTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMetaReplicasAddressChange.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestMetaReplicasAddressChange.class);

    @BeforeClass
    public static void setUp() throws Exception {
        TestMetaReplicasAddressChange.startCluster();
    }

    @Test
    public void testMetaAddressChange() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        ZKWatcher zkw = TEST_UTIL.getZooKeeperWatcher();
        String baseZNode = conf.get("zookeeper.znode.parent", "/hbase");
        String primaryMetaZnode = ZNodePaths.joinZNode((String)baseZNode, (String)conf.get("zookeeper.znode.metaserver", "meta-region-server"));
        byte[] data = ZKUtil.getData((ZKWatcher)zkw, (String)primaryMetaZnode);
        ServerName currentServer = ProtobufUtil.parseServerNameFrom((byte[])data);
        Set liveServers = TEST_UTIL.getAdmin().getClusterMetrics(EnumSet.of(ClusterMetrics.Option.LIVE_SERVERS)).getLiveServerMetrics().keySet();
        ServerName moveToServer = liveServers.stream().filter(s -> !currentServer.equals(s)).findAny().get();
        TableName tableName = this.name.getTableName();
        TEST_UTIL.createTable(tableName, "f");
        Assert.assertTrue((boolean)TEST_UTIL.getAdmin().tableExists(tableName));
        TEST_UTIL.getAdmin().move(RegionInfoBuilder.FIRST_META_REGIONINFO.getEncodedNameAsBytes(), moveToServer);
        Assert.assertNotEquals((Object)currentServer, (Object)moveToServer);
        LOG.debug("CurrentServer={}, moveToServer={}", (Object)currentServer, (Object)moveToServer);
        TEST_UTIL.waitFor(60000L, () -> {
            byte[] bytes = ZKUtil.getData((ZKWatcher)zkw, (String)primaryMetaZnode);
            ServerName actualServer = ProtobufUtil.parseServerNameFrom((byte[])bytes);
            return moveToServer.equals((Object)actualServer);
        });
        TEST_UTIL.getAdmin().disableTable(tableName);
        Assert.assertTrue((boolean)TEST_UTIL.getAdmin().isTableDisabled(tableName));
    }
}

