/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc;

import io.trino.jdbc.;
import io.trino.jdbc.$internal.airlift.units.Duration;
import io.trino.jdbc.$internal.client.ClientSelectedRole;
import io.trino.jdbc.$internal.client.ClientSession;
import io.trino.jdbc.$internal.client.StatementClient;
import io.trino.jdbc.$internal.client.StatementClientFactory;
import io.trino.jdbc.$internal.guava.base.Preconditions;
import io.trino.jdbc.$internal.guava.base.Splitter;
import io.trino.jdbc.$internal.guava.base.Strings;
import io.trino.jdbc.$internal.guava.collect.ImmutableMap;
import io.trino.jdbc.$internal.guava.collect.ImmutableSet;
import io.trino.jdbc.$internal.guava.collect.Maps;
import io.trino.jdbc.$internal.guava.primitives.Ints;
import io.trino.jdbc.ClientInfoProperty;
import io.trino.jdbc.NotImplementedException;
import io.trino.jdbc.TrinoDatabaseMetaData;
import io.trino.jdbc.TrinoDriverUri;
import io.trino.jdbc.TrinoPreparedStatement;
import io.trino.jdbc.TrinoStatement;
import java.net.URI;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.time.ZoneId;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TrinoConnection
implements Connection {
    private static final Logger logger = Logger.getLogger(TrinoConnection.class.getPackage().getName());
    private final AtomicBoolean closed = new AtomicBoolean();
    private final AtomicBoolean autoCommit = new AtomicBoolean(true);
    private final AtomicInteger isolationLevel = new AtomicInteger(1);
    private final AtomicBoolean readOnly = new AtomicBoolean();
    private final AtomicReference<String> catalog = new AtomicReference();
    private final AtomicReference<String> schema = new AtomicReference();
    private final AtomicReference<String> path = new AtomicReference();
    private final AtomicReference<String> authorizationUser = new AtomicReference();
    private final AtomicReference<ZoneId> timeZoneId = new AtomicReference();
    private final AtomicReference<Locale> locale = new AtomicReference();
    private final AtomicReference<Integer> networkTimeoutMillis = new AtomicReference<Integer>(Ints.saturatedCast(TimeUnit.MINUTES.toMillis(2L)));
    private final AtomicLong nextStatementId = new AtomicLong(1L);
    private final AtomicReference<Optional<String>> sessionUser = new AtomicReference();
    private final URI jdbcUri;
    private final URI httpUri;
    private final Optional<String> user;
    private final boolean compressionDisabled;
    private final boolean assumeLiteralNamesInMetadataCallsForNonConformingClients;
    private final boolean assumeLiteralUnderscoreInMetadataCallsForNonConformingClients;
    private final Map<String, String> extraCredentials;
    private final Optional<String> applicationNamePrefix;
    private final Optional<String> source;
    private final Map<ClientInfoProperty, String> clientInfo = new ConcurrentHashMap<ClientInfoProperty, String>();
    private final Map<String, String> sessionProperties = new ConcurrentHashMap<String, String>();
    private final Map<String, String> preparedStatements = new ConcurrentHashMap<String, String>();
    private final Map<String, ClientSelectedRole> roles = new ConcurrentHashMap<String, ClientSelectedRole>();
    private final AtomicReference<String> transactionId = new AtomicReference();
    private final .Call.Factory httpCallFactory;
    private final Set<TrinoStatement> statements = Collections.newSetFromMap(new ConcurrentHashMap());
    private boolean useExplicitPrepare = true;

    TrinoConnection(TrinoDriverUri uri, .Call.Factory httpCallFactory) {
        Objects.requireNonNull(uri, "uri is null");
        this.jdbcUri = uri.getUri();
        this.httpUri = uri.getHttpUri();
        uri.getSchema().ifPresent(this.schema::set);
        uri.getCatalog().ifPresent(this.catalog::set);
        this.user = uri.getUser();
        this.sessionUser.set(uri.getSessionUser());
        this.applicationNamePrefix = uri.getApplicationNamePrefix();
        this.source = uri.getSource();
        this.extraCredentials = uri.getExtraCredentials();
        this.compressionDisabled = uri.isCompressionDisabled();
        this.assumeLiteralNamesInMetadataCallsForNonConformingClients = uri.isAssumeLiteralNamesInMetadataCallsForNonConformingClients();
        if (this.assumeLiteralNamesInMetadataCallsForNonConformingClients) {
            logger.log(Level.WARNING, "Connection config assumeLiteralNamesInMetadataCallsForNonConformingClients is deprecated, please use assumeLiteralUnderscoreInMetadataCallsForNonConformingClients.");
        }
        this.assumeLiteralUnderscoreInMetadataCallsForNonConformingClients = uri.isAssumeLiteralUnderscoreInMetadataCallsForNonConformingClients();
        this.httpCallFactory = Objects.requireNonNull(httpCallFactory, "httpCallFactory is null");
        uri.getClientInfo().ifPresent(tags -> this.clientInfo.put(ClientInfoProperty.CLIENT_INFO, (String)tags));
        uri.getClientTags().ifPresent(tags -> this.clientInfo.put(ClientInfoProperty.CLIENT_TAGS, (String)tags));
        uri.getTraceToken().ifPresent(tags -> this.clientInfo.put(ClientInfoProperty.TRACE_TOKEN, (String)tags));
        this.roles.putAll(uri.getRoles());
        this.timeZoneId.set(uri.getTimeZone());
        this.locale.set(Locale.getDefault());
        this.sessionProperties.putAll(uri.getSessionProperties());
        uri.getExplicitPrepare().ifPresent(value -> {
            this.useExplicitPrepare = value;
        });
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.doCreateStatement();
    }

    private TrinoStatement doCreateStatement() throws SQLException {
        this.checkOpen();
        TrinoStatement statement = new TrinoStatement(this, this::unregisterStatement);
        this.registerStatement(statement);
        return statement;
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkOpen();
        String name = "statement" + this.nextStatementId.getAndIncrement();
        TrinoPreparedStatement statement = new TrinoPreparedStatement(this, this::unregisterStatement, name, sql);
        this.registerStatement(statement);
        return statement;
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw new NotImplementedException("Connection", "prepareCall");
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.checkOpen();
        return sql;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkOpen();
        if (autoCommit && !this.getAutoCommit()) {
            this.commit();
        }
        this.autoCommit.set(autoCommit);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkOpen();
        return this.autoCommit.get();
    }

    @Override
    public void commit() throws SQLException {
        this.checkOpen();
        if (this.getAutoCommit()) {
            throw new SQLException("Connection is in auto-commit mode");
        }
        if (this.transactionId.get() == null) {
            return;
        }
        try (TrinoStatement statement = this.doCreateStatement();){
            statement.internalExecute("COMMIT");
        }
    }

    @Override
    public void rollback() throws SQLException {
        this.checkOpen();
        if (this.getAutoCommit()) {
            throw new SQLException("Connection is in auto-commit mode");
        }
        if (this.transactionId.get() == null) {
            return;
        }
        try (TrinoStatement statement = this.doCreateStatement();){
            statement.internalExecute("ROLLBACK");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        block15: {
            try {
                if (this.closed.get()) break block15;
                SqlExceptionHolder heldException = new SqlExceptionHolder();
                for (TrinoStatement statement : this.statements) {
                    try {
                        statement.close();
                    }
                    catch (RuntimeException | SQLException e) {
                        heldException.hold(e);
                    }
                }
                if (this.transactionId.get() != null) {
                    try (TrinoStatement statement = this.doCreateStatement();){
                        statement.internalExecute("ROLLBACK");
                    }
                    catch (RuntimeException | SQLException e) {
                        heldException.hold(e);
                    }
                }
                heldException.throwIfHeld();
            }
            finally {
                this.closed.set(true);
            }
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed.get();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return new TrinoDatabaseMetaData(this, this.assumeLiteralNamesInMetadataCallsForNonConformingClients, this.assumeLiteralUnderscoreInMetadataCallsForNonConformingClients);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkOpen();
        this.readOnly.set(readOnly);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.readOnly.get();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.checkOpen();
        this.catalog.set(catalog);
    }

    @Override
    public String getCatalog() throws SQLException {
        this.checkOpen();
        return this.catalog.get();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.checkOpen();
        TrinoConnection.getIsolationLevel(level);
        this.isolationLevel.set(level);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.checkOpen();
        return this.isolationLevel.get();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkOpen();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkOpen();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        TrinoConnection.checkResultSet(resultSetType, resultSetConcurrency);
        return this.createStatement();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        TrinoConnection.checkResultSet(resultSetType, resultSetConcurrency);
        return this.prepareStatement(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        TrinoConnection.checkResultSet(resultSetType, resultSetConcurrency);
        throw new SQLFeatureNotSupportedException("prepareCall");
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw new SQLFeatureNotSupportedException("getTypeMap");
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("setTypeMap");
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.checkOpen();
        if (holdability != 1) {
            throw new SQLFeatureNotSupportedException("Changing holdability not supported");
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkOpen();
        return 1;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new SQLFeatureNotSupportedException("setSavepoint");
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException("setSavepoint");
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException("rollback");
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException("releaseSavepoint");
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        TrinoConnection.checkHoldability(resultSetHoldability);
        return this.createStatement(resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        TrinoConnection.checkHoldability(resultSetHoldability);
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        TrinoConnection.checkHoldability(resultSetHoldability);
        return this.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        if (autoGeneratedKeys != 1) {
            throw new SQLFeatureNotSupportedException("Auto generated keys must be NO_GENERATED_KEYS");
        }
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException("prepareStatement");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException("prepareStatement");
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new SQLFeatureNotSupportedException("createClob");
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new SQLFeatureNotSupportedException("createBlob");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new SQLFeatureNotSupportedException("createNClob");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new SQLFeatureNotSupportedException("createSQLXML");
    }

    @Override
    public boolean isValid(int timeout2) throws SQLException {
        if (timeout2 < 0) {
            throw new SQLException("Timeout is negative");
        }
        return !this.isClosed();
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        Objects.requireNonNull(name, "name is null");
        Optional<ClientInfoProperty> clientInfoProperty = ClientInfoProperty.forName(name);
        if (!clientInfoProperty.isPresent()) {
            return;
        }
        if (value != null) {
            this.clientInfo.put(clientInfoProperty.get(), value);
        } else {
            this.clientInfo.remove((Object)clientInfoProperty.get());
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        for (Map.Entry entry : Maps.fromProperties(properties).entrySet()) {
            this.setClientInfo((String)entry.getKey(), (String)entry.getValue());
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return Optional.ofNullable(name).flatMap(ClientInfoProperty::forName).map(this.clientInfo::get).orElse(null);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        Properties properties = new Properties();
        for (Map.Entry<ClientInfoProperty, String> entry : this.clientInfo.entrySet()) {
            properties.setProperty(entry.getKey().getPropertyName(), entry.getValue());
        }
        return properties;
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw new SQLFeatureNotSupportedException("createArrayOf");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw new SQLFeatureNotSupportedException("createStruct");
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.checkOpen();
        this.schema.set(schema);
    }

    @Override
    public String getSchema() throws SQLException {
        this.checkOpen();
        return this.schema.get();
    }

    public String getTimeZoneId() {
        return this.timeZoneId.get().getId();
    }

    public void setTimeZoneId(String timeZoneId) {
        this.timeZoneId.set(ZoneId.of(timeZoneId));
    }

    public Locale getLocale() {
        return this.locale.get();
    }

    public void setLocale(Locale locale) {
        this.locale.set(locale);
    }

    public void setSessionProperty(String name, String value) {
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(value, "value is null");
        Preconditions.checkArgument(!name.isEmpty(), "name is empty");
        CharsetEncoder charsetEncoder = StandardCharsets.US_ASCII.newEncoder();
        Preconditions.checkArgument(name.indexOf(61) < 0, "Session property name must not contain '=': %s", (Object)name);
        Preconditions.checkArgument(charsetEncoder.canEncode(name), "Session property name is not US_ASCII: %s", (Object)name);
        Preconditions.checkArgument(charsetEncoder.canEncode(value), "Session property value is not US_ASCII: %s", (Object)value);
        this.sessionProperties.put(name, value);
    }

    public void setSessionUser(String sessionUser) {
        Objects.requireNonNull(sessionUser, "sessionUser is null");
        this.sessionUser.set(Optional.of(sessionUser));
    }

    public void clearSessionUser() {
        this.sessionUser.set(Optional.empty());
    }

    @.VisibleForTesting
    Map<String, ClientSelectedRole> getRoles() {
        return ImmutableMap.copyOf(this.roles);
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.close();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.checkOpen();
        if (milliseconds < 0) {
            throw new SQLException("Timeout is negative");
        }
        this.networkTimeoutMillis.set(milliseconds);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        this.checkOpen();
        return this.networkTimeoutMillis.get();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return (T)this;
        }
        throw new SQLException("No wrapper for " + iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    URI getURI() {
        return this.jdbcUri;
    }

    @.VisibleForTesting
    Map<String, String> getExtraCredentials() {
        return ImmutableMap.copyOf(this.extraCredentials);
    }

    @.VisibleForTesting
    Map<String, String> getSessionProperties() {
        return ImmutableMap.copyOf(this.sessionProperties);
    }

    boolean shouldStartTransaction() {
        return !this.autoCommit.get() && this.transactionId.get() == null;
    }

    String getStartTransactionSql() throws SQLException {
        return String.format("START TRANSACTION ISOLATION LEVEL %s, READ %s", TrinoConnection.getIsolationLevel(this.isolationLevel.get()), this.readOnly.get() ? "ONLY" : "WRITE");
    }

    StatementClient startQuery(String sql, Map<String, String> sessionPropertiesOverride) {
        String source2 = this.getActualSource();
        Iterable<String> clientTags = Splitter.on(',').trimResults().omitEmptyStrings().split(Strings.nullToEmpty(this.clientInfo.get((Object)ClientInfoProperty.CLIENT_TAGS)));
        HashMap<String, String> allProperties = new HashMap<String, String>(this.sessionProperties);
        allProperties.putAll(sessionPropertiesOverride);
        int millis = this.networkTimeoutMillis.get();
        Duration timeout2 = millis > 0 ? new Duration(millis, TimeUnit.MILLISECONDS) : new Duration(999.0, TimeUnit.DAYS);
        ClientSession session = ClientSession.builder().server(this.httpUri).principal(this.user).user(this.sessionUser.get()).authorizationUser(Optional.ofNullable(this.authorizationUser.get())).source(source2).traceToken(Optional.ofNullable(this.clientInfo.get((Object)ClientInfoProperty.TRACE_TOKEN))).clientTags(ImmutableSet.copyOf(clientTags)).clientInfo(this.clientInfo.get((Object)ClientInfoProperty.CLIENT_INFO)).catalog(this.catalog.get()).schema(this.schema.get()).path(this.path.get()).timeZone(this.timeZoneId.get()).locale(this.locale.get()).properties(ImmutableMap.copyOf(allProperties)).preparedStatements(ImmutableMap.copyOf(this.preparedStatements)).roles(ImmutableMap.copyOf(this.roles)).credentials(this.extraCredentials).transactionId(this.transactionId.get()).clientRequestTimeout(timeout2).compressionDisabled(this.compressionDisabled).build();
        return StatementClientFactory.newStatementClient(this.httpCallFactory, session, sql);
    }

    void updateSession(StatementClient client) {
        client.getSetSessionProperties().forEach(this.sessionProperties::put);
        client.getResetSessionProperties().forEach(this.sessionProperties::remove);
        client.getAddedPreparedStatements().forEach(this.preparedStatements::put);
        client.getDeallocatedPreparedStatements().forEach(this.preparedStatements::remove);
        client.getSetRoles().forEach(this.roles::put);
        client.getSetCatalog().ifPresent(this.catalog::set);
        client.getSetSchema().ifPresent(this.schema::set);
        client.getSetPath().ifPresent(this.path::set);
        if (client.getSetAuthorizationUser().isPresent()) {
            this.authorizationUser.set(client.getSetAuthorizationUser().get());
            this.roles.clear();
        }
        if (client.isResetAuthorizationUser()) {
            this.authorizationUser.set(null);
            this.roles.clear();
        }
        if (client.getStartedTransactionId() != null) {
            this.transactionId.set(client.getStartedTransactionId());
        }
        if (client.isClearTransactionId()) {
            this.transactionId.set(null);
        }
    }

    void removePreparedStatement(String name) {
        this.preparedStatements.remove(name);
    }

    private void registerStatement(TrinoStatement statement) {
        Preconditions.checkState(this.statements.add(statement), "Statement is already registered");
    }

    private void unregisterStatement(TrinoStatement statement) {
        Preconditions.checkState(this.statements.remove(statement), "Statement is not registered");
    }

    @.VisibleForTesting
    int activeStatements() {
        return this.statements.size();
    }

    @.VisibleForTesting
    String getAuthorizationUser() {
        return this.authorizationUser.get();
    }

    private void checkOpen() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Connection is closed");
        }
    }

    private static void checkResultSet(int resultSetType, int resultSetConcurrency) throws SQLFeatureNotSupportedException {
        if (resultSetType != 1003) {
            throw new SQLFeatureNotSupportedException("Result set type must be TYPE_FORWARD_ONLY");
        }
        if (resultSetConcurrency != 1007) {
            throw new SQLFeatureNotSupportedException("Result set concurrency must be CONCUR_READ_ONLY");
        }
    }

    private static void checkHoldability(int resultSetHoldability) throws SQLFeatureNotSupportedException {
        if (resultSetHoldability != 1) {
            throw new SQLFeatureNotSupportedException("Result set holdability must be HOLD_CURSORS_OVER_COMMIT");
        }
    }

    private static String getIsolationLevel(int level) throws SQLException {
        switch (level) {
            case 1: {
                return "READ UNCOMMITTED";
            }
            case 2: {
                return "READ COMMITTED";
            }
            case 4: {
                return "REPEATABLE READ";
            }
            case 8: {
                return "SERIALIZABLE";
            }
        }
        throw new SQLException("Invalid transaction isolation level: " + level);
    }

    private String getActualSource() {
        if (this.source.isPresent()) {
            return this.source.get();
        }
        String source2 = "trino-jdbc";
        String applicationName = this.clientInfo.get((Object)ClientInfoProperty.APPLICATION_NAME);
        if (this.applicationNamePrefix.isPresent()) {
            source2 = this.applicationNamePrefix.get();
            if (applicationName != null) {
                source2 = source2 + applicationName;
            }
        } else if (applicationName != null) {
            source2 = applicationName;
        }
        return source2;
    }

    public boolean useExplicitPrepare() {
        return this.useExplicitPrepare;
    }

    private static final class SqlExceptionHolder {
        @.Nullable
        private Exception heldException;

        private SqlExceptionHolder() {
        }

        public void hold(Exception exception) {
            if (this.heldException == null) {
                this.heldException = exception;
            } else if (this.heldException != exception) {
                this.heldException.addSuppressed(exception);
            }
        }

        public void throwIfHeld() throws SQLException {
            if (this.heldException != null) {
                throw new SQLException(this.heldException);
            }
        }
    }
}

